/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class PayCommand {
    private static final SuggestionProvider<class_2168> PLAYER_NAMES = (context, builder) -> class_2172.method_9265((Iterable)((class_2168)context.getSource()).method_9262(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"pay").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAMES).then(class_2170.method_9244((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.01)).executes(PayCommand::pay))));
    }

    private static int pay(CommandContext<class_2168> context) {
        class_3222 sender;
        class_2168 source = (class_2168)context.getSource();
        try {
            sender = source.method_9207();
        }
        catch (CommandSyntaxException e) {
            source.method_9213((class_2561)class_2561.method_43471((String)"command.pay.sender_not_player"));
            return 0;
        }
        String targetPlayerName = StringArgumentType.getString(context, (String)"player");
        double amount = DoubleArgumentType.getDouble(context, (String)"amount");
        MinecraftServer server = source.method_9211();
        String senderUUID = sender.method_5667().toString();
        double senderBalance = BalanceManager.getBalance(senderUUID);
        if (senderBalance < amount) {
            sender.method_64398((class_2561)class_2561.method_43471((String)"command.pay.not_enough_money"));
            return 0;
        }
        class_3222 targetPlayer = server.method_3760().method_14566(targetPlayerName);
        if (targetPlayer == null) {
            sender.method_64398((class_2561)class_2561.method_43471((String)"command.pay.player_not_found"));
            return 0;
        }
        String targetUUID = targetPlayer.method_5667().toString();
        double targetBalance = BalanceManager.getBalance(targetUUID);
        BalanceManager.setBalance(senderUUID, senderBalance - amount);
        BalanceManager.setBalance(targetUUID, targetBalance + amount);
        sender.method_64398((class_2561)class_2561.method_43469((String)"command.pay.success_sender", (Object[])new Object[]{String.format("%.2f", amount), targetPlayerName}));
        targetPlayer.method_64398((class_2561)class_2561.method_43469((String)"command.pay.success_receiver", (Object[])new Object[]{String.format("%.2f", amount), sender.method_5477().getString()}));
        return 1;
    }
}

