/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class BalanceData
extends class_18 {
    private static final String DATA_NAME = "sarosmoneymod_balance";
    private final Map<String, Double> balances = new HashMap<String, Double>();
    private static BalanceData instance;

    public class_2487 writeNbt(class_2487 compound, class_7225.class_7874 registryLookup) {
        class_2487 mapTag = new class_2487();
        for (Map.Entry<String, Double> entry : this.balances.entrySet()) {
            mapTag.method_10549(entry.getKey(), entry.getValue().doubleValue());
        }
        compound.method_10566("balances", (class_2520)mapTag);
        return compound;
    }

    public static BalanceData fromNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        BalanceData data = new BalanceData();
        if (nbt.method_10545("balances")) {
            class_2487 mapTag = nbt.method_10562("balances").orElse(new class_2487());
            for (String key : mapTag.method_10541()) {
                data.balances.put(key, mapTag.method_10574(key).orElse(0.0));
            }
        }
        return data;
    }

    public double getBalance(String playerUUID) {
        return this.balances.getOrDefault(playerUUID, 0.0);
    }

    public boolean containsBalance(String playerUUID) {
        return this.balances.containsKey(playerUUID);
    }

    public void setBalance(String playerUUID, double balance) {
        this.balances.put(playerUUID, balance);
        this.method_80();
    }

    public Map<String, Double> getBalances() {
        return new HashMap<String, Double>(this.balances);
    }

    public static BalanceData get(MinecraftServer server) {
        if (server == null) {
            throw new IllegalArgumentException("Server instance is null");
        }
        if (instance == null) {
            instance = new BalanceData();
        }
        return instance;
    }

    public static void loadFromServer(MinecraftServer server) {
        if (instance == null) {
            instance = new BalanceData();
        }
    }

    public static void saveToServer(MinecraftServer server) {
    }

    public static String getDataName() {
        return DATA_NAME;
    }

    public static void reset() {
        instance = null;
    }
}

