/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.handlers;

import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.handlers.ContainerHandler;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class ShopSignHandler {
    private static String stripFormatting(String text) {
        return text.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
    }

    public static void handleSignInteraction(UUID ownerUUID, class_1657 customer, String itemName, double price, String type, class_2338 signPos) {
        if (!(customer instanceof class_3222)) {
            return;
        }
        class_3222 serverCustomer = (class_3222)customer;
        class_1937 world = customer.method_73183();
        class_2680 signState = world.method_8320(signPos);
        class_2338 containerPos = ContainerHandler.getAttachedContainerPos(world, signPos, signState);
        class_2586 blockEntity = world.method_8321(containerPos);
        if (!(blockEntity instanceof class_1263)) {
            customer.method_7353((class_2561)class_2561.method_43471((String)"shop.error.no_container").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)), false);
            return;
        }
        class_1263 container = (class_1263)blockEntity;
        if (blockEntity instanceof class_2595) {
            class_2595 chest = (class_2595)blockEntity;
            chest.method_5431();
        }
        if (type.equalsIgnoreCase("buy")) {
            ShopSignHandler.handleBuyInteraction(ownerUUID, serverCustomer, itemName, price, container);
        } else if (type.equalsIgnoreCase("sell")) {
            ShopSignHandler.handleSellInteraction(ownerUUID, serverCustomer, itemName, price, container);
        }
        serverCustomer.field_7512.method_7623();
        serverCustomer.field_7498.method_34252();
    }

    private static void handleBuyInteraction(UUID ownerUUID, class_3222 customer, String itemName, double price, class_1263 container) {
        double customerBalance = BalanceManager.getPlayerBalance(customer);
        if (customerBalance < price) {
            customer.method_64398((class_2561)class_2561.method_43469((String)"shop.error.not_enough_money", (Object[])new Object[]{String.format("%.2f", price)}).method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
            return;
        }
        class_1799 itemToTransfer = null;
        int containerSlot = -1;
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (stack.method_7960() || !ShopSignHandler.matchesItemName(stack, itemName)) continue;
            itemToTransfer = stack.method_7972();
            containerSlot = i;
            break;
        }
        if (itemToTransfer == null) {
            customer.method_64398((class_2561)class_2561.method_43471((String)"shop.error.item_not_available").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
            return;
        }
        class_1799 singleItem = itemToTransfer.method_7972();
        singleItem.method_7939(1);
        if (!ShopSignHandler.hasInventorySpace(customer.method_31548(), singleItem)) {
            customer.method_64398((class_2561)class_2561.method_43471((String)"shop.error.inventory_full").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
            return;
        }
        BalanceManager.updatePlayerBalance(customer, customerBalance - price);
        ShopSignHandler.addBalance(ownerUUID.toString(), price);
        container.method_5434(containerSlot, 1);
        ShopSignHandler.addToInventory(customer, singleItem.method_7972());
        ShopSignHandler.sendNotifications(customer, ownerUUID, itemName, price, "buy");
    }

    private static void handleSellInteraction(UUID ownerUUID, class_3222 customer, String itemName, double price, class_1263 container) {
        String ownerUUIDString = ownerUUID.toString();
        double ownerBalance = BalanceManager.getBalance(ownerUUIDString);
        if (ownerBalance < price) {
            customer.method_64398((class_2561)class_2561.method_43471((String)"shop.error.owner_not_enough_money").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
            return;
        }
        class_1799 itemToSell = null;
        int inventorySlot = -1;
        class_1661 inventory = customer.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !ShopSignHandler.matchesItemName(stack, itemName)) continue;
            itemToSell = stack.method_7972();
            inventorySlot = i;
            break;
        }
        if (itemToSell == null) {
            customer.method_64398((class_2561)class_2561.method_43471((String)"shop.error.item_not_in_inventory").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
            return;
        }
        if (!ShopSignHandler.hasContainerSpace(container, itemToSell)) {
            customer.method_64398((class_2561)class_2561.method_43471((String)"shop.error.container_full").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
            return;
        }
        ShopSignHandler.addBalance(customer.method_5667().toString(), price);
        BalanceManager.setBalance(ownerUUIDString, ownerBalance - price);
        inventory.method_5434(inventorySlot, 1);
        ShopSignHandler.addToContainer(container, itemToSell.method_7972());
        ShopSignHandler.sendNotifications(customer, ownerUUID, itemName, price, "sell");
    }

    private static boolean matchesItemName(class_1799 stack, String searchName) {
        String stackName = ShopSignHandler.stripFormatting(stack.method_7964().getString());
        return stackName.equalsIgnoreCase(ShopSignHandler.stripFormatting(searchName));
    }

    private static void addToInventory(class_3222 player, class_1799 itemStack) {
        int i;
        class_1661 inventory = player.method_31548();
        for (i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !class_1799.method_7973((class_1799)stack, (class_1799)itemStack) || stack.method_7947() >= stack.method_7914()) continue;
            stack.method_7933(1);
            inventory.method_5447(i, stack);
            return;
        }
        for (i = 0; i < inventory.method_5439(); ++i) {
            if (!inventory.method_5438(i).method_7960()) continue;
            inventory.method_5447(i, itemStack);
            return;
        }
    }

    private static void sendNotifications(class_3222 customer, UUID ownerUUID, String itemName, double price, String type) {
        if (type.equals("buy")) {
            customer.method_64398((class_2561)class_2561.method_43469((String)"shop.buy.success", (Object[])new Object[]{itemName, String.format("%.2f", price)}).method_10862(class_2583.field_24360.method_10977(class_124.field_1060)));
            class_3222 owner = customer.method_64396().method_9211().method_3760().method_14602(ownerUUID);
            if (owner != null) {
                owner.method_64398((class_2561)class_2561.method_43469((String)"shop.buy.owner_notification", (Object[])new Object[]{customer.method_5476().getString(), itemName, String.format("%.2f", price)}).method_10862(class_2583.field_24360.method_10977(class_124.field_1060)));
            }
        } else {
            customer.method_64398((class_2561)class_2561.method_43469((String)"shop.sell.success", (Object[])new Object[]{itemName, String.format("%.2f", price)}).method_10862(class_2583.field_24360.method_10977(class_124.field_1060)));
            class_3222 owner = customer.method_64396().method_9211().method_3760().method_14602(ownerUUID);
            if (owner != null) {
                owner.method_64398((class_2561)class_2561.method_43469((String)"shop.sell.owner_notification", (Object[])new Object[]{customer.method_5476().getString(), itemName, String.format("%.2f", price)}).method_10862(class_2583.field_24360.method_10977(class_124.field_1060)));
            }
        }
    }

    private static void addBalance(String playerUUID, double amount) {
        double current = BalanceManager.getBalance(playerUUID);
        BalanceManager.setBalance(playerUUID, current + amount);
    }

    private static boolean hasInventorySpace(class_1661 inventory, class_1799 itemStack) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) {
                return true;
            }
            if (!class_1799.method_7973((class_1799)stack, (class_1799)itemStack) || stack.method_7947() >= stack.method_7914()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasContainerSpace(class_1263 container, class_1799 itemStack) {
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (stack.method_7960()) {
                return true;
            }
            if (!class_1799.method_7973((class_1799)stack, (class_1799)itemStack) || stack.method_7947() >= stack.method_7914()) continue;
            return true;
        }
        return false;
    }

    private static void addToContainer(class_1263 container, class_1799 itemStack) {
        int i;
        for (i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (stack.method_7960() || !class_1799.method_7973((class_1799)stack, (class_1799)itemStack) || stack.method_7947() >= stack.method_7914()) continue;
            stack.method_7933(1);
            container.method_5447(i, stack);
            return;
        }
        for (i = 0; i < container.method_5439(); ++i) {
            if (!container.method_5438(i).method_7960()) continue;
            container.method_5447(i, itemStack);
            return;
        }
    }
}

