/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.network;

import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.network.NetworkHandler;
import de.sarocesch.sarosmoneymod.procedures.DepositProcedure;
import de.sarocesch.sarosmoneymod.procedures.WithdrawProcedure;
import de.sarocesch.sarosmoneymod.world.inventory.ATMGUIMenu;
import java.util.HashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ATMGUIButtonMessage
implements class_8710 {
    public static final class_8710.class_9154<ATMGUIButtonMessage> ID = new class_8710.class_9154(NetworkHandler.ATM_GUI_BUTTON_ID);
    public static final class_9139<class_9129, ATMGUIButtonMessage> CODEC = class_9139.method_56438((value, buf) -> value.write((class_2540)buf), ATMGUIButtonMessage::new);
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private final String withdrawValue;

    public ATMGUIButtonMessage(class_2540 buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.withdrawValue = buffer.method_10800(Short.MAX_VALUE);
    }

    public ATMGUIButtonMessage(int buttonID, int x, int y, int z, String withdrawValue) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.withdrawValue = withdrawValue;
    }

    public void write(class_2540 buffer) {
        buffer.method_53002(this.buttonID);
        buffer.method_53002(this.x);
        buffer.method_53002(this.y);
        buffer.method_53002(this.z);
        buffer.method_10814(this.withdrawValue);
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public int getButtonID() {
        return this.buttonID;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String getWithdrawValue() {
        return this.withdrawValue;
    }

    public static void handleButtonAction(class_1657 entity, int buttonID, int x, int y, int z, String withdrawValue) {
        class_1937 world = entity.method_73183();
        HashMap<String, Object> guistate = ATMGUIMenu.guistate;
        if (!world.method_22340(new class_2338(x, y, z))) {
            return;
        }
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            if (buttonID == 0) {
                WithdrawProcedure.execute((class_1297)serverPlayer, guistate, withdrawValue, serverPlayer);
            }
            if (buttonID == 1) {
                DepositProcedure.execute((class_1297)serverPlayer, guistate, withdrawValue, serverPlayer);
            }
            double playerBalance = BalanceManager.getPlayerBalance(serverPlayer);
            int wholePart = (int)playerBalance;
            int decimalPart = (int)((playerBalance - (double)wholePart) * 100.0);
            class_1703 class_17032 = entity.field_7512;
            if (class_17032 instanceof ATMGUIMenu) {
                ATMGUIMenu menu = (ATMGUIMenu)class_17032;
                menu.propertyDelegate.method_17391(0, wholePart);
                menu.propertyDelegate.method_17391(1, decimalPart);
                menu.method_7623();
            }
        }
    }
}

