/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.element.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import xaero.hud.render.util.ImmediateRenderUtil;

public class MinimapElementGraphics {
    private final PoseStack poseStack;
    private final Supplier<MultiBufferSource.BufferSource> vanillaBufferSourceSupplier;

    public MinimapElementGraphics(PoseStack poseStack, Supplier<MultiBufferSource.BufferSource> vanillaBufferSourceSupplier) {
        this.poseStack = poseStack;
        this.vanillaBufferSourceSupplier = vanillaBufferSourceSupplier;
    }

    public final void fill(int x1, int y1, int x2, int y2, int color) {
        this.fill(RenderPipelines.GUI, x1, y1, x2, y2, color);
    }

    public final void fill(RenderPipeline pipeline, int x1, int y1, int x2, int y2, int color) {
        if (x1 < x2) {
            int x1bu = x1;
            x1 = x2;
            x2 = x1bu;
        }
        if (y1 < y2) {
            int y1bu = y1;
            y1 = y2;
            y2 = y1bu;
        }
        ImmediateRenderUtil.coloredRectangle(this.pose().last().pose(), x1, y1, x2, y2, color, pipeline);
    }

    public final void fillGradient(int x1, int y1, int x2, int y2, int color1, int color2) {
        ImmediateRenderUtil.gradientRectangle(this.pose().last().pose(), x1, y1, x2, y2, color1, color2);
    }

    public final void blit(TextureAtlasSprite sprite, int x, int y, int width, int height, RenderPipeline renderPipeline) {
        AbstractTexture abstractTexture = Minecraft.getInstance().getTextureManager().getTexture(sprite.atlasLocation());
        if (abstractTexture == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)abstractTexture.getTextureView());
        ImmediateRenderUtil.texturedRect(this.pose(), x, y, sprite.getU0(), sprite.getV1(), width, height, sprite.getU1(), sprite.getV0(), 1.0f, renderPipeline);
    }

    public final void blit(ResourceLocation texture, int x, int y, int u1, int v1, int width, int height, int u2, int v2, int textureSize, RenderPipeline renderPipeline) {
        AbstractTexture abstractTexture = Minecraft.getInstance().getTextureManager().getTexture(texture);
        if (abstractTexture == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)abstractTexture.getTextureView());
        ImmediateRenderUtil.texturedRect(this.pose(), x, y, u1, v2, width, height, u2, v1, textureSize, renderPipeline);
    }

    public final void blit(GpuTextureView texture, int x, int y, int u1, int v1, int width, int height, int u2, int v2, int textureSize, RenderPipeline renderPipeline) {
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)texture);
        ImmediateRenderUtil.texturedRect(this.pose(), x, y, u1, v2, width, height, u2, v1, textureSize, renderPipeline);
    }

    public final void drawCenteredString(Font font, String text, int x, int y, int color) {
        this.drawString(font, text, x - font.width(text) / 2, y, color);
    }

    public final void drawCenteredString(Font font, Component text, int x, int y, int color) {
        this.drawString(font, text, x - font.width((FormattedText)text) / 2, y, color);
    }

    public final void drawCenteredString(Font font, FormattedCharSequence charSequence, int x, int y, int color) {
        this.drawString(font, charSequence, x - font.width(charSequence) / 2, y, color);
    }

    public final void drawString(Font font, String text, int x, int y, int color) {
        this.drawString(font, text, x, y, color, true);
    }

    public final void drawString(Font font, String text, int x, int y, int color, boolean shadow) {
        if (ARGB.alpha((int)color) == 0) {
            return;
        }
        MultiBufferSource.BufferSource vanillaBufferSource = this.getBufferSource();
        font.drawInBatch(text, (float)x, (float)y, color, shadow, this.pose().last().pose(), (MultiBufferSource)vanillaBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        vanillaBufferSource.endLastBatch();
    }

    public final void drawString(Font font, Component text, int x, int y, int color) {
        this.drawString(font, text, x, y, color, true);
    }

    public final void drawString(Font font, Component text, int x, int y, int color, boolean shadow) {
        if (ARGB.alpha((int)color) == 0) {
            return;
        }
        MultiBufferSource.BufferSource vanillaBufferSource = this.getBufferSource();
        font.drawInBatch(text, (float)x, (float)y, color, shadow, this.pose().last().pose(), (MultiBufferSource)vanillaBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        vanillaBufferSource.endLastBatch();
    }

    public final void drawString(Font font, FormattedCharSequence charSequence, int x, int y, int color) {
        this.drawString(font, charSequence, x, y, color, true);
    }

    public final void drawString(Font font, FormattedCharSequence charSequence, int x, int y, int color, boolean shadow) {
        if (ARGB.alpha((int)color) == 0) {
            return;
        }
        MultiBufferSource.BufferSource vanillaBufferSource = this.getBufferSource();
        font.drawInBatch(charSequence, (float)x, (float)y, color, shadow, this.pose().last().pose(), (MultiBufferSource)vanillaBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        vanillaBufferSource.endLastBatch();
    }

    public MultiBufferSource.BufferSource getBufferSource() {
        return this.vanillaBufferSourceSupplier.get();
    }

    public PoseStack pose() {
        return this.poseStack;
    }

    public void flush() {
        this.getBufferSource().endBatch();
    }
}

