/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.entityinfo;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityInfoDetector {
    public EntityHitResult getMouseOver(Minecraft mc, Level world, double reach, float partialTicks) {
        Entity entity = mc.getCameraEntity();
        if (entity != null && entity.getBoundingBox() != null && world != null) {
            List entities;
            HitResult objectMouseOver = entity.pick(reach, partialTicks, false);
            Vec3 playerEyes = entity.getEyePosition(partialTicks);
            double maxDistance = reach;
            if (objectMouseOver != null) {
                maxDistance = objectMouseOver.getLocation().distanceTo(playerEyes);
            }
            Vec3 lookVector = entity.getViewVector(partialTicks);
            Vec3 farthestPoint = playerEyes.add(lookVector.x * maxDistance, lookVector.y * maxDistance, lookVector.z * maxDistance);
            Entity pointedEntity = null;
            try {
                entities = world.getEntities(entity, entity.getBoundingBox().expandTowards(lookVector.x * maxDistance, lookVector.y * maxDistance, lookVector.z * maxDistance).expandTowards(1.0, 1.0, 1.0));
            }
            catch (IndexOutOfBoundsException ioobe) {
                return null;
            }
            double resultHitDistance = maxDistance;
            for (int i = 0; i < entities.size(); ++i) {
                double hitDistance;
                Entity other = (Entity)entities.get(i);
                if (!other.isPickable() || other.getId() == entity.getId() || other.isInvisibleTo((Player)mc.player) || other == entity.getVehicle()) continue;
                float pickRadius = other.getPickRadius();
                AABB boundingBox = other.getBoundingBox().inflate((double)pickRadius, (double)pickRadius, (double)pickRadius);
                if (boundingBox.contains(playerEyes)) {
                    double distance = entity.position().distanceTo(other.position());
                    if (!(distance < resultHitDistance)) continue;
                    pointedEntity = other;
                    resultHitDistance = distance;
                    continue;
                }
                Optional clipPosition = boundingBox.clip(playerEyes, farthestPoint);
                if (clipPosition.isEmpty() || (hitDistance = playerEyes.distanceTo((Vec3)clipPosition.get())) >= resultHitDistance) continue;
                pointedEntity = other;
                resultHitDistance = hitDistance;
            }
            if (pointedEntity != null) {
                return new EntityHitResult(pointedEntity);
            }
            return null;
        }
        return null;
    }
}

