/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import com.mojang.authlib.GameProfile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xaero.common.IXaeroMinimap;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.events.ClientEvents;

public class ClientEventsForge
extends ClientEvents {
    public ClientEventsForge(IXaeroMinimap modMain) {
        super(modMain);
    }

    @SubscribeEvent
    public void handleGuiOpenEvent(ScreenEvent.Opening event) {
        Screen guiBefore = event.getNewScreen();
        Screen gui = this.handleGuiOpen(guiBefore);
        if (guiBefore != null && gui == null) {
            event.setCanceled(true);
            return;
        }
        event.setNewScreen(gui);
    }

    @SubscribeEvent
    public void handleClientSendChatEvent(ClientChatEvent e) {
        if (this.handleClientSendChatEvent(e.getMessage())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        GameProfile gameProfile;
        if (e.getMessage() == null) {
            return;
        }
        Component text = e.getMessage();
        PlayerInfo playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(e.getSender());
        GameProfile gameProfile2 = gameProfile = playerInfo == null ? null : playerInfo.getProfile();
        if (gameProfile != null && this.handleClientPlayerChatReceivedEvent(e.getBoundChatType(), text, gameProfile)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleDrawScreenEventPost(ScreenEvent.Render.Post event) {
        this.handleDrawScreenEventPost(event.getScreen());
    }

    @SubscribeEvent
    public void worldUnload(LevelEvent.Unload event) {
        this.worldUnload(event.getLevel());
    }

    @SubscribeEvent
    public void handleClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.handleClientTickStart();
        }
    }

    @SubscribeEvent
    public void handlePlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.handlePlayerTickStart(event.player);
        }
    }

    @SubscribeEvent
    public void handleRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.handleRenderTickStart();
        }
    }

    @SubscribeEvent(priority=EventPriority.MONITOR)
    public void handleBossHealthRender(CustomizeGuiOverlayEvent.BossEventProgress event) {
        XaeroMinimapCore.onBossHealthRender(event.getY() + event.getIncrement());
    }
}

