/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.trace;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4668;
import net.minecraft.class_4723;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_895;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.lwjgl.opengl.GL11;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.misc.Misc;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;

public class EntityRenderTracer {
    public static boolean TRACING_MODEL_RENDERS;
    private class_1297 tracedEntity;
    private class_897 tracedEntityRenderer;
    private Class<?> tracedEntityModelClass;
    private List<ModelRenderTrace> traceResultList;
    private ModelRenderTrace lastModelRenderDetected;
    private class_4597.class_4598 modelRenderDetectionRenderTypeBuffer;
    private Field lastStateField;
    private Class<?> compositeRenderTypeClass;
    private Field enderDragonModelField;
    private Field stateField;
    private Class<?> textureStateShardClass;
    private Field compositeStateTextureStateField;
    private Field textureStateShardTextureField;
    private Field compositeStateDepthTestStateField;
    private Field compositeStateWriteMaskStateField;
    private Field compositeStateCullStateField;
    private Field compositeStateTransparencyStateField;
    private Field compositeStateShaderStateField;
    private Field renderBuffersBufferSourceField;
    private Field spriteCoordinateExpanderSpriteField;
    private Class<?> irisRenderLayerWrapperClass;
    private Method irisRenderLayerWrapperUnwrapMethod;

    public EntityRenderTracer() {
        this.initReflection();
        this.traceResultList = new ArrayList<ModelRenderTrace>();
    }

    public <T extends class_1297> List<ModelRenderTrace> trace(class_4587 matrixStack, T entity, class_897<? super T> entityRenderer) {
        TRACING_MODEL_RENDERS = true;
        this.tracedEntity = entity;
        this.tracedEntityRenderer = entityRenderer;
        this.tracedEntityModelClass = null;
        this.traceResultList.clear();
        this.lastModelRenderDetected = null;
        class_4587.class_4665 matrixEntryToRestore = matrixStack.method_23760();
        matrixStack.method_22903();
        try {
            class_4597.class_4598 renderTypeBuffer = this.modelRenderDetectionRenderTypeBuffer = (class_4597.class_4598)Misc.getReflectFieldValue(class_310.method_1551().method_22940(), this.renderBuffersBufferSourceField);
            entityRenderer.method_3936(entity, 0.0f, 1.0f, matrixStack, (class_4597)renderTypeBuffer, 0xF000F0);
            renderTypeBuffer.method_22993();
            OpenGLException.checkGLError();
        }
        catch (Throwable e) {
            this.traceResultList.clear();
            MinimapLogs.LOGGER.error("Exception when calling the full entity renderer for {} before prerendering the icon.", (Object)entity.method_5820(), (Object)e);
        }
        TRACING_MODEL_RENDERS = false;
        this.tracedEntity = null;
        this.tracedEntityRenderer = null;
        while (matrixStack.method_23760() != matrixEntryToRestore) {
            matrixStack.method_22909();
        }
        while (GL11.glGetError() != 0) {
        }
        return this.traceResultList;
    }

    public void onModelRender(class_583<?> model, class_4588 vertexConsumer, float red, float green, float blue, float alpha) {
        this.lastModelRenderDetected = null;
        if (this.tracedEntityModelClass == null) {
            class_583 currentMainModel = this.getEntityRendererModel(this.tracedEntityRenderer);
            Class<?> clazz = this.tracedEntityModelClass = currentMainModel == null ? null : currentMainModel.getClass();
            if (this.tracedEntityModelClass == null) {
                return;
            }
        }
        if (!model.getClass().isAssignableFrom(this.tracedEntityModelClass) && !this.tracedEntityModelClass.isAssignableFrom(model.getClass())) {
            return;
        }
        class_1921 lastRenderType = this.getLastRenderType((class_4597)this.modelRenderDetectionRenderTypeBuffer);
        if (lastRenderType == null && this.traceResultList.isEmpty()) {
            class_2960 textureLocation = null;
            try {
                class_2960 textureLocationUnchecked;
                textureLocation = textureLocationUnchecked = this.tracedEntityRenderer.method_3931(this.tracedEntity);
            }
            catch (Throwable t) {
                MinimapLogs.LOGGER.error("Couldn't fetch main entity texture when trying to use an alternative render type for an icon!", t);
            }
            if (textureLocation != null) {
                lastRenderType = model.method_23500(textureLocation);
            }
        }
        if (lastRenderType == null) {
            return;
        }
        Object renderState = this.getRenderState(lastRenderType);
        if (renderState == null) {
            return;
        }
        Object renderTextureState = Misc.getReflectFieldValue(renderState, this.compositeStateTextureStateField);
        class_2960 texture = null;
        if (this.textureStateShardClass.isAssignableFrom(renderTextureState.getClass())) {
            texture = this.getRenderStateTextureStateTexture(renderTextureState);
        }
        Object renderTransparencyState = Misc.getReflectFieldValue(renderState, this.compositeStateTransparencyStateField);
        renderTransparencyState = this.fixAdditiveTransparency(renderTransparencyState);
        Object renderDepthTestState = Misc.getReflectFieldValue(renderState, this.compositeStateDepthTestStateField);
        Object renderWriteMaskState = Misc.getReflectFieldValue(renderState, this.compositeStateWriteMaskStateField);
        Object renderCullState = Misc.getReflectFieldValue(renderState, this.compositeStateCullStateField);
        Object renderShaderState = Misc.getReflectFieldValue(renderState, this.compositeStateShaderStateField);
        CustomRenderTypes.EntityIconLayerPhases layerPhases = new CustomRenderTypes.EntityIconLayerPhases(renderTextureState, renderTransparencyState, renderDepthTestState, renderWriteMaskState, renderCullState, renderShaderState);
        class_1058 renderAtlasSprite = null;
        if (vertexConsumer instanceof class_4723) {
            renderAtlasSprite = (class_1058)Misc.getReflectFieldValue(vertexConsumer, this.spriteCoordinateExpanderSpriteField);
        }
        this.lastModelRenderDetected = new ModelRenderTrace(model, texture, renderAtlasSprite, layerPhases, red, green, blue, alpha);
        this.traceResultList.add(this.lastModelRenderDetected);
    }

    private Object fixAdditiveTransparency(Object renderTransparencyState) {
        int blendSrcFactor;
        Object result = renderTransparencyState;
        ((class_4668)renderTransparencyState).method_23516();
        int blendDestFactor = GL11.glGetInteger((int)32968);
        if (blendDestFactor == 1 && (blendSrcFactor = GL11.glGetInteger((int)32969)) != 0) {
            result = CustomRenderTypes.getTransparencyPhase(blendSrcFactor, blendDestFactor, 0, 1);
        }
        ((class_4668)renderTransparencyState).method_23518();
        return result;
    }

    public void onModelPartRender(class_630 modelRenderer, float red, float green, float blue, float alpha) {
        if (this.lastModelRenderDetected != null) {
            this.lastModelRenderDetected.addVisibleModelPart(modelRenderer, red, green, blue, alpha);
        }
    }

    private class_1921 getLastRenderType(class_4597 renderTypeBuffer) {
        if (!(renderTypeBuffer instanceof class_4597.class_4598)) {
            return null;
        }
        Object lastRenderTypeObject = Misc.getReflectFieldValue(renderTypeBuffer, this.lastStateField);
        if (lastRenderTypeObject instanceof Optional) {
            return ((Optional)lastRenderTypeObject).orElse(null);
        }
        return (class_1921)lastRenderTypeObject;
    }

    private Object getRenderState(class_1921 renderType) {
        while (renderType.getClass() == this.irisRenderLayerWrapperClass && this.irisRenderLayerWrapperUnwrapMethod != null) {
            renderType = (class_1921)Misc.getReflectMethodValue(renderType, this.irisRenderLayerWrapperUnwrapMethod, new Object[0]);
        }
        if (renderType.getClass() == this.compositeRenderTypeClass) {
            return Misc.getReflectFieldValue(renderType, this.stateField);
        }
        return null;
    }

    private class_2960 getRenderStateTextureStateTexture(Object renderTextureState) {
        Object renderStateTextureObject = Misc.getReflectFieldValue(renderTextureState, this.textureStateShardTextureField);
        if (!(renderStateTextureObject instanceof Optional)) {
            return (class_2960)renderStateTextureObject;
        }
        Optional optional = (Optional)renderStateTextureObject;
        return optional.orElse(null);
    }

    public <T extends class_1297> class_583<T> getEntityRendererModel(class_897<? super T> entityRenderer) {
        if (entityRenderer instanceof class_922) {
            return ((class_922)entityRenderer).method_4038();
        }
        if (entityRenderer instanceof class_895) {
            return (class_583)Misc.getReflectFieldValue(entityRenderer, this.enderDragonModelField);
        }
        return null;
    }

    private void initReflection() {
        this.enderDragonModelField = Misc.getFieldReflection(class_895.class, "model", "field_21008", "Lnet/minecraft/class_895$class_625;", "f_114183_");
        try {
            this.lastStateField = Misc.getFieldReflection(class_4597.class_4598.class, "lastState", "field_20954", "Ljava/util/Optional;", "f_109906_");
        }
        catch (Exception e) {
            this.lastStateField = Misc.getFieldReflection(class_4597.class_4598.class, "lastState", "c", "Ljava/util/Optional;", "f_109906_");
        }
        try {
            this.compositeRenderTypeClass = Misc.getClassForName("net.minecraft.class_1921$class_4687", "net.minecraft.client.renderer.RenderType$CompositeRenderType");
            this.stateField = Misc.getFieldReflection(this.compositeRenderTypeClass, "state", "field_21403", "Lnet/minecraft/class_1921$class_4688;", "f_110511_");
            Class<?> compositeStateClass = Misc.getClassForName("net.minecraft.class_1921$class_4688", "net.minecraft.client.renderer.RenderType$CompositeState");
            this.textureStateShardClass = Misc.getClassForName("net.minecraft.class_4668$class_4683", "net.minecraft.client.renderer.RenderStateShard$TextureStateShard");
            this.compositeStateTextureStateField = Misc.getFieldReflection(compositeStateClass, "textureState", "field_21406", "Lnet/minecraft/class_4668$class_5939;", "f_110576_");
            this.textureStateShardTextureField = Misc.getFieldReflection(this.textureStateShardClass, "texture", "field_21397", "Ljava/util/Optional;", "f_110328_");
            this.compositeStateTransparencyStateField = Misc.getFieldReflection(compositeStateClass, "transparencyState", "field_21407", "Lnet/minecraft/class_4668$class_4685;", "f_110577_");
            this.compositeStateDepthTestStateField = Misc.getFieldReflection(compositeStateClass, "depthTestState", "field_21411", "Lnet/minecraft/class_4668$class_4672;", "f_110581_");
            this.compositeStateWriteMaskStateField = Misc.getFieldReflection(compositeStateClass, "writeMaskState", "field_21419", "Lnet/minecraft/class_4668$class_4686;", "f_110589_");
            this.compositeStateCullStateField = Misc.getFieldReflection(compositeStateClass, "cullState", "field_21412", "Lnet/minecraft/class_4668$class_4671;", "f_110582_");
            this.compositeStateShaderStateField = Misc.getFieldReflection(compositeStateClass, "shaderState", "field_29461", "Lnet/minecraft/class_4668$class_5942;", "f_173274_");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        this.renderBuffersBufferSourceField = Misc.getFieldReflection(class_4599.class, "bufferSource", "field_46901", "Lnet/minecraft/class_4597$class_4598;", "f_110094_");
        this.spriteCoordinateExpanderSpriteField = Misc.getFieldReflection(class_4723.class, "sprite", "field_21731", "Lnet/minecraft/class_1058;", "f_110796_");
        try {
            try {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderTypeWrapper");
            }
            catch (ClassNotFoundException e) {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderLayerWrapper");
            }
            this.irisRenderLayerWrapperUnwrapMethod = Misc.getMethodReflection(this.irisRenderLayerWrapperClass, "unwrap", "unwrap", "()Lnet/minecraft/class_1921;", "unwrap", new Class[0]);
            MinimapLogs.LOGGER.info("Old Iris detected and supported!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

