/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.message;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import xaero.common.IXaeroMinimap;
import xaero.common.PlatformContextForge;
import xaero.common.message.MinimapMessage;
import xaero.common.message.MinimapMessageHandler;
import xaero.common.message.PacketConsumerForge;
import xaero.common.message.client.ClientMessageConsumer;
import xaero.common.message.server.ServerMessageConsumer;

public class MinimapMessageHandlerForge
extends MinimapMessageHandler {
    private final IXaeroMinimap modMain;
    private final PlatformContextForge xaeroHudForge;

    public MinimapMessageHandlerForge(IXaeroMinimap modMain, PlatformContextForge xaeroHudForge) {
        this.modMain = modMain;
        this.xaeroHudForge = xaeroHudForge;
    }

    @Override
    public <T extends MinimapMessage<T>> void register(int index, Class<T> type, ServerMessageConsumer<T> serverHandler, ClientMessageConsumer<T> clientHandler, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, FriendlyByteBuf> encoder) {
        PacketConsumerForge<T> consumer = new PacketConsumerForge<T>(serverHandler, clientHandler);
        if (clientHandler == null != (serverHandler == null)) {
            this.xaeroHudForge.getNetwork().messageBuilder(type, index, clientHandler == null ? NetworkDirection.PLAY_TO_SERVER : NetworkDirection.PLAY_TO_CLIENT).consumerNetworkThread(consumer).decoder(decoder).encoder(encoder).add();
            return;
        }
        this.xaeroHudForge.getNetwork().messageBuilder(type, index).consumerNetworkThread(consumer).decoder(decoder).encoder(encoder).add();
    }

    @Override
    public <T extends MinimapMessage<T>> void sendToPlayer(ServerPlayer player, T message) {
        this.xaeroHudForge.getNetwork().send(message, PacketDistributor.PLAYER.with((Object)player));
    }

    @Override
    public <T extends MinimapMessage<T>> void sendToServer(T message) {
        this.xaeroHudForge.getNetwork().send(message, PacketDistributor.SERVER.noArg());
    }
}

