/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.armor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import xaero.common.settings.ModSettings;
import xaero.hud.pvp.module.armor.ArmorStatusCachedComponents;
import xaero.hud.pvp.module.armor.ArmorStatusInventoryHelper;
import xaero.hud.pvp.module.armor.ArmorStatusSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class ArmorStatusRenderer
implements IModuleRenderer<ArmorStatusSession> {
    public static final int LINE_HEIGHT = 19;
    private int restoresLabelIndex;
    private int durabilityLabelIndex;
    private int labelCountLabelIndex;
    private int enchantsLabelIndex;
    private boolean renderedOffhand;
    private final ArmorStatusInventoryHelper inventoryHelper = new ArmorStatusInventoryHelper();

    @Override
    public void render(ArmorStatusSession session, ModuleRenderContext c, GuiGraphics guiGraphics, float partialTicks) {
        RenderSystem.enableDepthTest();
        this.durabilityLabelIndex = 0;
        this.labelCountLabelIndex = 0;
        this.restoresLabelIndex = 0;
        this.enchantsLabelIndex = 0;
        this.renderedOffhand = false;
        if (!session.isCentered()) {
            this.renderClassic(session, guiGraphics, c);
        } else {
            this.renderCentered(session, guiGraphics, c);
        }
        if (this.renderedOffhand) {
            session.onOffhandItemRender();
        }
        RenderSystem.disableDepthTest();
    }

    private void renderClassic(ArmorStatusSession session, GuiGraphics guiGraphics, ModuleRenderContext c) {
        Minecraft mc = Minecraft.m_91087_();
        int iconX = c.x + (c.flippedHorizontally ? c.w - 3 : 3);
        int iconY = c.y + 3;
        if (!c.flippedVertically) {
            iconY = this.renderClassicArmor(iconX, iconY, mc.f_91074_, session, guiGraphics, c);
        }
        iconY = this.renderClassicHeldItems(iconX, iconY, mc.f_91074_, session, guiGraphics, c);
        if (c.flippedVertically) {
            iconY = this.renderClassicArmor(iconX, iconY, mc.f_91074_, session, guiGraphics, c);
        }
    }

    private int renderClassicHeldItems(int iconX, int iconY, LocalPlayer player, ArmorStatusSession session, GuiGraphics guiGraphics, ModuleRenderContext c) {
        Component lastLabel;
        Component firstLabel;
        ItemStack main;
        EquipmentSlot bowHand = this.inventoryHelper.getBowHand(player);
        ItemStack arrows = bowHand != null && session.getArchery() ? this.inventoryHelper.getArrowStack((Player)player) : null;
        ItemStack off = session.getDisplayOffHand() ? player.m_6844_(EquipmentSlot.OFFHAND) : null;
        ItemStack itemStack = main = session.getDisplayMainHand() ? player.m_150109_().m_36056_() : null;
        if (off != null) {
            this.renderedOffhand = true;
        }
        if (off == arrows) {
            off = null;
        }
        if (main == arrows) {
            main = null;
        }
        if (c.flippedVertically) {
            int totalHeldItems = 0;
            if (off != null) {
                ++totalHeldItems;
            }
            if (main != null) {
                ++totalHeldItems;
            }
            if (arrows != null) {
                ++totalHeldItems;
            }
            iconY += 19 * (3 - totalHeldItems);
        }
        Component arrowLabel = arrows == null ? null : this.getArrowCountLabel(arrows, player);
        ItemStack first = c.flippedVertically ? arrows : off;
        Object object = firstLabel = c.flippedVertically ? arrowLabel : null;
        if (first != null) {
            this.renderItemWithInfo(session, guiGraphics, first, firstLabel, iconX, iconY, c.flippedHorizontally, !c.flippedVertically, !c.flippedVertically);
            iconY += 19;
        }
        if (main != null) {
            this.renderItemWithInfo(session, guiGraphics, main, null, iconX, iconY, c.flippedHorizontally, true, false);
            iconY += 19;
        }
        ItemStack last = c.flippedVertically ? off : arrows;
        Component component = lastLabel = c.flippedVertically ? null : arrowLabel;
        if (last != null) {
            this.renderItemWithInfo(session, guiGraphics, last, lastLabel, iconX, iconY, c.flippedHorizontally, c.flippedVertically, c.flippedVertically);
            iconY += 19;
        }
        return iconY;
    }

    private int renderClassicArmor(int iconX, int iconY, LocalPlayer player, ArmorStatusSession session, GuiGraphics guiGraphics, ModuleRenderContext c) {
        for (int i = 3; i >= 0; --i) {
            ItemStack itemStack = (ItemStack)player.m_150109_().f_35975_.get(i);
            if (!itemStack.m_41619_()) {
                this.renderItemWithInfo(session, guiGraphics, itemStack, null, iconX, iconY, c.flippedHorizontally, true, false);
            }
            iconY += 19;
        }
        return iconY;
    }

    private void renderCentered(ArmorStatusSession session, GuiGraphics guiGraphics, ModuleRenderContext c) {
        ItemStack main;
        int line;
        int slot;
        Minecraft mc = Minecraft.m_91087_();
        Inventory inventory = mc.f_91074_.m_150109_();
        int leftArmorSlotStart = c.flippedHorizontally ? 0 : 2;
        int rightArmorSlotStart = c.flippedHorizontally ? 2 : 0;
        int armorStartLine = c.flippedVertically ? 1 : 0;
        int armorStepDirection = c.flippedVertically ? -1 : 1;
        for (slot = leftArmorSlotStart; slot < leftArmorSlotStart + 2; ++slot) {
            line = armorStartLine + armorStepDirection * (slot - leftArmorSlotStart);
            this.renderItemWithInfo(session, guiGraphics, (ItemStack)inventory.f_35975_.get(slot), null, c.x + c.w / 2 - 94, c.y + 3 + 19 * line, true, true, false);
        }
        for (slot = rightArmorSlotStart; slot < rightArmorSlotStart + 2; ++slot) {
            line = armorStartLine + armorStepDirection * (slot - rightArmorSlotStart);
            this.renderItemWithInfo(session, guiGraphics, (ItemStack)inventory.f_35975_.get(slot), null, c.x + c.w / 2 + 94, c.y + 3 + 19 * line, false, true, false);
        }
        EquipmentSlot bowHand = this.inventoryHelper.getBowHand(mc.f_91074_);
        ItemStack arrows = bowHand != null && session.getArchery() ? this.inventoryHelper.getArrowStack((Player)mc.f_91074_) : null;
        ItemStack off = session.getDisplayOffHand() ? mc.f_91074_.m_6844_(EquipmentSlot.OFFHAND) : null;
        ItemStack itemStack = main = session.getDisplayMainHand() ? inventory.m_36056_() : null;
        if (off != null) {
            this.renderedOffhand = true;
        }
        if (off == arrows) {
            off = null;
        }
        if (main == arrows) {
            main = null;
        }
        boolean mainOnLeft = mc.f_91066_.m_232107_().m_231551_() == HumanoidArm.LEFT;
        int iconY = c.y + c.h / 2 > c.screenHeight / 2 ? c.y + 3 - 19 : c.y + c.h;
        int heldItemsCenteredPosition = session.getHeldItemsCenteredPosition();
        if (heldItemsCenteredPosition == 0) {
            if (off != null) {
                this.renderItemWithInfo(session, guiGraphics, off, null, mainOnLeft ? c.screenWidth - 3 : 3, iconY, mainOnLeft, true, true);
            }
            if (main != null) {
                this.renderItemWithInfo(session, guiGraphics, main, null, mainOnLeft ? 3 : c.screenWidth - 3, iconY, !mainOnLeft, true, false);
            }
        } else {
            if (off != null) {
                this.renderItemWithInfo(session, guiGraphics, off, null, c.x + c.w / 2 + (mainOnLeft ? 94 : -94), iconY, !mainOnLeft, true, true);
            }
            if (main != null) {
                this.renderItemWithInfo(session, guiGraphics, main, null, c.x + c.w / 2 + (mainOnLeft ? -94 : 94), iconY, mainOnLeft, true, false);
            }
        }
        if (arrows == null) {
            return;
        }
        int arrowY = c.y + c.h / 2 > c.screenHeight / 2 ? iconY - 19 : iconY + 19;
        boolean onTheRight = bowHand == EquipmentSlot.MAINHAND && !mainOnLeft || bowHand == EquipmentSlot.OFFHAND && mainOnLeft;
        Component arrowLabel = this.getArrowCountLabel(arrows, mc.f_91074_);
        if (heldItemsCenteredPosition == 0) {
            this.renderItemWithInfo(session, guiGraphics, arrows, arrowLabel, onTheRight ? c.screenWidth - 3 : 3, arrowY, onTheRight, false, false);
        } else {
            this.renderItemWithInfo(session, guiGraphics, arrows, arrowLabel, c.x + c.w / 2 + (onTheRight ? 94 : -94), arrowY, !onTheRight, false, false);
        }
    }

    public void renderItemWithInfo(ArmorStatusSession session, GuiGraphics guiGraphics, ItemStack stack, Component customLabel, int x, int y, boolean flipped, boolean withSize, boolean keepNormalCount) {
        if (stack == null || stack.m_41720_() == Items.f_41852_) {
            return;
        }
        boolean enchanted = stack.m_41793_();
        boolean fullCount = session.getShowFullCount();
        boolean enchants = session.getShowEnchants();
        Component label = customLabel;
        if (label == null) {
            label = this.getDamageLabel(stack, session, withSize && fullCount && keepNormalCount && stack.m_41613_() > 1, flipped);
        }
        Component enchantsLabel = null;
        if (enchants) {
            enchantsLabel = this.getEnchantsLabel(enchanted ? stack.m_41785_() : null, session.getEnchantsColor());
        }
        this.renderItemWithLabels(guiGraphics, stack, label, enchantsLabel, x, y, flipped, withSize, fullCount);
    }

    public void renderItemWithLabels(GuiGraphics guiGraphics, ItemStack stack, Component label1, Component label2, int x, int y, boolean flipped, boolean withSize, boolean fullCount) {
        Minecraft mc = Minecraft.m_91087_();
        if (stack == null || stack.m_41619_()) {
            return;
        }
        PoseStack matrixStack = guiGraphics.m_280168_();
        int iconX = x - (flipped ? 16 : 0);
        int iconY = y;
        int label1X = iconX + (flipped ? -3 - mc.f_91062_.m_92852_((FormattedText)label1) : 19);
        int label1Y = iconY;
        guiGraphics.m_280430_(mc.f_91062_, label1, label1X, label1Y, 0xFFFFFF);
        if (label2 != null) {
            int label2X = iconX + (flipped ? -3 - mc.f_91062_.m_92852_((FormattedText)label2) : 19);
            int label2Y = iconY + 9;
            guiGraphics.m_280430_(mc.f_91062_, label2, label2X, label2Y, 0xFFFFFF);
        }
        matrixStack.m_252880_(0.0f, 0.0f, -100.0f);
        guiGraphics.m_280480_(stack, iconX, iconY);
        matrixStack.m_252880_(0.0f, 0.0f, 100.0f);
        int size = 1;
        if (withSize) {
            size = stack.m_41613_();
            if (fullCount) {
                size = this.inventoryHelper.getFullItemCount(stack.m_41720_(), mc.f_91074_);
            }
        }
        Object sizeString = "" + size;
        if (size <= 1) {
            sizeString = "";
        }
        guiGraphics.m_280302_(mc.f_91062_, stack, iconX, iconY, (String)sizeString);
    }

    public Component getDamageLabel(ItemStack stack, ArmorStatusSession session, boolean includeCount, boolean flipped) {
        FoodProperties food;
        Component result = null;
        if (stack.m_41720_().m_41472_() && (food = stack.m_41720_().m_41473_()) != null && food.m_38744_() > 0) {
            result = ArmorStatusCachedComponents.FOOD_RESTORES[this.restoresLabelIndex++].get((double)food.m_38744_() / 2.0);
        }
        if (result == null && stack.m_41776_() > 0) {
            result = ArmorStatusCachedComponents.DURABILITY[this.durabilityLabelIndex++].get(session.getDurabilityType(), stack.m_41776_(), stack.m_41773_());
        }
        if (result == null) {
            result = stack.m_41786_();
        }
        if (includeCount) {
            result = ArmorStatusCachedComponents.LABEL_WITH_COUNT[this.labelCountLabelIndex++].get(result, stack.m_41613_(), flipped);
        }
        return result;
    }

    private Component getEnchantsLabel(ListTag enchants, int enchantColor) {
        if (enchants == null) {
            return null;
        }
        int color = ModSettings.COLORS[enchantColor];
        return ArmorStatusCachedComponents.ENCHANTS[this.enchantsLabelIndex++].get(enchants, color);
    }

    public Component getArrowCountLabel(ItemStack used, LocalPlayer player) {
        int count = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!this.inventoryHelper.isArrows(stack)) continue;
            count += stack.m_41613_();
        }
        ItemStack offhand = player.m_6844_(EquipmentSlot.OFFHAND);
        if (this.inventoryHelper.isArrows(offhand)) {
            count += offhand.m_41613_();
        }
        return ArmorStatusCachedComponents.ARROW_COUNT.get(used.m_41613_(), count);
    }
}

