/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.entityinfo;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.Random;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.joml.Matrix4f;
import org.joml.Vector3fc;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.hud.pvp.module.entityinfo.EntityInfoSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;
import xaero.pvp.BetterPVP;

public class EntityInfoRenderer
implements IModuleRenderer<EntityInfoSession> {
    public static final ResourceLocation HEART_CONTANER = new ResourceLocation("hud/heart/container_blinking");
    public static final ResourceLocation NORMAL_HEART_FULL = new ResourceLocation("hud/heart/full");
    public static final ResourceLocation NORMAL_HEART_HALF = new ResourceLocation("hud/heart/half");
    public static final ResourceLocation ABSORBING_HEART_FULL = new ResourceLocation("hud/heart/absorbing_full");
    public static final ResourceLocation ABSORBING_HEART_HALF = new ResourceLocation("hud/heart/absorbing_half");
    public static final ResourceLocation ARMOR_EMPTY = new ResourceLocation("hud/armor_empty");
    public static final ResourceLocation ARMOR_HALF = new ResourceLocation("hud/armor_half");
    public static final ResourceLocation ARMOR_FULL = new ResourceLocation("hud/armor_full");
    private final Random random = new Random();

    @Override
    public void render(EntityInfoSession session, ModuleRenderContext c, GuiGraphics guiGraphics, float partialTicks) {
        LivingEntity displayedEntity;
        Minecraft mc = Minecraft.m_91087_();
        long time = System.currentTimeMillis();
        EntityHitResult objectMouseOver = session.getDetector().getMouseOver(mc, (Level)mc.f_91073_, session.getEntityInfoDistance(), partialTicks);
        if (objectMouseOver != null && objectMouseOver.m_82443_() instanceof LivingEntity) {
            ServerLevel serverWorld;
            session.setDisplayedEntity((LivingEntity)objectMouseOver.m_82443_());
            if (mc.m_91092_() != null && (serverWorld = mc.m_91092_().m_129880_(mc.f_91073_.m_46472_())) != null) {
                session.setDisplayedServerEntity((LivingEntity)serverWorld.m_8791_(objectMouseOver.m_82443_().m_20148_()));
            }
            session.setLastDetection(time);
        }
        if ((displayedEntity = session.getDisplayedEntity()) == null) {
            return;
        }
        if (time - session.getLastDetection() > 1000L * (long)session.getEntityInfoStay()) {
            return;
        }
        if (System.currentTimeMillis() - session.getLastEffectBlink() > 500L) {
            session.setLastEffectBlink(System.currentTimeMillis());
            session.setEffectBlink(!session.getEffectBlink());
        }
        PoseStack matrixStack = guiGraphics.m_280168_();
        try {
            int healthOff;
            boolean flippedVer = c.flippedVertically;
            boolean flippedHor = c.flippedHorizontally;
            float resize = 1.0f;
            if (displayedEntity.m_20205_() > resize) {
                resize = displayedEntity.m_20205_();
            }
            if (displayedEntity.m_20206_() > resize * 2.0f) {
                resize = displayedEntity.m_20206_() / 2.0f;
            }
            if (session.getEntityInfoShowEntityModel()) {
                matrixStack.m_252880_(0.0f, 0.0f, -500.0f);
                RenderSystem.enableDepthTest();
                this.drawEntityOnScreen(mc, matrixStack, c.x + (flippedHor ? c.w - 25 : 25), c.y + 35, (int)(30.0f / resize), displayedEntity, flippedHor);
                RenderSystem.disableDepthTest();
                matrixStack.m_252880_(0.0f, 0.0f, 500.0f);
            }
            LivingEntity displayedServerEntity = session.getDisplayedServerEntity();
            int n = healthOff = session.getEntityInfoShowEntityModel() ? 55 : 5;
            if (mc.m_91092_() != null && session.getEntityInfoEffects() && displayedServerEntity != null) {
                int effectsOffset = (int)this.drawPotionEffects(mc, guiGraphics, session, displayedServerEntity, c.x + (flippedHor ? c.w - 3 : 3), c.y + (flippedVer ? c.h - 5 : 5), flippedVer ? c.y + c.h : c.screenHeight - c.y, flippedHor, flippedVer, c.screenScale);
                if (!session.getEntityInfoShowEntityModel() && effectsOffset != -1) {
                    healthOff += 3 + effectsOffset;
                }
            }
            boolean renderedArmor = session.getEntityInfoShowArmour() && this.drawArmourBar(mc, guiGraphics, session, displayedEntity, c.x + (flippedHor ? c.w - healthOff : healthOff), c.y + 15 + (flippedVer ? 31 : 0), flippedHor);
            this.drawHealthBar(mc, guiGraphics, session, displayedEntity, c.x + (flippedHor ? c.w - healthOff : healthOff), c.y + 15 + (flippedVer ? 31 : 0) + (renderedArmor ? 10 : 0) * (flippedVer ? -1 : 1), flippedHor, flippedVer);
            Component component = Misc.getFixedDisplayName((Entity)displayedEntity);
            if (component != null) {
                String name = component.getString();
                int xCoord = c.x + (flippedHor ? c.w - healthOff - mc.f_91062_.m_92895_(name) : healthOff);
                guiGraphics.m_280488_(mc.f_91062_, name, xCoord, c.y + 5 + (flippedVer ? 52 : 0), 0xFFFFFF);
            }
        }
        catch (Exception e) {
            BetterPVP.LOGGER.error("Please report this to Xaero96 on PlanetMinecraft/MinecraftForums/CurseForge!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawEntityOnScreen(Minecraft mc, PoseStack matrixStack, int x, int y, int scale, LivingEntity entity, boolean flip) {
        double cos;
        if (entity == null) {
            return;
        }
        EntityRenderDispatcher rendermanager = mc.m_91290_();
        if (rendermanager.f_114358_ == null) {
            return;
        }
        float yBodyRotBU = entity.f_20883_;
        float yRotBU = entity.m_146908_();
        float yHeadRotBU = entity.f_20885_;
        entity.f_20883_ = 0.0f;
        entity.m_146922_(0.0f);
        entity.f_20885_ = yHeadRotBU - yBodyRotBU;
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)x, (float)y, 50.0f);
        matrixStack.m_85841_((float)(-scale), (float)scale, (float)scale);
        OptimizedMath.rotatePose(matrixStack, 180.0f, (Vector3fc)OptimizedMath.ZP);
        OptimizedMath.rotatePose(matrixStack, 30.0f, (Vector3fc)OptimizedMath.XP);
        float width = entity.m_20205_() * (float)scale / 30.0f;
        if (width < 1.0f) {
            width = 1.0f;
        }
        if ((cos = Math.sqrt(2.0) / 2.0 / (double)width) > 1.0) {
            cos = 1.0;
        }
        float rotation = (float)Math.toDegrees(Math.acos(cos));
        OptimizedMath.rotatePose(matrixStack, (float)(flip ? 0 : 90) - rotation, (Vector3fc)OptimizedMath.YP);
        matrixStack.m_252880_(0.0f, -entity.m_20206_() / 2.0f, 0.0f);
        rendermanager.m_114468_(false);
        Lighting.m_84931_();
        boolean hideGUIBU = mc.f_91066_.f_92062_;
        mc.f_91066_.f_92062_ = true;
        try {
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            GraphicsStatus graphicsModeBU = (GraphicsStatus)mc.f_91066_.m_232060_().m_231551_();
            mc.f_91066_.m_232060_().m_231514_((Object)GraphicsStatus.FANCY);
            rendermanager.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (MultiBufferSource)bufferSource, 0xF000F0);
            mc.f_91066_.m_232060_().m_231514_((Object)graphicsModeBU);
            bufferSource.m_109911_();
        }
        finally {
            mc.f_91066_.f_92062_ = hideGUIBU;
            rendermanager.m_114468_(true);
            RenderSystem.disableBlend();
            entity.f_20883_ = yBodyRotBU;
            entity.m_146922_(yRotBU);
            entity.f_20885_ = yHeadRotBU;
            matrixStack.m_85849_();
        }
    }

    public boolean drawArmourBar(Minecraft mc, GuiGraphics guiGraphics, EntityInfoSession session, LivingEntity e, int x, int y, boolean flip) {
        int armorValue = e.m_21230_();
        if (armorValue > 0) {
            if (session.getEntityInfoArmourNumbers()) {
                guiGraphics.m_292816_(ARMOR_FULL, x - (flip ? 8 : 0), y, 9, 9);
                guiGraphics.m_280488_(mc.f_91062_, armorValue + "/20", x + (flip ? -11 - mc.f_91062_.m_92895_(armorValue + "/20") : 11), y, 0xFFFFFF);
            } else {
                for (int iconIndex = 0; iconIndex < 10; ++iconIndex) {
                    int iconX = x + (flip ? -8 - iconIndex * 8 : iconIndex * 8);
                    if (iconIndex * 2 + 1 < armorValue) {
                        guiGraphics.m_292816_(ARMOR_FULL, iconX, y, 9, 9);
                        continue;
                    }
                    if (iconIndex * 2 + 1 == armorValue) {
                        guiGraphics.m_292816_(ARMOR_HALF, iconX, y, 9, 9);
                        continue;
                    }
                    if (iconIndex * 2 + 1 <= armorValue) continue;
                    guiGraphics.m_292816_(ARMOR_EMPTY, iconX, y, 9, 9);
                }
            }
            return true;
        }
        return false;
    }

    public void drawHealthBar(Minecraft mc, GuiGraphics guiGraphics, EntityInfoSession session, LivingEntity e, int x, int y, boolean flip, boolean vertFlipped) {
        PoseStack matrixStack = guiGraphics.m_280168_();
        int health = Mth.m_14167_((float)e.m_21223_());
        float maxHealth = Mth.m_14165_((double)e.m_21133_(Attributes.f_22276_));
        float absorptionAmount = Mth.m_14167_((float)e.m_6103_());
        if (session.getEntityInfoHealthNumbers()) {
            String text = health + "/" + (int)maxHealth;
            if (absorptionAmount > 0.0f) {
                text = text + "+" + absorptionAmount;
                health = 0;
                maxHealth = 0.0f;
                absorptionAmount = 2.0f;
            } else {
                health = 2;
                maxHealth = 2.0f;
                absorptionAmount = 0.0f;
            }
            guiGraphics.m_280488_(mc.f_91062_, text, x + (flip ? -11 - mc.f_91062_.m_92895_(text) : 11), y, -1);
        }
        RenderSystem.enableBlend();
        int regularHalvesToRender = (int)(maxHealth + 1.0f) / 2 * 2;
        int regularFilledHalves = health;
        int absorptionHalvesToRender = (int)(absorptionAmount + 1.0f) / 2 * 2;
        int absorptionFilledHalves = (int)absorptionAmount;
        int limit = session.getEntityInfoMaxHearts() * 2;
        if (regularHalvesToRender > limit) {
            regularHalvesToRender = limit;
            int n = regularFilledHalves = maxHealth == 0.0f ? 0 : Math.round((float)(health * regularHalvesToRender) / maxHealth);
        }
        if (absorptionHalvesToRender > limit) {
            absorptionHalvesToRender = absorptionFilledHalves = limit;
        }
        int totalHalvesToRender = regularHalvesToRender + absorptionHalvesToRender;
        int rows = Mth.m_14167_((float)((float)totalHalvesToRender / 20.0f));
        int rowStep = Math.max(10 - (rows - 2), 3);
        boolean shake = maxHealth != 0.0f && (double)health <= (double)maxHealth * 0.4;
        int absorptionLeft = absorptionFilledHalves;
        Matrix4f modelMatrix = matrixStack.m_85850_().m_252922_();
        for (int heartIndex = totalHalvesToRender / 2 - 1; heartIndex >= 0; --heartIndex) {
            int rowIndex = (int)Math.ceil((float)(heartIndex + 1) / 10.0f) - 1;
            int xcoord = heartIndex % 10 * 8;
            int heartX = x + (flip ? -xcoord - 9 : xcoord);
            int heartY = y + rowIndex * rowStep * (vertFlipped ? -1 : 1);
            if (shake) {
                heartY += this.random.nextInt(2);
            }
            this.blitFlippable(mc, modelMatrix, HEART_CONTANER, heartX, heartY, 9, 9, flip);
            if (absorptionLeft > 0) {
                if (absorptionLeft == absorptionFilledHalves && absorptionFilledHalves % 2 == 1) {
                    this.blitFlippable(mc, modelMatrix, ABSORBING_HEART_HALF, heartX, heartY, 9, 9, flip);
                } else {
                    this.blitFlippable(mc, modelMatrix, ABSORBING_HEART_FULL, heartX, heartY, 9, 9, flip);
                }
                absorptionLeft -= 2;
                continue;
            }
            if (heartIndex * 2 + 1 < regularFilledHalves) {
                this.blitFlippable(mc, modelMatrix, NORMAL_HEART_FULL, heartX, heartY, 9, 9, flip);
            }
            if (heartIndex * 2 + 1 != regularFilledHalves) continue;
            this.blitFlippable(mc, modelMatrix, NORMAL_HEART_HALF, heartX, heartY, 9, 9, flip);
        }
        RenderSystem.disableBlend();
    }

    public double drawPotionEffects(Minecraft mc, GuiGraphics guiGraphics, EntityInfoSession session, LivingEntity e, int x, int y, int h, boolean flippedHor, boolean flippedVer, double scale) {
        Collection effects = e.m_21220_();
        if (effects.isEmpty()) {
            return -1.0;
        }
        effects = Ordering.natural().sortedCopy((Iterable)effects);
        PoseStack matrixStack = guiGraphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)x, (float)y, 0.0f);
        RenderSystem.enableBlend();
        MobEffectTextureManager effectSprites = mc.m_91306_();
        double pixelSize = (double)session.getEntityInfoEffectsScale() / scale * session.getAutoUIScale() / 2.0;
        double effectSize = 25.0 * pixelSize;
        int perColumn = (int)((double)h / effectSize);
        int place = 0;
        for (MobEffectInstance pe : effects) {
            TextureAtlasSprite sprite;
            if (pe == null || (sprite = effectSprites.m_118732_(pe.m_19544_())) == null) continue;
            matrixStack.m_85836_();
            matrixStack.m_85841_((float)pixelSize, (float)pixelSize, 1.0f);
            int column = place / perColumn;
            int row = place % perColumn;
            matrixStack.m_252880_(flippedHor ? (float)(-18 - 25 * column) : (float)(25 * column), flippedVer ? (float)(-18 - 25 * row) : (float)(25 * row), 0.0f);
            float alpha = 1.0f;
            if (!pe.m_267577_() && pe.m_19557_() <= 200 && !session.getEffectBlink()) {
                alpha = 0.4f;
            }
            guiGraphics.m_280565_(0, 0, 0, 18, 18, sprite, 1.0f, 1.0f, 1.0f, alpha);
            ++place;
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
        int rows = (effects.size() + perColumn - 1) / perColumn;
        return effectSize * (double)rows - 7.0 * pixelSize;
    }

    public void blitFlippable(Minecraft mc, Matrix4f matrix, ResourceLocation sprite, int x, int y, int width, int height, boolean flip) {
        TextureAtlasSprite textureAtlasSprite = mc.m_292761_().m_118901_(sprite);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureAtlasSprite.m_247685_());
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexbuffer = tessellator.m_85915_();
        vertexbuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vertexbuffer.m_252986_(matrix, (float)(x + 0), (float)(y + height), 0.0f).m_7421_(flip ? textureAtlasSprite.m_118410_() : textureAtlasSprite.m_118409_(), textureAtlasSprite.m_118412_()).m_5752_();
        vertexbuffer.m_252986_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_7421_(flip ? textureAtlasSprite.m_118409_() : textureAtlasSprite.m_118410_(), textureAtlasSprite.m_118412_()).m_5752_();
        vertexbuffer.m_252986_(matrix, (float)(x + width), (float)(y + 0), 0.0f).m_7421_(flip ? textureAtlasSprite.m_118409_() : textureAtlasSprite.m_118410_(), textureAtlasSprite.m_118411_()).m_5752_();
        vertexbuffer.m_252986_(matrix, (float)(x + 0), (float)(y + 0), 0.0f).m_7421_(flip ? textureAtlasSprite.m_118410_() : textureAtlasSprite.m_118409_(), textureAtlasSprite.m_118411_()).m_5752_();
        tessellator.m_85914_();
    }
}

