/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics.renderer.multitexture;

import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import net.minecraft.client.renderer.RenderType;

public class MultiTextureRenderTypeRenderer {
    private boolean used;
    private BufferBuilder bufferBuilder = new BufferBuilder(256);
    private List<BufferBuilder.RenderedBuffer> buffersForDrawCalls = new ArrayList<BufferBuilder.RenderedBuffer>();
    private IntArrayList texturesForDrawCalls = new IntArrayList();
    private IntConsumer textureBinderShader;
    private IntConsumer textureBinder;
    private Runnable textureFinalizer;
    private int prevTextureId;
    private RenderType renderType;

    MultiTextureRenderTypeRenderer() {
    }

    void init(IntConsumer textureBinderShader, IntConsumer textureBinder, Runnable textureFinalizer, RenderType renderType) {
        if (this.used) {
            throw new IllegalStateException("Multi-texture renderer already in use!");
        }
        this.used = true;
        this.textureBinderShader = textureBinderShader;
        this.textureBinder = textureBinder;
        this.textureFinalizer = textureFinalizer;
        this.prevTextureId = -1;
        this.renderType = renderType;
    }

    void draw() {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (!this.texturesForDrawCalls.isEmpty()) {
            BufferBuilder bufferBuilder = this.bufferBuilder;
            IntConsumer textureBinder = this.textureBinder;
            IntConsumer textureBinderShader = this.textureBinderShader;
            Runnable textureFinalizer = this.textureFinalizer;
            boolean hasTextureFinalizer = textureFinalizer != null;
            this.renderType.setupRenderState();
            this.endBuffer(bufferBuilder);
            boolean first = true;
            int shaderProgram = RenderSystem.getShader().getId();
            for (int i = 0; i < this.texturesForDrawCalls.size(); ++i) {
                int texture = this.texturesForDrawCalls.getInt(i);
                BufferBuilder.RenderedBuffer buffer = this.buffersForDrawCalls.get(i);
                if (texture == -1) {
                    texture = 0;
                }
                if (first) {
                    textureBinderShader.accept(texture);
                    BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)buffer);
                    ProgramManager.glUseProgram((int)shaderProgram);
                } else {
                    textureBinder.accept(texture);
                    BufferUploader.draw((BufferBuilder.RenderedBuffer)buffer);
                }
                if (hasTextureFinalizer) {
                    if (first) {
                        textureBinder.accept(texture);
                    }
                    textureFinalizer.run();
                }
                first = false;
            }
            textureBinder.accept(0);
            this.renderType.clearRenderState();
        }
        ProgramManager.glUseProgram((int)0);
        this.texturesForDrawCalls.clear();
        this.buffersForDrawCalls.clear();
        this.used = false;
        this.renderType = null;
    }

    private void endBuffer(BufferBuilder builder) {
        this.buffersForDrawCalls.add(builder.end());
    }

    public BufferBuilder begin(int textureId) {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (textureId == -1) {
            throw new IllegalStateException("Attempted to use the multi-texture renderer with texture id -1!");
        }
        if (textureId != this.prevTextureId) {
            if (this.prevTextureId != -1) {
                this.endBuffer(this.bufferBuilder);
            }
            this.bufferBuilder.begin(this.renderType.mode(), this.renderType.format());
            this.prevTextureId = textureId;
            this.texturesForDrawCalls.add(textureId);
        }
        return this.bufferBuilder;
    }
}

