/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.message;

import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPlayPayloadHandler;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import xaero.common.message.MinimapMessage;
import xaero.common.message.payload.MinimapMessagePayload;
import xaero.common.message.type.MinimapMessageType;

public class MinimapMessagePayloadHandler
implements IPlayPayloadHandler<MinimapMessagePayload<?>> {
    public void handle(MinimapMessagePayload<?> payload, PlayPayloadContext context) {
        this.handleTyped(payload, context);
    }

    private <T extends MinimapMessage<T>> void handleTyped(MinimapMessagePayload<T> payload, PlayPayloadContext context) {
        if (payload == null) {
            return;
        }
        Object message = payload.getMsg();
        MinimapMessageType type = payload.getType();
        if (context.flow() == PacketFlow.CLIENTBOUND) {
            if (type.getClientHandler() == null) {
                return;
            }
            context.workHandler().execute(() -> type.getClientHandler().handle((MinimapMessage)message));
            return;
        }
        if (type.getServerHandler() == null) {
            return;
        }
        ServerPlayer player = context.player().orElse(null);
        if (player == null) {
            return;
        }
        context.workHandler().execute(() -> type.getServerHandler().handle(player.getServer(), player, (MinimapMessage)message));
    }
}

