/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.message.payload;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import xaero.common.message.MinimapMessage;
import xaero.common.message.MinimapMessageHandlerFull;
import xaero.common.message.type.MinimapMessageType;

public class MinimapMessagePayload<T extends MinimapMessage<T>>
implements CustomPacketPayload {
    private final MinimapMessageType<T> type;
    private final T msg;
    private final MinimapMessageHandlerFull messageHandler;

    public MinimapMessagePayload(MinimapMessageType<T> type, T msg, MinimapMessageHandlerFull messageHandler) {
        this.type = type;
        this.msg = msg;
        this.messageHandler = messageHandler;
    }

    public MinimapMessageType<T> getType() {
        return this.type;
    }

    public T getMsg() {
        return this.msg;
    }

    public void write(@NotNull FriendlyByteBuf buf) {
        this.messageHandler.encodeMessage(this.type, (MinimapMessage<?>)this.msg, buf);
    }

    @NotNull
    public ResourceLocation id() {
        return MinimapMessage.MAIN_CHANNEL;
    }
}

