/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.trace;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SpriteCoordinateExpander;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.lwjgl.opengl.GL11;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.misc.Misc;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;

public class EntityRenderTracer {
    public static boolean TRACING_MODEL_RENDERS;
    private Entity tracedEntity;
    private EntityRenderer tracedEntityRenderer;
    private Class<?> tracedEntityModelClass;
    private List<ModelRenderTrace> traceResultList;
    private ModelRenderTrace lastModelRenderDetected;
    private MultiBufferSource.BufferSource modelRenderDetectionRenderTypeBuffer;
    private Field lastStateField;
    private Class<?> compositeRenderTypeClass;
    private Field enderDragonModelField;
    private Field stateField;
    private Class<?> textureStateShardClass;
    private Field compositeStateTextureStateField;
    private Field textureStateShardTextureField;
    private Field compositeStateDepthTestStateField;
    private Field compositeStateWriteMaskStateField;
    private Field compositeStateCullStateField;
    private Field compositeStateTransparencyStateField;
    private Field compositeStateShaderStateField;
    private Field renderBuffersBufferSourceField;
    private Field spriteCoordinateExpanderSpriteField;
    private Class<?> irisRenderLayerWrapperClass;
    private Method irisRenderLayerWrapperUnwrapMethod;

    public EntityRenderTracer() {
        this.initReflection();
        this.traceResultList = new ArrayList<ModelRenderTrace>();
    }

    public <T extends Entity> List<ModelRenderTrace> trace(PoseStack matrixStack, T entity, EntityRenderer<? super T> entityRenderer) {
        TRACING_MODEL_RENDERS = true;
        this.tracedEntity = entity;
        this.tracedEntityRenderer = entityRenderer;
        this.tracedEntityModelClass = null;
        this.traceResultList.clear();
        this.lastModelRenderDetected = null;
        PoseStack.Pose matrixEntryToRestore = matrixStack.last();
        matrixStack.pushPose();
        try {
            MultiBufferSource.BufferSource renderTypeBuffer = this.modelRenderDetectionRenderTypeBuffer = (MultiBufferSource.BufferSource)Misc.getReflectFieldValue(Minecraft.getInstance().renderBuffers(), this.renderBuffersBufferSourceField);
            entityRenderer.render(entity, 0.0f, 1.0f, matrixStack, (MultiBufferSource)renderTypeBuffer, 0xF000F0);
            renderTypeBuffer.endBatch();
            OpenGLException.checkGLError();
        }
        catch (Throwable e) {
            this.traceResultList.clear();
            MinimapLogs.LOGGER.error("Exception when calling the full entity renderer for {} before prerendering the icon.", (Object)entity.getScoreboardName(), (Object)e);
        }
        TRACING_MODEL_RENDERS = false;
        this.tracedEntity = null;
        this.tracedEntityRenderer = null;
        while (matrixStack.last() != matrixEntryToRestore) {
            matrixStack.popPose();
        }
        while (GL11.glGetError() != 0) {
        }
        return this.traceResultList;
    }

    public void onModelRender(EntityModel<?> model, VertexConsumer vertexConsumer, float red, float green, float blue, float alpha) {
        this.lastModelRenderDetected = null;
        if (this.tracedEntityModelClass == null) {
            EntityModel currentMainModel = this.getEntityRendererModel(this.tracedEntityRenderer);
            Class<?> clazz = this.tracedEntityModelClass = currentMainModel == null ? null : currentMainModel.getClass();
            if (this.tracedEntityModelClass == null) {
                return;
            }
        }
        if (!model.getClass().isAssignableFrom(this.tracedEntityModelClass) && !this.tracedEntityModelClass.isAssignableFrom(model.getClass())) {
            return;
        }
        RenderType lastRenderType = this.getLastRenderType((MultiBufferSource)this.modelRenderDetectionRenderTypeBuffer);
        if (lastRenderType == null && this.traceResultList.isEmpty()) {
            ResourceLocation textureLocation = null;
            try {
                ResourceLocation textureLocationUnchecked;
                textureLocation = textureLocationUnchecked = this.tracedEntityRenderer.getTextureLocation(this.tracedEntity);
            }
            catch (Throwable t) {
                MinimapLogs.LOGGER.error("Couldn't fetch main entity texture when trying to use an alternative render type for an icon!", t);
            }
            if (textureLocation != null) {
                lastRenderType = model.renderType(textureLocation);
            }
        }
        if (lastRenderType == null) {
            return;
        }
        Object renderState = this.getRenderState(lastRenderType);
        if (renderState == null) {
            return;
        }
        Object renderTextureState = Misc.getReflectFieldValue(renderState, this.compositeStateTextureStateField);
        ResourceLocation texture = null;
        if (this.textureStateShardClass.isAssignableFrom(renderTextureState.getClass())) {
            texture = this.getRenderStateTextureStateTexture(renderTextureState);
        }
        Object renderTransparencyState = Misc.getReflectFieldValue(renderState, this.compositeStateTransparencyStateField);
        renderTransparencyState = this.fixAdditiveTransparency(renderTransparencyState);
        Object renderDepthTestState = Misc.getReflectFieldValue(renderState, this.compositeStateDepthTestStateField);
        Object renderWriteMaskState = Misc.getReflectFieldValue(renderState, this.compositeStateWriteMaskStateField);
        Object renderCullState = Misc.getReflectFieldValue(renderState, this.compositeStateCullStateField);
        Object renderShaderState = Misc.getReflectFieldValue(renderState, this.compositeStateShaderStateField);
        CustomRenderTypes.EntityIconLayerPhases layerPhases = new CustomRenderTypes.EntityIconLayerPhases(renderTextureState, renderTransparencyState, renderDepthTestState, renderWriteMaskState, renderCullState, renderShaderState);
        TextureAtlasSprite renderAtlasSprite = null;
        if (vertexConsumer instanceof SpriteCoordinateExpander) {
            renderAtlasSprite = (TextureAtlasSprite)Misc.getReflectFieldValue(vertexConsumer, this.spriteCoordinateExpanderSpriteField);
        }
        this.lastModelRenderDetected = new ModelRenderTrace(model, texture, renderAtlasSprite, layerPhases, red, green, blue, alpha);
        this.traceResultList.add(this.lastModelRenderDetected);
    }

    private Object fixAdditiveTransparency(Object renderTransparencyState) {
        int blendSrcFactor;
        Object result = renderTransparencyState;
        ((RenderStateShard)renderTransparencyState).setupRenderState();
        int blendDestFactor = GL11.glGetInteger((int)32968);
        if (blendDestFactor == 1 && (blendSrcFactor = GL11.glGetInteger((int)32969)) != 0) {
            result = CustomRenderTypes.getTransparencyPhase(blendSrcFactor, blendDestFactor, 0, 1);
        }
        ((RenderStateShard)renderTransparencyState).clearRenderState();
        return result;
    }

    public void onModelPartRender(ModelPart modelRenderer, float red, float green, float blue, float alpha) {
        if (this.lastModelRenderDetected != null) {
            this.lastModelRenderDetected.addVisibleModelPart(modelRenderer, red, green, blue, alpha);
        }
    }

    private RenderType getLastRenderType(MultiBufferSource renderTypeBuffer) {
        if (!(renderTypeBuffer instanceof MultiBufferSource.BufferSource)) {
            return null;
        }
        Object lastRenderTypeObject = Misc.getReflectFieldValue(renderTypeBuffer, this.lastStateField);
        if (lastRenderTypeObject instanceof Optional) {
            return ((Optional)lastRenderTypeObject).orElse(null);
        }
        return (RenderType)lastRenderTypeObject;
    }

    private Object getRenderState(RenderType renderType) {
        while (renderType.getClass() == this.irisRenderLayerWrapperClass && this.irisRenderLayerWrapperUnwrapMethod != null) {
            renderType = (RenderType)Misc.getReflectMethodValue(renderType, this.irisRenderLayerWrapperUnwrapMethod, new Object[0]);
        }
        if (renderType.getClass() == this.compositeRenderTypeClass) {
            return Misc.getReflectFieldValue(renderType, this.stateField);
        }
        return null;
    }

    private ResourceLocation getRenderStateTextureStateTexture(Object renderTextureState) {
        Object renderStateTextureObject = Misc.getReflectFieldValue(renderTextureState, this.textureStateShardTextureField);
        if (!(renderStateTextureObject instanceof Optional)) {
            return (ResourceLocation)renderStateTextureObject;
        }
        Optional optional = (Optional)renderStateTextureObject;
        return optional.orElse(null);
    }

    public <T extends Entity> EntityModel<T> getEntityRendererModel(EntityRenderer<? super T> entityRenderer) {
        if (entityRenderer instanceof LivingEntityRenderer) {
            return ((LivingEntityRenderer)entityRenderer).getModel();
        }
        if (entityRenderer instanceof EnderDragonRenderer) {
            return (EntityModel)Misc.getReflectFieldValue(entityRenderer, this.enderDragonModelField);
        }
        return null;
    }

    private void initReflection() {
        this.enderDragonModelField = Misc.getFieldReflection(EnderDragonRenderer.class, "model", "field_21008", "Lnet/minecraft/class_895$class_625;", "f_114183_");
        try {
            this.lastStateField = Misc.getFieldReflection(MultiBufferSource.BufferSource.class, "lastState", "field_20954", "Ljava/util/Optional;", "f_109906_");
        }
        catch (Exception e) {
            this.lastStateField = Misc.getFieldReflection(MultiBufferSource.BufferSource.class, "lastState", "c", "Ljava/util/Optional;", "f_109906_");
        }
        try {
            this.compositeRenderTypeClass = Misc.getClassForName("net.minecraft.class_1921$class_4687", "net.minecraft.client.renderer.RenderType$CompositeRenderType");
            this.stateField = Misc.getFieldReflection(this.compositeRenderTypeClass, "state", "field_21403", "Lnet/minecraft/class_1921$class_4688;", "f_110511_");
            Class<?> compositeStateClass = Misc.getClassForName("net.minecraft.class_1921$class_4688", "net.minecraft.client.renderer.RenderType$CompositeState");
            this.textureStateShardClass = Misc.getClassForName("net.minecraft.class_4668$class_4683", "net.minecraft.client.renderer.RenderStateShard$TextureStateShard");
            this.compositeStateTextureStateField = Misc.getFieldReflection(compositeStateClass, "textureState", "field_21406", "Lnet/minecraft/class_4668$class_5939;", "f_110576_");
            this.textureStateShardTextureField = Misc.getFieldReflection(this.textureStateShardClass, "texture", "field_21397", "Ljava/util/Optional;", "f_110328_");
            this.compositeStateTransparencyStateField = Misc.getFieldReflection(compositeStateClass, "transparencyState", "field_21407", "Lnet/minecraft/class_4668$class_4685;", "f_110577_");
            this.compositeStateDepthTestStateField = Misc.getFieldReflection(compositeStateClass, "depthTestState", "field_21411", "Lnet/minecraft/class_4668$class_4672;", "f_110581_");
            this.compositeStateWriteMaskStateField = Misc.getFieldReflection(compositeStateClass, "writeMaskState", "field_21419", "Lnet/minecraft/class_4668$class_4686;", "f_110589_");
            this.compositeStateCullStateField = Misc.getFieldReflection(compositeStateClass, "cullState", "field_21412", "Lnet/minecraft/class_4668$class_4671;", "f_110582_");
            this.compositeStateShaderStateField = Misc.getFieldReflection(compositeStateClass, "shaderState", "field_29461", "Lnet/minecraft/class_4668$class_5942;", "f_173274_");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        this.renderBuffersBufferSourceField = Misc.getFieldReflection(RenderBuffers.class, "bufferSource", "field_20958", "Lnet/minecraft/class_4597$class_4598;", "f_110094_");
        this.spriteCoordinateExpanderSpriteField = Misc.getFieldReflection(SpriteCoordinateExpander.class, "sprite", "field_21731", "Lnet/minecraft/class_1058;", "f_110796_");
        try {
            try {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderTypeWrapper");
            }
            catch (ClassNotFoundException e) {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderLayerWrapper");
            }
            this.irisRenderLayerWrapperUnwrapMethod = Misc.getMethodReflection(this.irisRenderLayerWrapperClass, "unwrap", "unwrap", "()Lnet/minecraft/class_1921;", "unwrap", new Class[0]);
            MinimapLogs.LOGGER.info("Old Iris detected and supported!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

