/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.waypoint.render.world;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import xaero.common.HudMod;
import xaero.common.effect.Effects;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.gui.GuiMisc;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointUtil;
import xaero.common.minimap.waypoints.render.WaypointsIngameRenderer;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.element.render.MinimapElementReader;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderer;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointPurpose;
import xaero.hud.minimap.waypoint.render.world.WaypointWorldRenderContext;
import xaero.hud.minimap.waypoint.render.world.WaypointWorldRenderProvider;
import xaero.hud.minimap.waypoint.render.world.WaypointWorldRenderReader;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;
import xaero.hud.render.util.RenderBufferUtil;

public abstract class WaypointWorldRenderer
extends MinimapElementRenderer<Waypoint, WaypointWorldRenderContext> {
    private Vector3f lookVector;
    private boolean temporaryWaypointsGlobal;
    private double waypointsDistance;
    private double waypointsDistanceMin;
    private int distanceSetting;
    private boolean displayShortDistances;
    private boolean dimensionScaleDistance;
    private double clampDepth;
    private int lookingAtAngle;
    private int lookingAtAngleVertical;
    private boolean keepWaypointNames;
    private int autoConvertWaypointDistanceToKmThreshold;
    private int waypointDistancePrecision;
    private float iconScale;
    private int distanceTextScale;
    private int nameScale;
    protected int opacity;
    private float cameraAngleYaw;
    private float cameraAnglePitch;
    private String subWorldName;
    private MinimapRendererHelper helper;
    private Font fontRenderer;
    private MultiBufferSource.BufferSource minimapBufferSource;
    protected VertexConsumer texturedIconConsumer;
    protected VertexConsumer waypointBackgroundConsumer;

    protected WaypointWorldRenderer(MinimapElementReader<Waypoint, WaypointWorldRenderContext> elementReader, WaypointWorldRenderProvider provider, WaypointWorldRenderContext context) {
        super(elementReader, provider, context);
    }

    @Override
    public boolean renderElement(Waypoint w, boolean highlighted, boolean outOfBounds, double optionalDepth, float optionalScale, double partialX, double partialY, MinimapElementRenderInfo renderInfo, GuiGraphics guiGraphics, MultiBufferSource.BufferSource vanillaBufferSource) {
        double zFromEntity;
        double distanceFromEntity;
        double waypointPosDivider = renderInfo.backgroundCoordinateScale / ((WaypointWorldRenderContext)this.context).dimCoordinateScale;
        double wX = (double)w.getX(waypointPosDivider) + 0.5;
        double wZ = (double)w.getZ(waypointPosDivider) + 0.5;
        double offX = wX - renderInfo.renderPos.x;
        double offY = (double)w.getY() + 1.0 - renderInfo.renderPos.y;
        if (!w.isYIncluded()) {
            offY = renderInfo.renderEntityPos.y + 1.0 - renderInfo.renderPos.y;
        }
        double offZ = wZ - renderInfo.renderPos.z;
        double distance2D = Math.sqrt(offX * offX + offZ * offZ);
        if (this.waypointsDistanceMin != 0.0 && distance2D < this.waypointsDistanceMin) {
            return false;
        }
        double distanceScale = this.dimensionScaleDistance ? renderInfo.backgroundCoordinateScale : 1.0;
        double scaledDistance2D = distance2D * distanceScale;
        if (!(w.isDestination() || w.getPurpose() == WaypointPurpose.DEATH || w.isGlobal() || w.isTemporary() && this.temporaryWaypointsGlobal || this.waypointsDistance == 0.0 || !(scaledDistance2D > this.waypointsDistance))) {
            return false;
        }
        Vector3f lookVector = this.lookVector;
        double depth = offX * (double)lookVector.x() + offY * (double)lookVector.y() + offZ * (double)lookVector.z();
        double xFromEntity = wX - renderInfo.renderEntityPos.x;
        double yFromEntity = (double)w.getY() - renderInfo.renderEntityPos.y;
        if (!w.isYIncluded()) {
            yFromEntity = 0.0;
        }
        boolean usingNearbyDisplay = (distanceFromEntity = Math.sqrt(xFromEntity * xFromEntity + yFromEntity * yFromEntity + (zFromEntity = wZ - renderInfo.renderEntityPos.z) * zFromEntity)) <= 20.0 && !this.displayShortDistances;
        boolean displayingDistance = !usingNearbyDisplay && highlighted;
        String distanceText = displayingDistance ? this.getDistanceText(distanceFromEntity) : null;
        String name = null;
        if (usingNearbyDisplay || displayingDistance && this.keepWaypointNames || !displayingDistance && w.getPurpose() == WaypointPurpose.DEATH) {
            name = w.getLocalizedName();
        }
        Font fontRenderer = this.fontRenderer;
        MultiBufferSource.BufferSource bufferSource = this.minimapBufferSource;
        float iconScale = this.iconScale;
        int nameScale = this.nameScale;
        int halfIconPixel = (int)iconScale / 2;
        PoseStack matrixStack = guiGraphics.pose();
        if (renderInfo.location == MinimapElementRenderLocation.IN_WORLD && depth < this.clampDepth) {
            float scale = (float)(this.clampDepth / depth);
            matrixStack.scale(scale, scale, 1.0f);
        }
        matrixStack.translate((double)halfIconPixel, 0.0, optionalDepth);
        this.renderIconWithLabels(w, highlighted, name, distanceText, this.subWorldName, iconScale, nameScale, this.distanceTextScale, fontRenderer, halfIconPixel, matrixStack, bufferSource);
        return true;
    }

    @Override
    public void preRender(MinimapElementRenderInfo renderInfo, MultiBufferSource.BufferSource vanillaBufferSource, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        Minecraft mc = Minecraft.getInstance();
        Camera activeRender = mc.gameRenderer.getMainCamera();
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        MinimapWorldManager manager = session.getWorldManager();
        MinimapWorld currentWorld = manager.getCurrentWorld();
        ModSettings settings = HudMod.INSTANCE.getSettings();
        this.lookVector = activeRender.getLookVector().get(new Vector3f());
        this.cameraAngleYaw = activeRender.getYRot();
        this.cameraAnglePitch = activeRender.getXRot();
        double fov = ((Integer)mc.options.fov().get()).doubleValue();
        int screenWidth = mc.getWindow().getWidth();
        int screenHeight = mc.getWindow().getHeight();
        this.subWorldName = null;
        if (currentWorld != null && manager.getAutoWorld() != currentWorld) {
            this.subWorldName = "(" + currentWorld.getContainer().getSubName() + ")";
        }
        ((WaypointWorldRenderContext)this.context).dimCoordinateScale = session.getDimensionHelper().getDimCoordinateScale(manager.getCurrentWorld());
        ((WaypointWorldRenderContext)this.context).renderEntityPos = renderInfo.renderEntityPos;
        int displayMultipleWaypointInfo = settings.displayMultipleWaypointInfo;
        ((WaypointWorldRenderContext)this.context).onlyMainInfo = displayMultipleWaypointInfo == 0 || displayMultipleWaypointInfo == 1 && !renderInfo.renderEntity.isShiftKeyDown();
        this.temporaryWaypointsGlobal = settings.temporaryWaypointsGlobal;
        this.waypointsDistance = settings.getMaxWaypointsDistance();
        this.waypointsDistanceMin = settings.waypointsDistanceMin;
        this.distanceSetting = settings.distance;
        this.displayShortDistances = settings.alwaysShowDistance;
        this.dimensionScaleDistance = settings.dimensionScaledMaxWaypointDistance;
        this.clampDepth = settings.getWaypointsClampDepth(fov, screenHeight);
        this.lookingAtAngle = Mth.clamp((int)settings.lookingAtAngle, (int)0, (int)180);
        this.lookingAtAngleVertical = Mth.clamp((int)settings.lookingAtAngleVertical, (int)0, (int)180);
        this.keepWaypointNames = settings.keepWaypointNames;
        this.autoConvertWaypointDistanceToKmThreshold = settings.autoConvertWaypointDistanceToKmThreshold;
        this.waypointDistancePrecision = settings.waypointDistancePrecision;
        this.iconScale = settings.getWaypointsIngameIconScale();
        this.distanceTextScale = (int)Math.ceil(settings.getWaypointsIngameDistanceScale());
        this.nameScale = settings.getWaypointsIngameNameScale();
        this.opacity = settings.waypointOpacityIngame;
        ((WaypointWorldRenderContext)this.context).interactionBoxTop = this.distanceSetting == 0 || this.lookingAtAngleVertical == 0 ? 0 : (this.distanceSetting == 2 || this.lookingAtAngleVertical >= 90 ? -screenHeight : -OptimizedMath.myFloor((double)(screenHeight / 2) * Math.tan(Math.toRadians(this.lookingAtAngleVertical)) / Math.tan(Math.toRadians(fov / 2.0))));
        double horizontalTan = Math.tan(Math.toRadians(fov / 2.0)) * (double)screenWidth / (double)screenHeight;
        int n = this.distanceSetting == 0 || this.lookingAtAngle == 0 ? 0 : (((WaypointWorldRenderContext)this.context).interactionBoxLeft = this.distanceSetting == 2 || this.lookingAtAngle >= 90 ? -screenWidth : -OptimizedMath.myFloor((double)(screenWidth / 2) * Math.tan(Math.toRadians(this.lookingAtAngle)) / horizontalTan));
        if (Minecraft.getInstance().isEnforceUnicode()) {
            this.iconScale = (float)(Math.ceil(this.iconScale / 2.0f) * 2.0);
            this.distanceTextScale = (this.distanceTextScale + 1) / 2 * 2;
            this.nameScale = (this.nameScale + 1) / 2 * 2;
        }
        this.helper = HudMod.INSTANCE.getMinimap().getMinimapFBORenderer().getHelper();
        this.fontRenderer = mc.font;
        RenderSystem.disableDepthTest();
        vanillaBufferSource.endBatch();
        this.minimapBufferSource = HudMod.INSTANCE.getHudRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
        this.waypointBackgroundConsumer = this.minimapBufferSource.getBuffer(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
        this.texturedIconConsumer = this.minimapBufferSource.getBuffer(CustomRenderTypes.GUI_NEAREST);
    }

    @Override
    public void postRender(MinimapElementRenderInfo renderInfo, MultiBufferSource.BufferSource vanillaBufferSource, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        this.minimapBufferSource.endBatch();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        ((WaypointWorldRenderContext)this.context).onlyMainInfo = false;
        ((WaypointWorldRenderContext)this.context).renderEntityPos = null;
        this.fontRenderer = null;
        this.minimapBufferSource = null;
        this.waypointBackgroundConsumer = null;
        this.texturedIconConsumer = null;
    }

    protected void renderIconWithLabels(Waypoint w, boolean highlit, String name, String distanceText, String subWorldName, float iconScale, int nameScale, int distanceTextScale, Font fontRenderer, int halfIconPixel, PoseStack matrixStack, MultiBufferSource.BufferSource bufferSource) {
        matrixStack.scale(iconScale, iconScale, 1.0f);
        this.renderIcon(w, highlit, matrixStack, fontRenderer, bufferSource);
        matrixStack.scale(1.0f / iconScale, 1.0f / iconScale, 1.0f);
        matrixStack.translate((float)(-halfIconPixel), 0.0f, 0.0f);
        matrixStack.translate(0.0f, 2.0f, 0.0f);
        float labelAlpha = 0.3529412f;
        if ((distanceText != null || name != null) && subWorldName != null) {
            this.renderWaypointLabel(subWorldName, matrixStack, this.helper, fontRenderer, nameScale, labelAlpha);
            matrixStack.translate(0.0f, 2.0f, 0.0f);
        }
        if (name != null) {
            this.renderWaypointLabel(name, matrixStack, this.helper, fontRenderer, nameScale, labelAlpha);
        }
        matrixStack.translate(0.0f, 2.0f, 0.0f);
        if (distanceText != null) {
            this.renderWaypointLabel(distanceText, matrixStack, this.helper, fontRenderer, distanceTextScale, labelAlpha);
        }
    }

    protected void renderIcon(Waypoint w, boolean highlit, PoseStack matrixStack, Font fontRenderer, MultiBufferSource.BufferSource bufferSource) {
        int color = w.getWaypointColor().getHex();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = 0.52274513f * (float)this.opacity / 100.0f;
        if (highlit && ((WaypointWorldRenderContext)this.context).onlyMainInfo) {
            alpha = Math.min(1.0f, alpha * 1.5f);
        }
        int initialsWidth = w.getPurpose() == WaypointPurpose.DEATH ? 7 : fontRenderer.width(w.getInitials());
        int addedFrame = WaypointUtil.getAddedMinimapIconFrame(initialsWidth);
        this.renderColorBackground(matrixStack, addedFrame, red, green, blue, alpha, this.waypointBackgroundConsumer);
        if (w.getPurpose() == WaypointPurpose.DEATH) {
            this.renderTexturedIcon(matrixStack, addedFrame, 0, 78, 0.9882f, 0.9882f, 0.9882f, 1.0f, this.texturedIconConsumer);
            return;
        }
        Misc.drawNormalText(matrixStack, w.getInitials(), (float)(-initialsWidth / 2), -8.0f, -1, false, bufferSource);
    }

    private void renderColorBackground(PoseStack matrixStack, int addedFrame, float r, float g, float b, float a, VertexConsumer waypointBackgroundConsumer) {
        Matrix4f matrix = matrixStack.last().pose();
        waypointBackgroundConsumer.vertex(matrix, (float)(-5 - addedFrame), -9.0f, 0.0f).color(r, g, b, a).endVertex();
        waypointBackgroundConsumer.vertex(matrix, (float)(-5 - addedFrame), 0.0f, 0.0f).color(r, g, b, a).endVertex();
        waypointBackgroundConsumer.vertex(matrix, (float)(4 + addedFrame), 0.0f, 0.0f).color(r, g, b, a).endVertex();
        waypointBackgroundConsumer.vertex(matrix, (float)(4 + addedFrame), -9.0f, 0.0f).color(r, g, b, a).endVertex();
    }

    private void renderTexturedIcon(PoseStack matrixStack, int addedFrame, int textureX, int textureY, float r, float g, float b, float a, VertexConsumer vertexBuffer) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Matrix4f matrix = matrixStack.last().pose();
        vertexBuffer.vertex(matrix, (float)(-5 - addedFrame), (float)(-9 - addedFrame), 0.0f).color(r, g, b, a).uv((float)textureX * f, (float)textureY * f1).endVertex();
        vertexBuffer.vertex(matrix, (float)(-5 - addedFrame), (float)addedFrame, 0.0f).color(r, g, b, a).uv((float)textureX * f, (float)(textureY + 9 + addedFrame * 2) * f1).endVertex();
        vertexBuffer.vertex(matrix, (float)(4 + addedFrame), (float)addedFrame, 0.0f).color(r, g, b, a).uv((float)(textureX + 9 + addedFrame * 2) * f, (float)(textureY + 9 + addedFrame * 2) * f1).endVertex();
        vertexBuffer.vertex(matrix, (float)(4 + addedFrame), (float)(-9 - addedFrame), 0.0f).color(r, g, b, a).uv((float)(textureX + 9 + addedFrame * 2) * f, (float)textureY * f1).endVertex();
    }

    protected void renderWaypointLabel(String label, PoseStack matrixStack, MinimapRendererHelper helper, Font fontRenderer, int labelScale, float bgAlpha) {
        int nameWidth = fontRenderer.width(label);
        int backgroundWidth = nameWidth + 3;
        int halfBackgroundWidth = backgroundWidth / 2;
        int halfPixel = 0;
        if ((backgroundWidth & 1) != 0) {
            halfPixel = labelScale - labelScale / 2;
            matrixStack.translate((float)(-halfPixel), 0.0f, 0.0f);
        }
        matrixStack.scale((float)labelScale, (float)labelScale, 1.0f);
        RenderBufferUtil.addColoredRect(matrixStack.last().pose(), this.waypointBackgroundConsumer, -halfBackgroundWidth, 0.0f, backgroundWidth, 9, 0.0f, 0.0f, 0.0f, bgAlpha);
        Misc.drawNormalText(matrixStack, label, (float)(-halfBackgroundWidth + 2), 1.0f, -1, false, this.minimapBufferSource);
        matrixStack.translate(0.0f, 9.0f, 0.0f);
        matrixStack.scale(1.0f / (float)labelScale, 1.0f / (float)labelScale, 1.0f);
        if ((backgroundWidth & 1) != 0) {
            matrixStack.translate((float)halfPixel, 0.0f, 0.0f);
        }
    }

    private String getDistanceText(double distanceFromEntity) {
        if (this.autoConvertWaypointDistanceToKmThreshold != -1 && distanceFromEntity >= (double)this.autoConvertWaypointDistanceToKmThreshold) {
            return GuiMisc.getFormat(this.waypointDistancePrecision).format(distanceFromEntity / 1000.0) + "km";
        }
        return GuiMisc.getFormat(this.waypointDistancePrecision).format(distanceFromEntity) + "m";
    }

    @Override
    public boolean shouldRender(MinimapElementRenderLocation location) {
        if (!HudMod.INSTANCE.getSettings().getShowIngameWaypoints()) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        return mc.player != null && !Misc.hasEffect((Player)mc.player, Effects.NO_WAYPOINTS) && !Misc.hasEffect((Player)mc.player, Effects.NO_WAYPOINTS_HARMFUL);
    }

    @Override
    public int getOrder() {
        return 100;
    }

    public static final class Builder {
        private Builder() {
        }

        private Builder setDefault() {
            return this;
        }

        public WaypointWorldRenderer build() {
            WaypointWorldRenderContext context = new WaypointWorldRenderContext();
            return new WaypointsIngameRenderer(new WaypointWorldRenderReader(context), new WaypointWorldRenderProvider(), context, new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

