/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import xaero.common.graphics.shader.MinimapShaders;
import xaero.hud.render.TextureLocations;

public class CustomRenderTypes
extends RenderType {
    protected static final RenderStateShard.DepthTestStateShard GREATER_DEPTH_TEST = new RenderStateShard.DepthTestStateShard(">", 516);
    private static final RenderStateShard.OutputStateShard KEEP_TARGET = new RenderStateShard.OutputStateShard("xaero_keep_target", () -> {}, () -> {});
    protected static final RenderStateShard.TransparencyStateShard TRANSLUCENT_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("xaero_translucent_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
    });
    protected static final RenderStateShard.TransparencyStateShard LINES_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("xaero_lines_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
    });
    protected static final RenderStateShard.TransparencyStateShard PREMULTIPLIED_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("xaero_wm_premultiplied_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
    });
    public static final float DEFAULT_POLYGON_OFFSET = 10.0f;
    protected static final RenderStateShard.LayeringStateShard POLYGON_OFFSET_LAYERING = new RenderStateShard.LayeringStateShard("xaero_polygon_offset_layering", () -> {
        RenderSystem.m_69863_((float)0.0f, (float)10.0f);
        RenderSystem.m_69486_();
    }, () -> {
        RenderSystem.m_69863_((float)0.0f, (float)0.0f);
        RenderSystem.m_69469_();
    });
    public static final RenderType GUI_BILINEAR;
    public static final RenderType GUI_BILINEAR_PREMULTIPLIED;
    public static final RenderType GUI_NEAREST;
    public static final RenderType COLORED_WAYPOINTS_BGS;
    public static final RenderType MAP_CHUNK_OVERLAY;
    public static final RenderType MAP_LINES;
    public static final RenderType RADAR_NAME_BGS;
    public static final RenderType DEPTH_CLEAR;

    public static RenderType entityIconRenderType(ResourceLocation texture, EntityIconLayerPhases layerPhases) {
        ImmutableList<RenderStateShard> rendertype$state = new MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)layerPhases.texture).transparency(layerPhases.transparency).shader(layerPhases.shader).depthTest(layerPhases.depthTest).writeMaskState(layerPhases.writeMask).cull(layerPhases.cull).lightmap(f_110152_).overlay(f_110154_).target(KEEP_TARGET).build();
        return new MultiPhaseRenderType("xaero_entity_icon", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, true, rendertype$state);
    }

    private CustomRenderTypes(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static void resetDepthTest() {
        MultiPhaseBuilder.resetDepthTest();
    }

    public static void resetWriteMask() {
        MultiPhaseBuilder.resetWriteMask();
    }

    public static void resetTransparency() {
        MultiPhaseBuilder.resetTransparency();
    }

    public static RenderStateShard.TransparencyStateShard getTransparencyPhase(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        return new RenderStateShard.TransparencyStateShard("xaero_custom_transparency", () -> {
            RenderSystem.m_69478_();
            RenderSystem.m_69411_((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
        }, () -> {
            RenderSystem.m_69461_();
            RenderSystem.m_69453_();
        });
    }

    public static EntityIconLayerPhases getBasicEntityIconLayerPhases(ResourceLocation texture) {
        return new EntityIconLayerPhases(new RenderStateShard.TextureStateShard(texture, false, false), TRANSLUCENT_TRANSPARENCY, f_110113_, f_110114_, f_110110_, f_173066_);
    }

    static {
        ImmutableList<RenderStateShard> multiPhaseParameters = new MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocations.GUI_TEXTURES, false, false)).transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MinimapShaders.POSITION_COLOR_TEX)).cull(f_110110_).target(KEEP_TARGET).build();
        GUI_NEAREST = new MultiPhaseRenderType("xaero_gui_nearest", DefaultVertexFormat.f_85818_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocations.GUI_TEXTURES, true, false)).transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MinimapShaders.POSITION_COLOR_TEX)).cull(f_110110_).target(KEEP_TARGET).build();
        GUI_BILINEAR = new MultiPhaseRenderType("xaero_gui_bilinear", DefaultVertexFormat.f_85818_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocations.GUI_TEXTURES, true, false)).transparency(PREMULTIPLIED_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MinimapShaders.POSITION_COLOR_TEX_PRE)).cull(f_110110_).target(KEEP_TARGET).build();
        GUI_BILINEAR_PREMULTIPLIED = new MultiPhaseRenderType("xaero_gui_bilinear_pre", DefaultVertexFormat.f_85818_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MinimapShaders.POSITION_COLOR)).target(KEEP_TARGET).layering(POLYGON_OFFSET_LAYERING).build();
        COLORED_WAYPOINTS_BGS = new MultiPhaseRenderType("xaero_colored_waypoints", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MinimapShaders.POSITION_COLOR)).target(KEEP_TARGET).layering(POLYGON_OFFSET_LAYERING).build();
        RADAR_NAME_BGS = new MultiPhaseRenderType("xaero_radar_name_bg", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MinimapShaders.POSITION_COLOR)).target(KEEP_TARGET).build();
        MAP_CHUNK_OVERLAY = new MultiPhaseRenderType("xaero_chunk_overlay", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(LINES_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MinimapShaders.FRAMEBUFFER_LINES)).target(KEEP_TARGET).build();
        MAP_LINES = new MultiPhaseRenderType("xaero_lines", DefaultVertexFormat.f_166851_, VertexFormat.Mode.LINES, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MinimapShaders.POSITION_COLOR_NO_ALPHA_TEST)).target(KEEP_TARGET).depthTest(GREATER_DEPTH_TEST).writeMaskState(f_110116_).build();
        DEPTH_CLEAR = new MultiPhaseRenderType("xaero_depth_clear", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
    }

    static class MultiPhaseBuilder
    extends RenderStateShard {
        private RenderStateShard.EmptyTextureStateShard texture = RenderStateShard.f_110147_;
        private RenderStateShard.ShaderStateShard shader = RenderStateShard.f_173096_;
        private RenderStateShard.TransparencyStateShard transparency = RenderStateShard.f_110134_;
        private RenderStateShard.DepthTestStateShard depthTest = RenderStateShard.f_110113_;
        private RenderStateShard.CullStateShard cull = RenderStateShard.f_110158_;
        private RenderStateShard.LightmapStateShard lightmap = RenderStateShard.f_110153_;
        private RenderStateShard.OverlayStateShard overlay = RenderStateShard.f_110155_;
        private RenderStateShard.LayeringStateShard layering = RenderStateShard.f_110117_;
        private RenderStateShard.OutputStateShard target = RenderStateShard.f_110123_;
        private RenderStateShard.TexturingStateShard texturing = RenderStateShard.f_110148_;
        private RenderStateShard.WriteMaskStateShard writeMaskState = RenderStateShard.f_110114_;
        private RenderStateShard.LineStateShard lineWidth = RenderStateShard.f_110130_;

        MultiPhaseBuilder() {
            super("weird access error workaround", null, null);
        }

        public MultiPhaseBuilder texture(RenderStateShard.EmptyTextureStateShard texture) {
            this.texture = texture;
            return this;
        }

        public MultiPhaseBuilder shader(RenderStateShard.ShaderStateShard shader) {
            this.shader = shader;
            return this;
        }

        public MultiPhaseBuilder transparency(RenderStateShard.TransparencyStateShard transparency) {
            this.transparency = transparency;
            return this;
        }

        public MultiPhaseBuilder depthTest(RenderStateShard.DepthTestStateShard depthTest) {
            this.depthTest = depthTest;
            return this;
        }

        public MultiPhaseBuilder cull(RenderStateShard.CullStateShard cull) {
            this.cull = cull;
            return this;
        }

        public MultiPhaseBuilder lightmap(RenderStateShard.LightmapStateShard lightmap) {
            this.lightmap = lightmap;
            return this;
        }

        public MultiPhaseBuilder overlay(RenderStateShard.OverlayStateShard overlay) {
            this.overlay = overlay;
            return this;
        }

        public MultiPhaseBuilder layering(RenderStateShard.LayeringStateShard layering) {
            this.layering = layering;
            return this;
        }

        public MultiPhaseBuilder target(RenderStateShard.OutputStateShard target) {
            this.target = target;
            return this;
        }

        public MultiPhaseBuilder texturing(RenderStateShard.TexturingStateShard texturing) {
            this.texturing = texturing;
            return this;
        }

        public MultiPhaseBuilder writeMaskState(RenderStateShard.WriteMaskStateShard writeMaskState) {
            this.writeMaskState = writeMaskState;
            return this;
        }

        public MultiPhaseBuilder lineWidth(RenderStateShard.LineStateShard lineWidth) {
            this.lineWidth = lineWidth;
            return this;
        }

        public ImmutableList<RenderStateShard> build() {
            return ImmutableList.of((Object)this.texture, (Object)this.shader, (Object)this.transparency, (Object)this.depthTest, (Object)this.cull, (Object)this.lightmap, (Object)this.overlay, (Object)this.layering, (Object)this.target, (Object)this.texturing, (Object)this.writeMaskState, (Object)this.lineWidth, (Object[])new RenderStateShard[0]);
        }

        public static void resetDepthTest() {
            RenderStateShard.f_110112_.m_110185_();
            RenderStateShard.f_110112_.m_110188_();
        }

        public static void resetWriteMask() {
            RenderStateShard.f_110115_.m_110185_();
            RenderStateShard.f_110115_.m_110188_();
            RenderStateShard.f_110116_.m_110185_();
            RenderStateShard.f_110116_.m_110188_();
        }

        public static void resetTransparency() {
            RenderStateShard.f_110135_.m_110185_();
            RenderStateShard.f_110135_.m_110188_();
        }
    }

    public static class EntityIconLayerPhases {
        public RenderStateShard.TextureStateShard texture;
        public RenderStateShard.TransparencyStateShard transparency;
        public RenderStateShard.DepthTestStateShard depthTest;
        public RenderStateShard.WriteMaskStateShard writeMask;
        public RenderStateShard.CullStateShard cull;
        public RenderStateShard.ShaderStateShard shader;

        public EntityIconLayerPhases(Object texture, Object transparency, Object depthTest, Object writeMask, Object cull, Object shader) {
            this.texture = (RenderStateShard.TextureStateShard)texture;
            this.transparency = (RenderStateShard.TransparencyStateShard)transparency;
            this.depthTest = (RenderStateShard.DepthTestStateShard)depthTest;
            this.writeMask = (RenderStateShard.WriteMaskStateShard)writeMask;
            this.cull = (RenderStateShard.CullStateShard)cull;
            this.shader = (RenderStateShard.ShaderStateShard)shader;
        }
    }

    private static class MultiPhaseRenderType
    extends RenderType {
        public MultiPhaseRenderType(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, ImmutableList<RenderStateShard> phases) {
            super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, () -> phases.forEach(RenderStateShard::m_110185_), () -> phases.forEach(RenderStateShard::m_110188_));
        }
    }
}

