/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.icon.XaeroIcon;
import xaero.common.icon.XaeroIconAtlas;
import xaero.common.icon.XaeroIconAtlasManager;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.hud.compat.mods.ImmediatelyFastHelper;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.RadarIconManager;
import xaero.hud.minimap.radar.icon.creator.render.form.IRadarIconFormPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.trace.EntityRenderTracer;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.minimap.radar.icon.definition.form.RadarIconForm;
import xaero.hud.minimap.radar.icon.definition.form.model.config.RadarIconModelConfig;
import xaero.hud.render.util.ImmediateRenderUtil;

public class RadarIconCreator {
    private static final int PREFERRED_ATLAS_WIDTH = 1024;
    public static final int ICON_WIDTH = 64;
    public static final int FAR_PLANE = 500;
    private PoseStack matrixStack = new PoseStack();
    private ImprovedFramebuffer formRenderFramebuffer;
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer atlasRenderFramebuffer;
    private PoseStack.Pose shaderMatrixBackup;
    private final EntityRenderTracer renderTracer = new EntityRenderTracer();
    private final XaeroIconAtlasManager iconAtlasManager;
    private Matrix4f projectionMatrixBackup;

    public RadarIconCreator() {
        int maxTextureSize = GlStateManager.m_84092_((int)3379);
        int atlasTextureSize = Math.min(maxTextureSize, 1024) / 64 * 64;
        this.iconAtlasManager = new XaeroIconAtlasManager(64, atlasTextureSize, new ArrayList<XaeroIconAtlas>());
        this.initFramebuffers(atlasTextureSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entity> XaeroIcon create(EntityRenderer<? super T> entityRenderer, T entity, RenderTarget defaultFramebuffer, Parameters parameters) {
        IRadarIconFormPrerenderer formPrerenderer = parameters.form.getPrerenderer();
        if (formPrerenderer == null) {
            MinimapLogs.LOGGER.error("Tried prerendering radar icon for {} variant {} but the icon form used doesn't have a prerenderer!", (Object)EntityType.m_20613_((EntityType)entity.m_6095_()), parameters.variant);
            return RadarIconManager.FAILED;
        }
        OpenGLException.checkGLError();
        PoseStack matrixStack = this.matrixStack;
        Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
        ImmediatelyFastHelper.triggerBatchingBuffersFlush(matrixStack);
        this.formRenderFramebuffer.bindAsMainTarget(true);
        this.setupMatrices(64, 500);
        OpenGLException.checkGLError();
        List<ModelRenderTrace> traceResult = null;
        EntityModel<? super T> entityModel = null;
        if (formPrerenderer.requiresEntityModel()) {
            GlStateManager.m_84091_();
            if (Minecraft.m_91087_().m_91290_().f_114358_ != null) {
                traceResult = this.renderTracer.trace(matrixStack, entity, entityRenderer);
                this.formRenderFramebuffer.bindAsMainTarget(true);
            } else {
                MinimapLogs.LOGGER.info("Render info was null for entity " + entity.m_6302_());
            }
            entityModel = this.renderTracer.getEntityRendererModel(entityRenderer);
            if (entityModel == null) {
                this.endFormRendering();
                this.bindDefaultFramebuffer(defaultFramebuffer);
                this.restoreMatrices();
                return RadarIconManager.FAILED;
            }
        }
        boolean formRenderResult = false;
        PoseStack.Pose matrixEntryToRestore = matrixStack.m_85850_();
        matrixStack.m_85836_();
        try {
            GlStateManager.m_84318_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.m_84266_((int)16640, (boolean)Minecraft.f_91002_);
            formRenderResult = formPrerenderer.prerender(matrixStack, entityRenderer, entityModel, entity, traceResult, parameters);
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("Exception using the radar icon form prerenderer for entity {} variant {}!", (Object)EntityType.m_20613_((EntityType)entity.m_6095_()), parameters.variant, (Object)t);
        }
        finally {
            Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
            while (matrixStack.m_85850_() != matrixEntryToRestore) {
                matrixStack.m_85849_();
            }
        }
        this.endFormRendering();
        XaeroIcon icon = parameters.form.getFailureResult();
        if (formRenderResult) {
            icon = this.getFinalIcon(matrixStack, entity, formPrerenderer, parameters);
        }
        this.restoreMatrices();
        this.atlasRenderFramebuffer.m_83970_();
        this.bindDefaultFramebuffer(defaultFramebuffer);
        return icon;
    }

    private XaeroIcon getFinalIcon(PoseStack matrixStack, Entity entity, IRadarIconFormPrerenderer formPrerenderer, Parameters parameters) {
        this.iconRenderFramebuffer.bindAsMainTarget(true);
        GlStateManager.m_84318_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.m_84266_((int)16384, (boolean)Minecraft.f_91002_);
        GlStateManager.m_84519_();
        if (parameters.debug) {
            matrixStack.m_85836_();
            matrixStack.m_252880_(18.0f, 10.0f, -10.0f);
            matrixStack.m_85841_(1.0f, 1.0f, 1.0f);
            ImmediateRenderUtil.coloredRectangle(matrixStack, 0.0f, 0.0f, 9.0f, 9.0f, -16776961);
            matrixStack.m_85849_();
            RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)771);
        }
        this.formRenderFramebuffer.m_83956_();
        boolean outlined = formPrerenderer.isOutlined();
        boolean flipped = formPrerenderer.isFlipped();
        if (outlined) {
            this.renderOutline(matrixStack);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.m_84519_();
        ImmediateRenderUtil.texturedRect(matrixStack, 0.0f, 0.0f, 0, 0, 64.0f, 64.0f, 64.0f, 64.0f, 0.05f, false);
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)771);
        if (parameters.debug) {
            matrixStack.m_85836_();
            matrixStack.m_252880_(27.0f, 10.0f, -10.0f);
            matrixStack.m_85841_(1.0f, 1.0f, 1.0f);
            ImmediateRenderUtil.coloredRectangle(matrixStack, 0.0f, 0.0f, 9.0f, 9.0f, -16711681);
            matrixStack.m_85849_();
            RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)771);
        }
        GlStateManager.m_84525_();
        this.iconRenderFramebuffer.m_83970_();
        this.iconRenderFramebuffer.m_83956_();
        this.iconRenderFramebuffer.generateMipmaps();
        GlStateManager.m_84544_((int)0);
        XaeroIcon icon = null;
        try {
            XaeroIconAtlas atlas = this.getCurrentAtlas();
            icon = atlas.createIcon();
            this.atlasRenderFramebuffer.bindAsMainTarget(false);
            GlStateManager.m_84430_((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)64, (int)64);
            this.atlasRenderFramebuffer.setFramebufferTexture(atlas.getTextureId());
            this.atlasRenderFramebuffer.m_83949_();
            this.iconRenderFramebuffer.m_83956_();
            GlStateManager.m_84519_();
            if (flipped) {
                ImmediateRenderUtil.texturedRect(matrixStack, 0.0f, 0.0f, 0, 64, 64.0f, 64.0f, -64.0f, 64.0f, -1.0f, false);
            } else {
                ImmediateRenderUtil.texturedRect(matrixStack, 0.0f, 0.0f, 0, 0, 64.0f, 64.0f, 64.0f, 64.0f, -1.0f, false);
            }
            if (parameters.debug) {
                matrixStack.m_85836_();
                matrixStack.m_252880_(36.0f, 10.0f, -10.0f);
                matrixStack.m_85841_(1.0f, 1.0f, 1.0f);
                ImmediateRenderUtil.coloredRectangle(matrixStack, 0.0f, 0.0f, 9.0f, 9.0f, -256);
                matrixStack.m_85849_();
                RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)771);
            }
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("Exception rendering to a entity icon atlas for {} {}!", (Object)EntityType.m_20613_((EntityType)entity.m_6095_()), parameters.variant, (Object)t);
        }
        GlStateManager.m_84525_();
        GlStateManager.m_84544_((int)0);
        MinimapRendererHelper.restoreDefaultShaderBlendState();
        return icon;
    }

    private void renderOutline(PoseStack matrixStack) {
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.m_84525_();
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)1);
        for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
            for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                ImmediateRenderUtil.drawOutlineLayer(matrixStack, shadowOffsetX, shadowOffsetY, 0, 0, 64.0f, 64.0f, 64.0f, 64.0f, 0.05f);
            }
        }
    }

    private void setupMatrices(int finalIconSize, int farPlane) {
        this.shaderMatrixBackup = RenderSystem.m_157191_().m_85850_();
        this.projectionMatrixBackup = RenderSystem.m_253262_();
        Matrix4f ortho = new Matrix4f().setOrtho(0.0f, (float)finalIconSize, (float)finalIconSize, 0.0f, -1.0f, (float)farPlane);
        RenderSystem.m_252934_((Matrix4f)ortho);
        RenderSystem.m_157191_().m_85836_();
        RenderSystem.m_157191_().m_166856_();
        RenderSystem.m_157182_();
    }

    private void restoreMatrices() {
        RenderSystem.m_252934_((Matrix4f)this.projectionMatrixBackup);
        if (RenderSystem.m_157191_().m_85850_() != this.shaderMatrixBackup) {
            RenderSystem.m_157191_().m_85849_();
        }
        RenderSystem.m_157182_();
    }

    private void endFormRendering() {
        this.formRenderFramebuffer.m_83970_();
        GlStateManager.m_84525_();
        Lighting.m_84931_();
        Lighting.m_84930_();
    }

    private void bindDefaultFramebuffer(RenderTarget defaultFramebuffer) {
        if (defaultFramebuffer != null) {
            if (defaultFramebuffer instanceof ImprovedFramebuffer) {
                ((ImprovedFramebuffer)defaultFramebuffer).bindAsMainTarget(true);
                return;
            }
            ImprovedFramebuffer.restoreMainRenderTarget();
            defaultFramebuffer.m_83947_(true);
            return;
        }
        this.atlasRenderFramebuffer.bindDefaultFramebuffer(Minecraft.m_91087_());
        GlStateManager.m_84430_((int)0, (int)0, (int)Minecraft.m_91087_().m_91268_().m_85441_(), (int)Minecraft.m_91087_().m_91268_().m_85442_());
    }

    public void clearAtlases() {
        this.iconAtlasManager.clearAtlases();
        this.atlasRenderFramebuffer.setFramebufferTexture(0);
    }

    public EntityRenderTracer getRenderTracer() {
        return this.renderTracer;
    }

    private XaeroIconAtlas getCurrentAtlas() {
        return this.iconAtlasManager.getCurrentAtlas();
    }

    private void initFramebuffers(int atlasTextureSize) {
        this.formRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
        OpenGLException.checkGLError();
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, false);
        OpenGLException.checkGLError();
        this.formRenderFramebuffer.m_83956_();
        OpenGLException.checkGLError();
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.m_84209_((int)3553, (int)0, (int)32856, (int)this.formRenderFramebuffer.f_83917_, (int)this.formRenderFramebuffer.f_83918_, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.m_84544_((int)0);
        this.iconRenderFramebuffer.m_83956_();
        GL11.glTexParameteri((int)3553, (int)33085, (int)3);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.m_84209_((int)3553, (int)0, (int)32856, (int)this.iconRenderFramebuffer.f_83917_, (int)this.iconRenderFramebuffer.f_83918_, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.m_84544_((int)0);
        this.atlasRenderFramebuffer = new ImprovedFramebuffer(atlasTextureSize, atlasTextureSize, false);
        OpenGLException.checkGLError();
        GlStateManager.m_84541_((int)this.atlasRenderFramebuffer.getFramebufferTexture());
        this.atlasRenderFramebuffer.setFramebufferTexture(0);
        OpenGLException.checkGLError();
    }

    public static class Parameters {
        public final Object variant;
        public final float scale;
        public final RadarIconModelConfig defaultModelConfig;
        public final RadarIconForm form;
        public final boolean debug;

        public Parameters(Object variant, RadarIconModelConfig defaultModelConfig, RadarIconForm form, float scale, boolean debug) {
            this.variant = variant;
            this.scale = scale;
            this.defaultModelConfig = defaultModelConfig;
            this.form = form;
            this.debug = debug;
        }
    }
}

