/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.notification;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import xaero.hud.pvp.module.notification.Notification;
import xaero.hud.pvp.module.notification.NotificationSession;
import xaero.hud.render.TextureLocations;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class NotificationRenderer
implements IModuleRenderer<NotificationSession> {
    @Override
    public void render(NotificationSession session, ModuleRenderContext c, PoseStack matrixStack, float partialTicks) {
        boolean air;
        if (System.currentTimeMillis() - session.getLastBlink() > 500L) {
            session.setLastBlink(System.currentTimeMillis());
            session.setBlink(!session.getBlink());
        }
        Minecraft mc = Minecraft.m_91087_();
        int total = 0;
        boolean lowHunger = session.getNotificationHunger() && (float)mc.f_91074_.m_36324_().m_38702_() <= 2.0f * (float)session.getLowHunger();
        boolean lowHealth = session.getNotificationHP() && mc.f_91074_.m_21223_() <= 2.0f * (float)session.getLowHealth();
        boolean tnt = session.getNotificationTNT() && session.getWorldHelper().tntIsAround(mc.f_91074_);
        boolean arrow = session.getNotificationArrow() && session.getWorldHelper().arrowIsAround(mc.f_91074_);
        boolean bl = air = session.getNotificationAir() && mc.f_91074_.m_20146_() <= 30 * session.getLowAir();
        if (lowHunger) {
            ++total;
        }
        if (lowHealth) {
            ++total;
        }
        if (tnt) {
            ++total;
        }
        if (arrow) {
            ++total;
        }
        if (air) {
            ++total;
        }
        if (total == 0) {
            return;
        }
        int between = 32 - 4 * total;
        int unitLength = 32 + between;
        int totalLength = total * unitLength;
        int drawY = c.y + (c.h - 32) / 2;
        int drawX = c.x + c.w / 2 - totalLength / 2 + between / 2;
        if (session.getBlink()) {
            RenderSystem.m_157429_((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
        } else {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureLocations.GUI_TEXTURES);
        if (lowHunger) {
            this.renderNotification(Notification.LOW_HUNGER, drawX, drawY, matrixStack);
            drawX += unitLength;
        }
        if (lowHealth) {
            this.renderNotification(Notification.LOW_HEALTH, drawX, drawY, matrixStack);
            drawX += unitLength;
        }
        if (tnt) {
            this.renderNotification(Notification.TNT, drawX, drawY, matrixStack);
            drawX += unitLength;
        }
        if (arrow) {
            this.renderNotification(Notification.ARROW, drawX, drawY, matrixStack);
            drawX += unitLength;
        }
        if (air) {
            this.renderNotification(Notification.AIR, drawX, drawY, matrixStack);
            drawX += unitLength;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderNotification(Notification notification, int drawX, int drawY, PoseStack matrixStack) {
        GuiComponent.m_93228_((PoseStack)matrixStack, (int)drawX, (int)drawY, (int)17, (int)(notification.getTextureIndex() * 32), (int)notification.getTextureW(), (int)32);
    }
}

