/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.mods;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.IntConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.common.IXaeroMinimap;
import xaero.common.effect.Effects;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.highlight.HighlighterRegistry;
import xaero.common.minimap.region.MinimapTile;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.misc.Misc;
import xaero.common.settings.ModOptions;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.radar.render.element.RadarRenderer;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.render.util.RenderBufferUtil;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.shader.MapShaders;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiWorldMapSettings;
import xaero.map.mods.SupportMods;
import xaero.map.region.LeveledRegion;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTileChunk;
import xaero.map.region.texture.LeafRegionTexture;
import xaero.map.world.MapDimension;

public class SupportXaeroWorldmap {
    public static int WORLDMAP_COMPATIBILITY_VERSION = 20;
    public static final String MINIMAP_MW = "minimap";
    public int compatibilityVersion;
    private static final HashMap<MapTileChunk, Long> seedsUsed = new HashMap();
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    private IXaeroMinimap modMain;
    private int destinationCaving = Integer.MAX_VALUE;
    private long lastDestinationCavingSwitch;
    private int previousRenderedCaveLayer = Integer.MAX_VALUE;
    private int lastRenderedCaveLayer = Integer.MAX_VALUE;
    private ArrayList<MapRegion> regionBuffer = new ArrayList();

    public SupportXaeroWorldmap(IXaeroMinimap modMain) {
        this.modMain = modMain;
        try {
            this.compatibilityVersion = WorldMap.MINIMAP_COMPATIBILITY_VERSION;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        if (this.compatibilityVersion < 3) {
            throw new RuntimeException("Xaero's World Map 1.11.0 or newer required!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMinimap(MinimapSession minimapSession, class_4587 matrixStack, MinimapRendererHelper helper, int xFloored, int zFloored, int minViewX, int minViewZ, int maxViewX, int maxViewZ, boolean zooming, double zoom, double mapDimensionScale, class_4588 overlayBufferBuilder, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return;
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.renderThreadPauseSync;
        synchronized (object) {
            if (!mapProcessor.isRenderingPaused()) {
                class_746 player;
                if (mapProcessor.getCurrentDimension() == null) {
                    return;
                }
                int compatibilityVersion = this.compatibilityVersion;
                String worldString = mapProcessor.getCurrentWorldId();
                if (worldString == null) {
                    return;
                }
                if (compatibilityVersion >= 18) {
                    MapShaders.ensureShaders();
                }
                int mapX = xFloored >> 4;
                int mapZ = zFloored >> 4;
                int chunkX = mapX >> 2;
                int chunkZ = mapZ >> 2;
                int tileX = mapX & 3;
                int tileZ = mapZ & 3;
                int insideX = xFloored & 0xF;
                int insideZ = zFloored & 0xF;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                int minX = (mapX >> 2) - 4;
                int maxX = (mapX >> 2) + 4;
                int minZ = (mapZ >> 2) - 4;
                int maxZ = (mapZ >> 2) + 4;
                boolean wmHasCaveLayers = this.hasCaveLayers();
                boolean wmHasFullReload = compatibilityVersion >= 23;
                int globalRegionCacheHashCode = WorldMap.settings.getRegionCacheHashCode();
                boolean reloadEverything = WorldMap.settings.reloadEverything;
                int globalReloadVersion = WorldMap.settings.reloadVersion;
                boolean slimeChunks = this.modMain.getSettings().getSlimeChunks(minimapSession);
                boolean wmHasDimensionSwitch = this.hasDimensionSwitching();
                if (wmHasDimensionSwitch) {
                    mapProcessor.initMinimapRender(xFloored, zFloored);
                }
                if (!wmHasDimensionSwitch && wmHasCaveLayers) {
                    mapProcessor.updateCaveStart();
                }
                int renderedCaveLayer = wmHasCaveLayers ? mapProcessor.getCurrentCaveLayer() : 0;
                int globalCaveStart = !wmHasDimensionSwitch && wmHasCaveLayers ? mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().getLayer(renderedCaveLayer).getCaveStart() : 0;
                int globalCaveDepth = !wmHasDimensionSwitch && wmHasCaveLayers ? WorldMap.settings.caveModeDepth : 0;
                float brightness = this.getMinimapBrightness();
                if (renderedCaveLayer != this.lastRenderedCaveLayer) {
                    this.previousRenderedCaveLayer = this.lastRenderedCaveLayer;
                }
                boolean noCaveMaps = Misc.hasEffect((class_1657)(player = class_310.method_1551().field_1724), Effects.NO_CAVE_MAPS) || Misc.hasEffect((class_1657)player, Effects.NO_CAVE_MAPS_HARMFUL);
                boolean playerIsMoving = !wmHasDimensionSwitch && (player.field_6014 != player.method_23317() || player.field_6036 != player.method_23318() || player.field_5969 != player.method_23321());
                boolean shouldRequestLoading = true;
                LeveledRegion nextToLoadObj = null;
                if (!wmHasDimensionSwitch && compatibilityVersion >= 11) {
                    LeveledRegion nextToLoad;
                    shouldRequestLoading = false;
                    nextToLoadObj = nextToLoad = mapProcessor.getMapSaveLoad().getNextToLoadByViewing();
                    if (nextToLoad != null) {
                        if (wmHasFullReload) {
                            shouldRequestLoading = nextToLoad.shouldAllowAnotherRegionToLoad();
                        } else {
                            LeveledRegion leveledRegion = nextToLoad;
                            synchronized (leveledRegion) {
                                if (!(nextToLoad.reloadHasBeenRequested() || nextToLoad.hasRemovableSourceData() || nextToLoad instanceof MapRegion && ((MapRegion)nextToLoad).isRefreshing())) {
                                    shouldRequestLoading = true;
                                }
                            }
                        }
                    } else {
                        shouldRequestLoading = true;
                    }
                    this.regionBuffer.clear();
                    if (wmHasCaveLayers) {
                        int comparisonChunkX = (xFloored >> 4) - 16;
                        int comparisonChunkZ = (zFloored >> 4) - 16;
                        LeveledRegion.setComparison((int)comparisonChunkX, (int)comparisonChunkZ, (int)0, (int)comparisonChunkX, (int)comparisonChunkZ);
                    } else {
                        int comparisonRegionX = xFloored >> 9;
                        int comparisonRegionZ = zFloored >> 9;
                        LeveledRegion.setComparison((int)comparisonRegionX, (int)comparisonRegionZ, (int)0, (int)comparisonRegionX, (int)comparisonRegionZ);
                    }
                }
                MultiTextureRenderTypeRenderer mapWithLightRenderer = null;
                MultiTextureRenderTypeRenderer mapNoLightRenderer = null;
                if (compatibilityVersion >= 12) {
                    IntConsumer shaderBinder;
                    IntConsumer binder;
                    Runnable finalizer = null;
                    if (zooming) {
                        binder = t -> {
                            MultiTextureRenderTypeRendererProvider.defaultTextureBind(t);
                            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                        };
                        shaderBinder = t -> {
                            RenderSystem.setShaderTexture((int)0, (int)t);
                            MultiTextureRenderTypeRendererProvider.defaultTextureBind(t);
                            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                        };
                        finalizer = () -> GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    } else {
                        binder = MultiTextureRenderTypeRendererProvider::defaultTextureBind;
                        shaderBinder = t -> RenderSystem.setShaderTexture((int)0, (int)t);
                    }
                    mapWithLightRenderer = multiTextureRenderTypeRenderers.getRenderer(shaderBinder, binder, finalizer, CustomRenderTypes.MAP);
                    mapNoLightRenderer = multiTextureRenderTypeRenderers.getRenderer(shaderBinder, binder, finalizer, CustomRenderTypes.MAP);
                } else {
                    mapWithLightRenderer = multiTextureRenderTypeRenderers.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.MAP);
                    mapNoLightRenderer = multiTextureRenderTypeRenderers.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.MAP);
                }
                MinimapWorld world = minimapSession.getWorldManager().getAutoWorld();
                Long seed = !slimeChunks || world == null ? null : this.modMain.getSettings().getSlimeChunksSeed(world.getFullPath());
                this.renderChunks(matrixStack, minX, maxX, minZ, maxZ, minViewX, maxViewX, minViewZ, maxViewZ, mapProcessor, renderedCaveLayer, shouldRequestLoading, reloadEverything, globalReloadVersion, globalRegionCacheHashCode, globalCaveStart, globalCaveDepth, playerIsMoving, noCaveMaps, slimeChunks, chunkX, chunkZ, tileX, tileZ, insideX, insideZ, seed, wmHasCaveLayers, brightness, zooming, mapWithLightRenderer, mapNoLightRenderer, helper, overlayBufferBuilder);
                MapShaders.WORLD_MAP.setBrightness(brightness);
                MapShaders.WORLD_MAP.setWithLight(true);
                multiTextureRenderTypeRenderers.draw(mapWithLightRenderer);
                MapShaders.WORLD_MAP.setWithLight(false);
                multiTextureRenderTypeRenderers.draw(mapNoLightRenderer);
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                RenderSystem.disableBlend();
                this.lastRenderedCaveLayer = renderedCaveLayer;
                if (wmHasDimensionSwitch) {
                    mapProcessor.finalizeMinimapRender();
                } else if (compatibilityVersion >= 11) {
                    int toRequest = 1;
                    int counter = 0;
                    for (int i = 0; i < this.regionBuffer.size() && counter < toRequest; ++i) {
                        MapRegion region = this.regionBuffer.get(i);
                        if (region == nextToLoadObj && this.regionBuffer.size() > 1) continue;
                        MapRegion mapRegion = region;
                        synchronized (mapRegion) {
                            if (wmHasFullReload && !region.canRequestReload_unsynced()) {
                                continue;
                            }
                            if (!wmHasFullReload && (region.reloadHasBeenRequested() || region.recacheHasBeenRequested() || region instanceof MapRegion && region.isRefreshing() || region.getLoadState() != 0 && region.getLoadState() != 4 && (region.getLoadState() != 2 || !region.isBeingWritten()))) {
                                continue;
                            }
                            if (region.getLoadState() == 2) {
                                region.requestRefresh(mapProcessor);
                            } else {
                                mapProcessor.getMapSaveLoad().requestLoad(region, "Minimap sorted", false);
                            }
                            if (counter == 0) {
                                mapProcessor.getMapSaveLoad().setNextToLoadByViewing((LeveledRegion)region);
                            }
                            ++counter;
                            if (region.getLoadState() == 4) {
                                break;
                            }
                            continue;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderChunks(class_4587 matrixStack, int minX, int maxX, int minZ, int maxZ, int minViewX, int maxViewX, int minViewZ, int maxViewZ, MapProcessor mapProcessor, int renderedCaveLayer, boolean shouldRequestLoading, boolean reloadEverything, int globalReloadVersion, int globalRegionCacheHashCode, int globalCaveStart, int globalCaveDepth, boolean playerIsMoving, boolean noCaveMaps, boolean slimeChunks, int chunkX, int chunkZ, int tileX, int tileZ, int insideX, int insideZ, Long seed, boolean wmHasCaveLayers, float brightness, boolean zooming, MultiTextureRenderTypeRenderer mapWithLightRenderer, MultiTextureRenderTypeRenderer mapNoLightRenderer, MinimapRendererHelper helper, class_4588 overlayBufferBuilder) {
        MapRegion prevRegion = null;
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        boolean wmHasFullReload = this.compatibilityVersion >= 23;
        boolean wmHasDimensionSwitch = this.hasDimensionSwitching();
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minZ; j <= maxZ; ++j) {
                MapTileChunk previousLayerChunk;
                MapRegion previousLayerRegion;
                boolean chunkIsVisible;
                MapRegion region;
                if (wmHasDimensionSwitch) {
                    region = mapProcessor.getMinimapMapRegion(i >> 3, j >> 3);
                    mapProcessor.beforeMinimapRegionRender(region);
                } else {
                    region = wmHasCaveLayers ? mapProcessor.getMapRegion(renderedCaveLayer, i >> 3, j >> 3, mapProcessor.regionExists(renderedCaveLayer, i >> 3, j >> 3)) : mapProcessor.getMapRegion(i >> 3, j >> 3, mapProcessor.regionExists(i >> 3, j >> 3));
                }
                if (!wmHasDimensionSwitch && region != null && region != prevRegion) {
                    MapRegion mapRegion = region;
                    synchronized (mapRegion) {
                        int regionHashCode = region.getCacheHashCode();
                        int regionReloadVersion = region.getReloadVersion();
                        if (shouldRequestLoading && (wmHasFullReload && region.canRequestReload_unsynced() || !wmHasFullReload && !region.recacheHasBeenRequested() && !region.reloadHasBeenRequested() && (!(region instanceof MapRegion) || !region.isRefreshing())) && (region.getLoadState() == 0 || (region.getLoadState() == 4 || region.getLoadState() == 2 && region.isBeingWritten()) && (reloadEverything && regionReloadVersion != globalReloadVersion || regionHashCode != globalRegionCacheHashCode || wmHasCaveLayers && !playerIsMoving && region.caveStartOutdated(globalCaveStart, globalCaveDepth) || region.getVersion() != mapProcessor.getGlobalVersion() || this.compatibilityVersion >= 11 && (region.isMetaLoaded() || region.getLoadState() != 0 || !region.hasHadTerrain()) && region.getHighlightsHash() != region.getDim().getHighlightHandler().getRegionHash(region.getRegionX(), region.getRegionZ()) || region.getLoadState() != 2 && region.shouldCache()))) {
                            if (this.compatibilityVersion >= 11) {
                                if (!this.regionBuffer.contains(region)) {
                                    if (wmHasCaveLayers) {
                                        region.calculateSortingChunkDistance();
                                    } else {
                                        region.calculateSortingDistance();
                                    }
                                    xaero.map.misc.Misc.addToListOfSmallest((int)10, this.regionBuffer, (Comparable)region);
                                }
                            } else if (region.getLoadState() == 2) {
                                region.requestRefresh(mapProcessor);
                            } else if (shouldRequestLoading) {
                                mapProcessor.getMapSaveLoad().requestLoad(region, "Minimap", false);
                                mapProcessor.getMapSaveLoad().setNextToLoadByViewing(region);
                            }
                        }
                    }
                }
                prevRegion = region;
                if (i < minViewX || i > maxViewX || j < minViewZ || j > maxViewZ) continue;
                MapTileChunk chunk = region == null ? null : region.getChunk(i & 7, j & 7);
                boolean bl = chunkIsVisible = chunk != null && chunk.getGlColorTexture() != -1;
                if (!(!wmHasCaveLayers || chunkIsVisible || noCaveMaps && this.previousRenderedCaveLayer != Integer.MAX_VALUE || (previousLayerRegion = wmHasDimensionSwitch ? mapProcessor.getLeafMapRegion(this.previousRenderedCaveLayer, i >> 3, j >> 3, false) : mapProcessor.getMapRegion(this.previousRenderedCaveLayer, i >> 3, j >> 3, false)) == null || (previousLayerChunk = previousLayerRegion.getChunk(i & 7, j & 7)) == null || previousLayerChunk.getGlColorTexture() == -1)) {
                    region = previousLayerRegion;
                    chunk = previousLayerChunk;
                    chunkIsVisible = true;
                }
                if (!chunkIsVisible) continue;
                this.bumpLoadedRegion(mapProcessor, region, wmHasCaveLayers);
                if (this.compatibilityVersion < 12) {
                    this.bindMapTextureWithLighting(chunk, zooming);
                }
                GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                int drawX = 64 * (chunk.getX() - chunkX) - 16 * tileX - insideX;
                int drawZ = 64 * (chunk.getZ() - chunkZ) - 16 * tileZ - insideZ;
                this.prepareMapTexturedRect(matrix, drawX, drawZ, 0, 0, 64.0f, 64.0f, chunk, mapNoLightRenderer, mapWithLightRenderer, helper);
                if (!slimeChunks) continue;
                this.renderSlimeChunks(chunk, seed, drawX, drawZ, matrixStack, helper, overlayBufferBuilder);
            }
        }
    }

    private void bumpLoadedRegion(MapProcessor mapProcessor, MapRegion region, boolean wmHasCaveLayers) {
        if (!mapProcessor.isUploadingPaused() && region.isLoaded()) {
            if (wmHasCaveLayers) {
                mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().bumpLoadedRegion(region);
            } else {
                mapProcessor.getMapWorld().getCurrentDimension().getMapRegions().bumpLoadedRegion(region);
            }
        }
    }

    public void renderSlimeChunks(MapTileChunk chunk, Long seed, int drawX, int drawZ, class_4587 matrixStack, MinimapRendererHelper helper, class_4588 overlayBufferBuilder) {
        boolean newSeed;
        Long savedSeed = seedsUsed.get(chunk);
        boolean bl = newSeed = seed == null && savedSeed != null || seed != null && !seed.equals(savedSeed);
        if (newSeed) {
            seedsUsed.put(chunk, seed);
        }
        for (int t = 0; t < 16; ++t) {
            if (newSeed || (chunk.getTileGridsCache()[t % 4][t / 4] & 1) == 0) {
                chunk.getTileGridsCache()[t % 4][t / 4] = (byte)(1 | (MinimapTile.isSlimeChunk(this.modMain.getSettings(), chunk.getX() * 4 + t % 4, chunk.getZ() * 4 + t / 4, seed) ? 2 : 0));
            }
            if ((chunk.getTileGridsCache()[t % 4][t / 4] & 2) == 0) continue;
            int slimeDrawX = drawX + 16 * (t % 4);
            int slimeDrawZ = drawZ + 16 * (t / 4);
            RenderBufferUtil.addColoredRect(matrixStack.method_23760().method_23761(), overlayBufferBuilder, slimeDrawX, slimeDrawZ, 16, 16, -2142047936);
        }
    }

    public boolean getWorldMapWaypoints() {
        return WorldMap.settings.waypoints;
    }

    public int getWorldMapColours() {
        return WorldMap.settings.colours;
    }

    public boolean getWorldMapFlowers() {
        return WorldMap.settings.flowers;
    }

    public boolean getWorldMapLighting() {
        return WorldMap.settings.lighting;
    }

    public boolean getWorldMapTerrainDepth() {
        return WorldMap.settings.terrainDepth;
    }

    public int getWorldMapTerrainSlopes() {
        int wmSetting = WorldMap.settings.terrainSlopes;
        return wmSetting;
    }

    public boolean getWorldMapBiomeColorsVanillaMode() {
        return WorldMap.settings.biomeColorsVanillaMode;
    }

    public boolean getWorldMapIgnoreHeightmaps() {
        return WorldMap.settings.getClientBooleanValue(xaero.map.settings.ModOptions.IGNORE_HEIGHTMAPS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tryToGetMultiworldId(class_5321<class_1937> dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        if (this.compatibilityVersion >= 15) {
            Object object = mapProcessor.uiPauseSync;
            synchronized (object) {
                if (mapProcessor.isUIPaused()) {
                    return null;
                }
                return this.getMultiworldIdUnsynced(mapProcessor, dimId);
            }
        }
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            return this.getMultiworldIdUnsynced(mapProcessor, dimId);
        }
    }

    private String getMultiworldIdUnsynced(MapProcessor mapProcessor, class_5321<class_1937> dimId) {
        MapDimension mapDim;
        MapDimension mapDimension = mapDim = !mapProcessor.isMapWorldUsable() || mapProcessor.isWaitingForWorldUpdate() ? null : mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
        return mapDim == null ? null : (!mapDim.currentMultiworldWritable ? MINIMAP_MW : mapDim.getCurrentMultiworld());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPotentialMultiworldIds(class_5321<class_1937> dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim = mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
            return mapDim == null || !mapProcessor.isWaitingForWorldUpdate() && mapDim.currentMultiworldWritable ? null : mapDim.getMultiworldIdsCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMultiworldIds(class_5321<class_1937> dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim = mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
            return mapDim == null ? null : mapDim.getMultiworldIdsCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tryToGetMultiworldName(class_5321<class_1937> dimId, String multiworldId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiPauseSync;
        synchronized (object) {
            if (mapProcessor.isUIPaused()) {
                return null;
            }
            return this.getMultiworldNameUnsynced(mapProcessor, dimId, multiworldId);
        }
    }

    private String getMultiworldNameUnsynced(MapProcessor mapProcessor, class_5321<class_1937> dimId, String multiworldId) {
        MapDimension mapDim = !mapProcessor.isMapWorldUsable() ? null : mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
        return mapDim == null ? null : mapDim.getMultiworldName(multiworldId);
    }

    public void openSettings() {
        class_437 current = class_310.method_1551().field_1755;
        class_437 currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
        class_310.method_1551().method_1507((class_437)new GuiWorldMapSettings(current, currentEscScreen));
    }

    public float getMinimapBrightness() {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return 1.0f;
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        return mapProcessor.getBrightness(this.modMain.getSettings().getLighting());
    }

    private void bindMapTextureWithLighting(MapTileChunk chunk, boolean zooming) {
        chunk.getLeafTexture().bindColorTexture(false, zooming ? 9729 : 9728);
    }

    public boolean screenShouldSkipWorldRender(class_437 screen) {
        return xaero.map.misc.Misc.screenShouldSkipWorldRender((class_437)screen, (boolean)false);
    }

    public void prepareMapTexturedRect(Matrix4f matrix, float x, float y, int textureX, int textureY, float width, float height, MapTileChunk chunk, MultiTextureRenderTypeRenderer noLightRenderer, MultiTextureRenderTypeRenderer withLightrenderer, MinimapRendererHelper helper) {
        LeafRegionTexture texture = chunk.getLeafTexture();
        int textureId = texture.getGlColorTexture();
        if (textureId == -1) {
            return;
        }
        helper.prepareMyTexturedModalRect(matrix, x, y, textureX, (int)height, width, height, -height, 64.0f, textureId, texture.getTextureHasLight() ? withLightrenderer : noLightRenderer);
    }

    public boolean getAdjustHeightForCarpetLikeBlocks() {
        if (this.compatibilityVersion < 10) {
            return false;
        }
        return WorldMap.settings.adjustHeightForCarpetLikeBlocks;
    }

    public void registerHighlighters(HighlighterRegistry highlighterRegistry) {
        if (this.compatibilityVersion < 12) {
            return;
        }
        SupportMods.xaeroMinimap.registerMinimapHighlighters((Object)highlighterRegistry);
    }

    public void createRadarRenderWrapper(RadarRenderer radarRenderer) {
        if (this.compatibilityVersion < 12) {
            return;
        }
        SupportMods.xaeroMinimap.createRadarRendererWrapper((Object)radarRenderer);
    }

    public boolean worldMapIsRenderingRadar() {
        if (this.compatibilityVersion < 12) {
            return false;
        }
        return WorldMap.settings.minimapRadar;
    }

    public boolean usesPartialYFromWorldMap() {
        return this.compatibilityVersion >= 16;
    }

    public boolean getPartialYTeleport() {
        return WorldMap.settings.partialYTeleportation;
    }

    public boolean isStainedGlassDisplayed() {
        if (this.compatibilityVersion < 17) {
            return true;
        }
        return WorldMap.settings.displayStainedGlass;
    }

    public boolean hasCaveLayers() {
        return this.compatibilityVersion >= 19;
    }

    public boolean isMultiplayerMap() {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return false;
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        return mapProcessor.getMapWorld().isMultiplayer();
    }

    public int getManualCaveStart() {
        return WorldMap.settings.caveModeStart == Integer.MAX_VALUE ? Integer.MAX_VALUE : WorldMap.settings.caveModeStart;
    }

    public boolean hasEnabledCaveLayers() {
        return this.getCaveModeType() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCaveModeType() {
        if (!this.hasCaveLayers() || !WorldMap.settings.isCaveMapsAllowed()) {
            return 0;
        }
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return WorldMap.settings.defaultCaveModeType;
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiPauseSync;
        synchronized (object) {
            if (mapProcessor.isUIPaused()) {
                return WorldMap.settings.defaultCaveModeType;
            }
            MapDimension mapDim = mapProcessor.getMapWorld().getCurrentDimension();
            if (mapDim != null) {
                return mapDim.getCaveModeType();
            }
        }
        return WorldMap.settings.defaultCaveModeType;
    }

    public void openScreenForOption(ModOptions option) {
        class_437 currentEscScreen;
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        class_437 current = class_310.method_1551().field_1755;
        class_437 class_4372 = currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
        if (currentEscScreen instanceof GuiMap) {
            currentEscScreen = null;
        }
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        GuiMap screen = new GuiMap(current, currentEscScreen, mapProcessor, class_310.method_1551().method_1560());
        if (option == ModOptions.MANUAL_CAVE_MODE_START) {
            screen.enableCaveModeOptions();
        }
        class_310.method_1551().method_1507((class_437)screen);
    }

    public int getCaveModeDepth() {
        if (!this.hasCaveLayers()) {
            return 30;
        }
        return WorldMap.settings.caveModeDepth;
    }

    public boolean isLegibleCaveMaps() {
        if (!this.hasCaveLayers()) {
            return false;
        }
        return WorldMap.settings.legibleCaveMaps;
    }

    public boolean hasBiomeBlendingOption() {
        return this.compatibilityVersion >= 20;
    }

    public boolean getBiomeBlending() {
        return WorldMap.settings.biomeBlending;
    }

    public boolean hasTrackedPlayerSystemSupport() {
        return this.compatibilityVersion >= 22;
    }

    public void confirmPlayerRadarRender(class_1657 e) {
        if (this.hasTrackedPlayerSystemSupport()) {
            if (WorldMap.trackedPlayerRenderer.getCollector().playerExists(e.method_5667())) {
                WorldMap.trackedPlayerRenderer.getCollector().confirmPlayerRadarRender(e);
            }
            return;
        }
        if (SupportMods.xaeroPac.playerExists(e.method_5667())) {
            SupportMods.xaeroPac.confirmPlayerRadarRender(e);
        }
    }

    public boolean getDisplayClaims() {
        if (this.compatibilityVersion < 14) {
            return false;
        }
        return WorldMap.settings.displayClaims;
    }

    public int getClaimsBorderOpacity() {
        if (this.compatibilityVersion < 14) {
            return 80;
        }
        if (this.compatibilityVersion < 17) {
            return WorldMap.settings.claimsOpacity;
        }
        return WorldMap.settings.claimsBorderOpacity;
    }

    public int getClaimsFillOpacity() {
        if (this.compatibilityVersion < 14) {
            return 46;
        }
        if (this.compatibilityVersion < 17) {
            return WorldMap.settings.claimsOpacity * 58 / 100;
        }
        return WorldMap.settings.claimsFillOpacity;
    }

    public void toggleChunkClaims() {
        if (this.compatibilityVersion >= 14) {
            WorldMap.settings.setOptionValue(xaero.map.settings.ModOptions.PAC_CLAIMS, (Object)((Boolean)WorldMap.settings.getOptionValue(xaero.map.settings.ModOptions.PAC_CLAIMS) == false ? 1 : 0));
        }
    }

    public boolean supportsPacPlayerRadarFilter() {
        return this.compatibilityVersion >= 21;
    }

    public boolean hasDimensionSwitching() {
        return this.compatibilityVersion >= 24;
    }

    public boolean caveLayersAreUsable() {
        boolean result = this.hasEnabledCaveLayers();
        if (result && this.hasDimensionSwitching()) {
            WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
            if (worldmapSession == null) {
                return result;
            }
            class_1297 player = class_310.method_1551().method_1560();
            if (player == null) {
                return result;
            }
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            MapDimension mapDimension = mapProcessor.getMapWorld().getCurrentDimension();
            if (mapDimension == null) {
                return result;
            }
            if (mapDimension.getDimId() != player.field_6002.method_27983()) {
                return false;
            }
        }
        return result;
    }

    public boolean shouldPreventAutoCaveMode(class_1937 world) {
        if (!this.hasDimensionSwitching()) {
            return false;
        }
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return false;
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        MapDimension mapDimension = mapProcessor.getMapWorld().getCurrentDimension();
        if (mapDimension == null) {
            return false;
        }
        return mapDimension.getDimId() != world.method_27983();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMapDimensionScale() {
        if (!this.hasDimensionSwitching()) {
            return class_310.method_1551().field_1687.method_8597().comp_646();
        }
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return class_310.method_1551().field_1687.method_8597().comp_646();
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.renderThreadPauseSync;
        synchronized (object) {
            if (mapProcessor.isRenderingPaused()) {
                return 0.0;
            }
            class_2378 dimTypes = mapProcessor.getWorldDimensionTypeRegistry();
            if (dimTypes == null) {
                return 0.0;
            }
            return mapProcessor.getMapWorld().getCurrentDimension().calculateDimScale(dimTypes);
        }
    }

    public class_5321<class_1937> getMapDimension() {
        if (!this.hasDimensionSwitching()) {
            return class_310.method_1551().field_1687.method_27983();
        }
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return class_310.method_1551().field_1687.method_27983();
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        MapDimension mapDimension = mapProcessor.getMapWorld().getCurrentDimension();
        return mapDimension == null ? class_310.method_1551().field_1687.method_27983() : mapDimension.getDimId();
    }

    public boolean shouldAlwaysInitEffects() {
        return this.compatibilityVersion < 26;
    }
}

