/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.mixin;

import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.IXaeroMinimapClientPlayNetHandler;
import xaero.common.core.XaeroMinimapCore;

@Mixin(value={ClientPacketListener.class})
public class MixinClientPlayNetworkHandler
implements IXaeroMinimapClientPlayNetHandler {
    XaeroMinimapSession xaero_minimapSession;

    @Inject(at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V")}, method={"handleChunkBlocksUpdate"})
    public void onOnChunkDeltaUpdate(ClientboundSectionBlocksUpdatePacket packet, CallbackInfo info) {
        XaeroMinimapCore.onMultiBlockChange(packet);
    }

    @Inject(at={@At(value="HEAD")}, method={"updateLevelChunk"})
    public void onOnChunkData(int x, int z, ClientboundLevelChunkPacketData packet, CallbackInfo info) {
        XaeroMinimapCore.onChunkData(x, z, packet);
    }

    @Inject(at={@At(value="HEAD")}, method={"queueLightUpdate"})
    public void onChunkLightData(int x, int z, ClientboundLightUpdatePacketData packet, CallbackInfo info) {
        XaeroMinimapCore.onChunkLightData(x, z, packet);
    }

    @Inject(at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V")}, method={"handleBlockUpdate"})
    public void onOnBlockUpdate(ClientboundBlockUpdatePacket packet, CallbackInfo info) {
        XaeroMinimapCore.onBlockChange(packet);
    }

    @Inject(at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V")}, method={"handleSetSpawn"})
    public void onOnPlayerSpawnPosition(ClientboundSetDefaultSpawnPositionPacket packet, CallbackInfo info) {
        XaeroMinimapCore.onSpawn(packet);
    }

    @Override
    public XaeroMinimapSession getXaero_minimapSession() {
        return this.xaero_minimapSession;
    }

    @Override
    public void setXaero_minimapSession(XaeroMinimapSession session) {
        this.xaero_minimapSession = session;
    }

    @Inject(at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V")}, method={"handleLogin"})
    public void onOnGameJoin(ClientboundLoginPacket packet, CallbackInfo info) {
        XaeroMinimapCore.onPlayNetHandler((ClientPacketListener)this, packet);
    }

    @Inject(at={@At(value="HEAD")}, method={"cleanup"})
    public void onCleanup(CallbackInfo info) {
        XaeroMinimapCore.onPlayNetHandlerCleanup((ClientPacketListener)this);
    }
}

