/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.util;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.misc.Misc;
import xaero.hud.minimap.MinimapLogs;

public class RadarUtils {
    private static EntityDataAccessor<Optional<UUID>> FOX_TRUSTED_UUID_SECONDARY;
    private static EntityDataAccessor<Optional<UUID>> FOX_TRUSTED_UUID_MAIN;

    public static double getMaxDistance(MinimapProcessor minimap, boolean circle) {
        int cullingSize = minimap.getMinimapSize() / 2 + 48;
        if (!circle) {
            cullingSize = (int)((double)cullingSize * Math.sqrt(2.0));
        }
        return (double)(cullingSize * cullingSize) / (minimap.getMinimapZoom() * minimap.getMinimapZoom());
    }

    public static boolean isHostileException(Entity e) {
        if (e instanceof Piglin) {
            return ((Piglin)e).m_6162_();
        }
        return false;
    }

    public static boolean isTamed(Entity e, Player p) {
        if (e instanceof TamableAnimal) {
            TamableAnimal tameable = (TamableAnimal)e;
            return tameable.m_21824_() && p.m_142081_().equals(tameable.m_142504_());
        }
        if (e instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)e;
            return horse.m_30614_() && p.m_142081_().equals(horse.m_30615_());
        }
        if (e instanceof Fox) {
            Fox fox = (Fox)e;
            if (FOX_TRUSTED_UUID_SECONDARY != null && p.m_142081_().equals(((Optional)fox.m_20088_().m_135370_(FOX_TRUSTED_UUID_SECONDARY)).orElse(null))) {
                return true;
            }
            return FOX_TRUSTED_UUID_MAIN != null && p.m_142081_().equals(((Optional)fox.m_20088_().m_135370_(FOX_TRUSTED_UUID_MAIN)).orElse(null));
        }
        return false;
    }

    public static boolean isHostile(Entity e) {
        if (Minecraft.m_91087_().f_91073_.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        if (RadarUtils.isHostileException(e)) {
            return false;
        }
        return e instanceof Monster || e instanceof Enemy || e.m_5720_() == SoundSource.HOSTILE;
    }

    public static String getCustomName(Entity e, boolean nullable) {
        Component c = e.m_7770_();
        if (c != null && c instanceof TextComponent) {
            return ((TextComponent)c).m_131292_();
        }
        return nullable ? null : "{non-plain}";
    }

    static {
        Field foxTrustSecondaryField = null;
        Field foxTrustMainField = null;
        try {
            foxTrustSecondaryField = Misc.getFieldReflection(Fox.class, "DATA_TRUSTED_ID_0", "field_17951", "Lnet/minecraft/class_2940;", "f_28439_");
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        try {
            foxTrustMainField = Misc.getFieldReflection(Fox.class, "DATA_TRUSTED_ID_1", "field_17952", "Lnet/minecraft/class_2940;", "f_28440_");
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        if (foxTrustSecondaryField != null) {
            FOX_TRUSTED_UUID_SECONDARY = (EntityDataAccessor)Misc.getReflectFieldValue(0, foxTrustSecondaryField);
        }
        if (foxTrustMainField != null) {
            FOX_TRUSTED_UUID_MAIN = (EntityDataAccessor)Misc.getReflectFieldValue(0, foxTrustMainField);
        }
    }
}

