/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.effect;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import xaero.hud.pvp.module.effect.StatusEffectSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class StatusEffectRenderer
implements IModuleRenderer<StatusEffectSession> {
    @Override
    public void render(StatusEffectSession session, ModuleRenderContext c, PoseStack matrixStack, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!mc.f_91074_.m_21220_().isEmpty()) {
            this.renderEffects(session, matrixStack, c, mc);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderEffects(StatusEffectSession session, PoseStack matrixStack, ModuleRenderContext c, Minecraft mc) {
        Collection effects;
        if (c.flippedVertically) {
            c.y = c.y + c.h - 30;
        }
        if ((effects = mc.f_91074_.m_21220_()).isEmpty()) {
            return;
        }
        effects = Ordering.natural().sortedCopy((Iterable)effects);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        if (session.isBlinkEnabled() && System.currentTimeMillis() - session.getLastBlink() > 500L) {
            session.setLastBlink(System.currentTimeMillis());
            session.setBlink(!session.getBlink());
        }
        if (session.isCentered()) {
            this.renderCentered(session, matrixStack, c, mc, effects);
            return;
        }
        this.renderNormal(session, matrixStack, c, mc, effects);
    }

    private void renderCentered(StatusEffectSession session, PoseStack matrixStack, ModuleRenderContext c, Minecraft mc, Collection<MobEffectInstance> effects) {
        MobEffectTextureManager potionspriteuploader = mc.m_91306_();
        int columnWidth = 27;
        int defaultEffectAmount = 182 / columnWidth;
        if (effects.size() > defaultEffectAmount) {
            columnWidth = 182 / effects.size();
        }
        int totalSize = effects.size() * columnWidth;
        int firstColumn = c.x + c.w / 2 + totalSize / 2 * (c.flippedHorizontally ? 1 : -1);
        if (c.flippedHorizontally) {
            firstColumn -= columnWidth;
        }
        int currentX = firstColumn + (columnWidth - 18) / 2;
        int currentY = c.y + 7;
        for (MobEffectInstance effectInstance : effects) {
            int duration = effectInstance.m_19557_();
            if (duration <= 200 && !session.getBlink() && session.isBlinkEnabled()) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            } else {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            MobEffect effect = effectInstance.m_19544_();
            TextureAtlasSprite effectSprite = potionspriteuploader.m_118732_(effect);
            if (effectSprite != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)effectSprite.m_118414_().m_118330_());
                GuiComponent.m_93200_((PoseStack)matrixStack, (int)currentX, (int)currentY, (int)0, (int)18, (int)18, (TextureAtlasSprite)effectSprite);
            }
            String durationString = MobEffectUtil.m_19581_((MobEffectInstance)effectInstance, (float)1.0f);
            int amplifier = effectInstance.m_19564_();
            String levelString = amplifier > 0 ? "" + (effectInstance.m_19564_() + 1) : "";
            GuiComponent.m_93236_((PoseStack)matrixStack, (Font)mc.f_91062_, (String)levelString, (int)currentX, (int)currentY, (int)0xFFFFFF);
            GuiComponent.m_93236_((PoseStack)matrixStack, (Font)mc.f_91062_, (String)durationString, (int)(currentX + 10 - mc.f_91062_.m_92895_(durationString) / 2), (int)(currentY + 15), (int)0xFFFFFF);
            RenderSystem.m_69478_();
            currentX += columnWidth * (c.flippedHorizontally ? -1 : 1);
        }
    }

    private void renderNormal(StatusEffectSession session, PoseStack matrixStack, ModuleRenderContext c, Minecraft mc, Collection<MobEffectInstance> effects) {
        int rowHeight = 25;
        if (effects.size() > 6) {
            rowHeight = 135 / (effects.size() - 1);
        }
        MobEffectTextureManager potionspriteuploader = mc.m_91306_();
        for (MobEffectInstance effectInstance : effects) {
            Object potionName;
            int duration = effectInstance.m_19557_();
            if (duration <= 200 && !session.getBlink() && session.isBlinkEnabled()) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            } else {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            MobEffect effect = effectInstance.m_19544_();
            TextureAtlasSprite effectSprite = potionspriteuploader.m_118732_(effect);
            if (effectSprite != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)effectSprite.m_118414_().m_118330_());
                GuiComponent.m_93200_((PoseStack)matrixStack, (int)(c.flippedHorizontally ? c.x + c.w - 24 : c.x + 6), (int)(c.y + 7), (int)0, (int)18, (int)18, (TextureAtlasSprite)effectSprite);
            }
            String durationString = MobEffectUtil.m_19581_((MobEffectInstance)effectInstance, (float)1.0f);
            if (!session.shouldShowNames()) {
                potionName = durationString;
                durationString = null;
            } else {
                potionName = I18n.m_118938_((String)effect.m_19481_(), (Object[])new Object[0]);
                if (effectInstance.m_19564_() >= 1 && effectInstance.m_19564_() <= 9) {
                    potionName = (String)potionName + " " + I18n.m_118938_((String)("enchantment.level." + (effectInstance.m_19564_() + 1)), (Object[])new Object[0]);
                }
            }
            int amplifier = effectInstance.m_19564_();
            String levelString = amplifier > 0 ? "" + (effectInstance.m_19564_() + 1) : "";
            GuiComponent.m_93236_((PoseStack)matrixStack, (Font)mc.f_91062_, (String)levelString, (int)(c.flippedHorizontally ? c.x + c.w - 24 : c.x + 6), (int)(c.y + 7), (int)0xFFFFFF);
            GuiComponent.m_93236_((PoseStack)matrixStack, (Font)mc.f_91062_, (String)potionName, (int)(c.flippedHorizontally ? c.x + c.w - 28 - mc.f_91062_.m_92895_((String)potionName) : c.x + 10 + 18), (int)(c.y + 7), (int)0xFFFFFF);
            if (durationString != null) {
                GuiComponent.m_93236_((PoseStack)matrixStack, (Font)mc.f_91062_, (String)durationString, (int)(c.flippedHorizontally ? c.x + c.w - 28 - mc.f_91062_.m_92895_(durationString) : c.x + 10 + 18), (int)(c.y + 7 + 10), (int)0xFFFFFF);
            }
            RenderSystem.m_69478_();
            c.y = c.y + (c.flippedVertically ? -rowHeight : rowHeight);
        }
    }
}

