/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics.renderer.multitexture;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.function.IntConsumer;
import net.minecraft.class_1921;
import net.minecraft.class_285;
import net.minecraft.class_286;
import net.minecraft.class_287;

public class MultiTextureRenderTypeRenderer {
    private boolean used;
    private class_287 bufferBuilder = new class_287(256);
    private IntArrayList texturesForDrawCalls = new IntArrayList();
    private IntConsumer textureBinderShader;
    private IntConsumer textureBinder;
    private Runnable textureFinalizer;
    private int prevTextureId;
    private class_1921 renderType;

    MultiTextureRenderTypeRenderer() {
    }

    void init(IntConsumer textureBinderShader, IntConsumer textureBinder, Runnable textureFinalizer, class_1921 renderType) {
        if (this.used) {
            throw new IllegalStateException("Multi-texture renderer already in use!");
        }
        this.used = true;
        this.textureBinderShader = textureBinderShader;
        this.textureBinder = textureBinder;
        this.textureFinalizer = textureFinalizer;
        this.prevTextureId = -1;
        this.renderType = renderType;
    }

    void draw() {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (!this.texturesForDrawCalls.isEmpty()) {
            class_287 bufferBuilder = this.bufferBuilder;
            IntConsumer textureBinder = this.textureBinder;
            IntConsumer textureBinderShader = this.textureBinderShader;
            Runnable textureFinalizer = this.textureFinalizer;
            boolean hasTextureFinalizer = textureFinalizer != null;
            this.renderType.method_23516();
            bufferBuilder.method_1326();
            boolean first = true;
            int shaderProgram = RenderSystem.getShader().method_1270();
            for (Integer texture : this.texturesForDrawCalls) {
                if (texture == -1) {
                    texture = 0;
                }
                if (first) {
                    textureBinderShader.accept(texture);
                    class_286.method_1309((class_287)bufferBuilder);
                    class_285.method_22094((int)shaderProgram);
                } else {
                    textureBinder.accept(texture);
                    class_286.method_34424((class_287)bufferBuilder);
                }
                if (hasTextureFinalizer) {
                    if (first) {
                        textureBinder.accept(texture);
                    }
                    textureFinalizer.run();
                }
                first = false;
            }
            textureBinder.accept(0);
            this.renderType.method_23518();
        }
        class_285.method_22094((int)0);
        this.texturesForDrawCalls.clear();
        this.used = false;
        this.renderType = null;
    }

    public class_287 begin(int textureId) {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (textureId == -1) {
            throw new IllegalStateException("Attempted to use the multi-texture renderer with texture id -1!");
        }
        if (textureId != this.prevTextureId) {
            if (this.prevTextureId != -1) {
                this.bufferBuilder.method_1326();
            }
            this.bufferBuilder.method_1328(this.renderType.method_23033(), this.renderType.method_23031());
            this.prevTextureId = textureId;
            this.texturesForDrawCalls.add(textureId);
        }
        return this.bufferBuilder;
    }
}

