/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.notification;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import xaero.hud.pvp.module.notification.Notification;
import xaero.hud.pvp.module.notification.NotificationSession;
import xaero.hud.render.TextureLocations;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class NotificationRenderer
implements IModuleRenderer<NotificationSession> {
    @Override
    public void render(NotificationSession session, ModuleRenderContext c, class_4587 matrixStack, float partialTicks) {
        boolean air;
        if (System.currentTimeMillis() - session.getLastBlink() > 500L) {
            session.setLastBlink(System.currentTimeMillis());
            session.setBlink(!session.getBlink());
        }
        class_310 mc = class_310.method_1551();
        int total = 0;
        boolean lowHunger = session.getNotificationHunger() && (float)mc.field_1724.method_7344().method_7586() <= 2.0f * (float)session.getLowHunger();
        boolean lowHealth = session.getNotificationHP() && mc.field_1724.method_6032() <= 2.0f * (float)session.getLowHealth();
        boolean tnt = session.getNotificationTNT() && session.getWorldHelper().tntIsAround(mc.field_1724);
        boolean arrow = session.getNotificationArrow() && session.getWorldHelper().arrowIsAround(mc.field_1724);
        boolean bl = air = session.getNotificationAir() && mc.field_1724.method_5669() <= 30 * session.getLowAir();
        if (lowHunger) {
            ++total;
        }
        if (lowHealth) {
            ++total;
        }
        if (tnt) {
            ++total;
        }
        if (arrow) {
            ++total;
        }
        if (air) {
            ++total;
        }
        if (total == 0) {
            return;
        }
        int between = 32 - 4 * total;
        int unitLength = 32 + between;
        int totalLength = total * unitLength;
        int drawY = c.y + (c.h - 32) / 2;
        int drawX = c.x + c.w / 2 - totalLength / 2 + between / 2;
        if (session.getBlink()) {
            RenderSystem.setShaderColor((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)TextureLocations.GUI_TEXTURES);
        if (lowHunger) {
            this.renderNotification(mc, Notification.LOW_HUNGER, drawX, drawY, matrixStack);
            drawX += unitLength;
        }
        if (lowHealth) {
            this.renderNotification(mc, Notification.LOW_HEALTH, drawX, drawY, matrixStack);
            drawX += unitLength;
        }
        if (tnt) {
            this.renderNotification(mc, Notification.TNT, drawX, drawY, matrixStack);
            drawX += unitLength;
        }
        if (arrow) {
            this.renderNotification(mc, Notification.ARROW, drawX, drawY, matrixStack);
            drawX += unitLength;
        }
        if (air) {
            this.renderNotification(mc, Notification.AIR, drawX, drawY, matrixStack);
            drawX += unitLength;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22737);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderNotification(class_310 mc, Notification notification, int drawX, int drawY, class_4587 matrixStack) {
        mc.field_1705.method_25302(matrixStack, drawX, drawY, 17, notification.getTextureIndex() * 32, notification.getTextureW(), 32);
    }
}

