/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import xaero.hud.render.TextureLocations;

public class CustomRenderTypes
extends RenderType {
    protected static final RenderState.DepthTestState GREATER_DEPTH_TEST = new RenderState.DepthTestState(">", 516);
    private static final RenderState.TargetState KEEP_TARGET = new RenderState.TargetState("xaero_keep_target", () -> {}, () -> {});
    protected static final RenderState.TransparencyState TRANSLUCENT_TRANSPARENCY = new RenderState.TransparencyState("xaero_translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.TransparencyState LINES_TRANSPARENCY = new RenderState.TransparencyState("xaero_lines_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.AlphaState ALMOST_ZERO_ALPHA = new RenderState.AlphaState(1.0E-4f);
    public static final float DEFAULT_POLYGON_OFFSET = 10.0f;
    protected static final RenderState.LayerState POLYGON_OFFSET_LAYERING = new RenderState.LayerState("xaero_polygon_offset_layering", () -> {
        RenderSystem.polygonOffset((float)0.0f, (float)10.0f);
        RenderSystem.enablePolygonOffset();
    }, () -> {
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
    });
    public static final RenderType GUI_BILINEAR;
    public static final RenderType GUI_NEAREST;
    public static final RenderType COLORED_WAYPOINTS_BGS;
    public static final RenderType MAP_CHUNK_OVERLAY;
    public static final RenderType MAP_LINES;
    public static final RenderType RADAR_NAME_BGS;
    public static final RenderType DEPTH_CLEAR;

    public static RenderType entityIconRenderType(ResourceLocation texture, EntityIconLayerPhases layerPhases) {
        ImmutableList<RenderState> rendertype$state = new MultiPhaseBuilder().texture(layerPhases.texture).transparency(layerPhases.transparency).depthTest(layerPhases.depthTest).writeMaskState(layerPhases.writeMask).diffuseLighting(field_228533_y_).alpha(field_228517_i_).cull(layerPhases.cull).lightmap(field_228528_t_).overlay(field_228530_v_).target(KEEP_TARGET).fog(field_228501_K_).build();
        return new MultiPhaseRenderType("xaero_entity_icon", DefaultVertexFormats.field_227849_i_, 7, 256, true, true, rendertype$state);
    }

    public CustomRenderTypes(String name, VertexFormat vertexFormat, int drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static void resetDepthTest() {
        MultiPhaseBuilder.resetDepthTest();
    }

    public static void resetWriteMask() {
        MultiPhaseBuilder.resetWriteMask();
    }

    public static void resetTransparency() {
        MultiPhaseBuilder.resetTransparency();
    }

    public static RenderState.TransparencyState getTransparencyPhase(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        return new RenderState.TransparencyState("xaero_custom_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
    }

    public static EntityIconLayerPhases getBasicEntityIconLayerPhases(ResourceLocation texture) {
        return new EntityIconLayerPhases(new RenderState.TextureState(texture, true, false), TRANSLUCENT_TRANSPARENCY, field_228494_D_, field_228495_E_, field_228491_A_);
    }

    static {
        ImmutableList<RenderState> multiPhaseParameters = new MultiPhaseBuilder().texture(new RenderState.TextureState(TextureLocations.GUI_TEXTURES, false, false)).transparency(TRANSLUCENT_TRANSPARENCY).diffuseLighting(field_228533_y_).alpha(ALMOST_ZERO_ALPHA).cull(field_228491_A_).target(KEEP_TARGET).fog(field_228501_K_).build();
        GUI_NEAREST = new MultiPhaseRenderType("xaero_gui_nearest", DefaultVertexFormats.field_181709_i, 7, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().texture(new RenderState.TextureState(TextureLocations.GUI_TEXTURES, true, false)).transparency(TRANSLUCENT_TRANSPARENCY).diffuseLighting(field_228533_y_).alpha(ALMOST_ZERO_ALPHA).cull(field_228491_A_).target(KEEP_TARGET).fog(field_228501_K_).build();
        GUI_BILINEAR = new MultiPhaseRenderType("xaero_gui_bilinear", DefaultVertexFormats.field_181709_i, 7, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).diffuseLighting(field_228533_y_).alpha(ALMOST_ZERO_ALPHA).target(KEEP_TARGET).layering(POLYGON_OFFSET_LAYERING).fog(field_228501_K_).build();
        COLORED_WAYPOINTS_BGS = new MultiPhaseRenderType("xaero_colored_waypoints", DefaultVertexFormats.field_181706_f, 7, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).diffuseLighting(field_228533_y_).alpha(ALMOST_ZERO_ALPHA).target(KEEP_TARGET).layering(POLYGON_OFFSET_LAYERING).fog(field_228501_K_).build();
        RADAR_NAME_BGS = new MultiPhaseRenderType("xaero_radar_name_bg", DefaultVertexFormats.field_181706_f, 7, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).diffuseLighting(field_228533_y_).alpha(ALMOST_ZERO_ALPHA).target(KEEP_TARGET).fog(field_228501_K_).build();
        MAP_CHUNK_OVERLAY = new MultiPhaseRenderType("xaero_chunk_overlay", DefaultVertexFormats.field_181706_f, 7, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(LINES_TRANSPARENCY).diffuseLighting(field_228533_y_).alpha(ALMOST_ZERO_ALPHA).target(KEEP_TARGET).fog(field_228501_K_).build();
        MAP_LINES = new MultiPhaseRenderType("xaero_lines", DefaultVertexFormats.field_181706_f, 1, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).target(KEEP_TARGET).depthTest(GREATER_DEPTH_TEST).alpha(field_228516_h_).writeMaskState(field_228497_G_).build();
        DEPTH_CLEAR = new MultiPhaseRenderType("xaero_depth_clear", DefaultVertexFormats.field_181706_f, 7, 256, false, false, multiPhaseParameters);
    }

    public static class EntityIconLayerPhases {
        public RenderState.TextureState texture;
        public RenderState.TransparencyState transparency;
        public RenderState.DepthTestState depthTest;
        public RenderState.WriteMaskState writeMask;
        public RenderState.CullState cull;

        public EntityIconLayerPhases(RenderState.TextureState texture, RenderState.TransparencyState transparency, RenderState.DepthTestState depthTest, RenderState.WriteMaskState writeMask, RenderState.CullState cull) {
            this.texture = texture;
            this.transparency = transparency;
            this.depthTest = depthTest;
            this.writeMask = writeMask;
            this.cull = cull;
        }
    }

    static class MultiPhaseBuilder
    extends RenderState {
        private RenderState.TextureState texture = RenderState.field_228523_o_;
        private RenderState.TransparencyState transparency = RenderState.field_228510_b_;
        private RenderState.DiffuseLightingState diffuseLighting = RenderState.field_228533_y_;
        private RenderState.ShadeModelState shadeModel = RenderState.field_228519_k_;
        private RenderState.AlphaState alpha = RenderState.field_228516_h_;
        private RenderState.DepthTestState depthTest = RenderState.field_228494_D_;
        private RenderState.CullState cull = RenderState.field_228534_z_;
        private RenderState.LightmapState lightmap = RenderState.field_228529_u_;
        private RenderState.OverlayState overlay = RenderState.field_228531_w_;
        private RenderState.FogState fog = RenderState.field_228502_L_;
        private RenderState.LayerState layering = RenderState.field_228498_H_;
        private RenderState.TargetState target = RenderState.field_228504_N_;
        private RenderState.TexturingState texturing = RenderState.field_228524_p_;
        private RenderState.WriteMaskState writeMaskState = RenderState.field_228495_E_;
        private RenderState.LineState lineWidth = RenderState.field_228506_P_;

        private MultiPhaseBuilder() {
            super("weird access error workaround", null, null);
        }

        public MultiPhaseBuilder texture(RenderState.TextureState texture) {
            this.texture = texture;
            return this;
        }

        public MultiPhaseBuilder transparency(RenderState.TransparencyState transparency) {
            this.transparency = transparency;
            return this;
        }

        public MultiPhaseBuilder diffuseLighting(RenderState.DiffuseLightingState diffuseLighting) {
            this.diffuseLighting = diffuseLighting;
            return this;
        }

        public MultiPhaseBuilder shadeModel(RenderState.ShadeModelState shadeModel) {
            this.shadeModel = shadeModel;
            return this;
        }

        public MultiPhaseBuilder alpha(RenderState.AlphaState alpha) {
            this.alpha = alpha;
            return this;
        }

        public MultiPhaseBuilder depthTest(RenderState.DepthTestState depthTest) {
            this.depthTest = depthTest;
            return this;
        }

        public MultiPhaseBuilder cull(RenderState.CullState cull) {
            this.cull = cull;
            return this;
        }

        public MultiPhaseBuilder lightmap(RenderState.LightmapState lightmap) {
            this.lightmap = lightmap;
            return this;
        }

        public MultiPhaseBuilder overlay(RenderState.OverlayState overlay) {
            this.overlay = overlay;
            return this;
        }

        public MultiPhaseBuilder fog(RenderState.FogState fog) {
            this.fog = fog;
            return this;
        }

        public MultiPhaseBuilder layering(RenderState.LayerState layering) {
            this.layering = layering;
            return this;
        }

        public MultiPhaseBuilder target(RenderState.TargetState target) {
            this.target = target;
            return this;
        }

        public MultiPhaseBuilder texturing(RenderState.TexturingState texturing) {
            this.texturing = texturing;
            return this;
        }

        public MultiPhaseBuilder writeMaskState(RenderState.WriteMaskState writeMaskState) {
            this.writeMaskState = writeMaskState;
            return this;
        }

        public MultiPhaseBuilder lineWidth(RenderState.LineState lineWidth) {
            this.lineWidth = lineWidth;
            return this;
        }

        public ImmutableList<RenderState> build() {
            return ImmutableList.of((Object)this.texture, (Object)this.transparency, (Object)this.diffuseLighting, (Object)this.shadeModel, (Object)this.alpha, (Object)this.depthTest, (Object)this.cull, (Object)this.lightmap, (Object)this.overlay, (Object)this.fog, (Object)this.layering, (Object)this.target, (Object[])new RenderState[]{this.texturing, this.writeMaskState, this.lineWidth});
        }

        public static void resetDepthTest() {
            RenderState.field_228493_C_.func_228547_a_();
            RenderState.field_228493_C_.func_228549_b_();
        }

        public static void resetWriteMask() {
            RenderState.field_228496_F_.func_228547_a_();
            RenderState.field_228496_F_.func_228549_b_();
            RenderState.field_228497_G_.func_228547_a_();
            RenderState.field_228497_G_.func_228549_b_();
        }

        public static void resetTransparency() {
            RenderState.field_228511_c_.func_228547_a_();
            RenderState.field_228511_c_.func_228549_b_();
        }
    }

    private static class MultiPhaseRenderType
    extends RenderType {
        public MultiPhaseRenderType(String name, VertexFormat vertexFormat, int drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, ImmutableList<RenderState> phases) {
            super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, () -> phases.forEach(RenderState::func_228547_a_), () -> phases.forEach(RenderState::func_228549_b_));
        }
    }
}

