/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.ISettingEntry;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.TooltipButton;

public class ScreenSwitchSettingEntry
implements ISettingEntry {
    private String name;
    private BiFunction<Screen, Screen, Screen> screenFactory;
    private Supplier<CursorBox> tooltipSupplier;
    private boolean active;

    public ScreenSwitchSettingEntry(String name, BiFunction<Screen, Screen, Screen> screenFactoryFromCurrentAndEscape, CursorBox tooltip, boolean active) {
        this.name = name;
        this.screenFactory = screenFactoryFromCurrentAndEscape;
        this.tooltipSupplier = () -> tooltip;
        this.active = active;
    }

    @Override
    public String getStringForSearch(GameSettings mcOptions) {
        CursorBox entryTooltip = this.tooltipSupplier == null ? null : this.tooltipSupplier.get();
        return I18n.func_135052_a((String)this.name, (Object[])new Object[0]) + " " + this.name.replace("gui.xaero", "") + (entryTooltip != null ? " " + entryTooltip.getFullCode().replace("gui.xaero", "") + " " + I18n.func_135052_a((String)entryTooltip.getFullCode(), (Object[])new Object[0]) : "");
    }

    @Override
    public Widget createWidget(GameSettings mcOptions, int x, int y, int w, boolean canEditIngameSettings) {
        TooltipButton button = new TooltipButton(x, y, w, 20, (ITextComponent)new TranslationTextComponent(this.name), b -> {
            Minecraft mc = Minecraft.func_71410_x();
            Screen current = mc.field_71462_r;
            Screen currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
            Screen targetScreen = this.screenFactory.apply(current, currentEscScreen);
            if (current instanceof ScreenBase) {
                ((ScreenBase)current).onExit(targetScreen);
            } else {
                mc.func_147108_a(targetScreen);
            }
        }, this.tooltipSupplier);
        button.field_230693_o_ = this.active;
        return button;
    }

    public BiFunction<Screen, Screen, Screen> getScreenFactory() {
        return this.screenFactory;
    }
}

