/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.player.tracker;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.hud.entity.EntityUtils;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderer;
import xaero.hud.minimap.player.tracker.PlayerTrackerIconRenderer;
import xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElement;
import xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElementCollector;
import xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElementReader;
import xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElementRenderContext;
import xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElementRenderProvider;
import xaero.hud.render.util.RenderBufferUtil;

public final class PlayerTrackerMinimapElementRenderer
extends MinimapElementRenderer<PlayerTrackerMinimapElement<?>, PlayerTrackerMinimapElementRenderContext> {
    private final double WORLD_MINIMUM_DISTANCE = 10.0;
    private final double WORLD_FADING_LENGTH = 10.0;
    private IRenderTypeBuffer.Impl minimapBufferSource;
    private final PlayerTrackerMinimapElementCollector elementCollector;
    private final PlayerTrackerIconRenderer playerTrackerIconRenderer;
    private final IXaeroMinimap modMain;
    private float nameScale;

    private PlayerTrackerMinimapElementRenderer(PlayerTrackerMinimapElementCollector elementCollector, IXaeroMinimap modMain, PlayerTrackerMinimapElementRenderContext context, PlayerTrackerMinimapElementRenderProvider<PlayerTrackerMinimapElementRenderContext> provider, PlayerTrackerMinimapElementReader reader, PlayerTrackerIconRenderer playerTrackerIconRenderer) {
        super(reader, provider, context);
        this.elementCollector = elementCollector;
        this.modMain = modMain;
        this.playerTrackerIconRenderer = playerTrackerIconRenderer;
    }

    public ResourceLocation getPlayerSkin(PlayerEntity player, NetworkPlayerInfo info) {
        ResourceLocation skinTextureLocation;
        ResourceLocation resourceLocation = skinTextureLocation = player instanceof AbstractClientPlayerEntity ? ((AbstractClientPlayerEntity)player).func_110306_p() : info.func_178837_g();
        if (skinTextureLocation == null) {
            skinTextureLocation = DefaultPlayerSkin.func_177334_a((UUID)player.func_110124_au());
        }
        return skinTextureLocation;
    }

    @Override
    public void preRender(MinimapElementRenderInfo renderInfo, IRenderTypeBuffer.Impl vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider) {
        RenderSystem.disableDepthTest();
        vanillaBufferSource.func_228461_a_();
        this.minimapBufferSource = this.modMain.getHudRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
        ((PlayerTrackerMinimapElementRenderContext)this.context).coloredBackgroundConsumer = this.minimapBufferSource.getBuffer(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
        ((PlayerTrackerMinimapElementRenderContext)this.context).uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_NEAREST);
        ((PlayerTrackerMinimapElementRenderContext)this.context).renderEntityDimId = renderInfo.renderEntityDimension;
        ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimId = renderInfo.mapDimension;
        ((PlayerTrackerMinimapElementRenderContext)this.context).iconScale = renderInfo.location == MinimapElementRenderLocation.IN_WORLD ? HudMod.INSTANCE.getSettings().getTrackedPlayerWorldIconScale() : HudMod.INSTANCE.getSettings().getTrackedPlayerMinimapIconScale();
        this.nameScale = HudMod.INSTANCE.getSettings().getTrackedPlayerWorldNameScale();
    }

    @Override
    public void postRender(MinimapElementRenderInfo renderInfo, IRenderTypeBuffer.Impl vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider) {
        rendererProvider.draw(((PlayerTrackerMinimapElementRenderContext)this.context).uniqueTextureUIObjectRenderer);
        this.minimapBufferSource.func_228461_a_();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        this.elementCollector.resetRenderedOnRadarFlags();
    }

    @Override
    public boolean renderElement(PlayerTrackerMinimapElement<?> e, boolean highlighted, boolean outOfBounds, double optionalDepth, float optionalScale, double partialX, double partialY, MinimapElementRenderInfo renderInfo, MatrixStack matrixStack, IRenderTypeBuffer.Impl vanillaBufferSource) {
        float alpha;
        double trackedZ;
        double offZ;
        double trackedY;
        double offY;
        if (!outOfBounds && renderInfo.location != MinimapElementRenderLocation.IN_WORLD && e.wasRenderedOnRadar()) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        NetworkPlayerInfo info = mc.func_147114_u().func_175102_a(e.getPlayerId());
        if (info == null) {
            return false;
        }
        PlayerEntity clientPlayer = mc.field_71441_e.func_217371_b(e.getPlayerId());
        double trackedX = clientPlayer == null ? e.getX() : EntityUtils.getEntityX((Entity)clientPlayer, renderInfo.partialTicks);
        double offX = trackedX - renderInfo.renderEntityPos.field_72450_a;
        double distance = Math.sqrt(offX * offX + (offY = (trackedY = clientPlayer == null ? e.getY() : EntityUtils.getEntityY((Entity)clientPlayer, renderInfo.partialTicks)) - renderInfo.renderEntityPos.field_72448_b) * offY + (offZ = (trackedZ = clientPlayer == null ? e.getZ() : EntityUtils.getEntityZ((Entity)clientPlayer, renderInfo.partialTicks)) - renderInfo.renderEntityPos.field_72449_c) * offZ);
        if (distance < 10.0) {
            return false;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, optionalDepth);
        boolean inWorld = renderInfo.location == MinimapElementRenderLocation.IN_WORLD;
        float f = alpha = inWorld ? 0.5f : 1.0f;
        if (highlighted && inWorld) {
            alpha = 0.8f;
        }
        if (!highlighted && inWorld && distance < 20.0) {
            alpha *= (float)((distance - 10.0) / 10.0);
        }
        matrixStack.func_227861_a_(0.0, 0.0, 0.01);
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(((PlayerTrackerMinimapElementRenderContext)this.context).iconScale, ((PlayerTrackerMinimapElementRenderContext)this.context).iconScale, 1.0f);
        RenderBufferUtil.addColoredRect(matrixStack.func_227866_c_().func_227870_a_(), ((PlayerTrackerMinimapElementRenderContext)this.context).coloredBackgroundConsumer, -5.0f, -5.0f, 10, 10, 1.0f, 1.0f, 1.0f, alpha);
        this.playerTrackerIconRenderer.renderIcon(mc, ((PlayerTrackerMinimapElementRenderContext)this.context).uniqueTextureUIObjectRenderer, matrixStack, clientPlayer, this.getPlayerSkin(clientPlayer, info), alpha);
        matrixStack.func_227865_b_();
        if (highlighted && inWorld) {
            matrixStack.func_227861_a_((double)(-5.0f * ((PlayerTrackerMinimapElementRenderContext)this.context).iconScale), 0.0, 0.0);
            matrixStack.func_227862_a_(this.nameScale, this.nameScale, 1.0f);
            String playerName = info.func_178845_a().getName();
            int playerNameWidth = mc.field_71466_p.func_78256_a(playerName);
            float labelAlpha = 0.3529412f;
            RenderBufferUtil.addColoredRect(matrixStack.func_227866_c_().func_227870_a_(), ((PlayerTrackerMinimapElementRenderContext)this.context).coloredBackgroundConsumer, -playerNameWidth - 1, -5.0f, playerNameWidth + 1, 10, 0.0f, 0.0f, 0.0f, labelAlpha);
            mc.field_71466_p.func_228079_a_(playerName, (float)(-playerNameWidth), -4.0f, -1, false, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)this.minimapBufferSource, false, 0, 0xF000F0);
        }
        matrixStack.func_227865_b_();
        return true;
    }

    @Override
    public boolean shouldRender(MinimapElementRenderLocation location) {
        return location != MinimapElementRenderLocation.IN_WORLD && this.modMain.getSettings().displayTrackedPlayersOnMap || location == MinimapElementRenderLocation.IN_WORLD && this.modMain.getSettings().displayTrackedPlayersInWorld;
    }

    @Override
    public int getOrder() {
        return 100;
    }

    public PlayerTrackerMinimapElementCollector getCollector() {
        return this.elementCollector;
    }

    public static final class Builder {
        private final IXaeroMinimap modMain;

        private Builder(IXaeroMinimap modMain) {
            this.modMain = modMain;
        }

        private Builder setDefault() {
            return this;
        }

        public PlayerTrackerMinimapElementRenderer build() {
            PlayerTrackerMinimapElementCollector collector = new PlayerTrackerMinimapElementCollector(this.modMain.getPlayerTrackerSystemManager());
            return new PlayerTrackerMinimapElementRenderer(collector, this.modMain, new PlayerTrackerMinimapElementRenderContext(), new PlayerTrackerMinimapElementRenderProvider(collector), new PlayerTrackerMinimapElementReader(), new PlayerTrackerIconRenderer());
        }

        public static Builder begin(IXaeroMinimap modMain) {
            return new Builder(modMain).setDefault();
        }
    }
}

