/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.category.rule;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xaero.hud.category.rule.ObjectCategoryListRuleType;
import xaero.hud.minimap.radar.category.EntityRadarCategoryConstants;
import xaero.hud.minimap.radar.category.rule.EntityRadarCategoryHardRules;
import xaero.hud.minimap.radar.util.RadarUtils;

public class EntityRadarListRuleTypes {
    public static final List<ObjectCategoryListRuleType<Entity, PlayerEntity, ?>> TYPE_LIST = EntityRadarCategoryConstants.LIST_FACTORY.get();
    public static final Map<String, ObjectCategoryListRuleType<Entity, PlayerEntity, ?>> TYPE_MAP = EntityRadarCategoryConstants.MAP_FACTORY.get();
    public static final ObjectCategoryListRuleType<Entity, PlayerEntity, EntityType<?>> ENTITY_TYPE = new ObjectCategoryListRuleType("entity", (e, p) -> e.func_200600_R(), () -> Registry.field_212629_r, EntityRadarCategoryConstants.getDefaultElementResolver(ForgeRegistries.ENTITIES, s -> EntityType.func_220327_a((String)s).orElse(null), EntityType::func_200718_a), EntityRadarCategoryConstants.DEFAULT_LIST_SERIALIZER, EntityRadarCategoryConstants.DEFAULT_LIST_STRING_VALIDATOR_FIXER, EntityRadarCategoryConstants.DEFAULT_LIST_STRING_VALIDATOR, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, PlayerEntity, Item> ITEM_TYPE = new ObjectCategoryListRuleType<Entity, PlayerEntity, Item>("item", (e, p) -> e instanceof ItemEntity ? ((ItemEntity)e).func_92059_d().func_77973_b() : null, () -> Registry.field_212630_s, EntityRadarCategoryConstants.getDefaultElementResolver(ForgeRegistries.ITEMS, s -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s)), arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)), item -> ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).toString(), EntityRadarCategoryConstants.DEFAULT_LIST_STRING_VALIDATOR_FIXER, EntityRadarCategoryConstants.DEFAULT_LIST_STRING_VALIDATOR, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, PlayerEntity, String> PLAYER_NAME = new ObjectCategoryListRuleType<Entity, PlayerEntity, String>("player", (e, p) -> e instanceof PlayerEntity ? ((PlayerEntity)e).func_146103_bH().getName() : null, () -> Minecraft.func_71410_x().func_147114_u() == null ? new ArrayList() : Minecraft.func_71410_x().func_147114_u().func_175106_d().stream().map(pi -> pi.func_178845_a().getName())::iterator, xva$0 -> Lists.newArrayList((Object[])new String[]{xva$0}), Function.identity(), EntityRadarCategoryConstants.PLAYER_NAME_VALIDATOR_FIXER, EntityRadarCategoryConstants.PLAYER_NAME_VALIDATOR, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, PlayerEntity, String> CUSTOM_NAME = new ObjectCategoryListRuleType<Entity, PlayerEntity, String>("custom-name", (e, p) -> RadarUtils.getCustomName(e, false), () -> {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return Lists.newArrayList((Object[])new String[]{"example"});
        }
        Iterable entities = Minecraft.func_71410_x().field_71441_e.func_217416_b();
        if (entities == null) {
            return Lists.newArrayList((Object[])new String[]{"example"});
        }
        Stream<String> nameStream = StreamSupport.stream(entities.spliterator(), false).map(e -> RadarUtils.getCustomName(e, true)).filter(Objects::nonNull);
        Iterator iterator = nameStream.iterator();
        if (!iterator.hasNext()) {
            return Lists.newArrayList((Object[])new String[]{"example"});
        }
        return () -> iterator;
    }, xva$0 -> Lists.newArrayList((Object[])new String[]{xva$0}), Function.identity(), s -> s, s -> true, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, PlayerEntity, Boolean> LIVING = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_LIVING, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, PlayerEntity, Boolean> HOSTILE = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_HOSTILE, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, PlayerEntity, Boolean> TAMED = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_TAMED, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, PlayerEntity, Boolean> SAME_TEAM = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_SAME_TEAM, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, PlayerEntity, Boolean> BABY = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_BABY, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, PlayerEntity, Boolean> VANILLA = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_VANILLA, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, PlayerEntity, Boolean> ABOVE_GROUND = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_ABOVE_GROUND, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, PlayerEntity, Boolean> MY_GROUND = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_MY_GROUND, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, PlayerEntity, Boolean> LIT = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_LIT, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, PlayerEntity, Boolean> HAS_CUSTOM_NAME = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.HAS_CUSTOM_NAME, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, PlayerEntity, Boolean> IN_TEAM = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_IN_TEAM, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, PlayerEntity, Boolean> TRACKED = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_TRACKED, TYPE_LIST, TYPE_MAP);
}

