/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.form.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Logger;
import xaero.common.graphics.CustomRenderTypes;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.creator.render.form.model.part.RadarIconModelPartPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.form.model.part.ResolvedFieldModelPartRenderer;
import xaero.hud.minimap.radar.icon.creator.render.form.model.resolver.RadarIconModelFieldResolver;
import xaero.hud.minimap.radar.icon.creator.render.form.model.resolver.ResolvedFieldModelRootPathListener;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.minimap.radar.icon.definition.BuiltInRadarIconDefinitions;
import xaero.hud.minimap.radar.icon.definition.form.model.config.RadarIconModelConfig;

public class RadarIconModelPrerenderer {
    private static final Object[] ONE_RENDERER_ARRAY = new Object[1];
    private static final Object[] ONE_OBJECT_ARRAY = new Object[1];
    private final RadarIconModelPartPrerenderer partPrerenderer = new RadarIconModelPartPrerenderer();
    private final ResolvedFieldModelPartRenderer resolvedFieldRenderer = new ResolvedFieldModelPartRenderer();
    private final ResolvedFieldModelRootPathListener modelRootPathListener = new ResolvedFieldModelRootPathListener();
    private ModelRenderer mainPart;

    public ModelRenderer renderModel(MatrixStack matrixStack, IRenderTypeBuffer.Impl bufferSource, EntityModel<?> model, Entity entity, ModelRenderer mainPart, Parameters parameters) {
        this.mainPart = mainPart;
        boolean forceFieldCheck = parameters.forceFieldCheck;
        boolean fullModelIcon = parameters.fullModelIcon;
        RadarIconModelConfig config = parameters.config;
        Object modelRoot = null;
        if (config.modelRootPath != null) {
            modelRoot = this.resolveModelRoot(model, config.modelRootPath, entity);
        }
        if (modelRoot == null) {
            modelRoot = BuiltInRadarIconDefinitions.getModelRoot(model);
        }
        IVertexBuilder vertexConsumer = this.getLayerModelVertexConsumer(bufferSource, parameters.texture, parameters.textureAtlasSprite, parameters.mrt);
        if (config.modelMainPartFieldAliases != null && !config.modelMainPartFieldAliases.isEmpty()) {
            this.searchAndRenderFields(matrixStack, vertexConsumer, modelRoot, config.modelMainPartFieldAliases, true, parameters);
        }
        if (!forceFieldCheck && modelRoot instanceof AgeableModel) {
            this.renderAgeableListModel((AgeableModel)modelRoot, matrixStack, vertexConsumer, parameters);
            bufferSource.func_228461_a_();
            return this.mainPart;
        }
        if (!forceFieldCheck && modelRoot instanceof SegmentedModel && fullModelIcon) {
            this.mainPart = this.partPrerenderer.renderDeclaredMethod(matrixStack, vertexConsumer, this.partPrerenderer.listModelPartsMethod, (SegmentedModel)modelRoot, mainPart, parameters);
            bufferSource.func_228461_a_();
            return this.mainPart;
        }
        if (!forceFieldCheck && modelRoot instanceof IHasHead) {
            ModelRenderer headPart = ((IHasHead)modelRoot).func_205072_a();
            this.renderPart(matrixStack, vertexConsumer, headPart, parameters);
        }
        List<String> hardcodedMainPartAliases = parameters.hardcodedMainPartAliases;
        List<String> hardcodedModelPartsFields = parameters.hardcodedModelPartsFields;
        if (config.modelPartsFields == null) {
            this.searchAndRenderFields(matrixStack, vertexConsumer, modelRoot, hardcodedMainPartAliases, true, parameters);
        }
        List<String> headPartsFields = hardcodedModelPartsFields;
        if (fullModelIcon) {
            headPartsFields = null;
        } else if (config.modelPartsFields != null) {
            headPartsFields = config.modelPartsFields;
        }
        this.searchAndRenderFields(matrixStack, vertexConsumer, modelRoot, headPartsFields, false, parameters);
        bufferSource.func_228461_a_();
        return this.mainPart;
    }

    private void renderAgeableListModel(AgeableModel<?> modelRoot, MatrixStack matrixStack, IVertexBuilder vertexConsumer, Parameters parameters) {
        if (modelRoot instanceof BipedModel) {
            ModelRenderer headRenderer = ((BipedModel)modelRoot).field_78116_c;
            ModelRenderer headWearRenderer = ((BipedModel)modelRoot).field_178720_f;
            this.renderPart(matrixStack, vertexConsumer, headRenderer, parameters);
            this.renderPart(matrixStack, vertexConsumer, headWearRenderer, parameters);
        }
        this.mainPart = this.partPrerenderer.renderDeclaredMethod(matrixStack, vertexConsumer, this.partPrerenderer.ageableModelHeadPartsMethod, modelRoot, this.mainPart, parameters);
        if (parameters.fullModelIcon) {
            this.mainPart = this.partPrerenderer.renderDeclaredMethod(matrixStack, vertexConsumer, this.partPrerenderer.ageableModelBodyPartsMethod, modelRoot, this.mainPart, parameters);
        }
    }

    private void renderPart(MatrixStack matrixStack, IVertexBuilder vertexConsumer, ModelRenderer part, Parameters parameters) {
        if (this.mainPart == null) {
            this.mainPart = part;
        }
        this.partPrerenderer.renderPart(matrixStack, vertexConsumer, part, this.mainPart, parameters);
    }

    private void searchAndRenderFields(MatrixStack matrixStack, IVertexBuilder vertexBuilder, Object modelRoot, List<String> filter, boolean justOne, Parameters parameters) {
        this.resolvedFieldRenderer.prepare(matrixStack, vertexBuilder, justOne, this.mainPart, parameters, this.partPrerenderer);
        RadarIconModelFieldResolver.searchSuperclassFields(modelRoot, filter, this.resolvedFieldRenderer, ONE_RENDERER_ARRAY);
        this.mainPart = this.resolvedFieldRenderer.getMainPart();
    }

    public IVertexBuilder getLayerModelVertexConsumer(IRenderTypeBuffer.Impl renderTypeBuffer, ResourceLocation entityTexture, TextureAtlasSprite entityAtlasSprite, ModelRenderTrace mrt) {
        RenderType renderType = CustomRenderTypes.entityIconRenderType(entityTexture, mrt.layerPhases);
        IVertexBuilder regularConsumer = renderTypeBuffer.getBuffer(renderType);
        if (entityAtlasSprite != null) {
            return entityAtlasSprite.func_229230_a_(regularConsumer);
        }
        return regularConsumer;
    }

    private Object resolveModelRoot(EntityModel<?> model, ArrayList<ArrayList<String>> rootPath, Entity entity) {
        Object currentChainNode = model;
        for (ArrayList<String> pathStep : rootPath) {
            this.modelRootPathListener.prepare();
            RadarIconModelFieldResolver.searchSuperclassFields(currentChainNode, pathStep, this.modelRootPathListener, ONE_OBJECT_ARRAY);
            currentChainNode = this.modelRootPathListener.getCurrentNode();
            if (currentChainNode != null && !this.modelRootPathListener.failed()) continue;
            MinimapLogs.LOGGER.info(String.format("The following entity icon model root path step couldn't be resolved for %s:", EntityType.func_200718_a((EntityType)entity.func_200600_R())));
            pathStep.forEach(arg_0 -> ((Logger)MinimapLogs.LOGGER).info(arg_0));
            return null;
        }
        return currentChainNode;
    }

    public RadarIconModelPartPrerenderer getPartPrerenderer() {
        return this.partPrerenderer;
    }

    public static final class Parameters
    extends RadarIconModelPartPrerenderer.Parameters {
        public final RadarIconModelConfig defaultConfig;
        public final ResourceLocation texture;
        public final TextureAtlasSprite textureAtlasSprite;
        public final boolean forceFieldCheck;
        public final boolean fullModelIcon;
        public final List<String> hardcodedMainPartAliases;
        public final List<String> hardcodedModelPartsFields;

        public Parameters(RadarIconModelConfig config, RadarIconModelConfig defaultConfig, ResourceLocation texture, TextureAtlasSprite textureAtlasSprite, ModelRenderTrace mrt, boolean forceFieldCheck, boolean fullModelIcon, List<String> hardcodedMainPartAliases, List<String> hardcodedModelPartsFields, List<ModelRenderer> renderedDest) {
            super(config, mrt, renderedDest);
            this.defaultConfig = defaultConfig;
            this.texture = texture;
            this.textureAtlasSprite = textureAtlasSprite;
            this.forceFieldCheck = forceFieldCheck;
            this.fullModelIcon = fullModelIcon;
            this.hardcodedMainPartAliases = hardcodedMainPartAliases;
            this.hardcodedModelPartsFields = hardcodedModelPartsFields;
        }
    }
}

