/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.trace;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.SpriteAwareVertexBuilder;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.misc.Misc;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;

public class EntityRenderTracer {
    public static boolean TRACING_MODEL_RENDERS;
    private Entity tracedEntity;
    private EntityRenderer tracedEntityRenderer;
    private Class<?> tracedEntityModelClass;
    private List<ModelRenderTrace> traceResultList;
    private ModelRenderTrace lastModelRenderDetected;
    private IRenderTypeBuffer.Impl modelRenderDetectionRenderTypeBuffer;
    private Field lastStateField;
    private Class<?> compositeRenderTypeClass;
    private Field enderDragonModelField;
    private Field stateField;
    private Field compositeStateTextureStateField;
    private Field textureStateShardTextureField;
    private Field compositeStateDepthTestStateField;
    private Field compositeStateWriteMaskStateField;
    private Field compositeStateCullStateField;
    private Field compositeStateTransparencyStateField;
    private Field renderBuffersBufferSourceField;
    private Field spriteCoordinateExpanderSpriteField;
    private Class<?> irisRenderLayerWrapperClass;
    private Method irisRenderLayerWrapperUnwrapMethod;

    public EntityRenderTracer() {
        this.initReflection();
        this.traceResultList = new ArrayList<ModelRenderTrace>();
    }

    public <T extends Entity> List<ModelRenderTrace> trace(MatrixStack matrixStack, T entity, EntityRenderer<? super T> entityRenderer) {
        TRACING_MODEL_RENDERS = true;
        this.tracedEntity = entity;
        this.tracedEntityRenderer = entityRenderer;
        this.tracedEntityModelClass = null;
        this.traceResultList.clear();
        this.lastModelRenderDetected = null;
        MatrixStack.Entry matrixEntryToRestore = matrixStack.func_227866_c_();
        matrixStack.func_227860_a_();
        try {
            IRenderTypeBuffer.Impl renderTypeBuffer = this.modelRenderDetectionRenderTypeBuffer = (IRenderTypeBuffer.Impl)Misc.getReflectFieldValue(Minecraft.func_71410_x().func_228019_au_(), this.renderBuffersBufferSourceField);
            entityRenderer.func_225623_a_(entity, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)renderTypeBuffer, 0xF000F0);
            renderTypeBuffer.func_228461_a_();
            OpenGLException.checkGLError();
        }
        catch (Throwable e) {
            this.traceResultList.clear();
            MinimapLogs.LOGGER.error("Exception when calling the full entity renderer for {} before prerendering the icon.", (Object)entity.func_195047_I_(), (Object)e);
        }
        TRACING_MODEL_RENDERS = false;
        this.tracedEntity = null;
        this.tracedEntityRenderer = null;
        while (matrixStack.func_227866_c_() != matrixEntryToRestore) {
            matrixStack.func_227865_b_();
        }
        while (GL11.glGetError() != 0) {
        }
        return this.traceResultList;
    }

    public void onModelRender(EntityModel<?> model, IVertexBuilder vertexConsumer, float red, float green, float blue, float alpha) {
        this.lastModelRenderDetected = null;
        if (this.tracedEntityModelClass == null) {
            EntityModel currentMainModel = this.getEntityRendererModel(this.tracedEntityRenderer);
            Class<?> clazz = this.tracedEntityModelClass = currentMainModel == null ? null : currentMainModel.getClass();
            if (this.tracedEntityModelClass == null) {
                return;
            }
        }
        if (!model.getClass().isAssignableFrom(this.tracedEntityModelClass) && !this.tracedEntityModelClass.isAssignableFrom(model.getClass())) {
            return;
        }
        RenderType lastRenderType = this.getLastRenderType((IRenderTypeBuffer)this.modelRenderDetectionRenderTypeBuffer);
        if (lastRenderType == null && this.traceResultList.isEmpty()) {
            ResourceLocation textureLocation = null;
            try {
                ResourceLocation textureLocationUnchecked;
                textureLocation = textureLocationUnchecked = this.tracedEntityRenderer.func_110775_a(this.tracedEntity);
            }
            catch (Throwable t) {
                MinimapLogs.LOGGER.error("Couldn't fetch main entity texture when trying to use an alternative render type for an icon!", t);
            }
            if (textureLocation != null) {
                lastRenderType = model.func_228282_a_(textureLocation);
            }
        }
        if (lastRenderType == null) {
            return;
        }
        RenderType.State renderState = this.getRenderState(lastRenderType);
        if (renderState == null) {
            return;
        }
        RenderState.TextureState renderTextureState = (RenderState.TextureState)Misc.getReflectFieldValue(renderState, this.compositeStateTextureStateField);
        ResourceLocation texture = this.getRenderStateTextureStateTexture(renderTextureState);
        RenderState.TransparencyState renderTransparencyState = (RenderState.TransparencyState)Misc.getReflectFieldValue(renderState, this.compositeStateTransparencyStateField);
        renderTransparencyState = this.fixAdditiveTransparency(renderTransparencyState);
        RenderState.DepthTestState renderDepthTestState = (RenderState.DepthTestState)Misc.getReflectFieldValue(renderState, this.compositeStateDepthTestStateField);
        RenderState.WriteMaskState renderWriteMaskState = (RenderState.WriteMaskState)Misc.getReflectFieldValue(renderState, this.compositeStateWriteMaskStateField);
        RenderState.CullState renderCullState = (RenderState.CullState)Misc.getReflectFieldValue(renderState, this.compositeStateCullStateField);
        CustomRenderTypes.EntityIconLayerPhases layerPhases = new CustomRenderTypes.EntityIconLayerPhases(renderTextureState, renderTransparencyState, renderDepthTestState, renderWriteMaskState, renderCullState);
        TextureAtlasSprite renderAtlasSprite = null;
        if (vertexConsumer instanceof SpriteAwareVertexBuilder) {
            renderAtlasSprite = (TextureAtlasSprite)Misc.getReflectFieldValue(vertexConsumer, this.spriteCoordinateExpanderSpriteField);
        }
        this.lastModelRenderDetected = new ModelRenderTrace(model, texture, renderAtlasSprite, layerPhases, red, green, blue, alpha);
        this.traceResultList.add(this.lastModelRenderDetected);
    }

    private RenderState.TransparencyState fixAdditiveTransparency(RenderState.TransparencyState renderTransparencyState) {
        int blendSrcFactor;
        RenderState.TransparencyState result = renderTransparencyState;
        renderTransparencyState.func_228547_a_();
        int blendDestFactor = GL11.glGetInteger((int)32968);
        if (blendDestFactor == 1 && (blendSrcFactor = GL11.glGetInteger((int)32969)) != 0) {
            result = CustomRenderTypes.getTransparencyPhase(blendSrcFactor, blendDestFactor, 0, 1);
        }
        renderTransparencyState.func_228549_b_();
        return result;
    }

    public void onModelPartRender(ModelRenderer modelRenderer, float red, float green, float blue, float alpha) {
        if (this.lastModelRenderDetected != null) {
            this.lastModelRenderDetected.addVisibleModelPart(modelRenderer, red, green, blue, alpha);
        }
    }

    private RenderType getLastRenderType(IRenderTypeBuffer renderTypeBuffer) {
        if (!(renderTypeBuffer instanceof IRenderTypeBuffer.Impl)) {
            return null;
        }
        Object lastRenderTypeObject = Misc.getReflectFieldValue(renderTypeBuffer, this.lastStateField);
        if (lastRenderTypeObject instanceof Optional) {
            return ((Optional)lastRenderTypeObject).orElse(null);
        }
        return (RenderType)lastRenderTypeObject;
    }

    private RenderType.State getRenderState(RenderType renderType) {
        while (renderType.getClass() == this.irisRenderLayerWrapperClass && this.irisRenderLayerWrapperUnwrapMethod != null) {
            renderType = (RenderType)Misc.getReflectMethodValue(renderType, this.irisRenderLayerWrapperUnwrapMethod, new Object[0]);
        }
        if (renderType.getClass() == this.compositeRenderTypeClass) {
            return (RenderType.State)Misc.getReflectFieldValue(renderType, this.stateField);
        }
        return null;
    }

    private ResourceLocation getRenderStateTextureStateTexture(RenderState.TextureState renderTextureState) {
        Object renderStateTextureObject = Misc.getReflectFieldValue(renderTextureState, this.textureStateShardTextureField);
        if (!(renderStateTextureObject instanceof Optional)) {
            return (ResourceLocation)renderStateTextureObject;
        }
        Optional optional = (Optional)renderStateTextureObject;
        return optional.orElse(null);
    }

    public <T extends Entity> EntityModel<T> getEntityRendererModel(EntityRenderer<? super T> entityRenderer) {
        if (entityRenderer instanceof LivingRenderer) {
            return ((LivingRenderer)entityRenderer).func_217764_d();
        }
        if (entityRenderer instanceof EnderDragonRenderer) {
            return (EntityModel)Misc.getReflectFieldValue(entityRenderer, this.enderDragonModelField);
        }
        return null;
    }

    private void initReflection() {
        this.enderDragonModelField = Misc.getFieldReflection(EnderDragonRenderer.class, "model", "field_21008", "Lnet/minecraft/class_895$class_625;", "field_229058_m_");
        try {
            this.lastStateField = Misc.getFieldReflection(IRenderTypeBuffer.Impl.class, "lastState", "field_20954", "Ljava/util/Optional;", "field_228459_c_");
        }
        catch (Exception e) {
            this.lastStateField = Misc.getFieldReflection(IRenderTypeBuffer.Impl.class, "lastState", "c", "Ljava/util/Optional;", "field_228459_c_");
        }
        try {
            this.compositeRenderTypeClass = Misc.getClassForName("net.minecraft.class_1921$class_4687", "net.minecraft.client.renderer.RenderType$Type");
            this.stateField = Misc.getFieldReflection(this.compositeRenderTypeClass, "state", "field_21403", "Lnet/minecraft/class_1921$class_4688;", "field_228668_S_");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        this.compositeStateTextureStateField = Misc.getFieldReflection(RenderType.State.class, "textureState", "field_21406", "Lnet/minecraft/class_4668$class_4683;", "field_228677_a_");
        this.textureStateShardTextureField = Misc.getFieldReflection(RenderState.TextureState.class, "texture", "field_21397", "Ljava/util/Optional;", "field_228602_Q_");
        this.compositeStateTransparencyStateField = Misc.getFieldReflection(RenderType.State.class, "transparencyState", "field_21407", "Lnet/minecraft/class_4668$class_4685;", "field_228678_b_");
        this.compositeStateDepthTestStateField = Misc.getFieldReflection(RenderType.State.class, "depthTestState", "field_21411", "Lnet/minecraft/class_4668$class_4672;", "field_228682_f_");
        this.compositeStateWriteMaskStateField = Misc.getFieldReflection(RenderType.State.class, "writeMaskState", "field_21419", "Lnet/minecraft/class_4668$class_4686;", "field_228690_n_");
        this.compositeStateCullStateField = Misc.getFieldReflection(RenderType.State.class, "cullState", "field_21412", "Lnet/minecraft/class_4668$class_4671;", "field_228683_g_");
        this.renderBuffersBufferSourceField = Misc.getFieldReflection(RenderTypeBuffers.class, "bufferSource", "field_20958", "Lnet/minecraft/class_4597$class_4598;", "field_228481_c_");
        this.spriteCoordinateExpanderSpriteField = Misc.getFieldReflection(SpriteAwareVertexBuilder.class, "sprite", "field_21731", "Lnet/minecraft/class_1058;", "field_228788_b_");
        try {
            try {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderTypeWrapper");
            }
            catch (ClassNotFoundException e) {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderLayerWrapper");
            }
            this.irisRenderLayerWrapperUnwrapMethod = Misc.getMethodReflection(this.irisRenderLayerWrapperClass, "unwrap", "unwrap", "()Lnet/minecraft/class_1921;", "unwrap", new Class[0]);
            MinimapLogs.LOGGER.info("Old Iris detected and supported!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

