/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.preset;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import xaero.hud.preset.ModulePreset;

public final class HudPreset {
    private final ResourceLocation id;
    private final ITextComponent name;
    private final Set<ModulePreset<?>> modulePresets;
    private boolean applied;

    private HudPreset(ResourceLocation id, ITextComponent name, Set<ModulePreset<?>> modulePresets) {
        this.id = id;
        this.name = name;
        this.modulePresets = modulePresets;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ITextComponent getName() {
        return this.name;
    }

    public void apply() {
        this.applied = true;
        for (ModulePreset<?> modulePreset : this.modulePresets) {
            modulePreset.apply();
        }
    }

    public void confirm() {
        if (!this.applied) {
            return;
        }
        this.applied = false;
        for (ModulePreset<?> modulePreset : this.modulePresets) {
            modulePreset.confirm();
        }
    }

    public void cancel() {
        if (!this.applied) {
            return;
        }
        this.applied = false;
        for (ModulePreset<?> modulePreset : this.modulePresets) {
            modulePreset.cancel();
        }
    }

    public void applyAndConfirm() {
        this.apply();
        this.confirm();
        for (ModulePreset<?> modulePreset : this.modulePresets) {
            modulePreset.getModule().confirmTransform();
        }
    }

    public static final class Builder {
        private ResourceLocation id;
        private ITextComponent name;
        private final Set<ModulePreset<?>> modulePresets = new HashSet();

        private Builder() {
        }

        public Builder setDefault() {
            this.modulePresets.clear();
            return this;
        }

        public Builder setId(ResourceLocation id) {
            this.id = id;
            return this;
        }

        public Builder setName(ITextComponent name) {
            this.name = name;
            return this;
        }

        public Builder addModulePreset(ModulePreset<?> modulePreset) {
            this.modulePresets.add(modulePreset);
            return this;
        }

        public HudPreset build() {
            if (this.id == null || this.name == null) {
                throw new IllegalStateException();
            }
            return new HudPreset(this.id, this.name, this.modulePresets);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

