/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.entityinfo;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xaero.common.misc.Misc;
import xaero.hud.pvp.module.entityinfo.EntityInfoSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;
import xaero.pvp.BetterPVP;

public class EntityInfoRenderer
implements IModuleRenderer<EntityInfoSession> {
    private final Random random = new Random();

    @Override
    public void render(EntityInfoSession session, ModuleRenderContext c, MatrixStack matrixStack, float partialTicks) {
        LivingEntity displayedEntity;
        Minecraft mc = Minecraft.func_71410_x();
        long time = System.currentTimeMillis();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        EntityRayTraceResult objectMouseOver = session.getDetector().getMouseOver(mc, (World)mc.field_71441_e, session.getEntityInfoDistance(), partialTicks);
        if (objectMouseOver != null && objectMouseOver.func_216348_a() instanceof LivingEntity) {
            ServerWorld serverWorld;
            session.setDisplayedEntity((LivingEntity)objectMouseOver.func_216348_a());
            if (mc.func_71401_C() != null && (serverWorld = mc.func_71401_C().func_71218_a(mc.field_71441_e.func_234923_W_())) != null) {
                session.setDisplayedServerEntity((LivingEntity)serverWorld.func_217461_a(objectMouseOver.func_216348_a().func_110124_au()));
            }
            session.setLastDetection(time);
        }
        if ((displayedEntity = session.getDisplayedEntity()) == null) {
            return;
        }
        if (time - session.getLastDetection() > 1000L * (long)session.getEntityInfoStay()) {
            return;
        }
        if (System.currentTimeMillis() - session.getLastEffectBlink() > 500L) {
            session.setLastEffectBlink(System.currentTimeMillis());
            session.setEffectBlink(!session.getEffectBlink());
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        try {
            int healthOff;
            boolean flippedVer = c.flippedVertically;
            boolean flippedHor = c.flippedHorizontally;
            float resize = 1.0f;
            if (displayedEntity.func_213311_cf() > resize) {
                resize = displayedEntity.func_213311_cf();
            }
            if (displayedEntity.func_213302_cg() > resize * 2.0f) {
                resize = displayedEntity.func_213302_cg() / 2.0f;
            }
            if (session.getEntityInfoShowEntityModel()) {
                RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-500.0f);
                RenderSystem.enableDepthTest();
                this.drawEntityOnScreen(mc, c.x + (flippedHor ? c.w - 25 : 25), c.y + 35, (int)(30.0f / resize), displayedEntity, flippedHor);
                RenderSystem.disableDepthTest();
                RenderSystem.translatef((float)0.0f, (float)0.0f, (float)500.0f);
            }
            LivingEntity displayedServerEntity = session.getDisplayedServerEntity();
            int n = healthOff = session.getEntityInfoShowEntityModel() ? 55 : 5;
            if (mc.func_71401_C() != null && session.getEntityInfoEffects() && displayedServerEntity != null) {
                int effectsOffset = (int)this.drawPotionEffects(mc, matrixStack, session, displayedServerEntity, c.x + (flippedHor ? c.w - 3 : 3), c.y + (flippedVer ? c.h - 5 : 5), flippedVer ? c.y + c.h : c.screenHeight - c.y, flippedHor, flippedVer, c.screenScale);
                if (!session.getEntityInfoShowEntityModel() && effectsOffset != -1) {
                    healthOff += 3 + effectsOffset;
                }
            }
            boolean renderedArmor = session.getEntityInfoShowArmour() && this.drawArmourBar(mc, matrixStack, session, displayedEntity, c.x + (flippedHor ? c.w - healthOff : healthOff), c.y + 15 + (flippedVer ? 31 : 0), flippedHor);
            this.drawHealthBar(mc, matrixStack, session, displayedEntity, c.x + (flippedHor ? c.w - healthOff : healthOff), c.y + 15 + (flippedVer ? 31 : 0) + (renderedArmor ? 10 : 0) * (flippedVer ? -1 : 1), flippedHor, flippedVer);
            ITextComponent component = Misc.getFixedDisplayName((Entity)displayedEntity);
            if (component != null) {
                String name = component.getString();
                int xCoord = c.x + (flippedHor ? c.w - healthOff - mc.field_71466_p.func_78256_a(name) : healthOff);
                AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)name, (int)xCoord, (int)(c.y + 5 + (flippedVer ? 52 : 0)), (int)0xFFFFFF);
            }
        }
        catch (Exception e) {
            BetterPVP.LOGGER.error("Please report this to Xaero96 on PlanetMinecraft/MinecraftForums/CurseForge!", (Throwable)e);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawEntityOnScreen(Minecraft mc, int x, int y, int scale, LivingEntity entity, boolean flip) {
        double cos;
        if (entity == null) {
            return;
        }
        EntityRendererManager rendermanager = mc.func_175598_ae();
        if (rendermanager.field_217783_c == null) {
            return;
        }
        float yBodyRotBU = entity.field_70761_aq;
        float yRotBU = entity.field_70177_z;
        float yHeadRotBU = entity.field_70759_as;
        entity.field_70761_aq = 0.0f;
        entity.field_70177_z = 0.0f;
        entity.field_70759_as = yHeadRotBU - yBodyRotBU;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)50.0f);
        RenderSystem.scaled((double)(-scale), (double)scale, (double)scale);
        RenderSystem.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(30.0f));
        float width = entity.func_213311_cf() * (float)scale / 30.0f;
        if (width < 1.0f) {
            width = 1.0f;
        }
        if ((cos = Math.sqrt(2.0) / 2.0 / (double)width) > 1.0) {
            cos = 1.0;
        }
        float rotation = (float)Math.toDegrees(Math.acos(cos));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(flip ? 0 : 90) - rotation));
        matrixStack.func_227861_a_(0.0, (double)(-entity.func_213302_cg() / 2.0f), 0.0);
        rendermanager.func_178633_a(false);
        boolean hideGUIBU = mc.field_71474_y.field_74319_N;
        mc.field_71474_y.field_74319_N = true;
        try {
            RenderSystem.enableRescaleNormal();
            IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            rendermanager.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0);
            irendertypebuffer$impl.func_228461_a_();
        }
        finally {
            mc.field_71474_y.field_74319_N = hideGUIBU;
            rendermanager.func_178633_a(true);
            RenderSystem.disableBlend();
            entity.field_70761_aq = yBodyRotBU;
            entity.field_70177_z = yRotBU;
            entity.field_70759_as = yHeadRotBU;
            RenderSystem.popMatrix();
        }
    }

    public boolean drawArmourBar(Minecraft mc, MatrixStack matrixStack, EntityInfoSession session, LivingEntity e, int x, int y, boolean flip) {
        int armorValue = e.func_70658_aO();
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        if (armorValue > 0) {
            if (session.getEntityInfoArmourNumbers()) {
                mc.field_71456_v.func_238474_b_(matrixStack, x - (flip ? 8 : 0), y, 34, 9, 9, 9);
                AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)(armorValue + "/20"), (int)(x + (flip ? -11 - mc.field_71466_p.func_78256_a(armorValue + "/20") : 11)), (int)y, (int)0xFFFFFF);
            } else {
                for (int iconIndex = 0; iconIndex < 10; ++iconIndex) {
                    int iconX = x + (flip ? -8 - iconIndex * 8 : iconIndex * 8);
                    if (iconIndex * 2 + 1 < armorValue) {
                        mc.field_71456_v.func_238474_b_(matrixStack, iconX, y, 34, 9, 9, 9);
                        continue;
                    }
                    if (iconIndex * 2 + 1 == armorValue) {
                        mc.field_71456_v.func_238474_b_(matrixStack, iconX, y, 25, 9, 9, 9);
                        continue;
                    }
                    if (iconIndex * 2 + 1 <= armorValue) continue;
                    mc.field_71456_v.func_238474_b_(matrixStack, iconX, y, 16, 9, 9, 9);
                }
            }
            return true;
        }
        return false;
    }

    public void drawHealthBar(Minecraft mc, MatrixStack matrixStack, EntityInfoSession session, LivingEntity e, int x, int y, boolean flip, boolean vertFlipped) {
        int health = MathHelper.func_76123_f((float)e.func_110143_aJ());
        float maxHealth = MathHelper.func_76143_f((double)e.func_233637_b_(Attributes.field_233818_a_));
        float absorptionAmount = MathHelper.func_76123_f((float)e.func_110139_bj());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (session.getEntityInfoHealthNumbers()) {
            String text = health + "/" + (int)maxHealth;
            if (absorptionAmount > 0.0f) {
                text = text + "+" + absorptionAmount;
                health = 0;
                maxHealth = 0.0f;
                absorptionAmount = 2.0f;
            } else {
                health = 2;
                maxHealth = 2.0f;
                absorptionAmount = 0.0f;
            }
            AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)text, (int)(x + (flip ? -11 - mc.field_71466_p.func_78256_a(text) : 11)), (int)y, (int)-1);
        }
        RenderSystem.enableBlend();
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        int regularHalvesToRender = (int)(maxHealth + 1.0f) / 2 * 2;
        int regularFilledHalves = health;
        int absorptionHalvesToRender = (int)(absorptionAmount + 1.0f) / 2 * 2;
        int absorptionFilledHalves = (int)absorptionAmount;
        int limit = session.getEntityInfoMaxHearts() * 2;
        if (regularHalvesToRender > limit) {
            regularHalvesToRender = limit;
            int n = regularFilledHalves = maxHealth == 0.0f ? 0 : Math.round((float)(health * regularHalvesToRender) / maxHealth);
        }
        if (absorptionHalvesToRender > limit) {
            absorptionHalvesToRender = absorptionFilledHalves = limit;
        }
        int totalHalvesToRender = regularHalvesToRender + absorptionHalvesToRender;
        int rows = MathHelper.func_76123_f((float)((float)totalHalvesToRender / 20.0f));
        int rowStep = Math.max(10 - (rows - 2), 3);
        boolean shake = maxHealth != 0.0f && (double)health <= (double)maxHealth * 0.4;
        int absorptionLeft = absorptionFilledHalves;
        for (int heartIndex = totalHalvesToRender / 2 - 1; heartIndex >= 0; --heartIndex) {
            int rowIndex = (int)Math.ceil((float)(heartIndex + 1) / 10.0f) - 1;
            int xcoord = heartIndex % 10 * 8;
            int heartX = x + (flip ? -xcoord - 9 : xcoord);
            int heartY = y + rowIndex * rowStep * (vertFlipped ? -1 : 1);
            if (shake) {
                heartY += this.random.nextInt(2);
            }
            this.blitFlippable(heartX, heartY, 25, 0, 9, 9, flip);
            if (absorptionLeft > 0) {
                if (absorptionLeft == absorptionFilledHalves && absorptionFilledHalves % 2 == 1) {
                    this.blitFlippable(heartX, heartY, 169, 0, 9, 9, flip);
                } else {
                    this.blitFlippable(heartX, heartY, 160, 0, 9, 9, flip);
                }
                absorptionLeft -= 2;
                continue;
            }
            if (heartIndex * 2 + 1 < regularFilledHalves) {
                this.blitFlippable(heartX, heartY, 52, 0, 9, 9, flip);
            }
            if (heartIndex * 2 + 1 != regularFilledHalves) continue;
            this.blitFlippable(heartX, heartY, 61, 0, 9, 9, flip);
        }
        RenderSystem.disableBlend();
    }

    public double drawPotionEffects(Minecraft mc, MatrixStack matrixStack, EntityInfoSession session, LivingEntity e, int x, int y, int h, boolean flippedHor, boolean flippedVer, double scale) {
        Collection effects = e.func_70651_bq();
        if (effects.isEmpty()) {
            return -1.0;
        }
        effects = Ordering.natural().sortedCopy((Iterable)effects);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.enableBlend();
        PotionSpriteUploader effectSprites = mc.func_213248_ap();
        double pixelSize = (double)session.getEntityInfoEffectsScale() / scale * session.getAutoUIScale() / 2.0;
        double effectSize = 25.0 * pixelSize;
        int perColumn = (int)((double)h / effectSize);
        int place = 0;
        for (EffectInstance pe : effects) {
            TextureAtlasSprite sprite;
            if (pe == null || (sprite = effectSprites.func_215288_a(pe.func_188419_a())) == null) continue;
            RenderSystem.pushMatrix();
            RenderSystem.scaled((double)pixelSize, (double)pixelSize, (double)1.0);
            int column = place / perColumn;
            int row = place % perColumn;
            RenderSystem.translatef((float)(flippedHor ? (float)(-18 - 25 * column) : (float)(25 * column)), (float)(flippedVer ? (float)(-18 - 25 * row) : (float)(25 * row)), (float)0.0f);
            if (pe.func_76459_b() <= 200 && !session.getEffectBlink()) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            }
            mc.func_110434_K().func_110577_a(sprite.func_229241_m_().func_229223_g_());
            AbstractGui.func_238470_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)0, (int)18, (int)18, (TextureAtlasSprite)sprite);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ++place;
            RenderSystem.popMatrix();
        }
        RenderSystem.popMatrix();
        int rows = (effects.size() + perColumn - 1) / perColumn;
        return effectSize * (double)rows - 7.0 * pixelSize;
    }

    public void blitFlippable(int x, int y, int textureX, int textureY, int width, int height, boolean flip) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_225582_a_((double)(x + 0), (double)(y + height), 0.0).func_225583_a_((float)(textureX + (flip ? width : 0)) * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        vertexbuffer.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_((float)(textureX + (flip ? 0 : width)) * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        vertexbuffer.func_225582_a_((double)(x + width), (double)(y + 0), 0.0).func_225583_a_((float)(textureX + (flip ? 0 : width)) * 0.00390625f, (float)(textureY + 0) * 0.00390625f).func_181675_d();
        vertexbuffer.func_225582_a_((double)(x + 0), (double)(y + 0), 0.0).func_225583_a_((float)(textureX + (flip ? width : 0)) * 0.00390625f, (float)(textureY + 0) * 0.00390625f).func_181675_d();
        tessellator.func_78381_a();
    }
}

