/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.tooltip;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.fml.client.gui.GuiUtils;
import xaero.common.gui.GuiEditMode;
import xaero.hud.pvp.module.tooltip.ItemTooltipSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class ItemTooltipRenderer
implements IModuleRenderer<ItemTooltipSession> {
    @Override
    public void render(ItemTooltipSession session, ModuleRenderContext c, MatrixStack matrixStack, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack currentStack = mc.field_71439_g.field_71071_by.func_70448_g();
        if (currentStack != session.getPreviousStack()) {
            session.setItemSwitchTime(System.currentTimeMillis());
            session.setPreviousStack(currentStack);
        }
        if (currentStack == null) {
            return;
        }
        if (currentStack.func_190926_b()) {
            return;
        }
        if (!(mc.field_71462_r instanceof GuiEditMode) && System.currentTimeMillis() - session.getItemSwitchTime() > (long)(session.getItemTooltipTime() * 1000 / 2)) {
            return;
        }
        Screen screenInstance = session.getScreenInstance();
        screenInstance.func_231158_b_(mc, 0, 0);
        int screenWidth = c.screenWidth;
        int screenHeight = c.screenHeight;
        List<ITextComponent> textLines = session.getTooltipHelper().getTooltipLines(mc, currentStack, c.screenWidth, c.screenHeight, screenInstance);
        if (textLines.size() >= session.getItemTooltipMinLines()) {
            int border = 5;
            int renderX = c.x + border;
            int renderY = c.y + border;
            int renderW = c.w - 2 * border;
            int renderH = c.h - 2 * border;
            if (session.isCentered() || c.flippedHorizontally) {
                int tooltipTextWidth = 0;
                for (ITextComponent textLine : textLines) {
                    int textLineWidth = mc.field_71466_p.func_238414_a_((ITextProperties)textLine);
                    if (textLineWidth <= tooltipTextWidth) continue;
                    tooltipTextWidth = textLineWidth;
                }
                int tooltipWidth = tooltipTextWidth + 8;
                if (session.isCentered()) {
                    renderX += (renderW - tooltipWidth) / 2;
                } else {
                    screenWidth = renderX + renderW;
                    renderX += renderW - tooltipWidth;
                }
            }
            if (c.flippedVertically) {
                int tooltipHeight = 16;
                if (textLines.size() > 1) {
                    tooltipHeight += 2 + (textLines.size() - 1) * 10;
                }
                screenHeight = renderY + renderH;
                renderY += renderH - tooltipHeight;
            }
            screenInstance.field_230708_k_ = screenWidth;
            screenInstance.field_230709_l_ = screenHeight;
            GuiUtils.preItemToolTip((ItemStack)currentStack);
            screenInstance.renderToolTip(matrixStack, Lists.transform(textLines, ITextComponent::func_241878_f), renderX - 8, renderY + 16, mc.field_71466_p);
            GuiUtils.postItemToolTip();
            RenderHelper.func_74518_a();
        }
    }
}

