/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.render.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;

public class ImmediateRenderUtil {
    public static void coloredRectangle(MatrixStack matrices, float x1, float y1, float x2, float y2, int color) {
        ImmediateRenderUtil.coloredRectangle(matrices.func_227866_c_().func_227870_a_(), x1, y1, x2, y2, color);
    }

    public static void coloredRectangle(Matrix4f matrix, float x1, float y1, float x2, float y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_227888_a_(matrix, x1, y2, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x2, y2, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x2, y1, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x1, y1, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void texturedRect(MatrixStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        ImmediateRenderUtil.texturedRectInternal(matrixStack, x, y, textureX, textureY, width, height, theight, factor);
    }

    private static void texturedRectInternal(MatrixStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float textureH, float factor) {
        float f;
        float f1 = f = 1.0f / factor;
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + height, 0.0f).func_225583_a_((float)(textureX + 0) * f, (float)(textureY + 0) * f1).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + width, y + height, 0.0f).func_225583_a_(((float)textureX + width) * f, (float)(textureY + 0) * f1).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + width, y + 0.0f, 0.0f).func_225583_a_(((float)textureX + width) * f, ((float)textureY + textureH) * f1).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + 0.0f, 0.0f).func_225583_a_((float)(textureX + 0) * f, ((float)textureY + textureH) * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawOutlineLayer(MatrixStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        ImmediateRenderUtil.texturedRectInternal(matrixStack, x, y, textureX, textureY, width, height, theight, factor);
    }
}

