/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_276;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_583;
import net.minecraft.class_897;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.icon.XaeroIcon;
import xaero.common.icon.XaeroIconAtlas;
import xaero.common.icon.XaeroIconAtlasManager;
import xaero.common.misc.Misc;
import xaero.hud.compat.mods.ImmediatelyFastHelper;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.RadarIconManager;
import xaero.hud.minimap.radar.icon.creator.render.form.IRadarIconFormPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.trace.EntityRenderTracer;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.minimap.radar.icon.definition.form.RadarIconForm;
import xaero.hud.minimap.radar.icon.definition.form.model.config.RadarIconModelConfig;
import xaero.hud.render.util.ImmediateRenderUtil;

public class RadarIconCreator {
    private static final int PREFERRED_ATLAS_WIDTH = 1024;
    public static final int ICON_WIDTH = 64;
    public static final int FAR_PLANE = 500;
    private class_4587 matrixStack = new class_4587();
    private ImprovedFramebuffer formRenderFramebuffer;
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer atlasRenderFramebuffer;
    private final EntityRenderTracer renderTracer = new EntityRenderTracer();
    private final XaeroIconAtlasManager iconAtlasManager;

    public RadarIconCreator() {
        int maxTextureSize = class_4493.method_21923((int)3379);
        int atlasTextureSize = Math.min(maxTextureSize, 1024) / 64 * 64;
        this.iconAtlasManager = new XaeroIconAtlasManager(64, atlasTextureSize, new ArrayList<XaeroIconAtlas>());
        this.initFramebuffers(atlasTextureSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends class_1297> XaeroIcon create(class_897<? super T> entityRenderer, T entity, class_276 defaultFramebuffer, Parameters parameters) {
        IRadarIconFormPrerenderer formPrerenderer = parameters.form.getPrerenderer();
        if (formPrerenderer == null) {
            MinimapLogs.LOGGER.error("Tried prerendering radar icon for {} variant {} but the icon form used doesn't have a prerenderer!", (Object)class_1299.method_5890((class_1299)entity.method_5864()), parameters.variant);
            return RadarIconManager.FAILED;
        }
        OpenGLException.checkGLError();
        class_4587 matrixStack = this.matrixStack;
        class_310.method_1551().method_22940().method_23000().method_22993();
        ImmediatelyFastHelper.triggerBatchingBuffersFlush(matrixStack);
        this.formRenderFramebuffer.bindAsMainTarget(true);
        this.setupMatrices(64, 500);
        OpenGLException.checkGLError();
        List<ModelRenderTrace> traceResult = null;
        class_583<? super T> entityModel = null;
        if (formPrerenderer.requiresEntityModel()) {
            class_4493.method_22076();
            if (class_310.method_1551().method_1561().field_4686 != null) {
                traceResult = this.renderTracer.trace(matrixStack, entity, entityRenderer);
                this.formRenderFramebuffer.bindAsMainTarget(true);
            } else {
                MinimapLogs.LOGGER.info("Render info was null for entity " + entity.method_5820());
            }
            entityModel = this.renderTracer.getEntityRendererModel(entityRenderer);
            if (entityModel == null) {
                this.endFormRendering();
                this.bindDefaultFramebuffer(defaultFramebuffer);
                this.restoreMatrices(defaultFramebuffer);
                return RadarIconManager.FAILED;
            }
        }
        boolean formRenderResult = false;
        class_4587.class_4665 matrixEntryToRestore = matrixStack.method_23760();
        matrixStack.method_22903();
        try {
            class_4493.method_22012();
            class_4493.method_21943((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            class_4493.method_21965((int)16640, (boolean)class_310.field_1703);
            class_4493.method_22050();
            formRenderResult = formPrerenderer.prerender(matrixStack, entityRenderer, entityModel, entity, traceResult, parameters);
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("Exception using the radar icon form prerenderer for entity {} variant {}!", (Object)class_1299.method_5890((class_1299)entity.method_5864()), parameters.variant, (Object)t);
        }
        finally {
            class_310.method_1551().method_22940().method_23000().method_22993();
            while (matrixStack.method_23760() != matrixEntryToRestore) {
                matrixStack.method_22909();
            }
        }
        this.endFormRendering();
        XaeroIcon icon = parameters.form.getFailureResult();
        if (formRenderResult) {
            icon = this.getFinalIcon(matrixStack, entity, formPrerenderer, parameters);
        }
        this.restoreMatrices(defaultFramebuffer);
        this.atlasRenderFramebuffer.method_1240();
        this.bindDefaultFramebuffer(defaultFramebuffer);
        return icon;
    }

    private XaeroIcon getFinalIcon(class_4587 matrixStack, class_1297 entity, IRadarIconFormPrerenderer formPrerenderer, Parameters parameters) {
        this.iconRenderFramebuffer.bindAsMainTarget(true);
        class_4493.method_21943((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        class_4493.method_21965((int)16384, (boolean)class_310.field_1703);
        class_4493.method_22053();
        if (parameters.debug) {
            matrixStack.method_22903();
            matrixStack.method_22904(18.0, 10.0, -10.0);
            matrixStack.method_22905(1.0f, 1.0f, 1.0f);
            ImmediateRenderUtil.coloredRectangle(matrixStack, 0.0f, 0.0f, 9.0f, 9.0f, -16776961);
            matrixStack.method_22909();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        }
        this.formRenderFramebuffer.method_1241();
        boolean outlined = formPrerenderer.isOutlined();
        boolean flipped = formPrerenderer.isFlipped();
        if (outlined) {
            this.renderOutline(matrixStack);
        }
        class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4493.method_22053();
        ImmediateRenderUtil.texturedRect(matrixStack, 0.0f, 0.0f, 0, 0, 64.0f, 64.0f, 64.0f, 64.0f);
        RenderSystem.defaultAlphaFunc();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        if (parameters.debug) {
            matrixStack.method_22903();
            matrixStack.method_22904(27.0, 10.0, -10.0);
            matrixStack.method_22905(1.0f, 1.0f, 1.0f);
            ImmediateRenderUtil.coloredRectangle(matrixStack, 0.0f, 0.0f, 9.0f, 9.0f, -16711681);
            matrixStack.method_22909();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        }
        class_4493.method_22056();
        this.iconRenderFramebuffer.method_1240();
        this.iconRenderFramebuffer.method_1241();
        this.iconRenderFramebuffer.generateMipmaps();
        class_4493.method_22081((int)0);
        XaeroIcon icon = null;
        try {
            XaeroIconAtlas atlas = this.getCurrentAtlas();
            icon = atlas.createIcon();
            this.atlasRenderFramebuffer.bindAsMainTarget(false);
            class_4493.method_22025((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)64, (int)64);
            this.atlasRenderFramebuffer.setFramebufferTexture(atlas.getTextureId());
            this.atlasRenderFramebuffer.method_1239();
            this.iconRenderFramebuffer.method_1241();
            class_4493.method_22012();
            class_4493.method_22053();
            if (flipped) {
                ImmediateRenderUtil.texturedRect(matrixStack, 0.0f, 0.0f, 0, 64, 64.0f, 64.0f, -64.0f, 64.0f);
            } else {
                ImmediateRenderUtil.texturedRect(matrixStack, 0.0f, 0.0f, 0, 0, 64.0f, 64.0f, 64.0f, 64.0f);
            }
            if (parameters.debug) {
                matrixStack.method_22903();
                matrixStack.method_22904(36.0, 10.0, -10.0);
                matrixStack.method_22905(1.0f, 1.0f, 1.0f);
                ImmediateRenderUtil.coloredRectangle(matrixStack, 0.0f, 0.0f, 9.0f, 9.0f, -256);
                matrixStack.method_22909();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("Exception rendering to a entity icon atlas for {} {}!", (Object)class_1299.method_5890((class_1299)entity.method_5864()), parameters.variant, (Object)t);
        }
        class_4493.method_22021();
        class_4493.method_22056();
        class_4493.method_22081((int)0);
        return icon;
    }

    private void renderOutline(class_4587 matrixStack) {
        class_4493.method_22000((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        class_4493.method_22021();
        class_4493.method_21945((int)516, (float)0.05f);
        class_4493.method_22056();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)1);
        for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
            for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                ImmediateRenderUtil.drawOutlineLayer(matrixStack, shadowOffsetX, shadowOffsetY, 0, 0, 64.0f, 64.0f, 64.0f, 64.0f);
            }
        }
    }

    private void setupMatrices(int finalIconSize, int farPlane) {
        class_4493.method_21907((int)5889);
        class_4493.method_21924();
        class_4493.method_21939((double)0.0, (double)finalIconSize, (double)finalIconSize, (double)0.0, (double)-1.0, (double)farPlane);
        class_4493.method_21907((int)5888);
        class_4493.method_21926();
        class_4493.method_21924();
    }

    private void restoreMatrices(class_276 framebuffer) {
        class_4493.method_21928();
        class_4493.method_21907((int)5889);
        Misc.defaultOrtho(framebuffer, false);
        class_4493.method_21907((int)5888);
    }

    private void endFormRendering() {
        this.formRenderFramebuffer.method_1240();
        class_4493.method_22056();
        class_308.method_24211();
        class_308.method_1450();
        class_4493.method_22021();
        class_4493.method_21945((int)516, (float)0.0f);
    }

    private void bindDefaultFramebuffer(class_276 defaultFramebuffer) {
        if (defaultFramebuffer != null) {
            if (defaultFramebuffer instanceof ImprovedFramebuffer) {
                ((ImprovedFramebuffer)defaultFramebuffer).bindAsMainTarget(true);
                return;
            }
            ImprovedFramebuffer.restoreMainRenderTarget();
            defaultFramebuffer.method_1235(true);
            return;
        }
        ImprovedFramebuffer.bindDefaultFramebuffer(this.atlasRenderFramebuffer.getType(), 36160, class_310.method_1551());
        class_4493.method_22025((int)0, (int)0, (int)class_310.method_1551().method_22683().method_4489(), (int)class_310.method_1551().method_22683().method_4506());
    }

    public void clearAtlases() {
        this.iconAtlasManager.clearAtlases();
        this.atlasRenderFramebuffer.setFramebufferTexture(0);
    }

    public EntityRenderTracer getRenderTracer() {
        return this.renderTracer;
    }

    private XaeroIconAtlas getCurrentAtlas() {
        return this.iconAtlasManager.getCurrentAtlas();
    }

    private void initFramebuffers(int atlasTextureSize) {
        this.formRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
        OpenGLException.checkGLError();
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, false);
        OpenGLException.checkGLError();
        this.formRenderFramebuffer.method_1241();
        OpenGLException.checkGLError();
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        class_4493.method_21954((int)3553, (int)0, (int)32856, (int)this.formRenderFramebuffer.field_1480, (int)this.formRenderFramebuffer.field_1477, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        class_4493.method_22081((int)0);
        this.iconRenderFramebuffer.method_1241();
        GL11.glTexParameteri((int)3553, (int)33085, (int)3);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        if (!GL.getCapabilities().OpenGL30) {
            GL11.glTexParameteri((int)3553, (int)33169, (int)1);
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        class_4493.method_21954((int)3553, (int)0, (int)32856, (int)this.iconRenderFramebuffer.field_1480, (int)this.iconRenderFramebuffer.field_1477, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        class_4493.method_22081((int)0);
        this.atlasRenderFramebuffer = new ImprovedFramebuffer(atlasTextureSize, atlasTextureSize, false);
        OpenGLException.checkGLError();
        class_4493.method_22079((int)this.atlasRenderFramebuffer.getFramebufferTexture());
        this.atlasRenderFramebuffer.setFramebufferTexture(0);
        OpenGLException.checkGLError();
    }

    public static class Parameters {
        public final Object variant;
        public final float scale;
        public final RadarIconModelConfig defaultModelConfig;
        public final RadarIconForm form;
        public final boolean debug;

        public Parameters(Object variant, RadarIconModelConfig defaultModelConfig, RadarIconForm form, float scale, boolean debug) {
            this.variant = variant;
            this.scale = scale;
            this.defaultModelConfig = defaultModelConfig;
            this.form = form;
            this.debug = debug;
        }
    }
}

