/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import net.minecraft.client.gui.GuiButton;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.ISettingEntry;
import xaero.common.gui.ModOptionButton;
import xaero.common.gui.ModOptionSlider;
import xaero.common.settings.ModOptions;

public class ConfigSettingEntry
implements ISettingEntry {
    private ModOptions option;

    public ConfigSettingEntry(ModOptions option) {
        this.option = option;
    }

    @Override
    public GuiButton createWidget(int x, int y, int w, IXaeroMinimap modMain, int width, boolean canEditIngameSettings) {
        GuiButton widget = !this.option.getEnumFloat() ? new ModOptionButton(this.option, this.option.returnEnumOrdinal(), x, y, w, 20, modMain.getSettings().getKeyBinding(this.option)) : new ModOptionSlider(this.option, modMain, this.option.returnEnumOrdinal(), x, y, w, 20, width);
        widget.field_146124_l = !this.option.isIngameOnly() || canEditIngameSettings;
        return widget;
    }

    @Override
    public String getStringForSearch(IXaeroMinimap modMain) {
        String tooltipPart;
        CursorBox optionTooltip = this.option.getTooltip(modMain);
        String mainText = modMain.getSettings().getKeyBinding(this.option);
        if (optionTooltip != null) {
            tooltipPart = " " + optionTooltip.getPlainText();
            if (optionTooltip.getFullCode() != null) {
                tooltipPart = tooltipPart + " " + optionTooltip.getFullCode().replace("gui.xaero", "");
            }
        } else {
            tooltipPart = "";
        }
        return mainText + " " + this.option.getEnumStringRaw().replace("gui.xaero", "") + tooltipPart;
    }

    public int hashCode() {
        return this.option.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ConfigSettingEntry && ((ConfigSettingEntry)obj).option == this.option;
    }

    public boolean usesWorldMapHardValue(IXaeroMinimap modMain) {
        return modMain.getSettings().usesWorldMapHardValue(this.option);
    }
}

