/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.ResourceLocation;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.events.ClientEvents;
import xaero.common.gui.GuiSettings;
import xaero.common.gui.GuiSlimeSeed;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.info.BuiltInInfoDisplays;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModOptions;
import xaero.hud.HudSession;
import xaero.hud.category.setting.ObjectCategorySetting;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.controls.key.MinimapKeyMappings;
import xaero.hud.minimap.info.InfoDisplayIO;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.radar.category.EntityRadarBackwardsCompatibilityConfig;
import xaero.hud.minimap.radar.category.EntityRadarCategory;
import xaero.hud.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;
import xaero.hud.path.XaeroPath;
import xaero.hud.path.XaeroPathReader;

public class ModSettings {
    public static int defaultSettings;
    public static int ignoreUpdate;
    public static final String format = "\u00a7";
    protected IXaeroMinimap modMain;
    private EntityRadarBackwardsCompatibilityConfig entityRadarBackwardsCompatibilityConfig;
    private boolean foundOldRadarSettings;
    public static final String[] ENCHANT_COLORS;
    public static final String[] ENCHANT_COLOR_NAMES;
    public static final int[] COLORS;
    public static int serverSettings;
    @Deprecated
    public static KeyBinding keyBindZoom;
    @Deprecated
    public static KeyBinding keyBindZoom1;
    @Deprecated
    public static KeyBinding newWaypoint;
    @Deprecated
    public static KeyBinding keyWaypoints;
    @Deprecated
    public static KeyBinding keyLargeMap;
    @Deprecated
    public static KeyBinding keyToggleMap;
    @Deprecated
    public static KeyBinding keyToggleWaypoints;
    @Deprecated
    public static KeyBinding keyToggleMapWaypoints;
    @Deprecated
    public static KeyBinding keyToggleSlimes;
    @Deprecated
    public static KeyBinding keyToggleGrid;
    @Deprecated
    public static KeyBinding keyInstantWaypoint;
    @Deprecated
    public static KeyBinding keySwitchSet;
    @Deprecated
    public static KeyBinding keyAllSets;
    @Deprecated
    public static KeyBinding keyLightOverlay;
    @Deprecated
    public static KeyBinding keyToggleRadar;
    @Deprecated
    public static KeyBinding keyReverseEntityRadar;
    @Deprecated
    public static KeyBinding keyManualCaveMode;
    @Deprecated
    public static KeyBinding keyAlternativeListPlayers;
    @Deprecated
    public static KeyBinding keyToggleTrackedPlayersOnMap;
    @Deprecated
    public static KeyBinding keyToggleTrackedPlayersInWorld;
    @Deprecated
    public static KeyBinding keyToggleTrackedPlayers;
    public static String minimapItemId;
    public static Item minimapItem;
    public int zoom = 0;
    public float[] zooms = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
    public int caveMaps = 2;
    public int caveZoom = 1;
    private boolean showWaypoints = true;
    private boolean deathpoints = true;
    private boolean oldDeathpoints = true;
    public int chunkGrid = -1;
    public boolean slimeChunks = false;
    private static HashMap<XaeroPath, Long> serverSlimeSeeds;
    private boolean showIngameWaypoints = true;
    private boolean lockNorth = false;
    private boolean antiAliasing = true;
    private boolean displayRedstone = true;
    public boolean mapSafeMode = false;
    public int distance = 1;
    public static final String[] distanceTypes;
    private int blockColours = 0;
    public static final String[] blockColourTypes;
    private boolean lighting = true;
    public boolean compassOverEverything = true;
    private int minimapSize = 0;
    public double minimapOpacity = 100.0;
    public double waypointsIngameCloseScale = 1.0;
    private int waypointsIngameIconScale = 0;
    private int waypointsIngameDistanceScale = 0;
    private int waypointsIngameNameScale = 0;
    private static final float DEFAULT_SCALE = 0.8f;
    private static final float MINECRAFT_SCALE = 0.02666667f;
    private static final double WAYPOINT_ICON_WORLD_SCALE = 0.02133333496749401;
    private double dotNameScale = 1.0;
    public static boolean settingsButton;
    public static boolean updateNotification;
    private boolean showFlowers = true;
    public boolean keepWaypointNames = true;
    private int waypointsDistanceExp = 0;
    public double waypointsDistanceMin = 0.0;
    public String defaultWaypointTPCommandFormat = "/tp @s {x} {y} {z}";
    public String defaultWaypointTPCommandRotationFormat = "/tp @s {x} {y} {z} {yaw} ~";
    public double arrowScale = 1.5;
    public int arrowColour = 0;
    public String[] arrowColourNames = new String[]{"gui.xaero_red", "gui.xaero_green", "gui.xaero_blue", "gui.xaero_yellow", "gui.xaero_purple", "gui.xaero_white", "gui.xaero_black", "gui.xaero_legacy_color"};
    public float[][] arrowColours = new float[][]{{0.8f, 0.1f, 0.1f, 1.0f}, {0.09f, 0.57f, 0.0f, 1.0f}, {0.0f, 0.55f, 1.0f, 1.0f}, {1.0f, 0.93f, 0.0f, 1.0f}, {0.73f, 0.33f, 0.83f, 1.0f}, {1.0f, 1.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 0.0f, 1.0f}, {0.4588f, 0.0f, 0.0f, 1.0f}};
    public boolean smoothDots = true;
    public static final String[] ENTITY_ICONS_OPTIONS;
    private boolean worldMap = true;
    private boolean terrainDepth = true;
    private static final String[] SLOPES_MODES;
    private int terrainSlopes = 2;
    public int mainEntityAs = 0;
    public boolean blockTransparency = true;
    public int waypointOpacityIngame = 80;
    public int waypointOpacityMap = 90;
    public boolean allowWrongWorldTeleportation = false;
    public int hideWorldNames = 1;
    public boolean openSlimeSettings = true;
    public boolean alwaysShowDistance = false;
    public static final String[] ENTITY_NAMES_OPTIONS;
    private static final String[] SHOW_LIGHT_LEVEL_NAMES;
    public int renderLayerIndex = 1;
    public boolean differentiateByServerAddress = true;
    private boolean biomeColorsVanillaMode = false;
    public int lookingAtAngle = 10;
    public int lookingAtAngleVertical = 180;
    public boolean centeredEnlarged = false;
    public int zoomOnEnlarged = 0;
    public int minimapTextAlign = 0;
    public boolean waypointsMutualEdit = true;
    private int caveMapsDepth = 30;
    public boolean hideWaypointCoordinates = false;
    public boolean renderAllSets = false;
    public int playerArrowOpacity = 100;
    public boolean waypointsBottom;
    private static final String[] MINIMAP_SHAPES;
    public int minimapShape;
    public int lightOverlayType;
    public int lightOverlayMaxLight = 7;
    public int lightOverlayMinLight = 0;
    public int lightOverlayColor = 13;
    private static final String[] DOTS_STYLES;
    private int dotsStyle = 0;
    public boolean debugEntityIcons;
    private int uiScale = 0;
    private static final String[] PUSHBOX_OPTIONS;
    public int bossHealthPushBox = 1;
    public int potionEffectPushBox = 1;
    public static final String[] FRAME_OPTIONS;
    public int minimapFrame = 0;
    public int minimapFrameColor = 9;
    public static final String[] COMPASS_OPTIONS;
    public int compassLocation = 1;
    private int compassDirectionScale = 0;
    public int compassColor = 9;
    private int northCompassColor = -1;
    public boolean debugEntityVariantIds;
    private static final String[] MULTIPLE_WAYPOINT_INFO;
    public int displayMultipleWaypointInfo = 1;
    private boolean entityRadar = true;
    public boolean adjustHeightForCarpetLikeBlocks = true;
    public int autoConvertWaypointDistanceToKmThreshold = 10000;
    public int waypointDistancePrecision = 1;
    public int mainDotSize = 2;
    public boolean partialYTeleportation = true;
    public boolean deleteReachedDeathpoints = true;
    public boolean hideMinimapUnderScreen = true;
    public boolean hideMinimapUnderF3 = true;
    public boolean manualCaveModeStartAuto = true;
    public int manualCaveModeStart = -1;
    public int chunkGridLineWidth = 1;
    public boolean temporaryWaypointsGlobal = true;
    public boolean keepUnlockedWhenEnlarged = false;
    public boolean enlargedMinimapAToggle = false;
    public static final String[] RADAR_OVER_MAP_OPTIONS;
    public boolean displayTrackedPlayersOnMap = true;
    public boolean displayTrackedPlayersInWorld = true;
    public boolean radarHideInvisibleEntities = true;
    private boolean displayStainedGlass = true;
    public int waypointOnMapScale = 0;
    public boolean switchToAutoOnDeath = true;
    public int infoDisplayBackgroundOpacity = 40;
    public int caveModeToggleTimer = 1000;
    private boolean legibleCaveMaps;
    public boolean allowInternetAccess = true;
    public boolean dimensionScaledMaxWaypointDistance = true;
    private int trackedPlayerWorldIconScale;
    private int trackedPlayerWorldNameScale;
    private int trackedPlayerMinimapIconScale;
    private static int[] OLD_MINIMAP_SIZES;

    public ModSettings(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.entityRadarBackwardsCompatibilityConfig = new EntityRadarBackwardsCompatibilityConfig();
        int n = defaultSettings = modMain.getVersionID().endsWith("fair") ? 16188159 : Integer.MAX_VALUE;
        if (serverSettings == 0) {
            serverSettings = defaultSettings;
        }
    }

    public boolean isKeyRepeat(KeyBinding kb) {
        return kb != this.modMain.getSettingsKey() && kb != keyWaypoints && kb != newWaypoint && kb != keyLargeMap && kb != keyToggleMap && kb != keyToggleWaypoints && kb != keyToggleMapWaypoints && kb != keyToggleSlimes && kb != keyToggleGrid && kb != keyInstantWaypoint && kb != keySwitchSet && kb != keyAllSets && kb != keyLightOverlay && kb != keyBindZoom && kb != keyBindZoom1 && kb != keyToggleRadar && kb != keyReverseEntityRadar && kb != keyManualCaveMode && kb != keyToggleTrackedPlayersOnMap && kb != keyToggleTrackedPlayersInWorld;
    }

    public boolean getMinimap() {
        return BuiltInHudModules.MINIMAP.isActive() && !this.minimapDisabled() && (minimapItem == null || Minecraft.func_71410_x().field_71439_g == null || MinimapProcessor.hasMinimapItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
    }

    public boolean getCaveMaps(boolean manualCaveMode) {
        return (manualCaveMode || this.caveMaps > 0) && !this.caveMapsDisabled();
    }

    public boolean getShowWaypoints() {
        return this.showWaypoints && !this.showWaypointsDisabled();
    }

    public boolean getDeathpoints() {
        return this.deathpoints && !this.deathpointsDisabled();
    }

    public boolean getOldDeathpoints() {
        return this.oldDeathpoints;
    }

    public void setSlimeChunksSeed(long seed, XaeroPath fullWorldID) {
        serverSlimeSeeds.put(fullWorldID, seed);
    }

    public Long getSlimeChunksSeed(XaeroPath fullWorldID) {
        IntegratedServer sp = Minecraft.func_71410_x().func_71401_C();
        if (sp == null) {
            return serverSlimeSeeds.get(fullWorldID);
        }
        try {
            if (sp.func_130014_f_().field_73011_w.getDimension() != 0) {
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        long seed = sp.func_130014_f_().func_72905_C();
        return seed;
    }

    public boolean customSlimeSeedNeeded(HudSession minimapSession) {
        return !(Minecraft.func_71410_x().field_71462_r instanceof GuiSlimeSeed) && Minecraft.func_71410_x().func_71401_C() == null && minimapSession != null;
    }

    @Deprecated
    public boolean getSlimeChunks(WaypointsManager waypointsManager) {
        return this.getSlimeChunks((MinimapSession)waypointsManager);
    }

    public boolean getSlimeChunks(MinimapSession session) {
        return this.slimeChunks && (Minecraft.func_71410_x().func_71401_C() != null || this.getSlimeChunksSeed(session.getWorldState().getCurrentWorldPath()) != null);
    }

    public boolean getShowIngameWaypoints() {
        return this.showIngameWaypoints && !this.showWaypointsDisabled() && (minimapItem == null || Minecraft.func_71410_x().field_71439_g == null || MinimapProcessor.hasMinimapItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
    }

    @Deprecated
    public boolean waypointsGUI(WaypointsManager waypointsManager) {
        return this.waypointsGUI((MinimapSession)waypointsManager);
    }

    public boolean waypointsGUI(MinimapSession waypointSession) {
        return Minecraft.func_71410_x().field_71439_g != null && waypointSession.getWorldState().getAutoWorldPath() != null && (minimapItem == null || Minecraft.func_71410_x().field_71439_g == null || MinimapProcessor.hasMinimapItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
    }

    public boolean getLockNorth(int mapSize, int shape) {
        if (mapSize > 180 && shape == 0) {
            return true;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession == null) {
            return this.lockNorth;
        }
        return this.lockNorth || !this.keepUnlockedWhenEnlarged && minimapSession.getMinimapProcessor().isEnlargedMap();
    }

    public boolean getAntiAliasing() {
        return this.antiAliasing && this.assumeUsingFBO();
    }

    public boolean getDisplayRedstone() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.displayRedstone;
        }
        return this.displayRedstone;
    }

    public int getBlockColours() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapColours();
        }
        return this.blockColours;
    }

    private boolean separateLighting() {
        return !this.modMain.getSupportMods().shouldUseWorldMapChunks() || this.modMain.getSupportMods().worldmapSupport.compatibilityVersion >= 4;
    }

    public boolean getLighting() {
        if (this.separateLighting()) {
            return this.lighting;
        }
        return this.modMain.getSupportMods().worldmapSupport.getWorldMapLighting();
    }

    public int getMinimapSize(double scale) {
        if (this.minimapSize > 0) {
            return this.minimapSize;
        }
        int height = Minecraft.func_71410_x().field_71440_d;
        int width = Minecraft.func_71410_x().field_71443_c;
        int size = (int)((float)(height <= width ? height : width) / this.getMinimapScale(scale));
        return Math.min(Math.max((int)(ModOptions.SIZE.getValueMin() + ModOptions.SIZE.getValueStep()), 2 * size * 130 / 1080), (int)ModOptions.SIZE.getValueMax());
    }

    public float getMinimapScale(double scale) {
        return this.getUIScale(this.uiScale, 1, 11, scale);
    }

    public float getUIScale(int optionValue, int min, int max, double scale) {
        if (optionValue <= min) {
            return this.getAutoUIScale();
        }
        if (optionValue == max) {
            return (float)scale;
        }
        return optionValue;
    }

    public int getAutoUIScale() {
        int size;
        int height = Minecraft.func_71410_x().field_71440_d;
        int width = Minecraft.func_71410_x().field_71443_c;
        int n = size = height <= width ? height : width;
        if (size >= 1500) {
            int steps = size / 500;
            return steps;
        }
        return 2;
    }

    public float getWaypointsIngameIconScale(double scale) {
        return this.getUIScale(this.waypointsIngameIconScale, 0, 17, scale);
    }

    public float getWaypointsIngameDistanceScale(double scale) {
        return this.getUIScale(this.waypointsIngameDistanceScale, 0, 17, scale);
    }

    public int getWaypointsIngameNameScale(double scale) {
        int resultScale = (int)this.getUIScale(this.waypointsIngameNameScale, 0, 17, scale);
        if (this.waypointsIngameNameScale <= 0) {
            return (int)Math.ceil(resultScale / 2);
        }
        return resultScale;
    }

    public float getTrackedPlayerWorldIconScale(double scale) {
        return this.getUIScale(this.trackedPlayerWorldIconScale, 0, 17, scale);
    }

    public float getTrackedPlayerWorldNameScale(double scale) {
        return this.getUIScale(this.trackedPlayerWorldNameScale, 0, 17, scale);
    }

    public float getTrackedPlayerMinimapIconScale(double scale) {
        return this.getUIScale(this.trackedPlayerMinimapIconScale, 0, 17, scale);
    }

    public double getWaypointsClampDepth(double fov, int height, double scale) {
        int baseIconScale = (int)this.getWaypointsIngameIconScale(scale);
        double frameSizeAtClampDepth = this.waypointsIngameCloseScale * 0.02133333496749401 * (double)height / (double)baseIconScale;
        double fovMultiplier = 2.0 * Math.tan(Math.toRadians(fov / 2.0));
        return frameSizeAtClampDepth / fovMultiplier;
    }

    public double getDotNameScale() {
        return this.dotNameScale * (Minecraft.func_71410_x().func_152349_b() ? 2.0 : 1.0);
    }

    public boolean getShowFlowers() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapFlowers();
        }
        return this.showFlowers;
    }

    public double getMaxWaypointsDistance() {
        if (this.waypointsDistanceExp <= 0) {
            return 0.0;
        }
        return Math.pow(2.0, 2 + this.waypointsDistanceExp);
    }

    public boolean getSmoothDots() {
        return this.smoothDots && this.assumeUsingFBO();
    }

    public boolean getUseWorldMap() {
        return this.worldMap && this.assumeUsingFBO();
    }

    private boolean assumeUsingFBO() {
        return !this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isTriedFBO() && !this.mapSafeMode || this.modMain.getInterfaces().getMinimapInterface().usingFBO();
    }

    public boolean getTerrainDepth() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapTerrainDepth();
        }
        return this.terrainDepth;
    }

    public int getTerrainSlopes() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapTerrainSlopes();
        }
        return this.terrainSlopes;
    }

    public boolean getBiomeColorsVanillaMode() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapBiomeColorsVanillaMode();
        }
        return this.biomeColorsVanillaMode;
    }

    public int getCaveMapsDepth() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks() && this.modMain.getSupportMods().worldmapSupport.hasCaveLayers()) {
            return this.modMain.getSupportMods().worldmapSupport.getCaveModeDepth();
        }
        return this.caveMapsDepth;
    }

    public int getCompassScale() {
        return this.compassDirectionScale;
    }

    public int getNorthCompassColor() {
        if (this.northCompassColor < 0) {
            return this.compassColor;
        }
        return this.northCompassColor;
    }

    public boolean getPartialYTeleportation() {
        if (!this.modMain.getSupportMods().worldmap() || !this.modMain.getSupportMods().worldmapSupport.usesPartialYFromWorldMap()) {
            return this.partialYTeleportation;
        }
        return this.modMain.getSupportMods().worldmapSupport.getPartialYTeleport();
    }

    public boolean isLegibleCaveMaps() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks() && this.modMain.getSupportMods().worldmapSupport.hasCaveLayers()) {
            return this.modMain.getSupportMods().worldmapSupport.isLegibleCaveMaps();
        }
        return this.legibleCaveMaps;
    }

    public boolean isStainedGlassDisplayed() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.isStainedGlassDisplayed();
        }
        return this.displayStainedGlass;
    }

    public boolean getAdjustHeightForCarpetLikeBlocks() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getAdjustHeightForCarpetLikeBlocks();
        }
        return this.adjustHeightForCarpetLikeBlocks;
    }

    public boolean getEntityRadar() {
        return this.entityRadar && !this.modMain.isFairPlay() && (Minecraft.func_71410_x().field_71441_e == null || MinimapClientWorldDataHelper.getCurrentWorldData().getSyncedRules().allowRadarOnServer);
    }

    public int getDotsStyle() {
        if (this.assumeUsingFBO()) {
            return this.dotsStyle;
        }
        return 1;
    }

    public boolean isIgnoreHeightmaps() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapIgnoreHeightmaps();
        }
        MinimapWorldRootContainer currentRootContainer = BuiltInHudModules.MINIMAP.getCurrentSession().getWorldManager().getAutoRootContainer();
        return currentRootContainer.getConfig().isIgnoreHeightmaps();
    }

    @Deprecated
    public void saveAllWaypoints(WaypointsManager waypointsManager) throws IOException {
        waypointsManager.getWorldManagerIO().saveAllWorlds(waypointsManager);
    }

    @Deprecated
    public void saveWaypoints(WaypointWorld wpw) throws IOException {
        this.saveWaypoints(wpw, true);
    }

    @Deprecated
    public void saveWaypoints(WaypointWorld wpw, boolean overwrite) throws IOException {
        wpw.getContainer().getSession().getWorldManagerIO().saveWorld(wpw, overwrite);
    }

    public void writeSettings(PrintWriter writer) {
        writer.println("#CONFIG ONLY OPTIONS");
        writer.println("ignoreUpdate:" + ignoreUpdate);
        writer.println("settingsButton:" + settingsButton);
        if (minimapItemId != null) {
            writer.println("minimapItemId:" + minimapItemId);
        }
        writer.println("allowWrongWorldTeleportation:" + this.allowWrongWorldTeleportation);
        writer.println("differentiateByServerAddress:" + this.differentiateByServerAddress);
        writer.println("debugEntityIcons:" + this.debugEntityIcons);
        writer.println("debugEntityVariantIds:" + this.debugEntityVariantIds);
        writer.println("radarHideInvisibleEntities:" + this.radarHideInvisibleEntities);
        writer.println("allowInternetAccess:" + this.allowInternetAccess);
        writer.println("#INGAME SETTINGS (DO NOT EDIT!)");
        writer.println("updateNotification:" + updateNotification);
        writer.println("minimap:" + BuiltInHudModules.MINIMAP.isActive());
        writer.println("caveMaps:" + this.caveMaps);
        writer.println("caveZoom:" + this.caveZoom);
        writer.println("showWaypoints:" + this.showWaypoints);
        writer.println("showIngameWaypoints:" + this.showIngameWaypoints);
        writer.println("displayRedstone:" + this.displayRedstone);
        writer.println("deathpoints:" + this.deathpoints);
        writer.println("oldDeathpoints:" + this.oldDeathpoints);
        writer.println("distance:" + this.distance);
        writer.println("lockNorth:" + this.lockNorth);
        writer.println("zoom:" + this.zoom);
        writer.println("minimapSize:" + this.minimapSize);
        writer.println("chunkGrid:" + this.chunkGrid);
        writer.println("slimeChunks:" + this.slimeChunks);
        writer.println("mapSafeMode:" + this.mapSafeMode);
        writer.println("minimapOpacity:" + this.minimapOpacity);
        writer.println("waypointsIngameIconScale:" + this.waypointsIngameIconScale);
        writer.println("waypointsIngameDistanceScale:" + this.waypointsIngameDistanceScale);
        writer.println("waypointsIngameNameScale:" + this.waypointsIngameNameScale);
        writer.println("waypointsIngameCloseScale:" + this.waypointsIngameCloseScale);
        writer.println("antiAliasing:" + this.antiAliasing);
        writer.println("blockColours:" + this.blockColours);
        writer.println("lighting:" + this.lighting);
        writer.println("dotsStyle:" + this.dotsStyle);
        writer.println("dotNameScale:" + this.dotNameScale);
        writer.println("compassOverEverything:" + this.compassOverEverything);
        writer.println("showFlowers:" + this.showFlowers);
        writer.println("keepWaypointNames:" + this.keepWaypointNames);
        writer.println("waypointsDistanceExp:" + this.waypointsDistanceExp);
        writer.println("waypointsDistanceMin:" + this.waypointsDistanceMin);
        writer.println("defaultWaypointTPCommandFormat:" + this.defaultWaypointTPCommandFormat.replace(":", "^col^"));
        writer.println("defaultWaypointTPCommandRotationFormat:" + this.defaultWaypointTPCommandRotationFormat.replace(":", "^col^"));
        writer.println("arrowScale:" + this.arrowScale);
        writer.println("arrowColour:" + this.arrowColour);
        writer.println("smoothDots:" + this.smoothDots);
        writer.println("worldMap:" + this.worldMap);
        writer.println("terrainDepth:" + this.terrainDepth);
        writer.println("terrainSlopes:" + this.terrainSlopes);
        writer.println("mainEntityAs:" + this.mainEntityAs);
        writer.println("blockTransparency:" + this.blockTransparency);
        writer.println("waypointOpacityIngame:" + this.waypointOpacityIngame);
        writer.println("waypointOpacityMap:" + this.waypointOpacityMap);
        writer.println("hideWorldNames:" + this.hideWorldNames);
        writer.println("openSlimeSettings:" + this.openSlimeSettings);
        writer.println("alwaysShowDistance:" + this.alwaysShowDistance);
        writer.println("renderLayerIndex:" + this.renderLayerIndex);
        writer.println("biomeColorsVanillaMode:" + this.biomeColorsVanillaMode);
        writer.println("lookingAtAngle:" + this.lookingAtAngle);
        writer.println("lookingAtAngleVertical:" + this.lookingAtAngleVertical);
        writer.println("centeredEnlarged:" + this.centeredEnlarged);
        writer.println("zoomOnEnlarged:" + this.zoomOnEnlarged);
        writer.println("minimapTextAlign:" + this.minimapTextAlign);
        writer.println("waypointsMutualEdit:" + this.waypointsMutualEdit);
        writer.println("compassLocation:" + this.compassLocation);
        writer.println("compassDirectionScale:" + this.compassDirectionScale);
        writer.println("caveMapsDepth:" + this.caveMapsDepth);
        writer.println("hideWaypointCoordinates:" + this.hideWaypointCoordinates);
        writer.println("renderAllSets:" + this.renderAllSets);
        writer.println("playerArrowOpacity:" + this.playerArrowOpacity);
        writer.println("waypointsBottom:" + this.waypointsBottom);
        writer.println("minimapShape:" + this.minimapShape);
        writer.println("lightOverlayType:" + this.lightOverlayType);
        writer.println("lightOverlayMaxLight:" + this.lightOverlayMaxLight);
        writer.println("lightOverlayMinLight:" + this.lightOverlayMinLight);
        writer.println("lightOverlayColor:" + this.lightOverlayColor);
        writer.println("uiScale:" + this.uiScale);
        writer.println("bossHealthPushBox:" + this.bossHealthPushBox);
        writer.println("potionEffectPushBox:" + this.potionEffectPushBox);
        writer.println("minimapFrame:" + this.minimapFrame);
        writer.println("minimapFrameColor:" + this.minimapFrameColor);
        writer.println("compassColor:" + this.compassColor);
        writer.println("northCompassColor:" + this.northCompassColor);
        writer.println("displayMultipleWaypointInfo:" + this.displayMultipleWaypointInfo);
        writer.println("entityRadar:" + this.entityRadar);
        writer.println("adjustHeightForCarpetLikeBlocks:" + this.adjustHeightForCarpetLikeBlocks);
        writer.println("autoConvertWaypointDistanceToKmThreshold:" + this.autoConvertWaypointDistanceToKmThreshold);
        writer.println("waypointDistancePrecision:" + this.waypointDistancePrecision);
        writer.println("mainDotSize:" + this.mainDotSize);
        writer.println("partialYTeleportation:" + this.partialYTeleportation);
        writer.println("deleteReachedDeathpoints:" + this.deleteReachedDeathpoints);
        writer.println("hideMinimapUnderScreen:" + this.hideMinimapUnderScreen);
        writer.println("hideMinimapUnderF3:" + this.hideMinimapUnderF3);
        writer.println("manualCaveModeStartAuto:" + this.manualCaveModeStartAuto);
        writer.println("manualCaveModeStart:" + this.manualCaveModeStart);
        writer.println("chunkGridLineWidth:" + this.chunkGridLineWidth);
        writer.println("temporaryWaypointsGlobal:" + this.temporaryWaypointsGlobal);
        writer.println("keepUnlockedWhenEnlarged:" + this.keepUnlockedWhenEnlarged);
        writer.println("enlargedMinimapAToggle:" + this.enlargedMinimapAToggle);
        writer.println("displayStainedGlass:" + this.displayStainedGlass);
        writer.println("waypointOnMapScale:" + this.waypointOnMapScale);
        writer.println("switchToAutoOnDeath:" + this.switchToAutoOnDeath);
        writer.println("infoDisplayBackgroundOpacity:" + this.infoDisplayBackgroundOpacity);
        writer.println("caveModeToggleTimer:" + this.caveModeToggleTimer);
        writer.println("legibleCaveMaps:" + this.legibleCaveMaps);
        writer.println("displayTrackedPlayersOnMap:" + this.displayTrackedPlayersOnMap);
        writer.println("displayTrackedPlayersInWorld:" + this.displayTrackedPlayersInWorld);
        writer.println("dimensionScaledMaxWaypointDistance:" + this.dimensionScaledMaxWaypointDistance);
        writer.println("trackedPlayerWorldIconScale:" + this.trackedPlayerWorldIconScale);
        writer.println("trackedPlayerWorldNameScale:" + this.trackedPlayerWorldNameScale);
        writer.println("trackedPlayerMinimapIconScale:" + this.trackedPlayerMinimapIconScale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettings() throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new FileWriter(this.modMain.getConfigFile().toFile()));
            this.writeSettings(writer);
            this.modMain.getMinimap().getInfoDisplays().getIo().save(writer);
            Object[] keys = serverSlimeSeeds.keySet().toArray();
            Object[] values = serverSlimeSeeds.values().toArray();
            for (int i = 0; i < keys.length; ++i) {
                writer.println("seed:" + keys[i] + ":" + values[i]);
            }
            this.modMain.getHudIO().save(writer);
        }
    }

    public void readSetting(String[] args) {
        String valueString;
        String string = valueString = args.length < 2 ? "" : args[1];
        if (args[0].equalsIgnoreCase("ignoreUpdate")) {
            ignoreUpdate = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("updateNotification")) {
            updateNotification = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("settingsButton")) {
            settingsButton = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("minimapItemId")) {
            minimapItemId = valueString + ":" + args[2];
            minimapItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(valueString, args[2]));
        } else if (args[0].equalsIgnoreCase("allowWrongWorldTeleportation")) {
            this.allowWrongWorldTeleportation = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("differentiateByServerAddress")) {
            this.differentiateByServerAddress = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("debugEntityIcons")) {
            this.debugEntityIcons = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("debugEntityVariantIds")) {
            this.debugEntityVariantIds = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("radarHideInvisibleEntities")) {
            this.radarHideInvisibleEntities = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("allowInternetAccess")) {
            this.allowInternetAccess = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("minimap")) {
            BuiltInHudModules.MINIMAP.setActive(valueString.equals("true"));
        } else if (args[0].equalsIgnoreCase("caveMaps")) {
            this.caveMaps = valueString.equals("true") ? 1 : (valueString.equals("false") ? 0 : Integer.parseInt(valueString));
        } else if (args[0].equalsIgnoreCase("caveZoom")) {
            this.caveZoom = valueString.equals("true") ? 2 : (valueString.equals("false") ? 0 : Integer.parseInt(valueString));
        } else if (args[0].equalsIgnoreCase("showWaypoints")) {
            this.showWaypoints = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("deathpoints")) {
            this.deathpoints = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("oldDeathpoints")) {
            this.oldDeathpoints = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("showIngameWaypoints")) {
            this.showIngameWaypoints = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("displayRedstone")) {
            this.displayRedstone = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("distance")) {
            this.distance = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("showCoords")) {
            BuiltInInfoDisplays.COORDINATES.setState(valueString.equals("true"));
        } else if (args[0].equalsIgnoreCase("lockNorth")) {
            this.lockNorth = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("zoom")) {
            this.zoom = Integer.parseInt(valueString);
            if (this.zoom >= this.zooms.length) {
                this.zoom = this.zooms.length - 1;
            }
        } else if (args[0].equalsIgnoreCase("mapSize")) {
            int oldSize = Integer.parseInt(valueString);
            this.minimapSize = oldSize == -1 ? 0 : OLD_MINIMAP_SIZES[oldSize];
        } else if (args[0].equalsIgnoreCase("minimapSize")) {
            this.minimapSize = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("chunkGrid")) {
            this.chunkGrid = valueString.equals("true") ? 0 : (valueString.equals("false") ? -1 : Integer.parseInt(valueString));
        } else if (args[0].equalsIgnoreCase("slimeChunks")) {
            this.slimeChunks = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("mapSafeMode")) {
            this.mapSafeMode = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("minimapOpacity")) {
            this.minimapOpacity = Double.valueOf(valueString);
        } else if (args[0].equalsIgnoreCase("waypointsIngameIconScale")) {
            this.waypointsIngameIconScale = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("waypointsIngameDistanceScale")) {
            this.waypointsIngameDistanceScale = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("waypointsIngameNameScale")) {
            this.waypointsIngameNameScale = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("waypointsIngameCloseScale")) {
            this.waypointsIngameCloseScale = Double.valueOf(valueString);
        } else if (args[0].equalsIgnoreCase("antiAliasing")) {
            this.antiAliasing = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("blockColours")) {
            this.blockColours = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("lighting")) {
            this.lighting = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("dotsStyle")) {
            this.dotsStyle = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("dotNameScale")) {
            this.dotNameScale = Double.valueOf(valueString);
        } else if (args[0].equalsIgnoreCase("compassOverEverything")) {
            this.compassOverEverything = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("showBiome")) {
            BuiltInInfoDisplays.BIOME.setState(valueString.equals("true"));
        } else if (args[0].equalsIgnoreCase("showFlowers")) {
            this.showFlowers = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("keepWaypointNames")) {
            this.keepWaypointNames = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("waypointsDistance")) {
            double oldValue = Double.valueOf(valueString);
            this.waypointsDistanceExp = oldValue <= 0.0 ? 0 : (int)Math.max(3.0, Math.ceil(Math.log(oldValue) / Math.log(2.0))) - 2;
        } else if (args[0].equalsIgnoreCase("waypointsDistanceExp")) {
            this.waypointsDistanceExp = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("waypointsDistanceMin")) {
            this.waypointsDistanceMin = Double.valueOf(valueString);
        } else if (args[0].equalsIgnoreCase("waypointTp")) {
            this.defaultWaypointTPCommandFormat = "/" + valueString + " {x} {y} {z}";
            this.defaultWaypointTPCommandRotationFormat = "/" + valueString + " {x} {y} {z} {yaw} ~";
        } else if (args[0].equalsIgnoreCase("waypointTPCommand")) {
            this.defaultWaypointTPCommandFormat = valueString.replace("^col^", ":") + " {x} {y} {z}";
            this.defaultWaypointTPCommandRotationFormat = valueString.replace("^col^", ":") + " {x} {y} {z} {yaw} ~";
        } else if (args[0].equalsIgnoreCase("defaultWaypointTPCommandFormat")) {
            this.defaultWaypointTPCommandFormat = valueString.replace("^col^", ":");
        } else if (args[0].equalsIgnoreCase("defaultWaypointTPCommandRotationFormat")) {
            this.defaultWaypointTPCommandRotationFormat = valueString.replace("^col^", ":");
        } else if (args[0].equalsIgnoreCase("arrowScale")) {
            this.arrowScale = Double.valueOf(valueString);
        } else if (args[0].equalsIgnoreCase("arrowColour")) {
            this.arrowColour = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("seed")) {
            serverSlimeSeeds.put(new XaeroPathReader().read(valueString), Long.parseLong(args[2]));
        } else if (args[0].equalsIgnoreCase("smoothDots")) {
            this.smoothDots = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("worldMap")) {
            this.worldMap = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("terrainDepth")) {
            this.terrainDepth = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("terrainSlopes")) {
            this.terrainSlopes = valueString.equals("true") ? 2 : (valueString.equals("false") ? 0 : Integer.parseInt(valueString));
        } else if (args[0].equalsIgnoreCase("alwaysArrow") && valueString.equals("true")) {
            this.mainEntityAs = 2;
        } else if (args[0].equalsIgnoreCase("mainEntityAs")) {
            this.mainEntityAs = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("blockTransparency")) {
            this.blockTransparency = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("waypointOpacityIngame")) {
            this.waypointOpacityIngame = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("waypointOpacityMap")) {
            this.waypointOpacityMap = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("hideWorldNames")) {
            this.hideWorldNames = valueString.equals("true") ? 2 : (valueString.equals("false") ? 1 : Integer.parseInt(valueString));
        } else if (args[0].equalsIgnoreCase("openSlimeSettings")) {
            this.openSlimeSettings = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("alwaysShowDistance")) {
            this.alwaysShowDistance = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("showLightLevel")) {
            BuiltInInfoDisplays.LIGHT_LEVEL.setState(valueString.equals("true") ? 1 : (valueString.equals("false") ? 0 : Integer.parseInt(valueString)));
        } else if (args[0].equalsIgnoreCase("renderLayerIndex")) {
            this.renderLayerIndex = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("showTime")) {
            BuiltInInfoDisplays.TIME.setState(Integer.parseInt(valueString));
        } else if (args[0].equalsIgnoreCase("biomeColorsVanillaMode")) {
            this.biomeColorsVanillaMode = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("lookingAtAngle")) {
            this.lookingAtAngle = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("lookingAtAngleVertical")) {
            this.lookingAtAngleVertical = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("centeredEnlarged")) {
            this.centeredEnlarged = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("zoomedOutEnlarged")) {
            this.zoomOnEnlarged = valueString.equals("true") ? 1 : 0;
        } else if (args[0].equalsIgnoreCase("zoomOnEnlarged")) {
            this.zoomOnEnlarged = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("minimapTextAlign")) {
            this.minimapTextAlign = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("showAngles")) {
            BuiltInInfoDisplays.ANGLES.setState(valueString.equals("true"));
        } else if (args[0].equalsIgnoreCase("waypointsMutualEdit")) {
            this.waypointsMutualEdit = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("compass")) {
            this.compassLocation = valueString.equals("true") ? 1 : 0;
        } else if (args[0].equalsIgnoreCase("compassLocation")) {
            this.compassLocation = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("compassDirectionScale")) {
            this.compassDirectionScale = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("caveMapsDepth")) {
            this.caveMapsDepth = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("hideWaypointCoordinates")) {
            this.hideWaypointCoordinates = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("renderAllSets")) {
            this.renderAllSets = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("playerArrowOpacity")) {
            this.playerArrowOpacity = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("waypointsBottom")) {
            this.waypointsBottom = valueString.equals("true");
        } else if (args[0].equalsIgnoreCase("minimapShape")) {
            this.minimapShape = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("lightOverlayType")) {
            this.lightOverlayType = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("lightOverlayMaxLight")) {
            this.lightOverlayMaxLight = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("lightOverlayMinLight")) {
            this.lightOverlayMinLight = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("lightOverlayColor")) {
            this.lightOverlayColor = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("uiScale")) {
            this.uiScale = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("bossHealthPushBox")) {
            this.bossHealthPushBox = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("potionEffectPushBox")) {
            this.potionEffectPushBox = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("minimapFrame")) {
            this.minimapFrame = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("minimapFrameColor")) {
            this.minimapFrameColor = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("compassColor")) {
            this.compassColor = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("northCompassColor")) {
            this.northCompassColor = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("showDimensionName")) {
            BuiltInInfoDisplays.DIMENSION.setState(valueString.equals("true"));
        } else if (args[0].equalsIgnoreCase("displayMultipleWaypointInfo")) {
            this.displayMultipleWaypointInfo = Integer.parseInt(valueString);
        } else if (args[0].equalsIgnoreCase("entityRadar")) {
            this.entityRadar = valueString.equals("true");
        } else {
            if (this.entityRadarBackwardsCompatibilityConfig.readSetting(args)) {
                this.foundOldRadarSettings = true;
                return;
            }
            if (args[0].equalsIgnoreCase("adjustHeightForCarpetLikeBlocks")) {
                this.adjustHeightForCarpetLikeBlocks = valueString.equals("true");
            } else if (args[0].equalsIgnoreCase("autoConvertWaypointDistanceToKmThreshold")) {
                this.autoConvertWaypointDistanceToKmThreshold = Integer.parseInt(valueString);
            } else if (args[0].equalsIgnoreCase("waypointDistancePrecision")) {
                this.waypointDistancePrecision = Integer.parseInt(valueString);
            } else if (args[0].equalsIgnoreCase("mainDotSize")) {
                this.mainDotSize = Integer.parseInt(valueString);
            } else if (args[0].equalsIgnoreCase("partialYTeleportation")) {
                this.partialYTeleportation = valueString.equals("true");
            } else if (args[0].equalsIgnoreCase("deleteReachedDeathpoints")) {
                this.deleteReachedDeathpoints = valueString.equals("true");
            } else if (args[0].equalsIgnoreCase("hideMinimapUnderScreen")) {
                this.hideMinimapUnderScreen = valueString.equals("true");
            } else if (args[0].equalsIgnoreCase("manualCaveModeStart")) {
                this.manualCaveModeStart = Integer.parseInt(valueString);
            } else if (args[0].equalsIgnoreCase("manualCaveModeStartAuto")) {
                this.manualCaveModeStartAuto = valueString.equals("true");
            } else if (args[0].equalsIgnoreCase("chunkGridLineWidth")) {
                this.chunkGridLineWidth = Integer.parseInt(valueString);
            } else if (args[0].equalsIgnoreCase("hideMinimapUnderF3")) {
                this.hideMinimapUnderF3 = valueString.equals("true");
            } else if (args[0].equalsIgnoreCase("temporaryWaypointsGlobal")) {
                this.temporaryWaypointsGlobal = valueString.equals("true");
            } else if (args[0].equalsIgnoreCase("keepUnlockedWhenEnlarged")) {
                this.keepUnlockedWhenEnlarged = valueString.equals("true");
            } else if (args[0].equalsIgnoreCase("enlargedMinimapAToggle")) {
                this.enlargedMinimapAToggle = valueString.equals("true");
            } else if (args[0].equalsIgnoreCase("displayStainedGlass")) {
                this.displayStainedGlass = valueString.equals("true");
            } else if (args[0].equalsIgnoreCase("waypointOnMapScale")) {
                this.waypointOnMapScale = Integer.parseInt(valueString);
            } else if (args[0].equalsIgnoreCase("switchToAutoOnDeath")) {
                this.switchToAutoOnDeath = valueString.equals("true");
            } else if (args[0].equalsIgnoreCase("displayWeatherInfo")) {
                BuiltInInfoDisplays.WEATHER.setState(valueString.equals("true"));
            } else if (args[0].equalsIgnoreCase("infoDisplayBackgroundOpacity")) {
                this.infoDisplayBackgroundOpacity = Integer.parseInt(valueString);
            } else if (args[0].equalsIgnoreCase("caveModeToggleTimer")) {
                this.caveModeToggleTimer = Integer.parseInt(valueString);
            } else if (args[0].equalsIgnoreCase("legibleCaveMaps")) {
                this.legibleCaveMaps = valueString.equals("true");
            } else if (args[0].equalsIgnoreCase("displayPacPlayers") || args[0].equalsIgnoreCase("displayTrackedPlayers")) {
                this.displayTrackedPlayersOnMap = this.displayTrackedPlayersInWorld = valueString.equals("true");
            } else if (args[0].equalsIgnoreCase("displayTrackedPlayersOnMap")) {
                this.displayTrackedPlayersOnMap = valueString.equals("true");
            } else if (args[0].equalsIgnoreCase("displayTrackedPlayersInWorld")) {
                this.displayTrackedPlayersInWorld = valueString.equals("true");
            } else if (args[0].equalsIgnoreCase("dimensionScaledMaxWaypointDistance")) {
                this.dimensionScaledMaxWaypointDistance = args[1].equals("true");
            } else if (args[0].equalsIgnoreCase("trackedPlayerWorldIconScale")) {
                this.trackedPlayerWorldIconScale = Integer.parseInt(args[1]);
            } else if (args[0].equalsIgnoreCase("trackedPlayerWorldNameScale")) {
                this.trackedPlayerWorldNameScale = Integer.parseInt(args[1]);
            } else if (args[0].equalsIgnoreCase("trackedPlayerMinimapIconScale")) {
                this.trackedPlayerMinimapIconScale = Integer.parseInt(args[1]);
            }
        }
    }

    public void loadDefaultSettings() throws IOException {
        Path mainConfigFile = this.modMain.getConfigFile();
        File defaultConfigFile = mainConfigFile.getParent().resolveSibling("defaultconfigs").resolve(mainConfigFile.getFileName()).toFile();
        if (defaultConfigFile.exists()) {
            this.loadSettingsFile(defaultConfigFile);
        }
    }

    public void loadSettings() throws IOException {
        this.loadDefaultSettings();
        Path mainConfigFile = this.modMain.getConfigFile();
        Path configFolderPath = mainConfigFile.getParent();
        if (!Files.exists(configFolderPath, new LinkOption[0])) {
            Files.createDirectories(configFolderPath, new FileAttribute[0]);
        }
        if (Files.exists(mainConfigFile, new LinkOption[0])) {
            this.loadSettingsFile(mainConfigFile.toFile());
        }
        this.saveSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettingsFile(File file) throws IOException {
        try (BufferedReader reader = null;){
            String s;
            reader = new BufferedReader(new FileReader(file));
            InfoDisplayIO infoDisplayIO = this.modMain.getMinimap().getInfoDisplays().getIo();
            while ((s = reader.readLine()) != null) {
                if (this.modMain.getHudIO().load(s)) continue;
                String[] args = s.split(":");
                try {
                    if (args[0].equalsIgnoreCase("interface") && args[1].equals("gui.xaero_minimap")) {
                        BuiltInHudModules.MINIMAP.setTransform(this.modMain.getHud().getOldSystemCompatibility().loadOldTransform(args));
                        continue;
                    }
                    if (args[0].equals("infoDisplayOrder")) {
                        infoDisplayIO.loadInfoDisplayOrderLine(args);
                        continue;
                    }
                    if (args[0].equals("infoDisplay")) {
                        infoDisplayIO.loadInfoDisplayLine(args);
                        continue;
                    }
                    this.readSetting(args);
                }
                catch (Exception e) {
                    MinimapLogs.LOGGER.info("Skipping setting:" + args[0]);
                }
            }
        }
    }

    public String getMoreKeybindings(String s, ModOptions par1EnumOptions) {
        boolean clientSetting = this.getClientBooleanValue(par1EnumOptions);
        boolean serverSetting = this.getBooleanValue(par1EnumOptions);
        s = s + ModSettings.getTranslation(clientSetting) + (serverSetting != clientSetting ? "\u00a7e (" + ModSettings.getTranslation(serverSetting) + ")" : "");
        return s;
    }

    public String getKeyBinding(ModOptions par1EnumOptions) {
        boolean usingSafeMode;
        if (par1EnumOptions.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return par1EnumOptions.getEnumString();
        }
        String s = par1EnumOptions.getEnumString() + ": ";
        boolean bl = usingSafeMode = this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isTriedFBO() && !this.modMain.getInterfaces().getMinimapInterface().usingFBO() || this.mapSafeMode;
        if (this.usesWorldMapScreenValue(par1EnumOptions) || this.usesWorldMapOptionValue(par1EnumOptions) || this.usesWorldMapHardValue(par1EnumOptions)) {
            s = s + "\u00a7e" + I18n.func_135052_a((String)"gui.xaero_world_map", (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.CHUNK_GRID) {
            s = s + (this.chunkGrid > -1 ? format + ENCHANT_COLORS[this.chunkGrid] + I18n.func_135052_a((String)ENCHANT_COLOR_NAMES[this.chunkGrid], (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_off", (Object[])new Object[0]));
        } else if (par1EnumOptions == ModOptions.LIGHT_OVERLAY_COLOR) {
            s = s + format + ENCHANT_COLORS[this.lightOverlayColor] + I18n.func_135052_a((String)ENCHANT_COLOR_NAMES[this.lightOverlayColor], (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.UI_SCALE) {
            s = s + (this.uiScale <= 1 ? I18n.func_135052_a((String)"gui.xaero_ui_scale_auto", (Object[])new Object[0]) + " (" + this.getAutoUIScale() + ")" : (this.uiScale == 11 ? I18n.func_135052_a((String)"gui.xaero_ui_scale_mc", (Object[])new Object[0]) + " (" + new ScaledResolution(Minecraft.func_71410_x()).func_78325_e() + ")" : Integer.valueOf(this.uiScale)));
        } else if (par1EnumOptions == ModOptions.LIGHT_OVERLAY_MAX_LIGHT) {
            s = s + this.lightOverlayMaxLight;
        } else if (par1EnumOptions == ModOptions.LIGHT_OVERLAY_MIN_LIGHT) {
            s = s + this.lightOverlayMinLight;
        } else if (par1EnumOptions == ModOptions.MINIMAP_FRAME_COLOR) {
            s = s + format + ENCHANT_COLORS[this.minimapFrameColor] + I18n.func_135052_a((String)ENCHANT_COLOR_NAMES[this.minimapFrameColor], (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.COMPASS_COLOR) {
            s = s + format + ENCHANT_COLORS[this.compassColor] + I18n.func_135052_a((String)ENCHANT_COLOR_NAMES[this.compassColor], (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.NORTH_COMPASS_COLOR) {
            int effectiveColor = this.getNorthCompassColor();
            s = s + (effectiveColor != this.northCompassColor ? I18n.func_135052_a((String)"gui.xaero_north_compass_color_default", (Object[])new Object[0]) : format + ENCHANT_COLORS[effectiveColor] + I18n.func_135052_a((String)ENCHANT_COLOR_NAMES[effectiveColor], (Object[])new Object[0]));
        } else if (par1EnumOptions == ModOptions.DOTS_SIZE) {
            s = s + this.modMain.getEntityRadarCategoryManager().getRootCategory().getSettingValue(EntityRadarCategorySettings.DOT_SIZE);
            if (usingSafeMode) {
                s = s + "\u00a7e (" + ModSettings.getTranslation(false) + ")";
            }
        } else if (par1EnumOptions == ModOptions.SIZE) {
            s = s + (this.minimapSize > 0 ? this.minimapSize + "" : I18n.func_135052_a((String)"gui.xaero_auto_map_size", (Object[])new Object[0]) + " (" + this.getMinimapSize(new ScaledResolution(Minecraft.func_71410_x()).func_78325_e()) + ")");
        } else if (par1EnumOptions == ModOptions.WAYPOINTS_ICON_SCALE || par1EnumOptions == ModOptions.WAYPOINTS_DISTANCE_SCALE) {
            int settingValue = par1EnumOptions == ModOptions.WAYPOINTS_ICON_SCALE ? this.waypointsIngameIconScale : this.waypointsIngameDistanceScale;
            s = s + (settingValue <= 0 ? I18n.func_135052_a((String)"gui.xaero_ui_scale_auto", (Object[])new Object[0]) + " (" + this.getAutoUIScale() + ")" : (settingValue == 17 ? I18n.func_135052_a((String)"gui.xaero_ui_scale_mc", (Object[])new Object[0]) + " (" + new ScaledResolution(Minecraft.func_71410_x()).func_78325_e() + ")" : Integer.valueOf(settingValue)));
        } else if (par1EnumOptions == ModOptions.WAYPOINTS_NAME_SCALE) {
            int settingValue = this.waypointsIngameNameScale;
            s = s + (settingValue <= 0 ? I18n.func_135052_a((String)"gui.xaero_ui_scale_auto", (Object[])new Object[0]) + " (" + this.getWaypointsIngameNameScale(new ScaledResolution(Minecraft.func_71410_x()).func_78325_e()) + ")" : (settingValue == 17 ? I18n.func_135052_a((String)"gui.xaero_ui_scale_mc", (Object[])new Object[0]) + " (" + new ScaledResolution(Minecraft.func_71410_x()).func_78325_e() + ")" : Integer.valueOf(settingValue)));
        } else if (par1EnumOptions == ModOptions.TRACKED_PLAYER_WORLD_ICON_SCALE || par1EnumOptions == ModOptions.TRACKED_PLAYER_WORLD_NAME_SCALE || par1EnumOptions == ModOptions.TRACKED_PLAYER_MINIMAP_ICON_SCALE) {
            int settingValue = par1EnumOptions == ModOptions.TRACKED_PLAYER_WORLD_ICON_SCALE ? this.trackedPlayerWorldIconScale : (par1EnumOptions == ModOptions.TRACKED_PLAYER_WORLD_NAME_SCALE ? this.trackedPlayerWorldNameScale : this.trackedPlayerMinimapIconScale);
            s = s + (settingValue <= 0 ? I18n.func_135052_a((String)"gui.xaero_ui_scale_auto", (Object[])new Object[0]) + " (" + this.getAutoUIScale() + ")" : ((double)settingValue == par1EnumOptions.getValueMax() ? I18n.func_135052_a((String)"gui.xaero_ui_scale_mc", (Object[])new Object[0]) + " (" + new ScaledResolution(Minecraft.func_71410_x()).func_78325_e() + ")" : Integer.valueOf(settingValue)));
        } else if (par1EnumOptions == ModOptions.HEADS_SCALE) {
            s = s + this.getRadarSettingOptionName(EntityRadarCategorySettings.ICON_SCALE);
        } else if (par1EnumOptions == ModOptions.HEIGHT_LIMIT) {
            s = s + this.getRadarSettingOptionName(EntityRadarCategorySettings.HEIGHT_LIMIT);
        } else if (par1EnumOptions == ModOptions.START_FADING_AT) {
            s = s + this.getRadarSettingOptionName(EntityRadarCategorySettings.START_FADING_AT);
        } else {
            if (par1EnumOptions == ModOptions.WAYPOINTS_CLOSE_SCALE) {
                return this.getEnumFloatSliderText(s, "%.3f", par1EnumOptions);
            }
            if (par1EnumOptions == ModOptions.AUTO_CONVERT_TO_KM) {
                s = s + (this.autoConvertWaypointDistanceToKmThreshold == -1 ? I18n.func_135052_a((String)"gui.xaero_auto_convert_wp_distance_km_never", (Object[])new Object[0]) : Integer.valueOf(this.autoConvertWaypointDistanceToKmThreshold));
            } else if (par1EnumOptions == ModOptions.WP_DISTANCE_PRECISION) {
                s = s + this.waypointDistancePrecision;
            } else if (par1EnumOptions == ModOptions.MANUAL_CAVE_MODE_START) {
                s = s + (this.manualCaveModeStartAuto ? I18n.func_135052_a((String)"gui.xaero_manual_cave_mode_start_auto", (Object[])new Object[0]) : Integer.valueOf(this.manualCaveModeStart));
            } else if (par1EnumOptions == ModOptions.CHUNK_GRID_LINE_WIDTH) {
                s = s + this.chunkGridLineWidth;
            } else if (par1EnumOptions == ModOptions.WAYPOINT_ONMAP_SCALE) {
                s = s + (this.waypointOnMapScale <= 0 ? I18n.func_135052_a((String)"gui.xaero_waypoint_onmap_scale_auto", (Object[])new Object[0]) : Integer.valueOf(this.waypointOnMapScale));
            } else if (par1EnumOptions == ModOptions.INFO_DISPLAY_BG_OPACITY) {
                s = s + this.infoDisplayBackgroundOpacity;
            } else if (par1EnumOptions == ModOptions.CAVE_MODE_TOGGLE_TIMER) {
                s = s + this.caveModeToggleTimer + " ms";
            } else if (par1EnumOptions == ModOptions.MAIN_DOT_SIZE) {
                s = s + this.mainDotSize;
                if (usingSafeMode) {
                    s = s + "\u00a7e (" + ModSettings.getTranslation(false) + ")";
                }
            } else if (par1EnumOptions == ModOptions.ZOOM_ON_ENLARGE) {
                s = s + (this.zoomOnEnlarged <= 0 ? I18n.func_135052_a((String)"gui.xaero_zoom_on_enlarge_auto", (Object[])new Object[0]) : this.zooms[this.zoomOnEnlarged - 1] + "x");
            } else if (par1EnumOptions == ModOptions.COMPASS_SCALE) {
                s = s + (this.compassDirectionScale <= 0 ? I18n.func_135052_a((String)"gui.xaero_compass_scale_auto", (Object[])new Object[0]) : Integer.valueOf(this.compassDirectionScale));
            } else {
                if (par1EnumOptions.getEnumFloat()) {
                    return this.getEnumFloatSliderText(s, "%.1f", par1EnumOptions);
                }
                if (par1EnumOptions == ModOptions.ZOOM) {
                    s = s + this.zooms[this.zoom] + "x";
                } else if (par1EnumOptions == ModOptions.DISTANCE) {
                    s = s + I18n.func_135052_a((String)distanceTypes[this.distance], (Object[])new Object[0]);
                } else if (par1EnumOptions == ModOptions.SLIME_CHUNKS && this.customSlimeSeedNeeded(XaeroMinimapSession.getCurrentSession())) {
                    s = par1EnumOptions.getEnumString();
                } else if (par1EnumOptions == ModOptions.CAVE_MAPS) {
                    if (this.caveMaps == 0) {
                        s = s + I18n.func_135052_a((String)"gui.xaero_off", (Object[])new Object[0]);
                    } else {
                        int roofSideSize = this.caveMaps * 2 - 1;
                        s = s + roofSideSize + "x" + roofSideSize + " " + I18n.func_135052_a((String)"gui.xaero_roof", (Object[])new Object[0]);
                        if (!this.getCaveMaps(false)) {
                            s = s + "\u00a7e (" + ModSettings.getTranslation(false) + ")";
                        }
                    }
                } else if (par1EnumOptions == ModOptions.CAVE_ZOOM) {
                    s = this.caveZoom == 0 ? s + I18n.func_135052_a((String)"gui.xaero_off", (Object[])new Object[0]) : s + (1 + this.caveZoom) + "x";
                } else if (par1EnumOptions == ModOptions.HIDE_WORLD_NAMES) {
                    s = s + (this.hideWorldNames == 0 ? I18n.func_135052_a((String)"gui.xaero_off", (Object[])new Object[0]) : (this.hideWorldNames == 1 ? I18n.func_135052_a((String)"gui.xaero_partial", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_full", (Object[])new Object[0])));
                } else if (par1EnumOptions == ModOptions.MINIMAP_TEXT_ALIGN) {
                    s = s + (this.minimapTextAlign == 0 ? I18n.func_135052_a((String)"gui.xaero_center", (Object[])new Object[0]) : (this.minimapTextAlign == 1 ? I18n.func_135052_a((String)"gui.xaero_left", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_right", (Object[])new Object[0])));
                } else if (par1EnumOptions == ModOptions.ARROW_COLOUR) {
                    String colourName = "gui.xaero_team";
                    if (this.arrowColour != -1) {
                        colourName = this.arrowColourNames[this.arrowColour];
                    }
                    s = s + I18n.func_135052_a((String)colourName, (Object[])new Object[0]);
                } else {
                    s = par1EnumOptions == ModOptions.COLOURS ? s + I18n.func_135052_a((String)blockColourTypes[this.getBlockColours()], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.TERRAIN_SLOPES ? s + I18n.func_135052_a((String)SLOPES_MODES[this.terrainSlopes], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.RENDER_LAYER ? s + this.renderLayerIndex : (par1EnumOptions == ModOptions.MAIN_ENTITY_AS ? s + (this.mainEntityAs == 0 ? I18n.func_135052_a((String)"gui.xaero_crosshair", (Object[])new Object[0]) : (this.mainEntityAs == 1 ? I18n.func_135052_a((String)"gui.xaero_dot", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_arrow", (Object[])new Object[0]))) : (par1EnumOptions == ModOptions.MINIMAP_SHAPE ? s + I18n.func_135052_a((String)MINIMAP_SHAPES[this.minimapShape], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.LIGHT_OVERLAY_TYPE ? s + I18n.func_135052_a((String)SHOW_LIGHT_LEVEL_NAMES[this.lightOverlayType < 0 ? 0 : this.lightOverlayType], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.DOTS_STYLE ? s + I18n.func_135052_a((String)DOTS_STYLES[this.dotsStyle], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.BOSS_HEALTH_PUSHBOX ? s + I18n.func_135052_a((String)PUSHBOX_OPTIONS[this.bossHealthPushBox], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.POTION_EFFECTS_PUSHBOX ? s + I18n.func_135052_a((String)PUSHBOX_OPTIONS[this.potionEffectPushBox], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.MINIMAP_FRAME ? s + I18n.func_135052_a((String)FRAME_OPTIONS[this.minimapFrame], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.COMPASS_LOCATION ? s + I18n.func_135052_a((String)COMPASS_OPTIONS[this.compassLocation], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.MULTIPLE_WAYPOINT_INFO ? s + I18n.func_135052_a((String)MULTIPLE_WAYPOINT_INFO[this.displayMultipleWaypointInfo], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.EAMOUNT ? s + this.getRadarSettingOptionName(EntityRadarCategorySettings.ENTITY_NUMBER) : (par1EnumOptions == ModOptions.RADAR_ICONS_DISPLAYED ? s + this.getRadarSettingOptionName(EntityRadarCategorySettings.ICONS) : (par1EnumOptions == ModOptions.RADAR_NAMES_DISPLAYED ? s + this.getRadarSettingOptionName(EntityRadarCategorySettings.NAMES) : (par1EnumOptions == ModOptions.RADAR_OVER_FRAME ? s + this.getRadarSettingOptionName(EntityRadarCategorySettings.RENDER_OVER_MINIMAP) : (par1EnumOptions == ModOptions.RADAR_Y_DISPLAYED ? s + this.getRadarSettingOptionName(EntityRadarCategorySettings.DISPLAY_Y) : this.getMoreKeybindings(s, par1EnumOptions)))))))))))))))));
                }
            }
        }
        return s;
    }

    public boolean usesWorldMapOptionValue(ModOptions par1EnumOptions) {
        return this.modMain.getSupportMods().shouldUseWorldMapChunks() && (par1EnumOptions == ModOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS || par1EnumOptions == ModOptions.COLOURS || par1EnumOptions == ModOptions.IGNORE_HEIGHTMAPS || par1EnumOptions == ModOptions.FLOWERS || par1EnumOptions == ModOptions.BIOMES_VANILLA || par1EnumOptions == ModOptions.LIGHT && !this.separateLighting() || par1EnumOptions == ModOptions.TERRAIN_DEPTH || par1EnumOptions == ModOptions.TERRAIN_SLOPES || par1EnumOptions == ModOptions.DISPLAY_STAINED_GLASS || (par1EnumOptions == ModOptions.CAVE_MAPS_DEPTH || par1EnumOptions == ModOptions.LEGIBLE_CAVE_MAPS) && this.modMain.getSupportMods().worldmapSupport.hasCaveLayers()) || this.modMain.getSupportMods().worldmap() && par1EnumOptions == ModOptions.PARTIAL_Y_TELEPORTATION && this.modMain.getSupportMods().worldmapSupport.usesPartialYFromWorldMap();
    }

    public boolean usesWorldMapHardValue(ModOptions par1EnumOptions) {
        return this.modMain.getSupportMods().shouldUseWorldMapChunks() && par1EnumOptions == ModOptions.REDSTONE;
    }

    public boolean usesWorldMapScreenValue(ModOptions par1EnumOptions) {
        return this.modMain.getSupportMods().shouldUseWorldMapChunks() && par1EnumOptions == ModOptions.MANUAL_CAVE_MODE_START && this.modMain.getSupportMods().worldmapSupport.caveLayersAreUsable();
    }

    protected String getEnumFloatSliderText(String s, String f, ModOptions par1EnumOptions) {
        String f1 = String.format(f, this.getOptionFloatValue(par1EnumOptions));
        if (par1EnumOptions == ModOptions.WAYPOINTS_DISTANCE) {
            double waypointsDistance = this.getMaxWaypointsDistance();
            f1 = waypointsDistance == 0.0 ? I18n.func_135052_a((String)"gui.xaero_unlimited", (Object[])new Object[0]) : (int)waypointsDistance + "m";
        } else if (par1EnumOptions == ModOptions.WAYPOINTS_DISTANCE_MIN) {
            f1 = this.waypointsDistanceMin == 0.0 ? I18n.func_135052_a((String)"gui.xaero_off", (Object[])new Object[0]) : (int)this.waypointsDistanceMin + "m";
        } else if (par1EnumOptions == ModOptions.ARROW_SCALE) {
            f1 = f1 + "x";
        }
        return s + f1;
    }

    public boolean getBooleanValue(ModOptions o) {
        if (o == ModOptions.MINIMAP) {
            return this.getMinimap();
        }
        if (o == ModOptions.CAVE_MAPS) {
            return this.getCaveMaps(false);
        }
        if (o == ModOptions.WAYPOINTS) {
            return this.getShowWaypoints();
        }
        if (o == ModOptions.DEATHPOINTS) {
            return this.getDeathpoints();
        }
        if (o == ModOptions.OLD_DEATHPOINTS) {
            return this.getOldDeathpoints();
        }
        if (o == ModOptions.INGAME_WAYPOINTS) {
            return this.getShowIngameWaypoints();
        }
        if (o == ModOptions.NORTH) {
            return this.getLockNorth(this.getMinimapSize(new ScaledResolution(Minecraft.func_71410_x()).func_78325_e()), this.minimapShape);
        }
        if (o == ModOptions.SAFE_MAP) {
            return this.mapSafeMode || this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isTriedFBO() && !this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isLoadedFBO();
        }
        if (o == ModOptions.AA) {
            return this.getAntiAliasing();
        }
        if (o == ModOptions.SMOOTH_DOTS) {
            return this.getSmoothDots();
        }
        if (o == ModOptions.WORLD_MAP) {
            return this.getUseWorldMap();
        }
        if (o == ModOptions.TERRAIN_DEPTH) {
            return this.getTerrainDepth();
        }
        if (o == ModOptions.RADAR_DISPLAYED) {
            return this.getEntityRadar();
        }
        if (o == ModOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS) {
            return this.getAdjustHeightForCarpetLikeBlocks();
        }
        return this.getClientBooleanValue(o);
    }

    public boolean getClientBooleanValue(ModOptions o) {
        if (o.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return false;
        }
        if (o == ModOptions.IGNORE_HEIGHTMAPS) {
            return this.isIgnoreHeightmaps();
        }
        if (o == ModOptions.MINIMAP) {
            return BuiltInHudModules.MINIMAP.isActive();
        }
        if (o == ModOptions.WAYPOINTS) {
            return this.showWaypoints;
        }
        if (o == ModOptions.DEATHPOINTS) {
            return this.deathpoints;
        }
        if (o == ModOptions.OLD_DEATHPOINTS) {
            return this.oldDeathpoints;
        }
        if (o == ModOptions.INGAME_WAYPOINTS) {
            return this.showIngameWaypoints;
        }
        if (o == ModOptions.REDSTONE) {
            return this.displayRedstone;
        }
        if (o == ModOptions.NORTH) {
            return this.lockNorth;
        }
        if (o == ModOptions.SLIME_CHUNKS) {
            return this.slimeChunks;
        }
        if (o == ModOptions.SAFE_MAP) {
            return this.mapSafeMode;
        }
        if (o == ModOptions.AA) {
            return this.antiAliasing;
        }
        if (o == ModOptions.LIGHT) {
            return this.lighting;
        }
        if (o == ModOptions.COMPASS) {
            return this.compassOverEverything;
        }
        if (o == ModOptions.FLOWERS) {
            return this.showFlowers;
        }
        if (o == ModOptions.KEEP_WP_NAMES) {
            return this.keepWaypointNames;
        }
        if (o == ModOptions.SMOOTH_DOTS) {
            return this.smoothDots;
        }
        if (o == ModOptions.WORLD_MAP) {
            return this.worldMap;
        }
        if (o == ModOptions.TERRAIN_DEPTH) {
            return this.terrainDepth;
        }
        if (o == ModOptions.BLOCK_TRANSPARENCY) {
            return this.blockTransparency;
        }
        if (o == ModOptions.OPEN_SLIME_SETTINGS) {
            return this.openSlimeSettings;
        }
        if (o == ModOptions.ALWAYS_SHOW_DISTANCE) {
            return this.alwaysShowDistance;
        }
        if (o == ModOptions.BIOMES_VANILLA) {
            return this.biomeColorsVanillaMode;
        }
        if (o == ModOptions.CENTERED_ENLARGED) {
            return this.centeredEnlarged;
        }
        if (o == ModOptions.HIDE_WP_COORDS) {
            return this.hideWaypointCoordinates;
        }
        if (o == ModOptions.WAYPOINTS_ALL_SETS) {
            return this.renderAllSets;
        }
        if (o == ModOptions.WAYPOINTS_BOTTOM) {
            return this.waypointsBottom;
        }
        if (o == ModOptions.RADAR_DISPLAYED) {
            return this.entityRadar;
        }
        if (o == ModOptions.ENTITY_HEIGHT) {
            return this.modMain.getEntityRadarCategoryManager().getRootCategory().getSettingValue(EntityRadarCategorySettings.HEIGHT_FADE);
        }
        if (o == ModOptions.ENTITY_NAMETAGS) {
            return this.modMain.getEntityRadarCategoryManager().getRootCategory().getSettingValue(EntityRadarCategorySettings.ALWAYS_NAMETAGS);
        }
        if (o == ModOptions.ICON_NAME_FALLBACK) {
            return this.modMain.getEntityRadarCategoryManager().getRootCategory().getSettingValue(EntityRadarCategorySettings.ICON_NAME_FALLBACK);
        }
        if (o == ModOptions.UPDATE_NOTIFICATION) {
            return updateNotification;
        }
        if (o == ModOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS) {
            return this.adjustHeightForCarpetLikeBlocks;
        }
        if (o == ModOptions.PARTIAL_Y_TELEPORTATION) {
            return this.partialYTeleportation;
        }
        if (o == ModOptions.DELETE_REACHED_DEATHPOINTS) {
            return this.deleteReachedDeathpoints;
        }
        if (o == ModOptions.HIDE_MINIMAP_UNDER_SCREEN) {
            return this.hideMinimapUnderScreen;
        }
        if (o == ModOptions.HIDE_MINIMAP_UNDER_F3) {
            return this.hideMinimapUnderF3;
        }
        if (o == ModOptions.TEMPORARY_WAYPOINTS_GLOBAL) {
            return this.temporaryWaypointsGlobal;
        }
        if (o == ModOptions.KEEP_ENLARGED_UNLOCKED) {
            return this.keepUnlockedWhenEnlarged;
        }
        if (o == ModOptions.TOGGLED_ENLARGED) {
            return this.enlargedMinimapAToggle;
        }
        if (o == ModOptions.DISPLAY_STAINED_GLASS) {
            return this.displayStainedGlass;
        }
        if (o == ModOptions.SWITCH_TO_AUTO_ON_DEATH) {
            return this.switchToAutoOnDeath;
        }
        if (o == ModOptions.LEGIBLE_CAVE_MAPS) {
            return this.legibleCaveMaps;
        }
        if (o == ModOptions.TRACKED_PLAYERS_ON_MAP) {
            return this.displayTrackedPlayersOnMap;
        }
        if (o == ModOptions.TRACKED_PLAYERS_IN_WORLD) {
            return this.displayTrackedPlayersInWorld;
        }
        if (o == ModOptions.SCALED_MAX_WAYPOINT_DISTANCE) {
            return this.dimensionScaledMaxWaypointDistance;
        }
        return false;
    }

    public static String getTranslation(boolean o) {
        return I18n.func_135052_a((String)("gui.xaero_" + (o ? "on" : "off")), (Object[])new Object[0]);
    }

    private void changeZoomUnchecked(int direction) {
        this.zoom += direction;
        if (this.zoom >= this.zooms.length) {
            this.zoom = 0;
        } else if (this.zoom < 0) {
            this.zoom = this.zooms.length - 1;
        }
    }

    public void changeZoom(int direction) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            double targetBefore = minimapSession.getMinimapProcessor().getTargetZoom();
            int attempts = 0;
            do {
                this.changeZoomUnchecked(direction);
            } while (++attempts < this.zooms.length && targetBefore == minimapSession.getMinimapProcessor().getTargetZoom());
            if (attempts == this.zooms.length) {
                this.changeZoomUnchecked(direction);
            }
        } else {
            this.changeZoomUnchecked(direction);
        }
    }

    public void setOptionValue(ModOptions par1EnumOptions, int par2) {
        XaeroMinimapSession minimapSession;
        if (par1EnumOptions.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return;
        }
        if (this.usesWorldMapOptionValue(par1EnumOptions)) {
            this.modMain.getSupportMods().worldmapSupport.openSettings();
            return;
        }
        if (this.usesWorldMapScreenValue(par1EnumOptions)) {
            this.modMain.getSupportMods().worldmapSupport.openScreenForOption(par1EnumOptions);
            return;
        }
        if (par1EnumOptions == ModOptions.ZOOM) {
            this.changeZoomUnchecked(1);
        } else if (par1EnumOptions == ModOptions.MINIMAP) {
            BuiltInHudModules.MINIMAP.setActive(!BuiltInHudModules.MINIMAP.isActive());
        } else if (par1EnumOptions == ModOptions.CAVE_MAPS) {
            this.caveMaps = (this.caveMaps + 1) % 4;
        } else if (par1EnumOptions == ModOptions.CAVE_ZOOM) {
            this.caveZoom = (this.caveZoom + 1) % 4;
        } else if (par1EnumOptions == ModOptions.WAYPOINTS) {
            this.showWaypoints = !this.showWaypoints;
        } else if (par1EnumOptions == ModOptions.DEATHPOINTS) {
            this.deathpoints = !this.deathpoints;
        } else if (par1EnumOptions == ModOptions.OLD_DEATHPOINTS) {
            this.oldDeathpoints = !this.oldDeathpoints;
        } else if (par1EnumOptions == ModOptions.INGAME_WAYPOINTS) {
            this.showIngameWaypoints = !this.showIngameWaypoints;
        } else if (par1EnumOptions == ModOptions.REDSTONE) {
            this.displayRedstone = !this.displayRedstone;
        } else if (par1EnumOptions == ModOptions.DISTANCE) {
            this.distance = (this.distance + 1) % distanceTypes.length;
        } else if (par1EnumOptions == ModOptions.NORTH) {
            this.lockNorth = !this.lockNorth;
        } else if (par1EnumOptions == ModOptions.SLIME_CHUNKS) {
            minimapSession = XaeroMinimapSession.getCurrentSession();
            if (this.customSlimeSeedNeeded(minimapSession)) {
                GuiScreen current = Minecraft.func_71410_x().field_71462_r;
                GuiScreen currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSlimeSeed(this.modMain, minimapSession.getWaypointsManager(), current, currentEscScreen));
                return;
            }
            this.slimeChunks = !this.slimeChunks;
        } else if (par1EnumOptions == ModOptions.SAFE_MAP) {
            this.mapSafeMode = !this.mapSafeMode;
            minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                minimapSession.getMinimapProcessor().setToResetImage(true);
            }
        } else if (par1EnumOptions == ModOptions.AA) {
            this.antiAliasing = !this.antiAliasing;
        } else if (par1EnumOptions == ModOptions.COLOURS) {
            this.blockColours = (this.blockColours + 1) % blockColourTypes.length;
        } else if (par1EnumOptions == ModOptions.LIGHT) {
            this.lighting = !this.lighting;
        } else if (par1EnumOptions == ModOptions.COMPASS) {
            this.compassOverEverything = !this.compassOverEverything;
        } else if (par1EnumOptions == ModOptions.FLOWERS) {
            this.showFlowers = !this.showFlowers;
        } else if (par1EnumOptions == ModOptions.KEEP_WP_NAMES) {
            this.keepWaypointNames = !this.keepWaypointNames;
        } else if (par1EnumOptions == ModOptions.ARROW_COLOUR) {
            ++this.arrowColour;
            if (this.arrowColour == this.arrowColours.length) {
                this.arrowColour = -1;
            }
        } else if (par1EnumOptions == ModOptions.SMOOTH_DOTS) {
            this.smoothDots = !this.smoothDots;
        } else if (par1EnumOptions == ModOptions.DOTS_STYLE) {
            this.dotsStyle = (this.dotsStyle + 1) % DOTS_STYLES.length;
        } else if (par1EnumOptions == ModOptions.WORLD_MAP) {
            this.worldMap = !this.worldMap;
        } else if (par1EnumOptions == ModOptions.TERRAIN_DEPTH) {
            this.terrainDepth = !this.terrainDepth;
        } else if (par1EnumOptions == ModOptions.TERRAIN_SLOPES) {
            this.terrainSlopes = (this.terrainSlopes + 1) % 4;
        } else if (par1EnumOptions == ModOptions.MAIN_ENTITY_AS) {
            this.mainEntityAs = (this.mainEntityAs + 1) % 3;
        } else if (par1EnumOptions == ModOptions.BLOCK_TRANSPARENCY) {
            this.blockTransparency = !this.blockTransparency;
            minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                minimapSession.getMinimapProcessor().setToResetImage(true);
            }
        } else if (par1EnumOptions == ModOptions.HIDE_WORLD_NAMES) {
            this.hideWorldNames = (this.hideWorldNames + 1) % 3;
        } else if (par1EnumOptions == ModOptions.OPEN_SLIME_SETTINGS) {
            this.openSlimeSettings = !this.openSlimeSettings;
        } else if (par1EnumOptions == ModOptions.ALWAYS_SHOW_DISTANCE) {
            this.alwaysShowDistance = !this.alwaysShowDistance;
        } else if (par1EnumOptions == ModOptions.RENDER_LAYER) {
            this.renderLayerIndex = (this.renderLayerIndex + 1) % ClientEvents.OVERLAY_LAYERS.length;
        } else if (par1EnumOptions == ModOptions.BIOMES_VANILLA) {
            this.biomeColorsVanillaMode = !this.biomeColorsVanillaMode;
        } else if (par1EnumOptions == ModOptions.CENTERED_ENLARGED) {
            this.centeredEnlarged = !this.centeredEnlarged;
        } else if (par1EnumOptions == ModOptions.ZOOM_ON_ENLARGE) {
            this.zoomOnEnlarged = (this.zoomOnEnlarged + 1) % 6;
        } else if (par1EnumOptions == ModOptions.MINIMAP_TEXT_ALIGN) {
            this.minimapTextAlign = (this.minimapTextAlign + 1) % 3;
        } else if (par1EnumOptions == ModOptions.COMPASS_LOCATION) {
            this.compassLocation = (this.compassLocation + 1) % COMPASS_OPTIONS.length;
        } else if (par1EnumOptions == ModOptions.HIDE_WP_COORDS) {
            this.hideWaypointCoordinates = !this.hideWaypointCoordinates;
        } else if (par1EnumOptions == ModOptions.WAYPOINTS_ALL_SETS) {
            this.renderAllSets = !this.renderAllSets;
        } else if (par1EnumOptions == ModOptions.IGNORE_HEIGHTMAPS) {
            MinimapWorldRootContainer currentRootContainer = BuiltInHudModules.MINIMAP.getCurrentSession().getWorldManager().getAutoRootContainer();
            currentRootContainer.getConfig().setIgnoreHeightmaps(!currentRootContainer.getConfig().isIgnoreHeightmaps());
            currentRootContainer.getSession().getWorldManagerIO().getRootConfigIO().save(currentRootContainer);
        } else if (par1EnumOptions == ModOptions.WAYPOINTS_BOTTOM) {
            this.waypointsBottom = !this.waypointsBottom;
        } else if (par1EnumOptions == ModOptions.MINIMAP_SHAPE) {
            this.minimapShape = (this.minimapShape + 1) % 2;
        } else if (par1EnumOptions == ModOptions.LIGHT_OVERLAY_TYPE) {
            if (this.lightOverlayType < 0) {
                this.lightOverlayType = 0;
            }
            this.lightOverlayType = (this.lightOverlayType + 1) % 4;
        } else if (par1EnumOptions == ModOptions.BOSS_HEALTH_PUSHBOX) {
            this.bossHealthPushBox = (this.bossHealthPushBox + 1) % 3;
        } else if (par1EnumOptions == ModOptions.POTION_EFFECTS_PUSHBOX) {
            this.potionEffectPushBox = (this.potionEffectPushBox + 1) % 3;
        } else if (par1EnumOptions == ModOptions.MINIMAP_FRAME) {
            this.minimapFrame = (this.minimapFrame + 1) % FRAME_OPTIONS.length;
        } else if (par1EnumOptions == ModOptions.MULTIPLE_WAYPOINT_INFO) {
            this.displayMultipleWaypointInfo = (this.displayMultipleWaypointInfo + 1) % MULTIPLE_WAYPOINT_INFO.length;
        } else if (par1EnumOptions == ModOptions.RADAR_DISPLAYED) {
            this.entityRadar = !this.entityRadar;
        } else {
            if (par1EnumOptions == ModOptions.EAMOUNT) {
                this.toggleRadarSetting(EntityRadarCategorySettings.ENTITY_NUMBER);
                return;
            }
            if (par1EnumOptions == ModOptions.ENTITY_HEIGHT) {
                this.toggleRadarSetting(EntityRadarCategorySettings.HEIGHT_FADE);
                return;
            }
            if (par1EnumOptions == ModOptions.ENTITY_NAMETAGS) {
                this.toggleRadarSetting(EntityRadarCategorySettings.ALWAYS_NAMETAGS);
                return;
            }
            if (par1EnumOptions == ModOptions.RADAR_Y_DISPLAYED) {
                this.toggleRadarSetting(EntityRadarCategorySettings.DISPLAY_Y);
                return;
            }
            if (par1EnumOptions == ModOptions.ICON_NAME_FALLBACK) {
                this.toggleRadarSetting(EntityRadarCategorySettings.ICON_NAME_FALLBACK);
                return;
            }
            if (par1EnumOptions == ModOptions.RADAR_ICONS_DISPLAYED) {
                this.toggleRadarSetting(EntityRadarCategorySettings.ICONS);
                return;
            }
            if (par1EnumOptions == ModOptions.RADAR_NAMES_DISPLAYED) {
                this.toggleRadarSetting(EntityRadarCategorySettings.NAMES);
                return;
            }
            if (par1EnumOptions == ModOptions.UPDATE_NOTIFICATION) {
                updateNotification = !updateNotification;
            } else if (par1EnumOptions == ModOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS) {
                this.adjustHeightForCarpetLikeBlocks = !this.adjustHeightForCarpetLikeBlocks;
            } else if (par1EnumOptions == ModOptions.PARTIAL_Y_TELEPORTATION) {
                this.partialYTeleportation = !this.partialYTeleportation;
            } else if (par1EnumOptions == ModOptions.DELETE_REACHED_DEATHPOINTS) {
                this.deleteReachedDeathpoints = !this.deleteReachedDeathpoints;
            } else if (par1EnumOptions == ModOptions.HIDE_MINIMAP_UNDER_SCREEN) {
                this.hideMinimapUnderScreen = !this.hideMinimapUnderScreen;
            } else if (par1EnumOptions == ModOptions.HIDE_MINIMAP_UNDER_F3) {
                this.hideMinimapUnderF3 = !this.hideMinimapUnderF3;
            } else {
                if (par1EnumOptions == ModOptions.RADAR_OVER_FRAME) {
                    this.toggleRadarSetting(EntityRadarCategorySettings.RENDER_OVER_MINIMAP);
                    return;
                }
                if (par1EnumOptions == ModOptions.TEMPORARY_WAYPOINTS_GLOBAL) {
                    this.temporaryWaypointsGlobal = !this.temporaryWaypointsGlobal;
                } else if (par1EnumOptions == ModOptions.KEEP_ENLARGED_UNLOCKED) {
                    this.keepUnlockedWhenEnlarged = !this.keepUnlockedWhenEnlarged;
                } else if (par1EnumOptions == ModOptions.TOGGLED_ENLARGED) {
                    this.enlargedMinimapAToggle = !this.enlargedMinimapAToggle;
                } else if (par1EnumOptions == ModOptions.DISPLAY_STAINED_GLASS) {
                    this.displayStainedGlass = !this.displayStainedGlass;
                    minimapSession = XaeroMinimapSession.getCurrentSession();
                    if (minimapSession != null) {
                        minimapSession.getMinimapProcessor().setToResetImage(true);
                    }
                } else if (par1EnumOptions == ModOptions.SWITCH_TO_AUTO_ON_DEATH) {
                    this.switchToAutoOnDeath = !this.switchToAutoOnDeath;
                } else if (par1EnumOptions == ModOptions.LEGIBLE_CAVE_MAPS) {
                    this.legibleCaveMaps = !this.legibleCaveMaps;
                    minimapSession = XaeroMinimapSession.getCurrentSession();
                    if (minimapSession != null) {
                        minimapSession.getMinimapProcessor().setToResetImage(true);
                    }
                } else if (par1EnumOptions == ModOptions.TRACKED_PLAYERS_ON_MAP) {
                    this.displayTrackedPlayersOnMap = !this.displayTrackedPlayersOnMap;
                } else if (par1EnumOptions == ModOptions.TRACKED_PLAYERS_IN_WORLD) {
                    this.displayTrackedPlayersInWorld = !this.displayTrackedPlayersInWorld;
                } else if (par1EnumOptions == ModOptions.SCALED_MAX_WAYPOINT_DISTANCE) {
                    this.dimensionScaledMaxWaypointDistance = !this.dimensionScaledMaxWaypointDistance;
                }
            }
        }
        try {
            this.saveSettings();
        }
        catch (IOException ioe) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)ioe);
        }
        if (Minecraft.func_71410_x().field_71462_r != null) {
            Minecraft.func_71410_x().field_71462_r.func_146280_a(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71462_r.field_146294_l, Minecraft.func_71410_x().field_71462_r.field_146295_m);
        }
    }

    public void setOptionFloatValue(ModOptions options, double f) throws IOException {
        if (options.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return;
        }
        if (this.usesWorldMapOptionValue(options)) {
            this.modMain.getSupportMods().worldmapSupport.openSettings();
            return;
        }
        if (this.usesWorldMapScreenValue(options)) {
            this.modMain.getSupportMods().worldmapSupport.openScreenForOption(options);
            return;
        }
        if (options == ModOptions.OPACITY) {
            this.minimapOpacity = f;
        }
        if (options == ModOptions.WAYPOINTS_ICON_SCALE) {
            this.waypointsIngameIconScale = (int)f;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE_SCALE) {
            this.waypointsIngameDistanceScale = (int)f;
        }
        if (options == ModOptions.WAYPOINTS_NAME_SCALE) {
            this.waypointsIngameNameScale = (int)f;
        }
        if (options == ModOptions.WAYPOINTS_CLOSE_SCALE) {
            this.waypointsIngameCloseScale = f;
        }
        if (options == ModOptions.DOT_NAME_SCALE) {
            this.dotNameScale = f;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE) {
            this.waypointsDistanceExp = (int)f;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE_MIN) {
            this.waypointsDistanceMin = (int)f;
        }
        if (options == ModOptions.ARROW_SCALE) {
            this.arrowScale = f;
        }
        if (options == ModOptions.WAYPOINT_OPACITY_INGAME) {
            this.waypointOpacityIngame = (int)f;
        }
        if (options == ModOptions.WAYPOINT_OPACITY_MAP) {
            this.waypointOpacityMap = (int)f;
        }
        if (options == ModOptions.WAYPOINT_LOOKING_ANGLE) {
            this.lookingAtAngle = (int)f;
        }
        if (options == ModOptions.WAYPOINT_VERTICAL_LOOKING_ANGLE) {
            this.lookingAtAngleVertical = (int)f;
        }
        if (options == ModOptions.CAVE_MAPS_DEPTH) {
            this.caveMapsDepth = (int)f;
        }
        if (options == ModOptions.CHUNK_GRID) {
            this.chunkGrid = (int)f;
        }
        if (options == ModOptions.PLAYER_ARROW_OPACITY) {
            this.playerArrowOpacity = (int)f;
        }
        if (options == ModOptions.LIGHT_OVERLAY_COLOR) {
            this.lightOverlayColor = (int)f;
        }
        if (options == ModOptions.LIGHT_OVERLAY_MAX_LIGHT) {
            this.lightOverlayMaxLight = (int)f;
        }
        if (options == ModOptions.LIGHT_OVERLAY_MIN_LIGHT) {
            this.lightOverlayMinLight = (int)f;
        }
        if (options == ModOptions.SIZE) {
            this.minimapSize = f == 54.0 ? 0 : (int)f;
        }
        if (options == ModOptions.UI_SCALE) {
            this.uiScale = (int)f;
        }
        if (options == ModOptions.MINIMAP_FRAME_COLOR) {
            this.minimapFrameColor = (int)f;
        }
        if (options == ModOptions.COMPASS_SCALE) {
            this.compassDirectionScale = (int)f;
        }
        if (options == ModOptions.COMPASS_COLOR) {
            this.compassColor = (int)f;
        }
        if (options == ModOptions.NORTH_COMPASS_COLOR) {
            this.northCompassColor = (int)f;
        }
        if (options == ModOptions.DOTS_SIZE) {
            this.setOptionIndexForRadarSetting(EntityRadarCategorySettings.DOT_SIZE, (int)f);
            return;
        }
        if (options == ModOptions.HEADS_SCALE) {
            double currentScale = this.modMain.getEntityRadarCategoryManager().getRootCategory().getSettingValue(EntityRadarCategorySettings.ICON_SCALE);
            this.setOptionIndexForRadarSetting(EntityRadarCategorySettings.ICON_SCALE, (int)f);
            double newScale = this.modMain.getEntityRadarCategoryManager().getRootCategory().getSettingValue(EntityRadarCategorySettings.ICON_SCALE);
            if (newScale < 1.0 || newScale < 1.0 != currentScale < 1.0) {
                this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().resetEntityIcons();
            }
            return;
        }
        if (options == ModOptions.HEIGHT_LIMIT) {
            this.setOptionIndexForRadarSetting(EntityRadarCategorySettings.HEIGHT_LIMIT, (int)f);
            return;
        }
        if (options == ModOptions.START_FADING_AT) {
            this.setOptionIndexForRadarSetting(EntityRadarCategorySettings.START_FADING_AT, (int)f);
            return;
        }
        if (options == ModOptions.AUTO_CONVERT_TO_KM) {
            int n = this.autoConvertWaypointDistanceToKmThreshold = f <= 0.0 ? (int)f : (int)Math.pow(10.0, f - 1.0);
        }
        if (options == ModOptions.WP_DISTANCE_PRECISION) {
            this.waypointDistancePrecision = (int)f;
        }
        if (options == ModOptions.MAIN_DOT_SIZE) {
            this.mainDotSize = (int)f;
        }
        if (options == ModOptions.MANUAL_CAVE_MODE_START) {
            this.manualCaveModeStart = (int)f * 8 - 1;
            boolean bl = this.manualCaveModeStartAuto = (int)f == 0;
        }
        if (options == ModOptions.CHUNK_GRID_LINE_WIDTH) {
            this.chunkGridLineWidth = (int)f;
        }
        if (options == ModOptions.WAYPOINT_ONMAP_SCALE) {
            this.waypointOnMapScale = (int)f;
        }
        if (options == ModOptions.INFO_DISPLAY_BG_OPACITY) {
            this.infoDisplayBackgroundOpacity = (int)f;
        }
        if (options == ModOptions.CAVE_MODE_TOGGLE_TIMER) {
            this.caveModeToggleTimer = (int)f;
        }
        if (options == ModOptions.TRACKED_PLAYER_WORLD_ICON_SCALE) {
            this.trackedPlayerWorldIconScale = (int)f;
        }
        if (options == ModOptions.TRACKED_PLAYER_WORLD_NAME_SCALE) {
            this.trackedPlayerWorldNameScale = (int)f;
        }
        if (options == ModOptions.TRACKED_PLAYER_MINIMAP_ICON_SCALE) {
            this.trackedPlayerMinimapIconScale = (int)f;
        }
        try {
            this.saveSettings();
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        this.saveSettings();
    }

    public double getOptionFloatValue(ModOptions options) {
        if (options.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return 0.0;
        }
        if (options == ModOptions.OPACITY) {
            return this.minimapOpacity;
        }
        if (options == ModOptions.WAYPOINTS_ICON_SCALE) {
            return this.waypointsIngameIconScale;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE_SCALE) {
            return this.waypointsIngameDistanceScale;
        }
        if (options == ModOptions.WAYPOINTS_NAME_SCALE) {
            return this.waypointsIngameNameScale;
        }
        if (options == ModOptions.WAYPOINTS_CLOSE_SCALE) {
            return this.waypointsIngameCloseScale;
        }
        if (options == ModOptions.DOT_NAME_SCALE) {
            return this.dotNameScale;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE) {
            return this.waypointsDistanceExp;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE_MIN) {
            return this.waypointsDistanceMin;
        }
        if (options == ModOptions.ARROW_SCALE) {
            return this.arrowScale;
        }
        if (options == ModOptions.WAYPOINT_OPACITY_INGAME) {
            return this.waypointOpacityIngame;
        }
        if (options == ModOptions.WAYPOINT_OPACITY_MAP) {
            return this.waypointOpacityMap;
        }
        if (options == ModOptions.WAYPOINT_LOOKING_ANGLE) {
            return this.lookingAtAngle;
        }
        if (options == ModOptions.WAYPOINT_VERTICAL_LOOKING_ANGLE) {
            return this.lookingAtAngleVertical;
        }
        if (options == ModOptions.CAVE_MAPS_DEPTH) {
            return this.caveMapsDepth;
        }
        if (options == ModOptions.CHUNK_GRID) {
            return this.chunkGrid;
        }
        if (options == ModOptions.PLAYER_ARROW_OPACITY) {
            return this.playerArrowOpacity;
        }
        if (options == ModOptions.LIGHT_OVERLAY_COLOR) {
            return this.lightOverlayColor;
        }
        if (options == ModOptions.LIGHT_OVERLAY_MAX_LIGHT) {
            return this.lightOverlayMaxLight;
        }
        if (options == ModOptions.LIGHT_OVERLAY_MIN_LIGHT) {
            return this.lightOverlayMinLight;
        }
        if (options == ModOptions.SIZE) {
            return this.minimapSize;
        }
        if (options == ModOptions.UI_SCALE) {
            return this.uiScale;
        }
        if (options == ModOptions.MINIMAP_FRAME_COLOR) {
            return this.minimapFrameColor;
        }
        if (options == ModOptions.COMPASS_SCALE) {
            return this.compassDirectionScale;
        }
        if (options == ModOptions.COMPASS_COLOR) {
            return this.compassColor;
        }
        if (options == ModOptions.NORTH_COMPASS_COLOR) {
            return this.northCompassColor;
        }
        if (options == ModOptions.DOTS_SIZE) {
            return this.getOptionIndexForRadarSetting(EntityRadarCategorySettings.DOT_SIZE);
        }
        if (options == ModOptions.HEADS_SCALE) {
            return this.getOptionIndexForRadarSetting(EntityRadarCategorySettings.ICON_SCALE);
        }
        if (options == ModOptions.HEIGHT_LIMIT) {
            return this.getOptionIndexForRadarSetting(EntityRadarCategorySettings.HEIGHT_LIMIT);
        }
        if (options == ModOptions.START_FADING_AT) {
            return this.getOptionIndexForRadarSetting(EntityRadarCategorySettings.START_FADING_AT);
        }
        if (options == ModOptions.AUTO_CONVERT_TO_KM) {
            return this.autoConvertWaypointDistanceToKmThreshold <= 0 ? (double)this.autoConvertWaypointDistanceToKmThreshold : 1.0 + Math.log10(this.autoConvertWaypointDistanceToKmThreshold);
        }
        if (options == ModOptions.WP_DISTANCE_PRECISION) {
            return this.waypointDistancePrecision;
        }
        if (options == ModOptions.MAIN_DOT_SIZE) {
            return this.mainDotSize;
        }
        if (options == ModOptions.MANUAL_CAVE_MODE_START) {
            return (this.manualCaveModeStart + 1) / 8;
        }
        if (options == ModOptions.CHUNK_GRID_LINE_WIDTH) {
            return this.chunkGridLineWidth;
        }
        if (options == ModOptions.WAYPOINT_ONMAP_SCALE) {
            return this.waypointOnMapScale;
        }
        if (options == ModOptions.INFO_DISPLAY_BG_OPACITY) {
            return this.infoDisplayBackgroundOpacity;
        }
        if (options == ModOptions.CAVE_MODE_TOGGLE_TIMER) {
            return this.caveModeToggleTimer;
        }
        if (options == ModOptions.TRACKED_PLAYER_WORLD_ICON_SCALE) {
            return this.trackedPlayerWorldIconScale;
        }
        if (options == ModOptions.TRACKED_PLAYER_WORLD_NAME_SCALE) {
            return this.trackedPlayerWorldNameScale;
        }
        if (options == ModOptions.TRACKED_PLAYER_MINIMAP_ICON_SCALE) {
            return this.trackedPlayerMinimapIconScale;
        }
        return 1.0;
    }

    private <T> int getOptionIndexForRadarSetting(ObjectCategorySetting<T> setting) {
        EntityRadarCategory rootCategory = this.modMain.getEntityRadarCategoryManager().getRootCategory();
        return setting.getIndexWriter().apply(rootCategory.getSettingValue(setting));
    }

    public boolean minimapDisabled() {
        return (serverSettings & 1) != 1;
    }

    public boolean caveMapsDisabled() {
        return (serverSettings & 0x4000) != 16384 || this.modMain.isFairPlay() || Minecraft.func_71410_x().field_71441_e != null && (!MinimapClientWorldDataHelper.getCurrentWorldData().getSyncedRules().allowCaveModeOnServer && Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension() != -1 || !MinimapClientWorldDataHelper.getCurrentWorldData().getSyncedRules().allowNetherCaveModeOnServer && Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension() == -1);
    }

    public boolean showWaypointsDisabled() {
        return (serverSettings & 0x10000) != 65536;
    }

    public boolean deathpointsDisabled() {
        return (serverSettings & 0x200000) == 0;
    }

    public void resetServerSettings() {
        serverSettings = defaultSettings;
    }

    public static void setServerSettings() {
    }

    public static boolean canEditIngameSettings() {
        MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
        return minimapSession != null && minimapSession.getWorldState().getAutoWorldPath() != null;
    }

    private <T> String getRadarSettingOptionName(ObjectCategorySetting<T> setting) {
        EntityRadarCategory rootCategory = this.modMain.getEntityRadarCategoryManager().getRootCategory();
        return setting.getWidgetValueNameProvider().apply(rootCategory.getSettingValue(setting));
    }

    private <T> void toggleRadarSetting(ObjectCategorySetting<T> setting) {
        EntityRadarCategory rootCategory = this.modMain.getEntityRadarCategoryManager().getRootCategory();
        int currentIndex = setting.getIndexWriter().apply(rootCategory.getSettingValue(setting));
        int newIndex = (currentIndex + 1) % (setting.getUiLastOption() + 1);
        rootCategory.setSettingValue(setting, setting.getIndexReader().apply(newIndex));
        this.modMain.getEntityRadarCategoryManager().save();
    }

    private <T> void setOptionIndexForRadarSetting(ObjectCategorySetting<T> setting, int index) {
        EntityRadarCategory rootCategory = this.modMain.getEntityRadarCategoryManager().getRootCategory();
        rootCategory.setSettingValue(setting, setting.getIndexReader().apply(index));
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiSettings) {
            ((GuiSettings)Minecraft.func_71410_x().field_71462_r).setShouldSaveRadar();
        }
    }

    public EntityRadarBackwardsCompatibilityConfig getEntityRadarBackwardsCompatibilityConfig() {
        return this.entityRadarBackwardsCompatibilityConfig;
    }

    public void resetEntityRadarBackwardsCompatibilityConfig() {
        this.entityRadarBackwardsCompatibilityConfig = new EntityRadarBackwardsCompatibilityConfig();
        this.foundOldRadarSettings = false;
    }

    public boolean foundOldRadarSettings() {
        return this.foundOldRadarSettings;
    }

    public int getManualCaveModeStart() {
        return this.usesWorldMapScreenValue(ModOptions.MANUAL_CAVE_MODE_START) ? this.modMain.getSupportMods().worldmapSupport.getManualCaveStart() : (this.manualCaveModeStartAuto ? -1 : this.manualCaveModeStart);
    }

    static {
        ENCHANT_COLORS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        ENCHANT_COLOR_NAMES = new String[]{"gui.xaero_black", "gui.xaero_dark_blue", "gui.xaero_dark_green", "gui.xaero_dark_aqua", "gui.xaero_dark_red", "gui.xaero_dark_purple", "gui.xaero_gold", "gui.xaero_gray", "gui.xaero_dark_gray", "gui.xaero_blue", "gui.xaero_green", "gui.xaero_aqua", "gui.xaero_red", "gui.xaero_purple", "gui.xaero_yellow", "gui.xaero_white"};
        COLORS = new int[]{-16777216, -16777046, -16733696, -16733526, -5636096, -5635926, -22016, -5592406, -11184811, -11184641, -11141291, -11141121, -65536, -43521, -171, -1};
        keyBindZoom = MinimapKeyMappings.ZOOM_IN;
        keyBindZoom1 = MinimapKeyMappings.ZOOM_OUT;
        newWaypoint = MinimapKeyMappings.ADD_WAYPOINT;
        keyWaypoints = MinimapKeyMappings.WAYPOINT_MENU;
        keyLargeMap = MinimapKeyMappings.ENLARGE_MAP;
        keyToggleMap = MinimapKeyMappings.TOGGLE_MAP;
        keyToggleWaypoints = MinimapKeyMappings.TOGGLE_WORLD_WAYPOINTS;
        keyToggleMapWaypoints = MinimapKeyMappings.TOGGLE_MAP_WAYPOINTS;
        keyToggleSlimes = MinimapKeyMappings.TOGGLE_SLIME_CHUNKS;
        keyToggleGrid = MinimapKeyMappings.TOGGLE_GRID;
        keyInstantWaypoint = MinimapKeyMappings.TEMPORARY_WAYPOINT;
        keySwitchSet = MinimapKeyMappings.SWITCH_WAYPOINT_SET;
        keyAllSets = MinimapKeyMappings.RENDER_ALL_SETS;
        keyLightOverlay = MinimapKeyMappings.LIGHT_OVERLAY;
        keyToggleRadar = MinimapKeyMappings.TOGGLE_RADAR;
        keyReverseEntityRadar = MinimapKeyMappings.REVERSE_ENTITY_RADAR;
        keyManualCaveMode = MinimapKeyMappings.MANUAL_CAVE_MODE;
        keyAlternativeListPlayers = MinimapKeyMappings.ALTERNATIVE_LIST_PLAYERS;
        keyToggleTrackedPlayersOnMap = MinimapKeyMappings.TOGGLE_TRACKED_PLAYERS_MAP;
        keyToggleTrackedPlayersInWorld = MinimapKeyMappings.TOGGLE_TRACKED_PLAYERS_WORLD;
        keyToggleTrackedPlayers = MinimapKeyMappings.TOGGLE_TRACKED_PLAYERS_MAP;
        minimapItemId = null;
        minimapItem = null;
        serverSlimeSeeds = new HashMap();
        distanceTypes = new String[]{"gui.xaero_off", "gui.xaero_looking_at", "gui.xaero_all"};
        blockColourTypes = new String[]{"gui.xaero_accurate", "gui.xaero_vanilla"};
        settingsButton = false;
        updateNotification = true;
        ENTITY_ICONS_OPTIONS = new String[]{"gui.xaero_icons_off", "gui.xaero_icons_list", "gui.xaero_icons_always", "-"};
        SLOPES_MODES = new String[]{"gui.xaero_off", "gui.xaero_slopes_legacy", "gui.xaero_slopes_default_3d", "gui.xaero_slopes_default_2d"};
        ENTITY_NAMES_OPTIONS = new String[]{"gui.xaero_names_off", "gui.xaero_names_list", "gui.xaero_names_always", "-"};
        SHOW_LIGHT_LEVEL_NAMES = new String[]{"gui.xaero_off", "gui.xaero_light_block", "gui.xaero_light_sky", "gui.xaero_light_all", "gui.xaero_light_both2"};
        MINIMAP_SHAPES = new String[]{"gui.xaero_minimap_shape_square", "gui.xaero_minimap_shape_circle"};
        DOTS_STYLES = new String[]{"gui.xaero_dots_style_default", "gui.xaero_dots_style_legacy"};
        PUSHBOX_OPTIONS = new String[]{"gui.xaero_off", "gui.xaero_pushbox_normal", "gui.xaero_pushbox_screen_height"};
        FRAME_OPTIONS = new String[]{"gui.xaero_minimap_frame_default", "gui.xaero_minimap_frame_colored_thick", "gui.xaero_minimap_frame_colored_thin", "gui.xaero_off"};
        COMPASS_OPTIONS = new String[]{"gui.xaero_off", "gui.xaero_minimap_compass_inside_frame", "gui.xaero_minimap_compass_on_frame"};
        MULTIPLE_WAYPOINT_INFO = new String[]{"gui.xaero_off", "gui.xaero_while_sneaking", "gui.xaero_multiple_waypoints_always"};
        RADAR_OVER_MAP_OPTIONS = new String[]{"gui.xaero_radar_over_map_never", "gui.xaero_radar_over_map_list", "gui.xaero_radar_over_map_always", "-"};
        OLD_MINIMAP_SIZES = new int[]{57, 85, 113, 169};
    }
}

