/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui.entry;

import java.util.function.Supplier;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.common.graphics.CursorBox;
import xaero.hud.category.ObjectCategory;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.ConnectionLineType;
import xaero.hud.category.ui.entry.EditorListEntry;
import xaero.hud.category.ui.entry.EditorListEntryTextWithAction;
import xaero.hud.category.ui.entry.EditorListRootEntry;
import xaero.hud.category.ui.entry.EditorListTextButtonEntry;
import xaero.hud.category.ui.node.EditorCategoryNode;
import xaero.hud.category.ui.node.EditorSettingsNode;

public class EditorListEntryCategory<C extends ObjectCategory<?, C>, ED extends EditorCategoryNode<C, ?, ED>>
extends EditorListRootEntry {
    private static final CursorBox HELP_TOOLTIP = new CursorBox("gui.xaero_category_help2", null, true);
    private static final CursorBox PROTECTED_TOOLTIP = new CursorBox("gui.xaero_category_protected_category", null, true);
    private static final CursorBox UP_TOOLTIP = new CursorBox("gui.xaero_category_category_move_up", null, true);
    private static final CursorBox DOWN_TOOLTIP = new CursorBox("gui.xaero_category_category_move_down", null, true);

    public EditorListEntryCategory(int screenWidth, int index, GuiCategoryEditor.SettingRowList rowList, ConnectionLineType lineType, EditorCategoryNode<?, ?, ?> node, EditorCategoryNode<?, ?, ?> parent, Supplier<CursorBox> tooltipSupplier, boolean isFinalExpanded) {
        super(screenWidth, index, rowList, lineType, node);
        int subIndex = parent == null ? -1 : parent.getSubCategories().indexOf(node);
        EditorCategoryNode<?, ?, ?> dataCast = node;
        EditorCategoryNode<?, ?, ?> parentCast = parent;
        GuiCategoryEditor.SettingRowList rowListCast = rowList;
        boolean isCut = rowListCast.isCut(dataCast);
        Object currentCut = rowListCast.getCut();
        this.withSubEntry(this.getCategoryNameEntryFactory(dataCast, rowListCast, isCut, tooltipSupplier));
        EditorListRootEntry.CenteredEntryFactory pasteEntryFactory = this.getPasteEntryFactory(currentCut, isCut, dataCast, rowListCast);
        if (dataCast.isExpanded() || !dataCast.isMovable()) {
            if (rowListCast.hasCut()) {
                this.withSubEntry(pasteEntryFactory);
            }
            if (isFinalExpanded) {
                this.addHelpElement(HELP_TOOLTIP);
            }
            return;
        }
        if (!((EditorSettingsNode)dataCast.getSettingsNode()).getProtection()) {
            this.withSubEntry(this.getDuplicateEntryFactory(subIndex, parentCast, rowListCast));
        }
        if (rowListCast.hasCut()) {
            this.withSubEntry(pasteEntryFactory);
        }
        if (((EditorSettingsNode)dataCast.getSettingsNode()).getProtection()) {
            this.withSubEntry(this.getProtectedEntryFactory());
            return;
        }
        if (!rowListCast.hasCut()) {
            this.withSubEntry(this.getCutEntryFactory(dataCast, parentCast, rowListCast));
        }
        if (parent.getSubCategories().size() <= 1) {
            return;
        }
        this.withSubEntry(this.getPriorityEntryFactory(-1, parentCast, subIndex));
        this.withSubEntry(this.getPriorityEntryFactory(1, parentCast, subIndex));
    }

    private EditorListRootEntry.CenteredEntryFactory getCategoryNameEntryFactory(ED dataCast, final GuiCategoryEditor.SettingRowList rowListCast, final boolean isCut, Supplier<CursorBox> tooltipSupplier) {
        return new EditorListRootEntry.CenteredEntryFactory((EditorCategoryNode)dataCast, tooltipSupplier){
            final /* synthetic */ EditorCategoryNode val$dataCast;
            final /* synthetic */ Supplier val$tooltipSupplier;
            {
                this.val$dataCast = editorCategoryNode;
                this.val$tooltipSupplier = supplier;
            }

            @Override
            public EditorListEntry get(int x, int y, int w, int h, EditorListRootEntry root) {
                Runnable action = isCut ? new Runnable(){

                    @Override
                    public void run() {
                        rowListCast.pasteTo(val$dataCast);
                    }
                } : this.val$dataCast.getExpandAction(rowListCast);
                EditorListEntryTextWithAction result = new EditorListEntryTextWithAction(x, y, w, h, EditorListEntryCategory.this.index, EditorListEntryCategory.this.rowList, EditorListEntryCategory.this, action, (Supplier<CursorBox>)this.val$tooltipSupplier);
                if (isCut) {
                    result.setColor(-5636096);
                    result.setHoverColor(-43691);
                }
                return result;
            }
        };
    }

    private EditorListRootEntry.CenteredEntryFactory getPasteEntryFactory(ED currentCut, boolean isCut, ED dataCast, GuiCategoryEditor.SettingRowList rowListCast) {
        CursorBox pasteTooltip = this.getPasteTooltip(currentCut, isCut);
        if (pasteTooltip != null) {
            pasteTooltip.setAutoLinebreak(false);
        }
        return new EditorListRootEntry.CenteredEntryFactory((EditorCategoryNode)dataCast, rowListCast, pasteTooltip){
            final /* synthetic */ EditorCategoryNode val$dataCast;
            final /* synthetic */ GuiCategoryEditor.SettingRowList val$rowListCast;
            final /* synthetic */ CursorBox val$pasteTooltip;
            {
                this.val$dataCast = editorCategoryNode;
                this.val$rowListCast = settingRowList;
                this.val$pasteTooltip = cursorBox;
            }

            @Override
            public EditorListEntry get(int x, int y, int w, int h, EditorListRootEntry root) {
                return new EditorListTextButtonEntry(x + 248, y + 2, EditorListEntryCategory.this.index, EditorListEntryCategory.this.rowList, "\u25c4", -5592406, -1, 5, this.val$dataCast.getPasteAction(this.val$rowListCast), EditorListEntryCategory.this, this.val$pasteTooltip);
            }
        };
    }

    private CursorBox getPasteTooltip(ED currentCut, boolean isCut) {
        if (currentCut == null) {
            return null;
        }
        if (isCut) {
            return new CursorBox("gui.xaero_category_paste_cancel", null, true);
        }
        TextComponentTranslation component = new TextComponentTranslation("gui.xaero_category_paste", new Object[]{new TextComponentTranslation(((EditorCategoryNode)currentCut).getDisplayName(), new Object[0]), new TextComponentTranslation(this.node.getDisplayName(), new Object[0])});
        return new CursorBox((ITextComponent)component, true);
    }

    private EditorListRootEntry.CenteredEntryFactory getDuplicateEntryFactory(int subIndex, ED parentCast, GuiCategoryEditor.SettingRowList rowListCast) {
        TextComponentTranslation duplicateTooltipComponent = new TextComponentTranslation("gui.xaero_category_duplicate", new Object[]{new TextComponentTranslation(this.node.getDisplayName(), new Object[0])});
        CursorBox duplicateTooltip = new CursorBox((ITextComponent)duplicateTooltipComponent, true);
        duplicateTooltip.setAutoLinebreak(false);
        return new EditorListRootEntry.CenteredEntryFactory((EditorCategoryNode)parentCast, subIndex, rowListCast, duplicateTooltip){
            final /* synthetic */ EditorCategoryNode val$parentCast;
            final /* synthetic */ int val$subIndex;
            final /* synthetic */ GuiCategoryEditor.SettingRowList val$rowListCast;
            final /* synthetic */ CursorBox val$duplicateTooltip;
            {
                this.val$parentCast = editorCategoryNode;
                this.val$subIndex = n;
                this.val$rowListCast = settingRowList;
                this.val$duplicateTooltip = cursorBox;
            }

            @Override
            public EditorListEntry get(int x, int y, int w, int h, EditorListRootEntry root) {
                return new EditorListTextButtonEntry(x + 230, y + 2, EditorListEntryCategory.this.index, EditorListEntryCategory.this.rowList, "+", -5592406, -1, 5, this.val$parentCast.getDuplicateAction(this.val$subIndex, this.val$rowListCast), EditorListEntryCategory.this, this.val$duplicateTooltip);
            }
        };
    }

    private EditorListRootEntry.CenteredEntryFactory getProtectedEntryFactory() {
        return new EditorListRootEntry.CenteredEntryFactory(){

            @Override
            public EditorListEntry get(int x, int y, int w, int h, EditorListRootEntry root) {
                return new EditorListTextButtonEntry(x - 24, y + 2, EditorListEntryCategory.this.index, EditorListEntryCategory.this.rowList, "!", -1644980, -171, 5, new Supplier<Boolean>(){

                    @Override
                    public Boolean get() {
                        return false;
                    }
                }, EditorListEntryCategory.this, PROTECTED_TOOLTIP);
            }
        };
    }

    private EditorListRootEntry.CenteredEntryFactory getCutEntryFactory(ED dataCast, ED parentCast, GuiCategoryEditor.SettingRowList rowListCast) {
        TextComponentTranslation cutTooltipComponent = new TextComponentTranslation("gui.xaero_category_cut", new Object[]{new TextComponentTranslation(this.node.getDisplayName(), new Object[0])});
        CursorBox cutTooltip = new CursorBox((ITextComponent)cutTooltipComponent, true);
        cutTooltip.setAutoLinebreak(false);
        return new EditorListRootEntry.CenteredEntryFactory((EditorCategoryNode)dataCast, (EditorCategoryNode)parentCast, rowListCast, cutTooltip){
            final /* synthetic */ EditorCategoryNode val$dataCast;
            final /* synthetic */ EditorCategoryNode val$parentCast;
            final /* synthetic */ GuiCategoryEditor.SettingRowList val$rowListCast;
            final /* synthetic */ CursorBox val$cutTooltip;
            {
                this.val$dataCast = editorCategoryNode;
                this.val$parentCast = editorCategoryNode2;
                this.val$rowListCast = settingRowList;
                this.val$cutTooltip = cursorBox;
            }

            @Override
            public EditorListEntry get(int x, int y, int w, int h, EditorListRootEntry root) {
                return new EditorListTextButtonEntry(x + 248, y + 2, EditorListEntryCategory.this.index, EditorListEntryCategory.this.rowList, "\u25ba", -5592406, -1, 5, this.val$dataCast.getCutAction(this.val$parentCast, this.val$rowListCast), EditorListEntryCategory.this, this.val$cutTooltip);
            }
        };
    }

    private EditorListRootEntry.CenteredEntryFactory getPriorityEntryFactory(final int direction, ED parentCast, int subIndex) {
        final String label = direction < 0 ? "\u25b2" : "\u25bc";
        CursorBox tooltip = direction < 0 ? UP_TOOLTIP : DOWN_TOOLTIP;
        return new EditorListRootEntry.CenteredEntryFactory((EditorCategoryNode)parentCast, subIndex, tooltip){
            final /* synthetic */ EditorCategoryNode val$parentCast;
            final /* synthetic */ int val$subIndex;
            final /* synthetic */ CursorBox val$tooltip;
            {
                this.val$parentCast = editorCategoryNode;
                this.val$subIndex = n2;
                this.val$tooltip = cursorBox;
            }

            @Override
            public EditorListEntry get(int x, int y, int w, int h, EditorListRootEntry root) {
                return new EditorListTextButtonEntry(x - 32 + 8 * direction, y + 2, EditorListEntryCategory.this.index, EditorListEntryCategory.this.rowList, label, -5592406, -1, 5, this.val$parentCast.getMoveAction(this.val$subIndex, direction, EditorListEntryCategory.this.rowList), EditorListEntryCategory.this, this.val$tooltip);
            }
        };
    }

    @Override
    public String getMessage() {
        return "";
    }
}

