/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.form.model.part;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import xaero.common.misc.Misc;

public class ModelPartUtil {
    private static final Field CUBES_FIELD = Misc.getFieldReflection(ModelRenderer.class, "cubeList", "field_78804_l");
    private static final Field CHILDREN_FIELD = Misc.getFieldReflection(ModelRenderer.class, "childModels", "field_78805_m");

    public static List<ModelBox> getCubes(ModelRenderer modelRenderer) {
        return (List)Misc.getReflectFieldValue(modelRenderer, CUBES_FIELD);
    }

    public static List<ModelRenderer> getChildren(ModelRenderer modelRenderer) {
        return (List)Misc.getReflectFieldValue(modelRenderer, CHILDREN_FIELD);
    }

    public static boolean hasDirectCubes(ModelRenderer part) {
        List<ModelBox> cubes = ModelPartUtil.getCubes(part);
        return cubes != null && !cubes.isEmpty();
    }

    public static boolean hasCubes(ModelRenderer part) {
        if (ModelPartUtil.hasDirectCubes(part)) {
            return true;
        }
        List<ModelRenderer> children = ModelPartUtil.getChildren(part);
        if (children == null) {
            return false;
        }
        for (ModelRenderer child : children) {
            if (!ModelPartUtil.hasCubes(child)) continue;
            return true;
        }
        return false;
    }

    public static ModelBox getBiggestCuboid(ModelRenderer part) {
        List<ModelBox> mainCubeList = ModelPartUtil.getCubes(part);
        if (mainCubeList == null) {
            return null;
        }
        if (mainCubeList.isEmpty()) {
            return null;
        }
        float biggestSize = 0.0f;
        ModelBox biggestCuboid = null;
        for (ModelBox cuboid : mainCubeList) {
            float size = Math.abs((cuboid.field_78248_d - cuboid.field_78252_a) * (cuboid.field_78249_e - cuboid.field_78250_b) * (cuboid.field_78246_f - cuboid.field_78251_c));
            if (!(size >= biggestSize)) continue;
            biggestCuboid = cuboid;
            biggestSize = size;
        }
        return biggestCuboid;
    }
}

