/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.armor;

import java.util.function.Function;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import xaero.common.gui.component.CachedComponentSupplier;
import xaero.common.settings.ModSettings;

public class ArmorStatusCachedComponents {
    static final CachedComponentSupplier ARROW_COUNT;
    static final CachedComponentSupplier[] FOOD_RESTORES;
    static final CachedComponentSupplier[] DURABILITY;
    static final CachedComponentSupplier[] LABEL_WITH_COUNT;
    static final CachedComponentSupplier[] ENCHANTS;

    private static void translateEchant(StringBuilder lineBuilder, String name, int count) {
        if (name == null || name.isEmpty()) {
            return;
        }
        if (count <= 1) {
            lineBuilder.append(name);
            return;
        }
        String[] words = name.split(" ");
        for (int i = 0; i < words.length; ++i) {
            String s1 = words[i];
            if (i == words.length - 1 || s1.length() <= 2) {
                lineBuilder.append(s1);
                continue;
            }
            lineBuilder.append(s1.substring(0, 1).toUpperCase()).append(s1.substring(1, 2).toLowerCase()).append("-");
        }
    }

    static {
        int i;
        ARROW_COUNT = new CachedComponentSupplier(new Function<Object[], ITextComponent>(){

            @Override
            public ITextComponent apply(Object[] args) {
                int count = (Integer)args[0];
                int totalCount = (Integer)args[1];
                return new TextComponentString(count + "/" + totalCount);
            }
        });
        FOOD_RESTORES = new CachedComponentSupplier[32];
        DURABILITY = new CachedComponentSupplier[32];
        LABEL_WITH_COUNT = new CachedComponentSupplier[32];
        ENCHANTS = new CachedComponentSupplier[32];
        for (i = 0; i < FOOD_RESTORES.length; ++i) {
            ArmorStatusCachedComponents.FOOD_RESTORES[i] = new CachedComponentSupplier(new Function<Object[], ITextComponent>(){

                @Override
                public ITextComponent apply(Object[] args) {
                    double restoreValue = (Double)args[0];
                    TextComponentTranslation result = new TextComponentTranslation("gui.xaero_restores", new Object[0]);
                    result.func_150253_a().add(new TextComponentString(" " + restoreValue));
                    return result;
                }
            });
        }
        for (i = 0; i < DURABILITY.length; ++i) {
            ArmorStatusCachedComponents.DURABILITY[i] = new CachedComponentSupplier(new Function<Object[], ITextComponent>(){

                @Override
                public ITextComponent apply(Object[] args) {
                    int type = (Integer)args[0];
                    if (type == 3) {
                        return new TextComponentString("");
                    }
                    int maxDamage = (Integer)args[1];
                    int currentDamage = (Integer)args[2];
                    int durabilityLeft = maxDamage - currentDamage;
                    int percent = durabilityLeft * 100 / maxDamage;
                    TextComponentString result = type == 0 ? new TextComponentString(percent + "%") : (type == 1 ? new TextComponentString(durabilityLeft + "/" + maxDamage) : new TextComponentString(durabilityLeft + "/" + maxDamage + " (" + percent + "%)"));
                    if (percent <= 5) {
                        result = (TextComponentBase)result.func_150255_a(result.func_150256_b().func_150238_a(TextFormatting.LIGHT_PURPLE));
                    } else if (percent <= 25) {
                        result = (TextComponentBase)result.func_150255_a(result.func_150256_b().func_150238_a(TextFormatting.RED));
                    } else if (percent <= 50) {
                        result = (TextComponentBase)result.func_150255_a(result.func_150256_b().func_150238_a(TextFormatting.GOLD));
                    } else if (percent <= 75) {
                        result = (TextComponentBase)result.func_150255_a(result.func_150256_b().func_150238_a(TextFormatting.YELLOW));
                    }
                    return result;
                }
            });
        }
        for (i = 0; i < LABEL_WITH_COUNT.length; ++i) {
            ArmorStatusCachedComponents.LABEL_WITH_COUNT[i] = new CachedComponentSupplier(new Function<Object[], ITextComponent>(){

                @Override
                public ITextComponent apply(Object[] args) {
                    ITextComponent label = (ITextComponent)args[0];
                    int count = (Integer)args[1];
                    boolean flipped = (Boolean)args[2];
                    TextComponentTranslation result = flipped ? new TextComponentTranslation("(" + count + ") ", new Object[0]) : new TextComponentString("");
                    result.func_150253_a().add(label);
                    if (!flipped) {
                        result.func_150253_a().add(new TextComponentString(" (" + count + ")"));
                    }
                    return result;
                }
            });
        }
        for (int j = 0; j < ENCHANTS.length; ++j) {
            ArmorStatusCachedComponents.ENCHANTS[j] = new CachedComponentSupplier(new Function<Object[], ITextComponent>(){

                @Override
                public ITextComponent apply(Object[] args) {
                    NBTTagList enchants = (NBTTagList)args[0];
                    int color = (Integer)args[1];
                    int count = enchants.func_74745_c();
                    StringBuilder lineBuilder = new StringBuilder();
                    lineBuilder.append("\u00a7").append(ModSettings.ENCHANT_COLORS[color]);
                    for (int i = 0; i < count; ++i) {
                        short id = enchants.func_150305_b(i).func_74765_d("id");
                        short lvl = enchants.func_150305_b(i).func_74765_d("lvl");
                        String name = "";
                        Enchantment enchantment = Enchantment.func_185262_c((int)id);
                        if (enchantment != null) {
                            name = enchantment.func_77316_c((int)lvl);
                        }
                        if (i > 0) {
                            lineBuilder.append(", ");
                        }
                        ArmorStatusCachedComponents.translateEchant(lineBuilder, name, count);
                    }
                    String labelString = lineBuilder.toString();
                    return new TextComponentString(labelString);
                }
            });
        }
    }
}

