/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.entityinfo;

import com.google.common.collect.Ordering;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import xaero.hud.pvp.module.entityinfo.EntityInfoSession;
import xaero.hud.render.TextureLocations;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;
import xaero.pvp.BetterPVP;

public class EntityInfoRenderer
implements IModuleRenderer<EntityInfoSession> {
    private final Random random = new Random();

    @Override
    public void render(EntityInfoSession session, ModuleRenderContext c, float partialTicks) {
        EntityLivingBase displayedEntity;
        Minecraft mc = Minecraft.func_71410_x();
        long time = System.currentTimeMillis();
        RayTraceResult objectMouseOver = session.getDetector().getMouseOver(mc, (World)mc.field_71441_e, session.getEntityInfoDistance(), partialTicks);
        if (objectMouseOver != null && objectMouseOver.field_72308_g instanceof EntityLivingBase) {
            WorldServer serverWorld;
            session.setDisplayedEntity((EntityLivingBase)objectMouseOver.field_72308_g);
            if (mc.func_71401_C() != null && (serverWorld = mc.func_71401_C().func_71218_a(mc.field_71441_e.field_73011_w.getDimension())) != null) {
                session.setDisplayedServerEntity((EntityLivingBase)serverWorld.func_175733_a(objectMouseOver.field_72308_g.func_110124_au()));
            }
            session.setLastDetection(time);
        }
        if ((displayedEntity = session.getDisplayedEntity()) == null) {
            return;
        }
        if (time - session.getLastDetection() > 1000L * (long)session.getEntityInfoStay()) {
            return;
        }
        if (System.currentTimeMillis() - session.getLastEffectBlink() > 500L) {
            session.setLastEffectBlink(System.currentTimeMillis());
            session.setEffectBlink(!session.getEffectBlink());
        }
        try {
            int healthOff;
            boolean flippedVer = c.flippedVertically;
            boolean flippedHor = c.flippedHorizontally;
            float resize = 1.0f;
            if (displayedEntity.field_70130_N > resize) {
                resize = displayedEntity.field_70130_N;
            }
            if (displayedEntity.field_70131_O > resize * 2.0f) {
                resize = displayedEntity.field_70131_O / 2.0f;
            }
            if (session.getEntityInfoShowEntityModel()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
                GlStateManager.func_179126_j();
                this.drawEntityOnScreen(mc, c.x + (flippedHor ? c.w - 25 : 25), c.y + 35, (int)(30.0f / resize), displayedEntity, flippedHor);
                GlStateManager.func_179097_i();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            }
            EntityLivingBase displayedServerEntity = session.getDisplayedServerEntity();
            int n = healthOff = session.getEntityInfoShowEntityModel() ? 55 : 5;
            if (mc.func_71401_C() != null && session.getEntityInfoEffects() && displayedServerEntity != null) {
                int effectsOffset = (int)this.drawPotionEffects(mc, session, displayedServerEntity, c.x + (flippedHor ? c.w - 3 : 3), c.y + (flippedVer ? c.h - 5 : 5), flippedVer ? c.y + c.h : c.screenHeight - c.y, flippedHor, flippedVer, c.screenScale);
                if (!session.getEntityInfoShowEntityModel() && effectsOffset != -1) {
                    healthOff += 3 + effectsOffset;
                }
            }
            boolean renderedArmor = session.getEntityInfoShowArmour() && this.drawArmourBar(mc, session, displayedEntity, c.x + (flippedHor ? c.w - healthOff : healthOff), c.y + 15 + (flippedVer ? 31 : 0), flippedHor);
            this.drawHealthBar(mc, session, displayedEntity, c.x + (flippedHor ? c.w - healthOff : healthOff), c.y + 15 + (flippedVer ? 31 : 0) + (renderedArmor ? 10 : 0) * (flippedVer ? -1 : 1), flippedHor, flippedVer);
            ITextComponent component = displayedEntity.func_145748_c_();
            if (component != null) {
                String name = component.func_150254_d();
                int xCoord = c.x + (flippedHor ? c.w - healthOff - mc.field_71466_p.func_78256_a(name) : healthOff);
                mc.field_71466_p.func_175063_a(name, (float)xCoord, (float)(c.y + 5 + (flippedVer ? 52 : 0)), 0xFFFFFF);
            }
        }
        catch (Exception e) {
            BetterPVP.LOGGER.error("Please report this to Xaero96 on PlanetMinecraft/MinecraftForums/CurseForge!", (Throwable)e);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawEntityOnScreen(Minecraft mc, int x, int y, int scale, EntityLivingBase entity, boolean flip) {
        double cos;
        if (entity == null) {
            return;
        }
        RenderManager rendermanager = mc.func_175598_ae();
        if (rendermanager.field_78734_h == null) {
            return;
        }
        float yBodyRotBU = entity.field_70761_aq;
        float yRotBU = entity.field_70177_z;
        float yHeadRotBU = entity.field_70759_as;
        entity.field_70761_aq = 0.0f;
        entity.field_70177_z = 0.0f;
        entity.field_70759_as = yHeadRotBU - yBodyRotBU;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float width = entity.field_70130_N * (float)scale / 30.0f;
        if (width < 1.0f) {
            width = 1.0f;
        }
        if ((cos = Math.sqrt(2.0) / 2.0 / (double)width) > 1.0) {
            cos = 1.0;
        }
        float rotation = (float)Math.toDegrees(Math.acos(cos));
        GlStateManager.func_179114_b((float)((float)(flip ? 0 : 90) - rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(-entity.field_70131_O / 2.0f), (float)0.0f);
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        boolean hideGUIBU = mc.field_71474_y.field_74319_N;
        mc.field_71474_y.field_74319_N = true;
        try {
            GlStateManager.func_179142_g();
            RenderHelper.func_74519_b();
            rendermanager.func_188391_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        }
        finally {
            mc.field_71474_y.field_74319_N = hideGUIBU;
            rendermanager.func_178633_a(true);
            GlStateManager.func_179084_k();
            entity.field_70761_aq = yBodyRotBU;
            entity.field_70177_z = yRotBU;
            entity.field_70759_as = yHeadRotBU;
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
            GlStateManager.func_179101_C();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179090_x();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        }
    }

    public boolean drawArmourBar(Minecraft mc, EntityInfoSession session, EntityLivingBase e, int x, int y, boolean flip) {
        int armorValue = e.func_70658_aO();
        mc.func_110434_K().func_110577_a(GuiIngame.field_110324_m);
        if (armorValue > 0) {
            if (session.getEntityInfoArmourNumbers()) {
                mc.field_71456_v.func_73729_b(x - (flip ? 8 : 0), y, 34, 9, 9, 9);
                mc.field_71466_p.func_175063_a(armorValue + "/20", (float)(x + (flip ? -11 - mc.field_71466_p.func_78256_a(armorValue + "/20") : 11)), (float)y, 0xFFFFFF);
            } else {
                for (int iconIndex = 0; iconIndex < 10; ++iconIndex) {
                    int iconX = x + (flip ? -8 - iconIndex * 8 : iconIndex * 8);
                    if (iconIndex * 2 + 1 < armorValue) {
                        mc.field_71456_v.func_73729_b(iconX, y, 34, 9, 9, 9);
                        continue;
                    }
                    if (iconIndex * 2 + 1 == armorValue) {
                        mc.field_71456_v.func_73729_b(iconX, y, 25, 9, 9, 9);
                        continue;
                    }
                    if (iconIndex * 2 + 1 <= armorValue) continue;
                    mc.field_71456_v.func_73729_b(iconX, y, 16, 9, 9, 9);
                }
            }
            return true;
        }
        return false;
    }

    public void drawHealthBar(Minecraft mc, EntityInfoSession session, EntityLivingBase e, int x, int y, boolean flip, boolean vertFlipped) {
        int health = MathHelper.func_76123_f((float)e.func_110143_aJ());
        float maxHealth = MathHelper.func_76143_f((double)e.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e());
        float absorptionAmount = MathHelper.func_76123_f((float)e.func_110139_bj());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (session.getEntityInfoHealthNumbers()) {
            String text = health + "/" + (int)maxHealth;
            if (absorptionAmount > 0.0f) {
                text = text + "+" + absorptionAmount;
                health = 0;
                maxHealth = 0.0f;
                absorptionAmount = 2.0f;
            } else {
                health = 2;
                maxHealth = 2.0f;
                absorptionAmount = 0.0f;
            }
            mc.field_71466_p.func_175063_a(text, (float)(x + (flip ? -11 - mc.field_71466_p.func_78256_a(text) : 11)), (float)y, -1);
        }
        mc.func_110434_K().func_110577_a(GuiIngame.field_110324_m);
        int regularHalvesToRender = (int)(maxHealth + 1.0f) / 2 * 2;
        int regularFilledHalves = health;
        int absorptionHalvesToRender = (int)(absorptionAmount + 1.0f) / 2 * 2;
        int absorptionFilledHalves = (int)absorptionAmount;
        int limit = session.getEntityInfoMaxHearts() * 2;
        if (regularHalvesToRender > limit) {
            regularHalvesToRender = limit;
            int n = regularFilledHalves = maxHealth == 0.0f ? 0 : Math.round((float)(health * regularHalvesToRender) / maxHealth);
        }
        if (absorptionHalvesToRender > limit) {
            absorptionHalvesToRender = absorptionFilledHalves = limit;
        }
        int totalHalvesToRender = regularHalvesToRender + absorptionHalvesToRender;
        int rows = MathHelper.func_76123_f((float)((float)totalHalvesToRender / 20.0f));
        int rowStep = Math.max(10 - (rows - 2), 3);
        boolean shake = maxHealth != 0.0f && (double)health <= (double)maxHealth * 0.4;
        int absorptionLeft = absorptionFilledHalves;
        for (int heartIndex = totalHalvesToRender / 2 - 1; heartIndex >= 0; --heartIndex) {
            int rowIndex = (int)Math.ceil((float)(heartIndex + 1) / 10.0f) - 1;
            int xcoord = heartIndex % 10 * 8;
            int heartX = x + (flip ? -xcoord - 9 : xcoord);
            int heartY = y + rowIndex * rowStep * (vertFlipped ? -1 : 1);
            if (shake) {
                heartY += this.random.nextInt(2);
            }
            this.blitFlippable(heartX, heartY, 25, 0, 9, 9, flip);
            if (absorptionLeft > 0) {
                if (absorptionLeft == absorptionFilledHalves && absorptionFilledHalves % 2 == 1) {
                    this.blitFlippable(heartX, heartY, 169, 0, 9, 9, flip);
                } else {
                    this.blitFlippable(heartX, heartY, 160, 0, 9, 9, flip);
                }
                absorptionLeft -= 2;
                continue;
            }
            if (heartIndex * 2 + 1 < regularFilledHalves) {
                this.blitFlippable(heartX, heartY, 52, 0, 9, 9, flip);
            }
            if (heartIndex * 2 + 1 != regularFilledHalves) continue;
            this.blitFlippable(heartX, heartY, 61, 0, 9, 9, flip);
        }
    }

    public double drawPotionEffects(Minecraft mc, EntityInfoSession session, EntityLivingBase e, int x, int y, int h, boolean flippedHor, boolean flippedVer, double scale) {
        if (e.func_70651_bq().isEmpty()) {
            return -1.0;
        }
        List effects = Ordering.natural().sortedCopy((Iterable)e.func_70651_bq());
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179147_l();
        double pixelSize = (double)session.getEntityInfoEffectsScale() / scale * session.getAutoUIScale() / 2.0;
        double effectSize = 25.0 * pixelSize;
        int perColumn = (int)((double)h / effectSize);
        int place = 0;
        for (PotionEffect pe : effects) {
            Potion p;
            if (pe == null || !(p = pe.func_188419_a()).func_76400_d()) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)pixelSize, (double)pixelSize, (double)1.0);
            int column = place / perColumn;
            int row = place % perColumn;
            GlStateManager.func_179109_b((float)(flippedHor ? (float)(-18 - 25 * column) : (float)(25 * column)), (float)(flippedVer ? (float)(-18 - 25 * row) : (float)(25 * row)), (float)0.0f);
            if (pe.func_76459_b() <= 200 && !session.getEffectBlink()) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            }
            mc.func_110434_K().func_110577_a(TextureLocations.INV_TEXTURES);
            int iconIndex = p.func_76392_e();
            mc.field_71456_v.func_73729_b(0, 0, iconIndex % 8 * 18, 198 + iconIndex / 8 * 18, 18, 18);
            p.renderHUDEffect(pe, (Gui)mc.field_71456_v, -3, -3, 0.0f, 1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ++place;
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        int rows = (effects.size() + perColumn - 1) / perColumn;
        return effectSize * (double)rows - 7.0 * pixelSize;
    }

    public void blitFlippable(int x, int y, int textureX, int textureY, int width, int height, boolean flip) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + (flip ? width : 0)) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + (flip ? 0 : width)) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_187315_a((double)((float)(textureX + (flip ? 0 : width)) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_187315_a((double)((float)(textureX + (flip ? width : 0)) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }
}

