/*
 * Decompiled with CFR 0.152.
 */
package xaero.pvp;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapCommonBase;
import xaero.common.XaeroMinimapSession;
import xaero.common.command.CommandXaero;
import xaero.common.controls.ControlsRegister;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.events.ForgeEventHandler;
import xaero.common.file.SimpleBackup;
import xaero.common.gui.GuiHelper;
import xaero.common.gui.widget.WidgetLoadingHandler;
import xaero.common.gui.widget.WidgetScreenHandler;
import xaero.common.interfaces.InterfaceManager;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.message.LevelMapPropertiesConsumer;
import xaero.common.misc.Internet;
import xaero.common.mods.SupportMods;
import xaero.common.server.XaeroMinimapServer;
import xaero.common.server.core.XaeroMinimapServerCore;
import xaero.common.server.level.LevelMapProperties;
import xaero.common.settings.ModSettings;
import xaero.common.validator.FieldValidatorHolder;
import xaero.common.validator.NumericFieldValidator;
import xaero.patreon.Patreon7;
import xaero.patreon.PatreonMod4;
import xaero.pvp.BetterPVPClient;
import xaero.pvp.BetterPVPSession;
import xaero.pvp.controls.BPVPControlsRegister;
import xaero.pvp.events.BPVPEvents;
import xaero.pvp.events.BPVPFMLEvents;
import xaero.pvp.gui.BPVPGuiHelper;
import xaero.pvp.interfaces.BPVPInterfaceHandler;
import xaero.pvp.interfaces.BPVPInterfaceLoader;
import xaero.pvp.settings.BPVPModSettings;

@Mod(modid="XaeroBetterPvP", name="Better PvP", version="21.10.44", guiFactory="xaero.pvp.gui.ConfigGuiFactory", acceptedMinecraftVersions="[1.7.10]", acceptableRemoteVersions="*")
public class BetterPVP
implements IXaeroMinimap {
    @Mod.Instance(value="XaeroBetterPvP")
    public static BetterPVP instance;
    private static final String versionID_minecraft = "1.7.10";
    private static final String versionID_mod;
    private static final boolean versionID_fair;
    public static final String versionID;
    private int newestUpdateID;
    private boolean isOutdated = true;
    public static String fileLayoutID;
    private String latestVersion;
    private String latestVersionMD5;
    private ModSettings settings;
    private String message = "";
    private ControlsRegister controlsRegister;
    private ForgeEventHandler events;
    protected InterfaceRenderer interfaceRenderer;
    protected InterfaceManager interfaces;
    private GuiHelper guiHelper;
    private FieldValidatorHolder fieldValidators;
    private SupportMods supportMods;
    private WidgetScreenHandler widgetScreenHandler;
    private WidgetLoadingHandler widgetLoader;
    private File modJAR = null;
    private File configFile;
    public File waypointsFile;
    public File waypointsFolder;
    private static SimpleNetworkWrapper network;
    private XaeroMinimapServer minimapServer;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws IOException {
        Path waypointTempToAddFolder;
        SupportMods.checkForMinimapDuplicates();
        network = NetworkRegistry.INSTANCE.newSimpleChannel("xaerominimap:main");
        if (event.getSide() == Side.SERVER) {
            return;
        }
        if (event.getSourceFile().getName().endsWith(".jar")) {
            this.modJAR = event.getSourceFile();
        }
        Path gameDir = Minecraft.func_71410_x().field_71412_D.toPath();
        Path config = event.getModConfigurationDirectory().toPath();
        this.waypointsFile = config.resolve("xaerowaypoints.txt").toFile();
        String modId = this.getClass().getAnnotation(Mod.class).modid();
        new BetterPVPClient().preInit(event, modId, this);
        Path wrongWaypointsFolder3 = config.resolve("XaeroWaypoints");
        Path wrongWaypointsFolder2 = this.modJAR != null ? this.modJAR.toPath().getParent().resolve("XaeroWaypoints") : config.getParent().resolve("mods").resolve("XaeroWaypoints");
        Path wrongWaypointsFolder4 = new File(config.toFile().getCanonicalPath()).toPath().getParent().resolve("XaeroWaypoints");
        Path wrongWaypointsFolder5 = config.getParent().resolve("XaeroWaypoints");
        this.waypointsFolder = gameDir.resolve("XaeroWaypoints").toAbsolutePath().toFile();
        if (wrongWaypointsFile.exists() && !this.waypointsFile.exists()) {
            Files.move(wrongWaypointsFile.toPath(), this.waypointsFile.toPath(), new CopyOption[0]);
        }
        if (wrongWaypointsFolder.exists() && !this.waypointsFolder.exists()) {
            Files.move(wrongWaypointsFolder.toPath(), this.waypointsFolder.toPath(), new CopyOption[0]);
        } else if (wrongWaypointsFolder2.toFile().exists() && !this.waypointsFolder.exists()) {
            Files.move(wrongWaypointsFolder2, this.waypointsFolder.toPath(), new CopyOption[0]);
        } else if (wrongWaypointsFolder3.toFile().exists() && !this.waypointsFolder.exists()) {
            Files.move(wrongWaypointsFolder3, this.waypointsFolder.toPath(), new CopyOption[0]);
        } else if (wrongWaypointsFolder4.toFile().exists() && !this.waypointsFolder.exists()) {
            Files.move(wrongWaypointsFolder4, this.waypointsFolder.toPath(), new CopyOption[0]);
        } else if (wrongWaypointsFolder5.toFile().exists() && !this.waypointsFolder.exists()) {
            Files.move(wrongWaypointsFolder5, this.waypointsFolder.toPath(), new CopyOption[0]);
        }
        Path waypointsFolderBackup062020 = this.waypointsFolder.toPath().resolveSibling(this.waypointsFolder.getName() + "_BACKUP032021");
        if (!Files.exists(waypointsFolderBackup062020, new LinkOption[0]) && this.waypointsFolder.exists()) {
            System.out.println("Backing up XaeroWaypoints...");
            SimpleBackup.copyDirectoryWithContents(this.waypointsFolder.toPath(), waypointsFolderBackup062020, 32, new CopyOption[0]);
            System.out.println("Done backing up XaeroWaypoints!");
        }
        this.configFile = config.resolve("pvpsettings.txt").toFile();
        File oldConfigFile = gameDir.resolve("config").resolve("pvpsettings.txt").toFile();
        if (oldConfigFile.exists() && !this.configFile.exists()) {
            Files.move(oldConfigFile.toPath(), this.configFile.toPath(), new CopyOption[0]);
        }
        if (Files.exists(waypointTempToAddFolder = this.waypointsFolder.toPath().resolve("temp_to_add"), new LinkOption[0])) {
            ModSettings.copyTempFilesBack(waypointTempToAddFolder);
        }
    }

    @Override
    public String getVersionsURL() {
        return "http://data.chocolateminecraft.com/Versions_" + Patreon7.KEY_VERSION + "/BetterPvPMod.txt";
    }

    @Override
    public String getUpdateLink() {
        return "http://chocolateminecraft.com/update/bpvp.html";
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) throws IOException {
        new XaeroMinimapCommonBase().setup(event);
        if (event.getSide() == Side.SERVER) {
            this.minimapServer = new XaeroMinimapServer(this);
            this.minimapServer.load(event);
            XaeroMinimapServerCore.minimapServer = this.minimapServer;
            return;
        }
        Patreon7.checkPatreon();
        this.widgetScreenHandler = new WidgetScreenHandler();
        this.widgetLoader = new WidgetLoadingHandler(this.widgetScreenHandler);
        this.settings = new BPVPModSettings(this);
        this.controlsRegister = new BPVPControlsRegister();
        this.guiHelper = new BPVPGuiHelper(this);
        this.fieldValidators = new FieldValidatorHolder(new NumericFieldValidator());
        this.interfaceRenderer = new InterfaceRenderer(this);
        BPVPInterfaceLoader interfaceLoader = new BPVPInterfaceLoader(this);
        this.interfaces = new BPVPInterfaceHandler(this, interfaceLoader);
        XaeroMinimapCore.modMain = this;
        File old_optionsFile = Minecraft.func_71410_x().field_71412_D.toPath().resolve("pvpsettings.txt").toFile();
        if (old_optionsFile.exists() && !this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            Files.move(old_optionsFile.toPath(), this.configFile.toPath(), new CopyOption[0]);
        }
        if (old_waypointsFile.exists() && !this.waypointsFile.exists()) {
            this.waypointsFile.getParentFile().mkdirs();
            Files.move(old_waypointsFile.toPath(), this.waypointsFile.toPath(), new CopyOption[0]);
        }
    }

    @Mod.EventHandler
    public void load(FMLPostInitializationEvent event) throws IOException {
        PatreonMod4 patreonEntry;
        if (event.getSide() == Side.SERVER) {
            this.minimapServer.loadLater();
            this.minimapServer = null;
            return;
        }
        this.events = new BPVPEvents(this);
        MinecraftForge.EVENT_BUS.register((Object)this.events);
        FMLCommonHandler.instance().bus().register((Object)new BPVPFMLEvents(this));
        network.registerMessage(LevelMapPropertiesConsumer.class, LevelMapProperties.class, 0, Side.CLIENT);
        this.settings.loadSettings();
        Internet.checkModVersion(this);
        if (this.isOutdated && (patreonEntry = this.getPatreon()) != null) {
            patreonEntry.modJar = this.modJAR;
            patreonEntry.currentVersion = versionID;
            patreonEntry.latestVersion = this.latestVersion;
            patreonEntry.md5 = this.latestVersionMD5;
            patreonEntry.onVersionIgnore = new Runnable(){

                @Override
                public void run() {
                    ModSettings.ignoreUpdate = BetterPVP.this.newestUpdateID;
                    try {
                        BetterPVP.this.getSettings().saveSettings();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            Patreon7.addOutdatedMod(patreonEntry);
        }
        this.supportMods = new SupportMods(this);
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandXaero(this));
    }

    @Override
    public SimpleNetworkWrapper getNetwork() {
        return network;
    }

    @Override
    public String getFileLayoutID() {
        return fileLayoutID;
    }

    @Override
    public File getConfigFile() {
        return this.configFile;
    }

    @Override
    public File getModJAR() {
        return this.modJAR;
    }

    public BPVPModSettings getBPVPSettings() {
        return (BPVPModSettings)this.settings;
    }

    @Override
    public ModSettings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(ModSettings minimapSettings) {
        this.settings = minimapSettings;
    }

    @Override
    public void resetSettings() throws IOException {
        this.settings = new BPVPModSettings(this);
        this.settings.loadDefaultSettings();
    }

    @Override
    public boolean isOutdated() {
        return this.isOutdated;
    }

    @Override
    public void setOutdated(boolean value) {
        this.isOutdated = value;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String string) {
        this.message = string;
    }

    @Override
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public void setLatestVersion(String string) {
        this.latestVersion = string;
    }

    @Override
    public int getNewestUpdateID() {
        return this.newestUpdateID;
    }

    @Override
    public void setNewestUpdateID(int parseInt) {
        this.newestUpdateID = parseInt;
    }

    @Override
    public PatreonMod4 getPatreon() {
        return Patreon7.mods.get(fileLayoutID);
    }

    @Override
    public String getVersionID() {
        return versionID;
    }

    @Override
    public Object getSettingsKey() {
        return BPVPControlsRegister.keyBindSettings;
    }

    @Override
    public File getWaypointsFile() {
        return this.waypointsFile;
    }

    @Override
    public File getWaypointsFolder() {
        return this.waypointsFolder;
    }

    @Override
    public WidgetScreenHandler getWidgetScreenHandler() {
        return this.widgetScreenHandler;
    }

    @Override
    public WidgetLoadingHandler getWidgetLoader() {
        return this.widgetLoader;
    }

    @Override
    public XaeroMinimapSession createSession() {
        return new BetterPVPSession(this);
    }

    @Override
    public SupportMods getSupportMods() {
        return this.supportMods;
    }

    @Override
    public GuiHelper getGuiHelper() {
        return this.guiHelper;
    }

    @Override
    public FieldValidatorHolder getFieldValidators() {
        return this.fieldValidators;
    }

    @Override
    public ControlsRegister getControlsRegister() {
        return this.controlsRegister;
    }

    @Override
    public ForgeEventHandler getEvents() {
        return this.events;
    }

    @Override
    public InterfaceManager getInterfaces() {
        return this.interfaces;
    }

    @Override
    public InterfaceRenderer getInterfaceRenderer() {
        return this.interfaceRenderer;
    }

    @Override
    public void setLatestVersionMD5(String string) {
        this.latestVersionMD5 = string;
    }

    @Override
    public String getLatestVersionMD5() {
        return this.latestVersionMD5;
    }

    static {
        versionID_mod = BetterPVP.class.getAnnotation(Mod.class) == null ? null : BetterPVP.class.getAnnotation(Mod.class).version();
        versionID_fair = BetterPVP.class.getAnnotation(Mod.class) == null ? false : BetterPVP.class.getAnnotation(Mod.class).modid().endsWith("Fair");
        versionID = "1.7.10_" + versionID_mod + (versionID_fair ? "_fair" : "");
        fileLayoutID = versionID_fair ? "bpvpfair" : "bpvp";
    }
}

