/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.twm.entity;

import net.mcreator.twm.init.TwmModEntities;
import net.mcreator.twm.init.TwmModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;

public class Mol1Entity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)TwmModItems.MOLOTOVCOCKTAIL.get());

    public Mol1Entity(EntityType<? extends Mol1Entity> type, Level level) {
        super(type, level);
    }

    public Mol1Entity(EntityType<? extends Mol1Entity> type, double x, double y, double z, Level level) {
        super(type, x, y, z, level, PROJECTILE_ITEM, PROJECTILE_ITEM);
    }

    public Mol1Entity(EntityType<? extends Mol1Entity> type, LivingEntity shooter, Level level) {
        super(type, shooter, level, PROJECTILE_ITEM, PROJECTILE_ITEM);
    }

    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return PROJECTILE_ITEM;
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void onHitBlock(BlockHitResult hit) {
        super.onHitBlock(hit);
        Level level = this.level();
        if (level.isClientSide()) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        RandomSource random = server.getRandom();
        BlockPos origin = hit.getBlockPos().relative(hit.getDirection());
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos pos = origin.offset(dx, 0, dz);
                if (!server.isEmptyBlock(pos) || !Blocks.FIRE.defaultBlockState().canSurvive((LevelReader)server, pos)) continue;
                server.setBlock(pos, Blocks.FIRE.defaultBlockState(), 3);
            }
        }
        int radius = 4 + random.nextInt(3);
        for (int i = 0; i < 40 + random.nextInt(30); ++i) {
            BlockPos pos;
            int x = origin.getX() + random.nextInt(radius * 2 + 1) - radius;
            int z = origin.getZ() + random.nextInt(radius * 2 + 1) - radius;
            int y = origin.getY() - random.nextInt(2);
            if (random.nextFloat() > 0.6f || !server.isEmptyBlock(pos = new BlockPos(x, y, z)) || !Blocks.FIRE.defaultBlockState().canSurvive((LevelReader)server, pos)) continue;
            server.setBlock(pos, Blocks.FIRE.defaultBlockState(), 3);
        }
        for (int layer = 0; layer < 4; ++layer) {
            server.sendParticles((ParticleOptions)ParticleTypes.FLAME, (double)origin.getX() + 0.5, (double)origin.getY() + 0.2 + (double)layer * 0.3, (double)origin.getZ() + 0.5, 80, 0.8, 0.3, 0.8, 0.05);
            server.sendParticles((ParticleOptions)ParticleTypes.LAVA, (double)origin.getX() + 0.5, (double)origin.getY() + 0.4, (double)origin.getZ() + 0.5, 25, 0.4, 0.2, 0.4, 0.02);
            server.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)origin.getX() + 0.5, (double)origin.getY() + 1.0 + (double)layer * 0.6, (double)origin.getZ() + 0.5, 35, 0.7, 0.5, 0.7, 0.01);
        }
        server.playSound(null, origin, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"minecraft:block.glass.break")), SoundSource.BLOCKS, 1.3f, 0.7f + random.nextFloat() * 0.4f);
        this.discard();
    }

    public void tick() {
        super.tick();
        if (this.inGround) {
            this.discard();
        }
    }

    public static Mol1Entity shoot(Level level, LivingEntity shooter, RandomSource random, float pullingPower) {
        return Mol1Entity.shoot(level, shooter, random, pullingPower, 1.0);
    }

    public static Mol1Entity shoot(Level level, LivingEntity shooter, RandomSource random, float power, double damage) {
        Mol1Entity molotov = new Mol1Entity((EntityType<? extends Mol1Entity>)((EntityType)TwmModEntities.MOL_1.get()), shooter, level);
        molotov.shoot(shooter.getViewVector((float)1.0f).x, shooter.getViewVector((float)1.0f).y, shooter.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        molotov.setSilent(true);
        molotov.setCritArrow(true);
        molotov.setBaseDamage(damage);
        molotov.igniteForSeconds(5.0f);
        level.addFreshEntity((Entity)molotov);
        return molotov;
    }
}

