/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.twm.init;

import net.mcreator.twm.potion.AlcolismMobEffect;
import net.mcreator.twm.potion.ArmorPlusMobEffect;
import net.mcreator.twm.potion.BrokenArmorMobEffect;
import net.mcreator.twm.potion.EBleedingMobEffect;
import net.mcreator.twm.potion.LunarGraceMobEffect;
import net.mcreator.twm.potion.TorporMobEffect;
import net.mcreator.twm.potion.VicioMobEffect;
import net.mcreator.twm.potion.WildToxinMobEffect;
import net.mcreator.twm.procedures.VicioQuandoOEfeitoExpiraProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class TwmModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"twm");
    public static final DeferredHolder<MobEffect, MobEffect> WILD_TOXIN = REGISTRY.register("wild_toxin", () -> new WildToxinMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> TORPOR = REGISTRY.register("torpor", () -> new TorporMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> VICIO = REGISTRY.register("vicio", () -> new VicioMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ALCOLISM = REGISTRY.register("alcolism", () -> new AlcolismMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> LUNAR_GRACE = REGISTRY.register("lunar_grace", () -> new LunarGraceMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ARMOR_PLUS = REGISTRY.register("armor_plus", () -> new ArmorPlusMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BROKEN_ARMOR = REGISTRY.register("broken_armor", () -> new BrokenArmorMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> E_BLEEDING = REGISTRY.register("e_bleeding", () -> new EBleedingMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            TwmModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            TwmModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(VICIO)) {
            VicioQuandoOEfeitoExpiraProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), entity);
        }
    }
}

