/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.client;

import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.item.Scroll;
import java.util.List;
import java.util.logging.Logger;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Requirement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class Tooltip {
    private static final Logger LOGGER = Logger.getLogger(Tooltip.class.getName());
    private boolean isTaczLoaded = ModList.get().isLoaded("tacz");
    private boolean isIronsLoaded = ModList.get().isLoaded("irons_spellbooks");

    @SubscribeEvent
    public void onTooltipDisplay(ItemTooltipEvent event) {
        Requirement[] requirements;
        Item tag;
        ResourceLocation baseKey;
        if (Minecraft.getInstance().player == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        ResourceLocation effectiveKey = baseKey = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (this.isTaczLoaded && baseKey != null && "tacz".equals(baseKey.getNamespace())) {
            CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            CompoundTag compoundTag = tag = data != null ? data.copyTag() : null;
            if (tag != null && tag.contains("GunId", 8)) {
                String rawId = tag.getString("GunId");
                String cleanId = rawId.replace("tacz:", "").replace("tacz", "");
                effectiveKey = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"%s__%s".formatted(baseKey.getPath(), cleanId));
            }
        }
        if (this.isIronsLoaded && (tag = stack.getItem()) instanceof Scroll) {
            AbstractSpell spell;
            String[] split;
            Scroll scroll = (Scroll)tag;
            SpellData spellAtIndex = ISpellContainer.get((ItemStack)stack).getSpellAtIndex(0);
            if (spellAtIndex != null && spellAtIndex.getSpell() != null && (split = (spell = spellAtIndex.getSpell()).getSpellId().split(":")).length == 2) {
                effectiveKey = ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"scroll__%s_%d".formatted(split[1], spellAtIndex.getLevel()));
            }
        }
        if ((requirements = Configuration.getRequirements(effectiveKey)) != null) {
            List tooltips = event.getToolTip();
            tooltips.add(Component.literal((String)""));
            tooltips.add(Component.translatable((String)"tooltip.requirements").append(":").withStyle(ChatFormatting.GRAY));
            SkillModel skillModel = SkillModel.get((Player)Minecraft.getInstance().player);
            for (Requirement req : requirements) {
                boolean meets = skillModel.getSkillLevel(req.skill) >= req.level;
                tooltips.add(Component.translatable((String)req.skill.displayName).append(" " + req.level).withStyle(meets ? ChatFormatting.GREEN : ChatFormatting.RED));
            }
        }
    }
}

