/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.client.compat.jade;

import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Requirement;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import snownee.jade.api.ITooltip;

public class RequirementTooltipHelper {
    public static void appendRequirements(ITooltip tooltip, Player player, ResourceLocation key) {
        if (player == null || key == null) {
            return;
        }
        Requirement[] requirements = Configuration.getRequirements(key);
        if (requirements == null || requirements.length == 0) {
            return;
        }
        SkillModel skillModel = SkillModel.get(player);
        if (skillModel == null) {
            return;
        }
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"tooltip.requirements").append(":").withStyle(ChatFormatting.GRAY));
        for (Requirement req : requirements) {
            boolean meets = skillModel.getSkillLevel(req.skill) >= req.level;
            MutableComponent line = Component.translatable((String)req.skill.displayName).append(" " + req.level).withStyle(meets ? ChatFormatting.GREEN : ChatFormatting.RED);
            tooltip.add((Component)line);
        }
    }
}

