/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.client.screen.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.client.screen.SkillScreen;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.bandit.reskillable.common.commands.skills.SkillAttributeBonus;
import net.bandit.reskillable.common.network.payload.RequestLevelUp;
import net.bandit.reskillable.common.network.payload.TogglePerk;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SkillButton
extends Button {
    private final Skill skill;
    private boolean gateBlocked = false;
    private Component gateMissing = null;
    private List<Component> tooltipLines = List.of();

    public SkillButton(int x, int y, Skill skill) {
        super(new Button.Builder((Component)Component.literal((String)""), onPress -> RequestLevelUp.send(skill)).pos(x, y).size(79, 32));
        this.skill = skill;
    }

    public Skill getSkill() {
        return this.skill;
    }

    public void setGateBlocked(boolean blocked, Component missingList) {
        this.gateBlocked = blocked;
        this.gateMissing = missingList;
    }

    public void renderWidget(@NotNull GuiGraphics g, int mouseX, int mouseY, float pt) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer clientPlayer = mc.player;
        if (clientPlayer == null) {
            return;
        }
        SkillModel model = SkillModel.get((Player)clientPlayer);
        if (model == null) {
            return;
        }
        Font font = mc.font;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        g.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SkillScreen.RESOURCES);
        int level = model.getSkillLevel(this.skill);
        int maxLevel = Configuration.getMaxLevel();
        int u = ((int)Math.ceil((double)level * 4.0 / (double)maxLevel) - 1) * 16 + 176;
        int v = this.skill.index * 16 + 128;
        g.blit(SkillScreen.RESOURCES, this.getX(), this.getY(), 176, (level == maxLevel ? 64 : 0) + (this.isMouseOver(mouseX, mouseY) ? 32 : 0), this.width, this.height);
        g.blit(SkillScreen.RESOURCES, this.getX() + 6, this.getY() + 8, u, v, 16, 16);
        if (!model.isPerkEnabled(this.skill) && SkillAttributeBonus.getBySkill(this.skill) != null) {
            g.drawString(font, "\u2716", this.getX() + this.width - 10, this.getY() + this.height - 10, 0xFF5555, false);
        }
        g.drawString(font, (Component)Component.translatable((String)this.skill.getDisplayName()), this.getX() + 25, this.getY() + 7, 0xFFFFFF, false);
        g.drawString(font, (Component)Component.literal((String)(level + "/" + maxLevel)), this.getX() + 25, this.getY() + 18, 0xBEBEBE, false);
        if (this.gateBlocked) {
            g.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -2013265920);
            g.drawString(font, "\ud83d\udd12", this.getX() + this.width - 12, this.getY() + 3, -2316726, false);
        }
        this.tooltipLines = this.isMouseOver(mouseX, mouseY) ? this.getTooltipLines((Player)clientPlayer) : List.of();
    }

    public void updateWidgetNarration(@NotNull NarrationElementOutput output) {
        this.defaultButtonNarrationText(output);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!(this.active && this.visible && this.isMouseOver(mouseX, mouseY))) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        SkillModel model = SkillModel.get((Player)player);
        if (model == null) {
            return false;
        }
        if (button == 1) {
            if (SkillAttributeBonus.getBySkill(this.skill) != null) {
                TogglePerk.send(this.skill);
                player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.6f, 1.0f);
            }
            return true;
        }
        if (button == 0) {
            if (this.gateBlocked) {
                player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.35f, 0.6f);
                return true;
            }
            int level = model.getSkillLevel(this.skill);
            int cost = Configuration.calculateCostForLevel(level);
            int playerXP = this.getPlayerTotalXP((Player)player);
            if (!player.isCreative() && playerXP < cost) {
                player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.35f, 0.6f);
                return true;
            }
            RequestLevelUp.send(this.skill);
            return true;
        }
        return false;
    }

    public List<Component> getTooltipLines(Player player) {
        SkillModel model = SkillModel.get(player);
        if (model == null) {
            return List.of();
        }
        ArrayList<Component> lines = new ArrayList<Component>();
        int level = model.getSkillLevel(this.skill);
        int cost = Configuration.calculateCostForLevel(level);
        int playerXP = this.getPlayerTotalXP(player);
        MutableComponent xp = Component.literal((String)String.valueOf(playerXP)).withStyle(playerXP >= cost ? ChatFormatting.GREEN : ChatFormatting.RED);
        MutableComponent costC = Component.literal((String)String.valueOf(cost));
        lines.add((Component)Component.translatable((String)"tooltip.rereskillable.skill_cost", (Object[])new Object[]{xp, costC}));
        if (!Configuration.isSkillLevelingEnabled()) {
            lines.add((Component)Component.translatable((String)"message.reskillable.leveling_disabled").withStyle(ChatFormatting.RED));
            return lines;
        }
        int max = Configuration.getMaxLevel();
        if (level >= max) {
            lines.add((Component)Component.translatable((String)"message.reskillable.max_level", (Object[])new Object[]{max}).withStyle(ChatFormatting.RED));
            return lines;
        }
        if (this.gateBlocked) {
            lines.add((Component)Component.literal((String)"\ud83d\udd12 ").append((Component)Component.translatable((String)"message.reskillable.gate_blocked_short")).withStyle(ChatFormatting.RED));
            if (!Screen.hasShiftDown()) {
                lines.add((Component)Component.literal((String)"\u21e7 ").append((Component)Component.translatable((String)"message.reskillable.gate_hold_shift")).withStyle(ChatFormatting.DARK_GRAY));
            } else if (this.gateMissing != null) {
                lines.add((Component)Component.empty());
                lines.add((Component)Component.translatable((String)"message.reskillable.gate_requirements").withStyle(ChatFormatting.GOLD));
                for (Component part : this.splitRequirements(this.gateMissing)) {
                    lines.add((Component)Component.literal((String)" \u2022 ").append(part).withStyle(ChatFormatting.YELLOW));
                }
            }
            lines.add((Component)Component.literal((String)"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500").withStyle(ChatFormatting.DARK_GRAY));
        }
        if (SkillAttributeBonus.getBySkill(this.skill) != null) {
            boolean enabled = model.isPerkEnabled(this.skill);
            lines.add((Component)Component.literal((String)"\u27a4 ").append((Component)Component.translatable((String)"tooltip.rereskillable.right_click").withStyle(ChatFormatting.GOLD)).append((Component)Component.translatable((String)(enabled ? "tooltip.rereskillable.disable_perk" : "tooltip.rereskillable.enable_perk")).withStyle(enabled ? ChatFormatting.RED : ChatFormatting.GREEN)));
        }
        lines.add((Component)Component.literal((String)"\u27a4 ").append((Component)Component.translatable((String)"tooltip.rereskillable.left_click").withStyle(ChatFormatting.GOLD)).append((Component)Component.translatable((String)"tooltip.rereskillable.level_up").withStyle(ChatFormatting.AQUA)));
        return lines;
    }

    private int getPlayerTotalXP(Player player) {
        int level = player.experienceLevel;
        float progress = player.experienceProgress;
        if (level <= 16) {
            return level * level + 6 * level + Math.round(progress * (float)(2 * level + 7));
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) + Math.round(progress * (float)(5 * level - 38));
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0) + Math.round(progress * (float)(9 * level - 158));
    }

    private List<Component> splitRequirements(Component combined) {
        String raw = combined.getString();
        String[] parts = raw.split(",\\s*");
        ArrayList<Component> out = new ArrayList<Component>();
        for (String p : parts) {
            out.add((Component)Component.literal((String)p));
        }
        return out;
    }

    public List<Component> getCurrentTooltipLines() {
        return this.tooltipLines;
    }
}

