/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Requirement;
import net.bandit.reskillable.common.commands.skills.RequirementType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class AbsEventHandler {
    public static boolean checkRequirements(SkillModel skillModel, Player player, ResourceLocation resource) {
        Requirement[] requirements = RequirementType.USE.getRequirements(resource);
        if (requirements == null || requirements.length == 0) {
            return true;
        }
        ArrayList<Requirement> unmetRequirements = new ArrayList<Requirement>();
        for (Requirement requirement : requirements) {
            if (skillModel.getSkillLevel(requirement.skill) >= requirement.level) continue;
            unmetRequirements.add(requirement);
        }
        if (!unmetRequirements.isEmpty()) {
            AbsEventHandler.sendSkillRequirementMessage(player, RequirementType.USE, unmetRequirements);
            return false;
        }
        return true;
    }

    public static void sendSkillRequirementMessage(Player player, RequirementType type, List<Requirement> unmetRequirements) {
        String translationKey = switch (type) {
            default -> throw new MatchException(null, null);
            case RequirementType.ATTACK -> "message.reskillable.requirement.attack";
            case RequirementType.CRAFT -> "message.reskillable.requirement.craft";
            case RequirementType.USE -> "message.reskillable.requirement.use";
        };
        ArrayList<MutableComponent> formattedRequirements = new ArrayList<MutableComponent>();
        for (Requirement req : unmetRequirements) {
            String skillTranslationKey = "skill." + req.skill.name().toLowerCase();
            MutableComponent translatedSkillName = Component.translatable((String)skillTranslationKey);
            formattedRequirements.add(Component.literal((String)"").append((Component)translatedSkillName).append(" level " + req.level));
        }
        MutableComponent joinedRequirements = Component.literal((String)" ").append((Component)Component.literal((String)String.join((CharSequence)", ", formattedRequirements.stream().map(Component::getString).collect(Collectors.toList()))));
        MutableComponent message = Component.translatable((String)translationKey, (Object[])new Object[]{joinedRequirements});
        player.displayClientMessage((Component)message, true);
    }
}

