/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.gating;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.bandit.reskillable.common.gating.AdvancementGateUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public final class SkillLevelGate {
    private SkillLevelGate() {
    }

    public static GateResult check(SkillModel model, Skill levelingSkill, int currentLevel) {
        return SkillLevelGate.check(null, model, levelingSkill, currentLevel);
    }

    public static GateResult check(ServerPlayer player, SkillModel model, Skill levelingSkill, int currentLevel) {
        List rules;
        try {
            rules = (List)Configuration.SKILL_LEVEL_GATES.get();
        }
        catch (Throwable t) {
            return GateResult.allow();
        }
        if (rules == null || rules.isEmpty()) {
            return GateResult.allow();
        }
        int totalLevels = 0;
        for (Skill s : Skill.values()) {
            totalLevels += model.getSkillLevel(s);
        }
        ArrayList<MissingReq> missing = new ArrayList<MissingReq>();
        for (String line : rules) {
            Rule rule = Rule.parse(line);
            if (rule == null || rule.skill != levelingSkill || currentLevel < rule.minCurrentLevel) continue;
            if (rule.minTotalLevels != null && totalLevels < rule.minTotalLevels) {
                missing.add(MissingReq.total(rule.minTotalLevels));
            }
            for (Map.Entry<Skill, Integer> e : rule.minSkillLevels.entrySet()) {
                int actual = model.getSkillLevel(e.getKey());
                if (actual >= e.getValue()) continue;
                missing.add(MissingReq.skill(e.getKey(), e.getValue()));
            }
            if (player == null || rule.requiredAdvancements == null || rule.requiredAdvancements.isEmpty()) continue;
            for (ResourceLocation advId : rule.requiredAdvancements) {
                if (AdvancementGateUtil.has(player, advId)) continue;
                missing.add(MissingReq.adv(advId));
            }
        }
        if (missing.isEmpty()) {
            return GateResult.allow();
        }
        LinkedHashMap<String, MissingReq> best = new LinkedHashMap<String, MissingReq>();
        for (MissingReq req : missing) {
            String key = req.key();
            MissingReq existing = (MissingReq)best.get(key);
            if (existing == null) {
                best.put(key, req);
                continue;
            }
            if (req.advId != null || existing.advId != null || req.required <= existing.required) continue;
            best.put(key, req);
        }
        return GateResult.block(new ArrayList<MissingReq>(best.values()));
    }

    public record GateResult(boolean allowed, List<MissingReq> missing) {
        public static GateResult allow() {
            return new GateResult(true, List.of());
        }

        public static GateResult block(List<MissingReq> missing) {
            return new GateResult(false, missing);
        }

        public Component missingListComponent() {
            if (this.missing == null || this.missing.isEmpty()) {
                return Component.translatable((String)"message.reskillable.gate_missing_unknown");
            }
            MutableComponent out = Component.empty();
            for (int i = 0; i < this.missing.size(); ++i) {
                if (i > 0) {
                    out = out.append((Component)Component.literal((String)", "));
                }
                out = out.append(this.missing.get(i).toComponent());
            }
            return out;
        }
    }

    private record Rule(Skill skill, int minCurrentLevel, Integer minTotalLevels, Map<Skill, Integer> minSkillLevels, List<ResourceLocation> requiredAdvancements) {
        static Rule parse(String line) {
            int minLevel;
            Skill skill;
            if (line == null) {
                return null;
            }
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
                return null;
            }
            String[] parts = line.split(":", 3);
            if (parts.length < 3) {
                return null;
            }
            try {
                skill = Skill.valueOf(parts[0].trim().toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
            try {
                minLevel = Integer.parseInt(parts[1].trim());
            }
            catch (NumberFormatException ex) {
                return null;
            }
            Integer totalReq = null;
            LinkedHashMap<Skill, Integer> skillReqs = new LinkedHashMap<Skill, Integer>();
            ArrayList<ResourceLocation> advReqs = new ArrayList<ResourceLocation>();
            String reqs = parts[2].trim();
            if (!reqs.isEmpty()) {
                for (String raw : reqs.split(",")) {
                    int val;
                    String[] kv;
                    String tok = raw.trim();
                    if (tok.isEmpty() || (kv = tok.split("=", 2)).length != 2) continue;
                    String keyRaw = kv[0].trim();
                    String valRaw = kv[1].trim();
                    if (keyRaw.equalsIgnoreCase("ADV")) {
                        ResourceLocation id = ResourceLocation.tryParse((String)valRaw);
                        if (id == null) continue;
                        advReqs.add(id);
                        continue;
                    }
                    String key = keyRaw.toUpperCase(Locale.ROOT);
                    try {
                        val = Integer.parseInt(valRaw);
                    }
                    catch (NumberFormatException ex) {
                        continue;
                    }
                    if (key.equals("TOTAL")) {
                        totalReq = val;
                        continue;
                    }
                    try {
                        Skill reqSkill = Skill.valueOf(key);
                        skillReqs.put(reqSkill, val);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            return new Rule(skill, Math.max(0, minLevel), totalReq, skillReqs, advReqs);
        }
    }

    public record MissingReq(Skill skill, int required, ResourceLocation advId) {
        static MissingReq total(int required) {
            return new MissingReq(null, required, null);
        }

        static MissingReq skill(Skill skill, int required) {
            return new MissingReq(skill, required, null);
        }

        static MissingReq adv(ResourceLocation id) {
            return new MissingReq(null, 0, id);
        }

        String key() {
            if (this.advId != null) {
                return "ADV:" + String.valueOf(this.advId);
            }
            return this.skill == null ? "TOTAL" : this.skill.name();
        }

        Component toComponent() {
            if (this.advId != null) {
                return Component.translatable((String)"message.reskillable.req_adv", (Object[])new Object[]{MissingReq.prettyAdvName(this.advId)});
            }
            if (this.skill == null) {
                return Component.translatable((String)"message.reskillable.req_total", (Object[])new Object[]{this.required});
            }
            return Component.translatable((String)"message.reskillable.req_skill", (Object[])new Object[]{Component.translatable((String)("skill." + this.skill.name().toLowerCase(Locale.ROOT))), this.required});
        }

        private static Component prettyAdvName(ResourceLocation id) {
            String path = id.getPath();
            String last = path.contains("/") ? path.substring(path.lastIndexOf(47) + 1) : path;
            Object pretty = last.replace('_', ' ');
            if (!((String)pretty).isEmpty()) {
                pretty = ((String)pretty).substring(0, 1).toUpperCase(Locale.ROOT) + ((String)pretty).substring(1);
            }
            return Component.literal((String)(id.getNamespace() + ":" + (String)pretty));
        }
    }
}

